/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.prism.ps;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.prism.ps.Shader;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.PerspectiveTransform;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.prism.ps.PPSOneSamplerPeer;
import com.sun.scenario.effect.impl.state.AccessHelper;
import com.sun.scenario.effect.impl.state.PerspectiveTransformState;
import java.util.HashMap;

public class PPSPerspectiveTransformPeer
extends PPSOneSamplerPeer {
    public PPSPerspectiveTransformPeer(FilterContext fctx, Renderer r, String shaderName) {
        super(fctx, r, shaderName);
    }

    @Override
    protected final PerspectiveTransform getEffect() {
        return (PerspectiveTransform)super.getEffect();
    }

    private float[][] getITX() {
        PerspectiveTransformState state = (PerspectiveTransformState)AccessHelper.getState(this.getEffect());
        return state.getITX();
    }

    private float[] getTx0() {
        Rectangle ib = this.getInputBounds(0);
        Rectangle nb = this.getInputNativeBounds(0);
        float scalex = (float)ib.width / (float)nb.width;
        float[] itx0 = this.getITX()[0];
        return new float[]{itx0[0] * scalex, itx0[1] * scalex, itx0[2] * scalex};
    }

    private float[] getTx1() {
        Rectangle ib = this.getInputBounds(0);
        Rectangle nb = this.getInputNativeBounds(0);
        float scaley = (float)ib.height / (float)nb.height;
        float[] itx1 = this.getITX()[1];
        return new float[]{itx1[0] * scaley, itx1[1] * scaley, itx1[2] * scaley};
    }

    private float[] getTx2() {
        return this.getITX()[2];
    }

    @Override
    public int getTextureCoordinates(int inputIndex, float[] coords, float srcX, float srcY, float srcNativeWidth, float srcNativeHeight, Rectangle dstBounds, BaseTransform transform) {
        coords[0] = dstBounds.x;
        coords[1] = dstBounds.y;
        coords[2] = dstBounds.x + dstBounds.width;
        coords[3] = dstBounds.y + dstBounds.height;
        return 4;
    }

    @Override
    protected boolean isSamplerLinear(int i) {
        switch (i) {
            case 0: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected Shader createShader() {
        HashMap<String, Integer> samplers = new HashMap<String, Integer>();
        samplers.put("baseImg", 0);
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("tx1", 1);
        params.put("tx0", 0);
        params.put("tx2", 2);
        return this.getRenderer().createShader(this.getShaderName(), samplers, params, false);
    }

    @Override
    protected void updateShader(Shader shader) {
        float[] tx1_tmp = this.getTx1();
        shader.setConstant("tx1", tx1_tmp[0], tx1_tmp[1], tx1_tmp[2]);
        float[] tx0_tmp = this.getTx0();
        shader.setConstant("tx0", tx0_tmp[0], tx0_tmp[1], tx0_tmp[2]);
        float[] tx2_tmp = this.getTx2();
        shader.setConstant("tx2", tx2_tmp[0], tx2_tmp[1], tx2_tmp[2]);
    }
}

