/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.animation.shared;

import com.sun.scenario.animation.shared.AnimationAccessor;
import com.sun.scenario.animation.shared.ClipEnvelope;
import javafx.animation.Animation;
import javafx.util.Duration;

public class InfiniteClipEnvelope
extends ClipEnvelope {
    private boolean autoReverse;
    private long pos;

    protected InfiniteClipEnvelope(Animation animation) {
        super(animation);
        if (animation != null) {
            this.autoReverse = animation.isAutoReverse();
        }
    }

    @Override
    public void setAutoReverse(boolean autoReverse) {
        this.autoReverse = autoReverse;
    }

    @Override
    protected double calculateCurrentRate() {
        return !this.autoReverse ? this.rate : (this.ticks % (2L * this.cycleTicks) < this.cycleTicks ? this.rate : -this.rate);
    }

    @Override
    public ClipEnvelope setCycleDuration(Duration cycleDuration) {
        if (cycleDuration.isIndefinite()) {
            return InfiniteClipEnvelope.create(this.animation);
        }
        this.updateCycleTicks(cycleDuration);
        return this;
    }

    @Override
    public ClipEnvelope setCycleCount(int cycleCount) {
        return cycleCount != -1 ? InfiniteClipEnvelope.create(this.animation) : this;
    }

    @Override
    public void setRate(double rate) {
        Animation.Status status = this.animation.getStatus();
        if (status != Animation.Status.STOPPED) {
            if (status == Animation.Status.RUNNING) {
                this.setCurrentRate(Math.abs(this.currentRate - this.rate) < 1.0E-12 ? rate : -rate);
            }
            this.deltaTicks = this.ticks - Math.round((double)(this.ticks - this.deltaTicks) * Math.abs(rate / this.rate));
            if (rate * this.rate < 0.0) {
                long delta = 2L * this.cycleTicks - this.pos;
                this.deltaTicks += delta;
                this.ticks += delta;
            }
            this.abortCurrentPulse();
        }
        this.rate = rate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void timePulse(long currentTick) {
        if (this.cycleTicks == 0L) {
            return;
        }
        this.aborted = false;
        this.inTimePulse = true;
        try {
            long cycleDelta;
            long oldTicks = this.ticks;
            this.ticks = Math.max(0L, this.deltaTicks + Math.round((double)currentTick * Math.abs(this.rate)));
            long overallDelta = this.ticks - oldTicks;
            if (overallDelta == 0L) {
                return;
            }
            long l = cycleDelta = this.currentRate > 0.0 ? this.cycleTicks - this.pos : this.pos;
            while (overallDelta >= cycleDelta) {
                if (cycleDelta > 0L) {
                    this.pos = this.currentRate > 0.0 ? this.cycleTicks : 0L;
                    overallDelta -= cycleDelta;
                    AnimationAccessor.getDefault().playTo(this.animation, this.pos, this.cycleTicks);
                    if (this.aborted) {
                        return;
                    }
                }
                if (this.autoReverse) {
                    this.setCurrentRate(-this.currentRate);
                } else {
                    this.pos = this.currentRate > 0.0 ? 0L : this.cycleTicks;
                    AnimationAccessor.getDefault().jumpTo(this.animation, this.pos, this.cycleTicks, false);
                }
                cycleDelta = this.cycleTicks;
            }
            if (overallDelta > 0L) {
                this.pos += this.currentRate > 0.0 ? overallDelta : -overallDelta;
                AnimationAccessor.getDefault().playTo(this.animation, this.pos, this.cycleTicks);
            }
        }
        finally {
            this.inTimePulse = false;
        }
    }

    @Override
    public void jumpTo(long newTicks) {
        if (this.cycleTicks == 0L) {
            return;
        }
        long oldTicks = this.ticks;
        this.ticks = Math.max(0L, newTicks) % (2L * this.cycleTicks);
        long delta = this.ticks - oldTicks;
        if (delta != 0L) {
            this.deltaTicks += delta;
            if (this.autoReverse) {
                if (this.ticks > this.cycleTicks) {
                    this.pos = 2L * this.cycleTicks - this.ticks;
                    if (this.animation.getStatus() == Animation.Status.RUNNING) {
                        this.setCurrentRate(-this.rate);
                    }
                } else {
                    this.pos = this.ticks;
                    if (this.animation.getStatus() == Animation.Status.RUNNING) {
                        this.setCurrentRate(this.rate);
                    }
                }
            } else {
                this.pos = this.ticks % this.cycleTicks;
                if (this.pos == 0L) {
                    this.pos = this.ticks;
                }
            }
            AnimationAccessor.getDefault().jumpTo(this.animation, this.pos, this.cycleTicks, false);
            this.abortCurrentPulse();
        }
    }
}

