/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Dimension2D;
import com.sun.javafx.geom.FlatteningPathIterator;
import com.sun.javafx.geom.PathIterator;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;
import com.sun.javafx.geom.transform.BaseTransform;

public abstract class RectangularShape
extends Shape {
    protected RectangularShape() {
    }

    public abstract float getX();

    public abstract float getY();

    public abstract float getWidth();

    public abstract float getHeight();

    public float getMinX() {
        return this.getX();
    }

    public float getMinY() {
        return this.getY();
    }

    public float getMaxX() {
        return this.getX() + this.getWidth();
    }

    public float getMaxY() {
        return this.getY() + this.getHeight();
    }

    public float getCenterX() {
        return this.getX() + this.getWidth() / 2.0f;
    }

    public float getCenterY() {
        return this.getY() + this.getHeight() / 2.0f;
    }

    public abstract boolean isEmpty();

    public abstract void setFrame(float var1, float var2, float var3, float var4);

    public void setFrame(Point2D loc, Dimension2D size) {
        this.setFrame(loc.x, loc.y, size.width, size.height);
    }

    public void setFrameFromDiagonal(float x1, float y1, float x2, float y2) {
        float t;
        if (x2 < x1) {
            t = x1;
            x1 = x2;
            x2 = t;
        }
        if (y2 < y1) {
            t = y1;
            y1 = y2;
            y2 = t;
        }
        this.setFrame(x1, y1, x2 - x1, y2 - y1);
    }

    public void setFrameFromDiagonal(Point2D p1, Point2D p2) {
        this.setFrameFromDiagonal(p1.x, p1.y, p2.x, p2.y);
    }

    public void setFrameFromCenter(float centerX, float centerY, float cornerX, float cornerY) {
        float halfW = Math.abs(cornerX - centerX);
        float halfH = Math.abs(cornerY - centerY);
        this.setFrame(centerX - halfW, centerY - halfH, halfW * 2.0f, halfH * 2.0f);
    }

    public void setFrameFromCenter(Point2D center, Point2D corner) {
        this.setFrameFromCenter(center.x, center.y, corner.x, corner.y);
    }

    @Override
    public boolean contains(Point2D p) {
        return this.contains(p.x, p.y);
    }

    @Override
    public RectBounds getBounds() {
        float width = this.getWidth();
        float height = this.getHeight();
        if (width < 0.0f || height < 0.0f) {
            return new RectBounds();
        }
        float x = this.getX();
        float y = this.getY();
        float x1 = (float)Math.floor(x);
        float y1 = (float)Math.floor(y);
        float x2 = (float)Math.ceil(x + width);
        float y2 = (float)Math.ceil(y + height);
        return new RectBounds(x1, y1, x2, y2);
    }

    @Override
    public PathIterator getPathIterator(BaseTransform tx, float flatness) {
        return new FlatteningPathIterator(this.getPathIterator(tx), flatness);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.getX() + ",y=" + this.getY() + ",w=" + this.getWidth() + ",h=" + this.getHeight() + "]";
    }
}

