/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.fxml.expression;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.ArrayList;

public class KeyPath
extends AbstractList<String> {
    private ArrayList<String> elements;

    public KeyPath(ArrayList<String> elements) {
        if (elements == null) {
            throw new NullPointerException();
        }
        this.elements = elements;
    }

    @Override
    public String get(int index) {
        return this.elements.get(index);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.elements.size();
        for (int i = 0; i < n; ++i) {
            String element = this.elements.get(i);
            if (Character.isDigit(element.charAt(0))) {
                stringBuilder.append("[");
                stringBuilder.append(element);
                stringBuilder.append("]");
                continue;
            }
            if (i > 0) {
                stringBuilder.append(".");
            }
            stringBuilder.append(element);
        }
        return stringBuilder.toString();
    }

    public static KeyPath parse(String value) {
        KeyPath keyPath;
        try (PushbackReader reader = new PushbackReader(new StringReader(value));){
            keyPath = KeyPath.parse(reader);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        return keyPath;
    }

    protected static KeyPath parse(PushbackReader reader) throws IOException {
        ArrayList<String> elements = new ArrayList<String>();
        int c = reader.read();
        while (c != -1 && (Character.isJavaIdentifierStart(c) || c == 91)) {
            boolean bracketed;
            StringBuilder keyBuilder = new StringBuilder();
            boolean bl = bracketed = c == 91;
            if (bracketed) {
                char quote;
                boolean quoted;
                c = reader.read();
                boolean bl2 = quoted = c == 34 || c == 39;
                if (quoted) {
                    quote = (char)c;
                    c = reader.read();
                } else {
                    quote = '\u0000';
                }
                while (c != -1 && bracketed) {
                    if (Character.isISOControl(c)) {
                        throw new IllegalArgumentException("Illegal identifier character.");
                    }
                    if (!quoted && !Character.isDigit(c)) {
                        throw new IllegalArgumentException("Illegal character in index value.");
                    }
                    keyBuilder.append((char)c);
                    c = reader.read();
                    if (quoted) {
                        boolean bl3 = quoted = c != quote;
                        if (!quoted) {
                            c = reader.read();
                        }
                    }
                    bracketed = c != 93;
                }
                if (quoted) {
                    throw new IllegalArgumentException("Unterminated quoted identifier.");
                }
                if (bracketed) {
                    throw new IllegalArgumentException("Unterminated bracketed identifier.");
                }
                c = reader.read();
            } else {
                while (c != -1 && c != 46 && c != 91 && Character.isJavaIdentifierPart(c)) {
                    keyBuilder.append((char)c);
                    c = reader.read();
                }
            }
            if (c == 46 && (c = reader.read()) == -1) {
                throw new IllegalArgumentException("Illegal terminator character.");
            }
            if (keyBuilder.length() == 0) {
                throw new IllegalArgumentException("Missing identifier.");
            }
            elements.add(keyBuilder.toString());
        }
        if (elements.size() == 0) {
            throw new IllegalArgumentException("Invalid path.");
        }
        if (c != -1) {
            reader.unread(c);
        }
        return new KeyPath(elements);
    }
}

