/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.css;

import com.sun.javafx.css.CalculatedValue;
import com.sun.javafx.css.PseudoClassState;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javafx.css.PseudoClass;
import javafx.scene.text.Font;

public final class StyleCacheEntry {
    private Map<String, CalculatedValue> calculatedValues;

    public CalculatedValue get(String property) {
        CalculatedValue cv = null;
        if (this.calculatedValues != null && !this.calculatedValues.isEmpty()) {
            cv = this.calculatedValues.get(property);
        }
        return cv;
    }

    public void put(String property, CalculatedValue calculatedValue) {
        if (this.calculatedValues == null) {
            this.calculatedValues = new HashMap<String, CalculatedValue>(5);
        }
        this.calculatedValues.put(property, calculatedValue);
    }

    public static final class Key {
        private final Set<PseudoClass>[] pseudoClassStates;
        private final double fontSize;
        private int hash = Integer.MIN_VALUE;

        public Key(Set<PseudoClass>[] pseudoClassStates, Font font) {
            this.pseudoClassStates = new Set[pseudoClassStates.length];
            for (int n = 0; n < pseudoClassStates.length; ++n) {
                this.pseudoClassStates[n] = new PseudoClassState();
                this.pseudoClassStates[n].addAll(pseudoClassStates[n]);
            }
            this.fontSize = font != null ? font.getSize() : Font.getDefault().getSize();
        }

        public String toString() {
            return Arrays.toString(this.pseudoClassStates) + ", " + this.fontSize;
        }

        public static int hashCode(double value) {
            long bits = Double.doubleToLongBits(value);
            return (int)(bits ^ bits >>> 32);
        }

        public int hashCode() {
            if (this.hash == Integer.MIN_VALUE) {
                this.hash = Key.hashCode(this.fontSize);
                int iMax = this.pseudoClassStates != null ? this.pseudoClassStates.length : 0;
                for (int i = 0; i < iMax; ++i) {
                    Set<PseudoClass> states = this.pseudoClassStates[i];
                    if (states == null) continue;
                    this.hash = 67 * (this.hash + states.hashCode());
                }
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.hash != other.hash) {
                return false;
            }
            double diff = this.fontSize - other.fontSize;
            if (diff < -1.0E-6 || 1.0E-6 < diff) {
                return false;
            }
            if (this.pseudoClassStates == null ^ other.pseudoClassStates == null) {
                return false;
            }
            if (this.pseudoClassStates == null) {
                return true;
            }
            if (this.pseudoClassStates.length != other.pseudoClassStates.length) {
                return false;
            }
            for (int i = 0; i < this.pseudoClassStates.length; ++i) {
                Set<PseudoClass> this_pcs = this.pseudoClassStates[i];
                Set<PseudoClass> other_pcs = other.pseudoClassStates[i];
                if (!(this_pcs == null ? other_pcs != null : !this_pcs.equals(other_pcs))) continue;
                return false;
            }
            return true;
        }
    }
}

