/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.ListBuffer;
import java.util.HashMap;
import java.util.Map;

public class DeferredLintHandler {
    protected static final Context.Key<DeferredLintHandler> deferredLintHandlerKey = new Context.Key();
    private JCDiagnostic.DiagnosticPosition currentPos;
    private Map<JCDiagnostic.DiagnosticPosition, ListBuffer<LintLogger>> loggersQueue = new HashMap<JCDiagnostic.DiagnosticPosition, ListBuffer<LintLogger>>();
    private static final JCDiagnostic.DiagnosticPosition IMMEDIATE_POSITION = new JCDiagnostic.DiagnosticPosition(){

        @Override
        public JCTree getTree() {
            Assert.error();
            return null;
        }

        @Override
        public int getStartPosition() {
            Assert.error();
            return -1;
        }

        @Override
        public int getPreferredPosition() {
            Assert.error();
            return -1;
        }

        @Override
        public int getEndPosition(EndPosTable endPosTable) {
            Assert.error();
            return -1;
        }
    };

    public static DeferredLintHandler instance(Context context) {
        DeferredLintHandler deferredLintHandler = context.get(deferredLintHandlerKey);
        if (deferredLintHandler == null) {
            deferredLintHandler = new DeferredLintHandler(context);
        }
        return deferredLintHandler;
    }

    protected DeferredLintHandler(Context context) {
        context.put(deferredLintHandlerKey, this);
        this.currentPos = IMMEDIATE_POSITION;
    }

    public void report(LintLogger lintLogger) {
        if (this.currentPos == IMMEDIATE_POSITION) {
            lintLogger.report();
        } else {
            ListBuffer<LintLogger> listBuffer = this.loggersQueue.get(this.currentPos);
            if (listBuffer == null) {
                listBuffer = new ListBuffer();
                this.loggersQueue.put(this.currentPos, listBuffer);
            }
            listBuffer.append(lintLogger);
        }
    }

    public void flush(JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        ListBuffer<LintLogger> listBuffer = this.loggersQueue.get(diagnosticPosition);
        if (listBuffer != null) {
            for (LintLogger lintLogger : listBuffer) {
                lintLogger.report();
            }
            this.loggersQueue.remove(diagnosticPosition);
        }
    }

    public JCDiagnostic.DiagnosticPosition setPos(JCDiagnostic.DiagnosticPosition diagnosticPosition) {
        JCDiagnostic.DiagnosticPosition diagnosticPosition2 = this.currentPos;
        this.currentPos = diagnosticPosition;
        return diagnosticPosition2;
    }

    public JCDiagnostic.DiagnosticPosition immediate() {
        return this.setPos(IMMEDIATE_POSITION);
    }

    public static interface LintLogger {
        public void report();
    }
}

