/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.testing.Platform;
import junit.framework.TestCase;

@GwtCompatible
public class AbstractTester<G>
extends TestCase {
    private G subjectGenerator;
    private String suiteName;
    private Runnable setUp;
    private Runnable tearDown;

    public void setUp() throws Exception {
        if (this.setUp != null) {
            this.setUp.run();
        }
    }

    public void tearDown() throws Exception {
        if (this.tearDown != null) {
            this.tearDown.run();
        }
    }

    public final void init(G subjectGenerator, String suiteName, Runnable setUp, Runnable tearDown) {
        this.subjectGenerator = subjectGenerator;
        this.suiteName = suiteName;
        this.setUp = setUp;
        this.tearDown = tearDown;
    }

    public final void init(G subjectGenerator, String suiteName) {
        this.init(subjectGenerator, suiteName, null, null);
    }

    public G getSubjectGenerator() {
        return this.subjectGenerator;
    }

    public final String getTestMethodName() {
        return super.getName();
    }

    public String getName() {
        return Platform.format("%s[%s]", super.getName(), this.suiteName);
    }
}

