/*
 * Decompiled with CFR 0.152.
 */
package com.github.cereda.arara.utils;

import com.github.cereda.arara.controller.LanguageController;
import com.github.cereda.arara.model.AraraException;
import com.github.cereda.arara.model.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VelocityUtils {
    private static final LanguageController messages = LanguageController.getInstance();

    public static void mergeVelocityTemplate(File input, File output, Map<String, Object> map) throws AraraException {
        try {
            VelocityEngine engine = new VelocityEngine();
            engine.setProperty("file.resource.loader.path", input.getCanonicalFile().getParent());
            engine.setProperty("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
            engine.init();
            VelocityContext context = new VelocityContext(map);
            Template template = engine.getTemplate(input.getName(), "UTF-8");
            FileOutputStream stream = new FileOutputStream(output);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            template.merge(context, writer);
            ((Writer)writer).close();
            stream.close();
        }
        catch (ResourceNotFoundException rnfexception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_VELOCITY_FILE_NOT_FOUND), rnfexception);
        }
        catch (ParseErrorException peexception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_VELOCITY_PARSE_EXCEPTION), peexception);
        }
        catch (MethodInvocationException miexception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_VELOCITY_METHOD_INVOCATION_EXCEPTION), miexception);
        }
        catch (IOException ioexception) {
            throw new AraraException(messages.getMessage(Messages.ERROR_VELOCITY_FILE_NOT_FOUND), ioexception);
        }
    }
}

