#ifdef GET_MIMGBaseOpcode_DECL
enum MIMGBaseOpcode {
  IMAGE_ATOMIC_ADD = 0,
  IMAGE_ATOMIC_AND = 1,
  IMAGE_ATOMIC_CMPSWAP = 2,
  IMAGE_ATOMIC_DEC = 3,
  IMAGE_ATOMIC_INC = 4,
  IMAGE_ATOMIC_OR = 5,
  IMAGE_ATOMIC_SMAX = 6,
  IMAGE_ATOMIC_SMIN = 7,
  IMAGE_ATOMIC_SUB = 8,
  IMAGE_ATOMIC_SWAP = 9,
  IMAGE_ATOMIC_UMAX = 10,
  IMAGE_ATOMIC_UMIN = 11,
  IMAGE_ATOMIC_XOR = 12,
  IMAGE_GATHER4 = 13,
  IMAGE_GATHER4_B = 14,
  IMAGE_GATHER4_B_CL = 15,
  IMAGE_GATHER4_B_CL_O = 16,
  IMAGE_GATHER4_B_O = 17,
  IMAGE_GATHER4_C = 18,
  IMAGE_GATHER4_CL = 19,
  IMAGE_GATHER4_CL_O = 20,
  IMAGE_GATHER4_C_B = 21,
  IMAGE_GATHER4_C_B_CL = 22,
  IMAGE_GATHER4_C_B_CL_O = 23,
  IMAGE_GATHER4_C_B_O = 24,
  IMAGE_GATHER4_C_CL = 25,
  IMAGE_GATHER4_C_CL_O = 26,
  IMAGE_GATHER4_C_L = 27,
  IMAGE_GATHER4_C_LZ = 28,
  IMAGE_GATHER4_C_LZ_O = 29,
  IMAGE_GATHER4_C_L_O = 30,
  IMAGE_GATHER4_C_O = 31,
  IMAGE_GATHER4_L = 32,
  IMAGE_GATHER4_LZ = 33,
  IMAGE_GATHER4_LZ_O = 34,
  IMAGE_GATHER4_L_O = 35,
  IMAGE_GATHER4_O = 36,
  IMAGE_GET_LOD = 37,
  IMAGE_GET_RESINFO = 38,
  IMAGE_LOAD = 39,
  IMAGE_LOAD_MIP = 40,
  IMAGE_LOAD_MIP_PCK = 41,
  IMAGE_LOAD_MIP_PCK_SGN = 42,
  IMAGE_LOAD_PCK = 43,
  IMAGE_LOAD_PCK_SGN = 44,
  IMAGE_SAMPLE = 45,
  IMAGE_SAMPLE_B = 46,
  IMAGE_SAMPLE_B_CL = 47,
  IMAGE_SAMPLE_B_CL_O = 48,
  IMAGE_SAMPLE_B_O = 49,
  IMAGE_SAMPLE_C = 50,
  IMAGE_SAMPLE_CD = 51,
  IMAGE_SAMPLE_CD_CL = 52,
  IMAGE_SAMPLE_CD_CL_O = 53,
  IMAGE_SAMPLE_CD_O = 54,
  IMAGE_SAMPLE_CL = 55,
  IMAGE_SAMPLE_CL_O = 56,
  IMAGE_SAMPLE_C_B = 57,
  IMAGE_SAMPLE_C_B_CL = 58,
  IMAGE_SAMPLE_C_B_CL_O = 59,
  IMAGE_SAMPLE_C_B_O = 60,
  IMAGE_SAMPLE_C_CD = 61,
  IMAGE_SAMPLE_C_CD_CL = 62,
  IMAGE_SAMPLE_C_CD_CL_O = 63,
  IMAGE_SAMPLE_C_CD_O = 64,
  IMAGE_SAMPLE_C_CL = 65,
  IMAGE_SAMPLE_C_CL_O = 66,
  IMAGE_SAMPLE_C_D = 67,
  IMAGE_SAMPLE_C_D_CL = 68,
  IMAGE_SAMPLE_C_D_CL_O = 69,
  IMAGE_SAMPLE_C_D_O = 70,
  IMAGE_SAMPLE_C_L = 71,
  IMAGE_SAMPLE_C_LZ = 72,
  IMAGE_SAMPLE_C_LZ_O = 73,
  IMAGE_SAMPLE_C_L_O = 74,
  IMAGE_SAMPLE_C_O = 75,
  IMAGE_SAMPLE_D = 76,
  IMAGE_SAMPLE_D_CL = 77,
  IMAGE_SAMPLE_D_CL_O = 78,
  IMAGE_SAMPLE_D_O = 79,
  IMAGE_SAMPLE_L = 80,
  IMAGE_SAMPLE_LZ = 81,
  IMAGE_SAMPLE_LZ_O = 82,
  IMAGE_SAMPLE_L_O = 83,
  IMAGE_SAMPLE_O = 84,
  IMAGE_STORE = 85,
  IMAGE_STORE_MIP = 86,
  IMAGE_STORE_MIP_PCK = 87,
  IMAGE_STORE_PCK = 88,
};
#endif

#ifdef GET_MIMGDim_DECL
enum MIMGDim {
  AMDGPUDim1D = 0,
  AMDGPUDim1DArray = 1,
  AMDGPUDim2D = 2,
  AMDGPUDim2DArray = 3,
  AMDGPUDim2DArrayMsaa = 4,
  AMDGPUDim2DMsaa = 5,
  AMDGPUDim3D = 6,
  AMDGPUDimCube = 7,
};
#endif

#ifdef GET_MIMGEncoding_DECL
enum MIMGEncoding {
  MIMGEncGfx6 = 0,
  MIMGEncGfx8 = 1,
};
#endif

#ifdef GET_ImageDimIntrinsicTable_DECL
const ImageDimIntrinsicInfo *getImageDimIntrinsicInfo(unsigned Intr);
#endif

#ifdef GET_ImageDimIntrinsicTable_IMPL
const ImageDimIntrinsicInfo ImageDimIntrinsicTable[] = {
  { Intrinsic::amdgcn_image_atomic_add_1d, IMAGE_ATOMIC_ADD, AMDGPUDim1D }, // 0
  { Intrinsic::amdgcn_image_atomic_add_1darray, IMAGE_ATOMIC_ADD, AMDGPUDim1DArray }, // 1
  { Intrinsic::amdgcn_image_atomic_add_2d, IMAGE_ATOMIC_ADD, AMDGPUDim2D }, // 2
  { Intrinsic::amdgcn_image_atomic_add_2darray, IMAGE_ATOMIC_ADD, AMDGPUDim2DArray }, // 3
  { Intrinsic::amdgcn_image_atomic_add_2darraymsaa, IMAGE_ATOMIC_ADD, AMDGPUDim2DArrayMsaa }, // 4
  { Intrinsic::amdgcn_image_atomic_add_2dmsaa, IMAGE_ATOMIC_ADD, AMDGPUDim2DMsaa }, // 5
  { Intrinsic::amdgcn_image_atomic_add_3d, IMAGE_ATOMIC_ADD, AMDGPUDim3D }, // 6
  { Intrinsic::amdgcn_image_atomic_add_cube, IMAGE_ATOMIC_ADD, AMDGPUDimCube }, // 7
  { Intrinsic::amdgcn_image_atomic_and_1d, IMAGE_ATOMIC_AND, AMDGPUDim1D }, // 8
  { Intrinsic::amdgcn_image_atomic_and_1darray, IMAGE_ATOMIC_AND, AMDGPUDim1DArray }, // 9
  { Intrinsic::amdgcn_image_atomic_and_2d, IMAGE_ATOMIC_AND, AMDGPUDim2D }, // 10
  { Intrinsic::amdgcn_image_atomic_and_2darray, IMAGE_ATOMIC_AND, AMDGPUDim2DArray }, // 11
  { Intrinsic::amdgcn_image_atomic_and_2darraymsaa, IMAGE_ATOMIC_AND, AMDGPUDim2DArrayMsaa }, // 12
  { Intrinsic::amdgcn_image_atomic_and_2dmsaa, IMAGE_ATOMIC_AND, AMDGPUDim2DMsaa }, // 13
  { Intrinsic::amdgcn_image_atomic_and_3d, IMAGE_ATOMIC_AND, AMDGPUDim3D }, // 14
  { Intrinsic::amdgcn_image_atomic_and_cube, IMAGE_ATOMIC_AND, AMDGPUDimCube }, // 15
  { Intrinsic::amdgcn_image_atomic_cmpswap_1d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1D }, // 16
  { Intrinsic::amdgcn_image_atomic_cmpswap_1darray, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1DArray }, // 17
  { Intrinsic::amdgcn_image_atomic_cmpswap_2d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2D }, // 18
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darray, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArray }, // 19
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darraymsaa, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArrayMsaa }, // 20
  { Intrinsic::amdgcn_image_atomic_cmpswap_2dmsaa, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DMsaa }, // 21
  { Intrinsic::amdgcn_image_atomic_cmpswap_3d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim3D }, // 22
  { Intrinsic::amdgcn_image_atomic_cmpswap_cube, IMAGE_ATOMIC_CMPSWAP, AMDGPUDimCube }, // 23
  { Intrinsic::amdgcn_image_atomic_dec_1d, IMAGE_ATOMIC_DEC, AMDGPUDim1D }, // 24
  { Intrinsic::amdgcn_image_atomic_dec_1darray, IMAGE_ATOMIC_DEC, AMDGPUDim1DArray }, // 25
  { Intrinsic::amdgcn_image_atomic_dec_2d, IMAGE_ATOMIC_DEC, AMDGPUDim2D }, // 26
  { Intrinsic::amdgcn_image_atomic_dec_2darray, IMAGE_ATOMIC_DEC, AMDGPUDim2DArray }, // 27
  { Intrinsic::amdgcn_image_atomic_dec_2darraymsaa, IMAGE_ATOMIC_DEC, AMDGPUDim2DArrayMsaa }, // 28
  { Intrinsic::amdgcn_image_atomic_dec_2dmsaa, IMAGE_ATOMIC_DEC, AMDGPUDim2DMsaa }, // 29
  { Intrinsic::amdgcn_image_atomic_dec_3d, IMAGE_ATOMIC_DEC, AMDGPUDim3D }, // 30
  { Intrinsic::amdgcn_image_atomic_dec_cube, IMAGE_ATOMIC_DEC, AMDGPUDimCube }, // 31
  { Intrinsic::amdgcn_image_atomic_inc_1d, IMAGE_ATOMIC_INC, AMDGPUDim1D }, // 32
  { Intrinsic::amdgcn_image_atomic_inc_1darray, IMAGE_ATOMIC_INC, AMDGPUDim1DArray }, // 33
  { Intrinsic::amdgcn_image_atomic_inc_2d, IMAGE_ATOMIC_INC, AMDGPUDim2D }, // 34
  { Intrinsic::amdgcn_image_atomic_inc_2darray, IMAGE_ATOMIC_INC, AMDGPUDim2DArray }, // 35
  { Intrinsic::amdgcn_image_atomic_inc_2darraymsaa, IMAGE_ATOMIC_INC, AMDGPUDim2DArrayMsaa }, // 36
  { Intrinsic::amdgcn_image_atomic_inc_2dmsaa, IMAGE_ATOMIC_INC, AMDGPUDim2DMsaa }, // 37
  { Intrinsic::amdgcn_image_atomic_inc_3d, IMAGE_ATOMIC_INC, AMDGPUDim3D }, // 38
  { Intrinsic::amdgcn_image_atomic_inc_cube, IMAGE_ATOMIC_INC, AMDGPUDimCube }, // 39
  { Intrinsic::amdgcn_image_atomic_or_1d, IMAGE_ATOMIC_OR, AMDGPUDim1D }, // 40
  { Intrinsic::amdgcn_image_atomic_or_1darray, IMAGE_ATOMIC_OR, AMDGPUDim1DArray }, // 41
  { Intrinsic::amdgcn_image_atomic_or_2d, IMAGE_ATOMIC_OR, AMDGPUDim2D }, // 42
  { Intrinsic::amdgcn_image_atomic_or_2darray, IMAGE_ATOMIC_OR, AMDGPUDim2DArray }, // 43
  { Intrinsic::amdgcn_image_atomic_or_2darraymsaa, IMAGE_ATOMIC_OR, AMDGPUDim2DArrayMsaa }, // 44
  { Intrinsic::amdgcn_image_atomic_or_2dmsaa, IMAGE_ATOMIC_OR, AMDGPUDim2DMsaa }, // 45
  { Intrinsic::amdgcn_image_atomic_or_3d, IMAGE_ATOMIC_OR, AMDGPUDim3D }, // 46
  { Intrinsic::amdgcn_image_atomic_or_cube, IMAGE_ATOMIC_OR, AMDGPUDimCube }, // 47
  { Intrinsic::amdgcn_image_atomic_smax_1d, IMAGE_ATOMIC_SMAX, AMDGPUDim1D }, // 48
  { Intrinsic::amdgcn_image_atomic_smax_1darray, IMAGE_ATOMIC_SMAX, AMDGPUDim1DArray }, // 49
  { Intrinsic::amdgcn_image_atomic_smax_2d, IMAGE_ATOMIC_SMAX, AMDGPUDim2D }, // 50
  { Intrinsic::amdgcn_image_atomic_smax_2darray, IMAGE_ATOMIC_SMAX, AMDGPUDim2DArray }, // 51
  { Intrinsic::amdgcn_image_atomic_smax_2darraymsaa, IMAGE_ATOMIC_SMAX, AMDGPUDim2DArrayMsaa }, // 52
  { Intrinsic::amdgcn_image_atomic_smax_2dmsaa, IMAGE_ATOMIC_SMAX, AMDGPUDim2DMsaa }, // 53
  { Intrinsic::amdgcn_image_atomic_smax_3d, IMAGE_ATOMIC_SMAX, AMDGPUDim3D }, // 54
  { Intrinsic::amdgcn_image_atomic_smax_cube, IMAGE_ATOMIC_SMAX, AMDGPUDimCube }, // 55
  { Intrinsic::amdgcn_image_atomic_smin_1d, IMAGE_ATOMIC_SMIN, AMDGPUDim1D }, // 56
  { Intrinsic::amdgcn_image_atomic_smin_1darray, IMAGE_ATOMIC_SMIN, AMDGPUDim1DArray }, // 57
  { Intrinsic::amdgcn_image_atomic_smin_2d, IMAGE_ATOMIC_SMIN, AMDGPUDim2D }, // 58
  { Intrinsic::amdgcn_image_atomic_smin_2darray, IMAGE_ATOMIC_SMIN, AMDGPUDim2DArray }, // 59
  { Intrinsic::amdgcn_image_atomic_smin_2darraymsaa, IMAGE_ATOMIC_SMIN, AMDGPUDim2DArrayMsaa }, // 60
  { Intrinsic::amdgcn_image_atomic_smin_2dmsaa, IMAGE_ATOMIC_SMIN, AMDGPUDim2DMsaa }, // 61
  { Intrinsic::amdgcn_image_atomic_smin_3d, IMAGE_ATOMIC_SMIN, AMDGPUDim3D }, // 62
  { Intrinsic::amdgcn_image_atomic_smin_cube, IMAGE_ATOMIC_SMIN, AMDGPUDimCube }, // 63
  { Intrinsic::amdgcn_image_atomic_sub_1d, IMAGE_ATOMIC_SUB, AMDGPUDim1D }, // 64
  { Intrinsic::amdgcn_image_atomic_sub_1darray, IMAGE_ATOMIC_SUB, AMDGPUDim1DArray }, // 65
  { Intrinsic::amdgcn_image_atomic_sub_2d, IMAGE_ATOMIC_SUB, AMDGPUDim2D }, // 66
  { Intrinsic::amdgcn_image_atomic_sub_2darray, IMAGE_ATOMIC_SUB, AMDGPUDim2DArray }, // 67
  { Intrinsic::amdgcn_image_atomic_sub_2darraymsaa, IMAGE_ATOMIC_SUB, AMDGPUDim2DArrayMsaa }, // 68
  { Intrinsic::amdgcn_image_atomic_sub_2dmsaa, IMAGE_ATOMIC_SUB, AMDGPUDim2DMsaa }, // 69
  { Intrinsic::amdgcn_image_atomic_sub_3d, IMAGE_ATOMIC_SUB, AMDGPUDim3D }, // 70
  { Intrinsic::amdgcn_image_atomic_sub_cube, IMAGE_ATOMIC_SUB, AMDGPUDimCube }, // 71
  { Intrinsic::amdgcn_image_atomic_swap_1d, IMAGE_ATOMIC_SWAP, AMDGPUDim1D }, // 72
  { Intrinsic::amdgcn_image_atomic_swap_1darray, IMAGE_ATOMIC_SWAP, AMDGPUDim1DArray }, // 73
  { Intrinsic::amdgcn_image_atomic_swap_2d, IMAGE_ATOMIC_SWAP, AMDGPUDim2D }, // 74
  { Intrinsic::amdgcn_image_atomic_swap_2darray, IMAGE_ATOMIC_SWAP, AMDGPUDim2DArray }, // 75
  { Intrinsic::amdgcn_image_atomic_swap_2darraymsaa, IMAGE_ATOMIC_SWAP, AMDGPUDim2DArrayMsaa }, // 76
  { Intrinsic::amdgcn_image_atomic_swap_2dmsaa, IMAGE_ATOMIC_SWAP, AMDGPUDim2DMsaa }, // 77
  { Intrinsic::amdgcn_image_atomic_swap_3d, IMAGE_ATOMIC_SWAP, AMDGPUDim3D }, // 78
  { Intrinsic::amdgcn_image_atomic_swap_cube, IMAGE_ATOMIC_SWAP, AMDGPUDimCube }, // 79
  { Intrinsic::amdgcn_image_atomic_umax_1d, IMAGE_ATOMIC_UMAX, AMDGPUDim1D }, // 80
  { Intrinsic::amdgcn_image_atomic_umax_1darray, IMAGE_ATOMIC_UMAX, AMDGPUDim1DArray }, // 81
  { Intrinsic::amdgcn_image_atomic_umax_2d, IMAGE_ATOMIC_UMAX, AMDGPUDim2D }, // 82
  { Intrinsic::amdgcn_image_atomic_umax_2darray, IMAGE_ATOMIC_UMAX, AMDGPUDim2DArray }, // 83
  { Intrinsic::amdgcn_image_atomic_umax_2darraymsaa, IMAGE_ATOMIC_UMAX, AMDGPUDim2DArrayMsaa }, // 84
  { Intrinsic::amdgcn_image_atomic_umax_2dmsaa, IMAGE_ATOMIC_UMAX, AMDGPUDim2DMsaa }, // 85
  { Intrinsic::amdgcn_image_atomic_umax_3d, IMAGE_ATOMIC_UMAX, AMDGPUDim3D }, // 86
  { Intrinsic::amdgcn_image_atomic_umax_cube, IMAGE_ATOMIC_UMAX, AMDGPUDimCube }, // 87
  { Intrinsic::amdgcn_image_atomic_umin_1d, IMAGE_ATOMIC_UMIN, AMDGPUDim1D }, // 88
  { Intrinsic::amdgcn_image_atomic_umin_1darray, IMAGE_ATOMIC_UMIN, AMDGPUDim1DArray }, // 89
  { Intrinsic::amdgcn_image_atomic_umin_2d, IMAGE_ATOMIC_UMIN, AMDGPUDim2D }, // 90
  { Intrinsic::amdgcn_image_atomic_umin_2darray, IMAGE_ATOMIC_UMIN, AMDGPUDim2DArray }, // 91
  { Intrinsic::amdgcn_image_atomic_umin_2darraymsaa, IMAGE_ATOMIC_UMIN, AMDGPUDim2DArrayMsaa }, // 92
  { Intrinsic::amdgcn_image_atomic_umin_2dmsaa, IMAGE_ATOMIC_UMIN, AMDGPUDim2DMsaa }, // 93
  { Intrinsic::amdgcn_image_atomic_umin_3d, IMAGE_ATOMIC_UMIN, AMDGPUDim3D }, // 94
  { Intrinsic::amdgcn_image_atomic_umin_cube, IMAGE_ATOMIC_UMIN, AMDGPUDimCube }, // 95
  { Intrinsic::amdgcn_image_atomic_xor_1d, IMAGE_ATOMIC_XOR, AMDGPUDim1D }, // 96
  { Intrinsic::amdgcn_image_atomic_xor_1darray, IMAGE_ATOMIC_XOR, AMDGPUDim1DArray }, // 97
  { Intrinsic::amdgcn_image_atomic_xor_2d, IMAGE_ATOMIC_XOR, AMDGPUDim2D }, // 98
  { Intrinsic::amdgcn_image_atomic_xor_2darray, IMAGE_ATOMIC_XOR, AMDGPUDim2DArray }, // 99
  { Intrinsic::amdgcn_image_atomic_xor_2darraymsaa, IMAGE_ATOMIC_XOR, AMDGPUDim2DArrayMsaa }, // 100
  { Intrinsic::amdgcn_image_atomic_xor_2dmsaa, IMAGE_ATOMIC_XOR, AMDGPUDim2DMsaa }, // 101
  { Intrinsic::amdgcn_image_atomic_xor_3d, IMAGE_ATOMIC_XOR, AMDGPUDim3D }, // 102
  { Intrinsic::amdgcn_image_atomic_xor_cube, IMAGE_ATOMIC_XOR, AMDGPUDimCube }, // 103
  { Intrinsic::amdgcn_image_gather4_2d, IMAGE_GATHER4, AMDGPUDim2D }, // 104
  { Intrinsic::amdgcn_image_gather4_2darray, IMAGE_GATHER4, AMDGPUDim2DArray }, // 105
  { Intrinsic::amdgcn_image_gather4_b_2d, IMAGE_GATHER4_B, AMDGPUDim2D }, // 106
  { Intrinsic::amdgcn_image_gather4_b_2darray, IMAGE_GATHER4_B, AMDGPUDim2DArray }, // 107
  { Intrinsic::amdgcn_image_gather4_b_cl_2d, IMAGE_GATHER4_B_CL, AMDGPUDim2D }, // 108
  { Intrinsic::amdgcn_image_gather4_b_cl_2darray, IMAGE_GATHER4_B_CL, AMDGPUDim2DArray }, // 109
  { Intrinsic::amdgcn_image_gather4_b_cl_cube, IMAGE_GATHER4_B_CL, AMDGPUDimCube }, // 110
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2d, IMAGE_GATHER4_B_CL_O, AMDGPUDim2D }, // 111
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2darray, IMAGE_GATHER4_B_CL_O, AMDGPUDim2DArray }, // 112
  { Intrinsic::amdgcn_image_gather4_b_cl_o_cube, IMAGE_GATHER4_B_CL_O, AMDGPUDimCube }, // 113
  { Intrinsic::amdgcn_image_gather4_b_cube, IMAGE_GATHER4_B, AMDGPUDimCube }, // 114
  { Intrinsic::amdgcn_image_gather4_b_o_2d, IMAGE_GATHER4_B_O, AMDGPUDim2D }, // 115
  { Intrinsic::amdgcn_image_gather4_b_o_2darray, IMAGE_GATHER4_B_O, AMDGPUDim2DArray }, // 116
  { Intrinsic::amdgcn_image_gather4_b_o_cube, IMAGE_GATHER4_B_O, AMDGPUDimCube }, // 117
  { Intrinsic::amdgcn_image_gather4_c_2d, IMAGE_GATHER4_C, AMDGPUDim2D }, // 118
  { Intrinsic::amdgcn_image_gather4_c_2darray, IMAGE_GATHER4_C, AMDGPUDim2DArray }, // 119
  { Intrinsic::amdgcn_image_gather4_c_b_2d, IMAGE_GATHER4_C_B, AMDGPUDim2D }, // 120
  { Intrinsic::amdgcn_image_gather4_c_b_2darray, IMAGE_GATHER4_C_B, AMDGPUDim2DArray }, // 121
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2d, IMAGE_GATHER4_C_B_CL, AMDGPUDim2D }, // 122
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2darray, IMAGE_GATHER4_C_B_CL, AMDGPUDim2DArray }, // 123
  { Intrinsic::amdgcn_image_gather4_c_b_cl_cube, IMAGE_GATHER4_C_B_CL, AMDGPUDimCube }, // 124
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2d, IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2D }, // 125
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2darray, IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2DArray }, // 126
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_cube, IMAGE_GATHER4_C_B_CL_O, AMDGPUDimCube }, // 127
  { Intrinsic::amdgcn_image_gather4_c_b_cube, IMAGE_GATHER4_C_B, AMDGPUDimCube }, // 128
  { Intrinsic::amdgcn_image_gather4_c_b_o_2d, IMAGE_GATHER4_C_B_O, AMDGPUDim2D }, // 129
  { Intrinsic::amdgcn_image_gather4_c_b_o_2darray, IMAGE_GATHER4_C_B_O, AMDGPUDim2DArray }, // 130
  { Intrinsic::amdgcn_image_gather4_c_b_o_cube, IMAGE_GATHER4_C_B_O, AMDGPUDimCube }, // 131
  { Intrinsic::amdgcn_image_gather4_c_cl_2d, IMAGE_GATHER4_C_CL, AMDGPUDim2D }, // 132
  { Intrinsic::amdgcn_image_gather4_c_cl_2darray, IMAGE_GATHER4_C_CL, AMDGPUDim2DArray }, // 133
  { Intrinsic::amdgcn_image_gather4_c_cl_cube, IMAGE_GATHER4_C_CL, AMDGPUDimCube }, // 134
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2d, IMAGE_GATHER4_C_CL_O, AMDGPUDim2D }, // 135
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2darray, IMAGE_GATHER4_C_CL_O, AMDGPUDim2DArray }, // 136
  { Intrinsic::amdgcn_image_gather4_c_cl_o_cube, IMAGE_GATHER4_C_CL_O, AMDGPUDimCube }, // 137
  { Intrinsic::amdgcn_image_gather4_c_cube, IMAGE_GATHER4_C, AMDGPUDimCube }, // 138
  { Intrinsic::amdgcn_image_gather4_c_l_2d, IMAGE_GATHER4_C_L, AMDGPUDim2D }, // 139
  { Intrinsic::amdgcn_image_gather4_c_l_2darray, IMAGE_GATHER4_C_L, AMDGPUDim2DArray }, // 140
  { Intrinsic::amdgcn_image_gather4_c_l_cube, IMAGE_GATHER4_C_L, AMDGPUDimCube }, // 141
  { Intrinsic::amdgcn_image_gather4_c_l_o_2d, IMAGE_GATHER4_C_L_O, AMDGPUDim2D }, // 142
  { Intrinsic::amdgcn_image_gather4_c_l_o_2darray, IMAGE_GATHER4_C_L_O, AMDGPUDim2DArray }, // 143
  { Intrinsic::amdgcn_image_gather4_c_l_o_cube, IMAGE_GATHER4_C_L_O, AMDGPUDimCube }, // 144
  { Intrinsic::amdgcn_image_gather4_c_lz_2d, IMAGE_GATHER4_C_LZ, AMDGPUDim2D }, // 145
  { Intrinsic::amdgcn_image_gather4_c_lz_2darray, IMAGE_GATHER4_C_LZ, AMDGPUDim2DArray }, // 146
  { Intrinsic::amdgcn_image_gather4_c_lz_cube, IMAGE_GATHER4_C_LZ, AMDGPUDimCube }, // 147
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2d, IMAGE_GATHER4_C_LZ_O, AMDGPUDim2D }, // 148
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2darray, IMAGE_GATHER4_C_LZ_O, AMDGPUDim2DArray }, // 149
  { Intrinsic::amdgcn_image_gather4_c_lz_o_cube, IMAGE_GATHER4_C_LZ_O, AMDGPUDimCube }, // 150
  { Intrinsic::amdgcn_image_gather4_c_o_2d, IMAGE_GATHER4_C_O, AMDGPUDim2D }, // 151
  { Intrinsic::amdgcn_image_gather4_c_o_2darray, IMAGE_GATHER4_C_O, AMDGPUDim2DArray }, // 152
  { Intrinsic::amdgcn_image_gather4_c_o_cube, IMAGE_GATHER4_C_O, AMDGPUDimCube }, // 153
  { Intrinsic::amdgcn_image_gather4_cl_2d, IMAGE_GATHER4_CL, AMDGPUDim2D }, // 154
  { Intrinsic::amdgcn_image_gather4_cl_2darray, IMAGE_GATHER4_CL, AMDGPUDim2DArray }, // 155
  { Intrinsic::amdgcn_image_gather4_cl_cube, IMAGE_GATHER4_CL, AMDGPUDimCube }, // 156
  { Intrinsic::amdgcn_image_gather4_cl_o_2d, IMAGE_GATHER4_CL_O, AMDGPUDim2D }, // 157
  { Intrinsic::amdgcn_image_gather4_cl_o_2darray, IMAGE_GATHER4_CL_O, AMDGPUDim2DArray }, // 158
  { Intrinsic::amdgcn_image_gather4_cl_o_cube, IMAGE_GATHER4_CL_O, AMDGPUDimCube }, // 159
  { Intrinsic::amdgcn_image_gather4_cube, IMAGE_GATHER4, AMDGPUDimCube }, // 160
  { Intrinsic::amdgcn_image_gather4_l_2d, IMAGE_GATHER4_L, AMDGPUDim2D }, // 161
  { Intrinsic::amdgcn_image_gather4_l_2darray, IMAGE_GATHER4_L, AMDGPUDim2DArray }, // 162
  { Intrinsic::amdgcn_image_gather4_l_cube, IMAGE_GATHER4_L, AMDGPUDimCube }, // 163
  { Intrinsic::amdgcn_image_gather4_l_o_2d, IMAGE_GATHER4_L_O, AMDGPUDim2D }, // 164
  { Intrinsic::amdgcn_image_gather4_l_o_2darray, IMAGE_GATHER4_L_O, AMDGPUDim2DArray }, // 165
  { Intrinsic::amdgcn_image_gather4_l_o_cube, IMAGE_GATHER4_L_O, AMDGPUDimCube }, // 166
  { Intrinsic::amdgcn_image_gather4_lz_2d, IMAGE_GATHER4_LZ, AMDGPUDim2D }, // 167
  { Intrinsic::amdgcn_image_gather4_lz_2darray, IMAGE_GATHER4_LZ, AMDGPUDim2DArray }, // 168
  { Intrinsic::amdgcn_image_gather4_lz_cube, IMAGE_GATHER4_LZ, AMDGPUDimCube }, // 169
  { Intrinsic::amdgcn_image_gather4_lz_o_2d, IMAGE_GATHER4_LZ_O, AMDGPUDim2D }, // 170
  { Intrinsic::amdgcn_image_gather4_lz_o_2darray, IMAGE_GATHER4_LZ_O, AMDGPUDim2DArray }, // 171
  { Intrinsic::amdgcn_image_gather4_lz_o_cube, IMAGE_GATHER4_LZ_O, AMDGPUDimCube }, // 172
  { Intrinsic::amdgcn_image_gather4_o_2d, IMAGE_GATHER4_O, AMDGPUDim2D }, // 173
  { Intrinsic::amdgcn_image_gather4_o_2darray, IMAGE_GATHER4_O, AMDGPUDim2DArray }, // 174
  { Intrinsic::amdgcn_image_gather4_o_cube, IMAGE_GATHER4_O, AMDGPUDimCube }, // 175
  { Intrinsic::amdgcn_image_getlod_1d, IMAGE_GET_LOD, AMDGPUDim1D }, // 176
  { Intrinsic::amdgcn_image_getlod_1darray, IMAGE_GET_LOD, AMDGPUDim1DArray }, // 177
  { Intrinsic::amdgcn_image_getlod_2d, IMAGE_GET_LOD, AMDGPUDim2D }, // 178
  { Intrinsic::amdgcn_image_getlod_2darray, IMAGE_GET_LOD, AMDGPUDim2DArray }, // 179
  { Intrinsic::amdgcn_image_getlod_3d, IMAGE_GET_LOD, AMDGPUDim3D }, // 180
  { Intrinsic::amdgcn_image_getlod_cube, IMAGE_GET_LOD, AMDGPUDimCube }, // 181
  { Intrinsic::amdgcn_image_getresinfo_1d, IMAGE_GET_RESINFO, AMDGPUDim1D }, // 182
  { Intrinsic::amdgcn_image_getresinfo_1darray, IMAGE_GET_RESINFO, AMDGPUDim1DArray }, // 183
  { Intrinsic::amdgcn_image_getresinfo_2d, IMAGE_GET_RESINFO, AMDGPUDim2D }, // 184
  { Intrinsic::amdgcn_image_getresinfo_2darray, IMAGE_GET_RESINFO, AMDGPUDim2DArray }, // 185
  { Intrinsic::amdgcn_image_getresinfo_2darraymsaa, IMAGE_GET_RESINFO, AMDGPUDim2DArrayMsaa }, // 186
  { Intrinsic::amdgcn_image_getresinfo_2dmsaa, IMAGE_GET_RESINFO, AMDGPUDim2DMsaa }, // 187
  { Intrinsic::amdgcn_image_getresinfo_3d, IMAGE_GET_RESINFO, AMDGPUDim3D }, // 188
  { Intrinsic::amdgcn_image_getresinfo_cube, IMAGE_GET_RESINFO, AMDGPUDimCube }, // 189
  { Intrinsic::amdgcn_image_load_1d, IMAGE_LOAD, AMDGPUDim1D }, // 190
  { Intrinsic::amdgcn_image_load_1darray, IMAGE_LOAD, AMDGPUDim1DArray }, // 191
  { Intrinsic::amdgcn_image_load_2d, IMAGE_LOAD, AMDGPUDim2D }, // 192
  { Intrinsic::amdgcn_image_load_2darray, IMAGE_LOAD, AMDGPUDim2DArray }, // 193
  { Intrinsic::amdgcn_image_load_2darraymsaa, IMAGE_LOAD, AMDGPUDim2DArrayMsaa }, // 194
  { Intrinsic::amdgcn_image_load_2dmsaa, IMAGE_LOAD, AMDGPUDim2DMsaa }, // 195
  { Intrinsic::amdgcn_image_load_3d, IMAGE_LOAD, AMDGPUDim3D }, // 196
  { Intrinsic::amdgcn_image_load_cube, IMAGE_LOAD, AMDGPUDimCube }, // 197
  { Intrinsic::amdgcn_image_load_mip_1d, IMAGE_LOAD_MIP, AMDGPUDim1D }, // 198
  { Intrinsic::amdgcn_image_load_mip_1darray, IMAGE_LOAD_MIP, AMDGPUDim1DArray }, // 199
  { Intrinsic::amdgcn_image_load_mip_2d, IMAGE_LOAD_MIP, AMDGPUDim2D }, // 200
  { Intrinsic::amdgcn_image_load_mip_2darray, IMAGE_LOAD_MIP, AMDGPUDim2DArray }, // 201
  { Intrinsic::amdgcn_image_load_mip_3d, IMAGE_LOAD_MIP, AMDGPUDim3D }, // 202
  { Intrinsic::amdgcn_image_load_mip_cube, IMAGE_LOAD_MIP, AMDGPUDimCube }, // 203
  { Intrinsic::amdgcn_image_sample_1d, IMAGE_SAMPLE, AMDGPUDim1D }, // 204
  { Intrinsic::amdgcn_image_sample_1darray, IMAGE_SAMPLE, AMDGPUDim1DArray }, // 205
  { Intrinsic::amdgcn_image_sample_2d, IMAGE_SAMPLE, AMDGPUDim2D }, // 206
  { Intrinsic::amdgcn_image_sample_2darray, IMAGE_SAMPLE, AMDGPUDim2DArray }, // 207
  { Intrinsic::amdgcn_image_sample_3d, IMAGE_SAMPLE, AMDGPUDim3D }, // 208
  { Intrinsic::amdgcn_image_sample_b_1d, IMAGE_SAMPLE_B, AMDGPUDim1D }, // 209
  { Intrinsic::amdgcn_image_sample_b_1darray, IMAGE_SAMPLE_B, AMDGPUDim1DArray }, // 210
  { Intrinsic::amdgcn_image_sample_b_2d, IMAGE_SAMPLE_B, AMDGPUDim2D }, // 211
  { Intrinsic::amdgcn_image_sample_b_2darray, IMAGE_SAMPLE_B, AMDGPUDim2DArray }, // 212
  { Intrinsic::amdgcn_image_sample_b_3d, IMAGE_SAMPLE_B, AMDGPUDim3D }, // 213
  { Intrinsic::amdgcn_image_sample_b_cl_1d, IMAGE_SAMPLE_B_CL, AMDGPUDim1D }, // 214
  { Intrinsic::amdgcn_image_sample_b_cl_1darray, IMAGE_SAMPLE_B_CL, AMDGPUDim1DArray }, // 215
  { Intrinsic::amdgcn_image_sample_b_cl_2d, IMAGE_SAMPLE_B_CL, AMDGPUDim2D }, // 216
  { Intrinsic::amdgcn_image_sample_b_cl_2darray, IMAGE_SAMPLE_B_CL, AMDGPUDim2DArray }, // 217
  { Intrinsic::amdgcn_image_sample_b_cl_3d, IMAGE_SAMPLE_B_CL, AMDGPUDim3D }, // 218
  { Intrinsic::amdgcn_image_sample_b_cl_cube, IMAGE_SAMPLE_B_CL, AMDGPUDimCube }, // 219
  { Intrinsic::amdgcn_image_sample_b_cl_o_1d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim1D }, // 220
  { Intrinsic::amdgcn_image_sample_b_cl_o_1darray, IMAGE_SAMPLE_B_CL_O, AMDGPUDim1DArray }, // 221
  { Intrinsic::amdgcn_image_sample_b_cl_o_2d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim2D }, // 222
  { Intrinsic::amdgcn_image_sample_b_cl_o_2darray, IMAGE_SAMPLE_B_CL_O, AMDGPUDim2DArray }, // 223
  { Intrinsic::amdgcn_image_sample_b_cl_o_3d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim3D }, // 224
  { Intrinsic::amdgcn_image_sample_b_cl_o_cube, IMAGE_SAMPLE_B_CL_O, AMDGPUDimCube }, // 225
  { Intrinsic::amdgcn_image_sample_b_cube, IMAGE_SAMPLE_B, AMDGPUDimCube }, // 226
  { Intrinsic::amdgcn_image_sample_b_o_1d, IMAGE_SAMPLE_B_O, AMDGPUDim1D }, // 227
  { Intrinsic::amdgcn_image_sample_b_o_1darray, IMAGE_SAMPLE_B_O, AMDGPUDim1DArray }, // 228
  { Intrinsic::amdgcn_image_sample_b_o_2d, IMAGE_SAMPLE_B_O, AMDGPUDim2D }, // 229
  { Intrinsic::amdgcn_image_sample_b_o_2darray, IMAGE_SAMPLE_B_O, AMDGPUDim2DArray }, // 230
  { Intrinsic::amdgcn_image_sample_b_o_3d, IMAGE_SAMPLE_B_O, AMDGPUDim3D }, // 231
  { Intrinsic::amdgcn_image_sample_b_o_cube, IMAGE_SAMPLE_B_O, AMDGPUDimCube }, // 232
  { Intrinsic::amdgcn_image_sample_c_1d, IMAGE_SAMPLE_C, AMDGPUDim1D }, // 233
  { Intrinsic::amdgcn_image_sample_c_1darray, IMAGE_SAMPLE_C, AMDGPUDim1DArray }, // 234
  { Intrinsic::amdgcn_image_sample_c_2d, IMAGE_SAMPLE_C, AMDGPUDim2D }, // 235
  { Intrinsic::amdgcn_image_sample_c_2darray, IMAGE_SAMPLE_C, AMDGPUDim2DArray }, // 236
  { Intrinsic::amdgcn_image_sample_c_3d, IMAGE_SAMPLE_C, AMDGPUDim3D }, // 237
  { Intrinsic::amdgcn_image_sample_c_b_1d, IMAGE_SAMPLE_C_B, AMDGPUDim1D }, // 238
  { Intrinsic::amdgcn_image_sample_c_b_1darray, IMAGE_SAMPLE_C_B, AMDGPUDim1DArray }, // 239
  { Intrinsic::amdgcn_image_sample_c_b_2d, IMAGE_SAMPLE_C_B, AMDGPUDim2D }, // 240
  { Intrinsic::amdgcn_image_sample_c_b_2darray, IMAGE_SAMPLE_C_B, AMDGPUDim2DArray }, // 241
  { Intrinsic::amdgcn_image_sample_c_b_3d, IMAGE_SAMPLE_C_B, AMDGPUDim3D }, // 242
  { Intrinsic::amdgcn_image_sample_c_b_cl_1d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim1D }, // 243
  { Intrinsic::amdgcn_image_sample_c_b_cl_1darray, IMAGE_SAMPLE_C_B_CL, AMDGPUDim1DArray }, // 244
  { Intrinsic::amdgcn_image_sample_c_b_cl_2d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim2D }, // 245
  { Intrinsic::amdgcn_image_sample_c_b_cl_2darray, IMAGE_SAMPLE_C_B_CL, AMDGPUDim2DArray }, // 246
  { Intrinsic::amdgcn_image_sample_c_b_cl_3d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim3D }, // 247
  { Intrinsic::amdgcn_image_sample_c_b_cl_cube, IMAGE_SAMPLE_C_B_CL, AMDGPUDimCube }, // 248
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1D }, // 249
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1darray, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1DArray }, // 250
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2D }, // 251
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2darray, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2DArray }, // 252
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_3d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim3D }, // 253
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_cube, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDimCube }, // 254
  { Intrinsic::amdgcn_image_sample_c_b_cube, IMAGE_SAMPLE_C_B, AMDGPUDimCube }, // 255
  { Intrinsic::amdgcn_image_sample_c_b_o_1d, IMAGE_SAMPLE_C_B_O, AMDGPUDim1D }, // 256
  { Intrinsic::amdgcn_image_sample_c_b_o_1darray, IMAGE_SAMPLE_C_B_O, AMDGPUDim1DArray }, // 257
  { Intrinsic::amdgcn_image_sample_c_b_o_2d, IMAGE_SAMPLE_C_B_O, AMDGPUDim2D }, // 258
  { Intrinsic::amdgcn_image_sample_c_b_o_2darray, IMAGE_SAMPLE_C_B_O, AMDGPUDim2DArray }, // 259
  { Intrinsic::amdgcn_image_sample_c_b_o_3d, IMAGE_SAMPLE_C_B_O, AMDGPUDim3D }, // 260
  { Intrinsic::amdgcn_image_sample_c_b_o_cube, IMAGE_SAMPLE_C_B_O, AMDGPUDimCube }, // 261
  { Intrinsic::amdgcn_image_sample_c_cd_1d, IMAGE_SAMPLE_C_CD, AMDGPUDim1D }, // 262
  { Intrinsic::amdgcn_image_sample_c_cd_1darray, IMAGE_SAMPLE_C_CD, AMDGPUDim1DArray }, // 263
  { Intrinsic::amdgcn_image_sample_c_cd_2d, IMAGE_SAMPLE_C_CD, AMDGPUDim2D }, // 264
  { Intrinsic::amdgcn_image_sample_c_cd_2darray, IMAGE_SAMPLE_C_CD, AMDGPUDim2DArray }, // 265
  { Intrinsic::amdgcn_image_sample_c_cd_3d, IMAGE_SAMPLE_C_CD, AMDGPUDim3D }, // 266
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1D }, // 267
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1darray, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1DArray }, // 268
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2D }, // 269
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2darray, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2DArray }, // 270
  { Intrinsic::amdgcn_image_sample_c_cd_cl_3d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim3D }, // 271
  { Intrinsic::amdgcn_image_sample_c_cd_cl_cube, IMAGE_SAMPLE_C_CD_CL, AMDGPUDimCube }, // 272
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1D }, // 273
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1darray, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1DArray }, // 274
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2D }, // 275
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2darray, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2DArray }, // 276
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_3d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim3D }, // 277
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_cube, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDimCube }, // 278
  { Intrinsic::amdgcn_image_sample_c_cd_cube, IMAGE_SAMPLE_C_CD, AMDGPUDimCube }, // 279
  { Intrinsic::amdgcn_image_sample_c_cd_o_1d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim1D }, // 280
  { Intrinsic::amdgcn_image_sample_c_cd_o_1darray, IMAGE_SAMPLE_C_CD_O, AMDGPUDim1DArray }, // 281
  { Intrinsic::amdgcn_image_sample_c_cd_o_2d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim2D }, // 282
  { Intrinsic::amdgcn_image_sample_c_cd_o_2darray, IMAGE_SAMPLE_C_CD_O, AMDGPUDim2DArray }, // 283
  { Intrinsic::amdgcn_image_sample_c_cd_o_3d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim3D }, // 284
  { Intrinsic::amdgcn_image_sample_c_cd_o_cube, IMAGE_SAMPLE_C_CD_O, AMDGPUDimCube }, // 285
  { Intrinsic::amdgcn_image_sample_c_cl_1d, IMAGE_SAMPLE_C_CL, AMDGPUDim1D }, // 286
  { Intrinsic::amdgcn_image_sample_c_cl_1darray, IMAGE_SAMPLE_C_CL, AMDGPUDim1DArray }, // 287
  { Intrinsic::amdgcn_image_sample_c_cl_2d, IMAGE_SAMPLE_C_CL, AMDGPUDim2D }, // 288
  { Intrinsic::amdgcn_image_sample_c_cl_2darray, IMAGE_SAMPLE_C_CL, AMDGPUDim2DArray }, // 289
  { Intrinsic::amdgcn_image_sample_c_cl_3d, IMAGE_SAMPLE_C_CL, AMDGPUDim3D }, // 290
  { Intrinsic::amdgcn_image_sample_c_cl_cube, IMAGE_SAMPLE_C_CL, AMDGPUDimCube }, // 291
  { Intrinsic::amdgcn_image_sample_c_cl_o_1d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim1D }, // 292
  { Intrinsic::amdgcn_image_sample_c_cl_o_1darray, IMAGE_SAMPLE_C_CL_O, AMDGPUDim1DArray }, // 293
  { Intrinsic::amdgcn_image_sample_c_cl_o_2d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim2D }, // 294
  { Intrinsic::amdgcn_image_sample_c_cl_o_2darray, IMAGE_SAMPLE_C_CL_O, AMDGPUDim2DArray }, // 295
  { Intrinsic::amdgcn_image_sample_c_cl_o_3d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim3D }, // 296
  { Intrinsic::amdgcn_image_sample_c_cl_o_cube, IMAGE_SAMPLE_C_CL_O, AMDGPUDimCube }, // 297
  { Intrinsic::amdgcn_image_sample_c_cube, IMAGE_SAMPLE_C, AMDGPUDimCube }, // 298
  { Intrinsic::amdgcn_image_sample_c_d_1d, IMAGE_SAMPLE_C_D, AMDGPUDim1D }, // 299
  { Intrinsic::amdgcn_image_sample_c_d_1darray, IMAGE_SAMPLE_C_D, AMDGPUDim1DArray }, // 300
  { Intrinsic::amdgcn_image_sample_c_d_2d, IMAGE_SAMPLE_C_D, AMDGPUDim2D }, // 301
  { Intrinsic::amdgcn_image_sample_c_d_2darray, IMAGE_SAMPLE_C_D, AMDGPUDim2DArray }, // 302
  { Intrinsic::amdgcn_image_sample_c_d_3d, IMAGE_SAMPLE_C_D, AMDGPUDim3D }, // 303
  { Intrinsic::amdgcn_image_sample_c_d_cl_1d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim1D }, // 304
  { Intrinsic::amdgcn_image_sample_c_d_cl_1darray, IMAGE_SAMPLE_C_D_CL, AMDGPUDim1DArray }, // 305
  { Intrinsic::amdgcn_image_sample_c_d_cl_2d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim2D }, // 306
  { Intrinsic::amdgcn_image_sample_c_d_cl_2darray, IMAGE_SAMPLE_C_D_CL, AMDGPUDim2DArray }, // 307
  { Intrinsic::amdgcn_image_sample_c_d_cl_3d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim3D }, // 308
  { Intrinsic::amdgcn_image_sample_c_d_cl_cube, IMAGE_SAMPLE_C_D_CL, AMDGPUDimCube }, // 309
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1D }, // 310
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1darray, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1DArray }, // 311
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2D }, // 312
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2darray, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2DArray }, // 313
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_3d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim3D }, // 314
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_cube, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDimCube }, // 315
  { Intrinsic::amdgcn_image_sample_c_d_cube, IMAGE_SAMPLE_C_D, AMDGPUDimCube }, // 316
  { Intrinsic::amdgcn_image_sample_c_d_o_1d, IMAGE_SAMPLE_C_D_O, AMDGPUDim1D }, // 317
  { Intrinsic::amdgcn_image_sample_c_d_o_1darray, IMAGE_SAMPLE_C_D_O, AMDGPUDim1DArray }, // 318
  { Intrinsic::amdgcn_image_sample_c_d_o_2d, IMAGE_SAMPLE_C_D_O, AMDGPUDim2D }, // 319
  { Intrinsic::amdgcn_image_sample_c_d_o_2darray, IMAGE_SAMPLE_C_D_O, AMDGPUDim2DArray }, // 320
  { Intrinsic::amdgcn_image_sample_c_d_o_3d, IMAGE_SAMPLE_C_D_O, AMDGPUDim3D }, // 321
  { Intrinsic::amdgcn_image_sample_c_d_o_cube, IMAGE_SAMPLE_C_D_O, AMDGPUDimCube }, // 322
  { Intrinsic::amdgcn_image_sample_c_l_1d, IMAGE_SAMPLE_C_L, AMDGPUDim1D }, // 323
  { Intrinsic::amdgcn_image_sample_c_l_1darray, IMAGE_SAMPLE_C_L, AMDGPUDim1DArray }, // 324
  { Intrinsic::amdgcn_image_sample_c_l_2d, IMAGE_SAMPLE_C_L, AMDGPUDim2D }, // 325
  { Intrinsic::amdgcn_image_sample_c_l_2darray, IMAGE_SAMPLE_C_L, AMDGPUDim2DArray }, // 326
  { Intrinsic::amdgcn_image_sample_c_l_3d, IMAGE_SAMPLE_C_L, AMDGPUDim3D }, // 327
  { Intrinsic::amdgcn_image_sample_c_l_cube, IMAGE_SAMPLE_C_L, AMDGPUDimCube }, // 328
  { Intrinsic::amdgcn_image_sample_c_l_o_1d, IMAGE_SAMPLE_C_L_O, AMDGPUDim1D }, // 329
  { Intrinsic::amdgcn_image_sample_c_l_o_1darray, IMAGE_SAMPLE_C_L_O, AMDGPUDim1DArray }, // 330
  { Intrinsic::amdgcn_image_sample_c_l_o_2d, IMAGE_SAMPLE_C_L_O, AMDGPUDim2D }, // 331
  { Intrinsic::amdgcn_image_sample_c_l_o_2darray, IMAGE_SAMPLE_C_L_O, AMDGPUDim2DArray }, // 332
  { Intrinsic::amdgcn_image_sample_c_l_o_3d, IMAGE_SAMPLE_C_L_O, AMDGPUDim3D }, // 333
  { Intrinsic::amdgcn_image_sample_c_l_o_cube, IMAGE_SAMPLE_C_L_O, AMDGPUDimCube }, // 334
  { Intrinsic::amdgcn_image_sample_c_lz_1d, IMAGE_SAMPLE_C_LZ, AMDGPUDim1D }, // 335
  { Intrinsic::amdgcn_image_sample_c_lz_1darray, IMAGE_SAMPLE_C_LZ, AMDGPUDim1DArray }, // 336
  { Intrinsic::amdgcn_image_sample_c_lz_2d, IMAGE_SAMPLE_C_LZ, AMDGPUDim2D }, // 337
  { Intrinsic::amdgcn_image_sample_c_lz_2darray, IMAGE_SAMPLE_C_LZ, AMDGPUDim2DArray }, // 338
  { Intrinsic::amdgcn_image_sample_c_lz_3d, IMAGE_SAMPLE_C_LZ, AMDGPUDim3D }, // 339
  { Intrinsic::amdgcn_image_sample_c_lz_cube, IMAGE_SAMPLE_C_LZ, AMDGPUDimCube }, // 340
  { Intrinsic::amdgcn_image_sample_c_lz_o_1d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1D }, // 341
  { Intrinsic::amdgcn_image_sample_c_lz_o_1darray, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1DArray }, // 342
  { Intrinsic::amdgcn_image_sample_c_lz_o_2d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2D }, // 343
  { Intrinsic::amdgcn_image_sample_c_lz_o_2darray, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2DArray }, // 344
  { Intrinsic::amdgcn_image_sample_c_lz_o_3d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim3D }, // 345
  { Intrinsic::amdgcn_image_sample_c_lz_o_cube, IMAGE_SAMPLE_C_LZ_O, AMDGPUDimCube }, // 346
  { Intrinsic::amdgcn_image_sample_c_o_1d, IMAGE_SAMPLE_C_O, AMDGPUDim1D }, // 347
  { Intrinsic::amdgcn_image_sample_c_o_1darray, IMAGE_SAMPLE_C_O, AMDGPUDim1DArray }, // 348
  { Intrinsic::amdgcn_image_sample_c_o_2d, IMAGE_SAMPLE_C_O, AMDGPUDim2D }, // 349
  { Intrinsic::amdgcn_image_sample_c_o_2darray, IMAGE_SAMPLE_C_O, AMDGPUDim2DArray }, // 350
  { Intrinsic::amdgcn_image_sample_c_o_3d, IMAGE_SAMPLE_C_O, AMDGPUDim3D }, // 351
  { Intrinsic::amdgcn_image_sample_c_o_cube, IMAGE_SAMPLE_C_O, AMDGPUDimCube }, // 352
  { Intrinsic::amdgcn_image_sample_cd_1d, IMAGE_SAMPLE_CD, AMDGPUDim1D }, // 353
  { Intrinsic::amdgcn_image_sample_cd_1darray, IMAGE_SAMPLE_CD, AMDGPUDim1DArray }, // 354
  { Intrinsic::amdgcn_image_sample_cd_2d, IMAGE_SAMPLE_CD, AMDGPUDim2D }, // 355
  { Intrinsic::amdgcn_image_sample_cd_2darray, IMAGE_SAMPLE_CD, AMDGPUDim2DArray }, // 356
  { Intrinsic::amdgcn_image_sample_cd_3d, IMAGE_SAMPLE_CD, AMDGPUDim3D }, // 357
  { Intrinsic::amdgcn_image_sample_cd_cl_1d, IMAGE_SAMPLE_CD_CL, AMDGPUDim1D }, // 358
  { Intrinsic::amdgcn_image_sample_cd_cl_1darray, IMAGE_SAMPLE_CD_CL, AMDGPUDim1DArray }, // 359
  { Intrinsic::amdgcn_image_sample_cd_cl_2d, IMAGE_SAMPLE_CD_CL, AMDGPUDim2D }, // 360
  { Intrinsic::amdgcn_image_sample_cd_cl_2darray, IMAGE_SAMPLE_CD_CL, AMDGPUDim2DArray }, // 361
  { Intrinsic::amdgcn_image_sample_cd_cl_3d, IMAGE_SAMPLE_CD_CL, AMDGPUDim3D }, // 362
  { Intrinsic::amdgcn_image_sample_cd_cl_cube, IMAGE_SAMPLE_CD_CL, AMDGPUDimCube }, // 363
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1D }, // 364
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1darray, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1DArray }, // 365
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2D }, // 366
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2darray, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2DArray }, // 367
  { Intrinsic::amdgcn_image_sample_cd_cl_o_3d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim3D }, // 368
  { Intrinsic::amdgcn_image_sample_cd_cl_o_cube, IMAGE_SAMPLE_CD_CL_O, AMDGPUDimCube }, // 369
  { Intrinsic::amdgcn_image_sample_cd_cube, IMAGE_SAMPLE_CD, AMDGPUDimCube }, // 370
  { Intrinsic::amdgcn_image_sample_cd_o_1d, IMAGE_SAMPLE_CD_O, AMDGPUDim1D }, // 371
  { Intrinsic::amdgcn_image_sample_cd_o_1darray, IMAGE_SAMPLE_CD_O, AMDGPUDim1DArray }, // 372
  { Intrinsic::amdgcn_image_sample_cd_o_2d, IMAGE_SAMPLE_CD_O, AMDGPUDim2D }, // 373
  { Intrinsic::amdgcn_image_sample_cd_o_2darray, IMAGE_SAMPLE_CD_O, AMDGPUDim2DArray }, // 374
  { Intrinsic::amdgcn_image_sample_cd_o_3d, IMAGE_SAMPLE_CD_O, AMDGPUDim3D }, // 375
  { Intrinsic::amdgcn_image_sample_cd_o_cube, IMAGE_SAMPLE_CD_O, AMDGPUDimCube }, // 376
  { Intrinsic::amdgcn_image_sample_cl_1d, IMAGE_SAMPLE_CL, AMDGPUDim1D }, // 377
  { Intrinsic::amdgcn_image_sample_cl_1darray, IMAGE_SAMPLE_CL, AMDGPUDim1DArray }, // 378
  { Intrinsic::amdgcn_image_sample_cl_2d, IMAGE_SAMPLE_CL, AMDGPUDim2D }, // 379
  { Intrinsic::amdgcn_image_sample_cl_2darray, IMAGE_SAMPLE_CL, AMDGPUDim2DArray }, // 380
  { Intrinsic::amdgcn_image_sample_cl_3d, IMAGE_SAMPLE_CL, AMDGPUDim3D }, // 381
  { Intrinsic::amdgcn_image_sample_cl_cube, IMAGE_SAMPLE_CL, AMDGPUDimCube }, // 382
  { Intrinsic::amdgcn_image_sample_cl_o_1d, IMAGE_SAMPLE_CL_O, AMDGPUDim1D }, // 383
  { Intrinsic::amdgcn_image_sample_cl_o_1darray, IMAGE_SAMPLE_CL_O, AMDGPUDim1DArray }, // 384
  { Intrinsic::amdgcn_image_sample_cl_o_2d, IMAGE_SAMPLE_CL_O, AMDGPUDim2D }, // 385
  { Intrinsic::amdgcn_image_sample_cl_o_2darray, IMAGE_SAMPLE_CL_O, AMDGPUDim2DArray }, // 386
  { Intrinsic::amdgcn_image_sample_cl_o_3d, IMAGE_SAMPLE_CL_O, AMDGPUDim3D }, // 387
  { Intrinsic::amdgcn_image_sample_cl_o_cube, IMAGE_SAMPLE_CL_O, AMDGPUDimCube }, // 388
  { Intrinsic::amdgcn_image_sample_cube, IMAGE_SAMPLE, AMDGPUDimCube }, // 389
  { Intrinsic::amdgcn_image_sample_d_1d, IMAGE_SAMPLE_D, AMDGPUDim1D }, // 390
  { Intrinsic::amdgcn_image_sample_d_1darray, IMAGE_SAMPLE_D, AMDGPUDim1DArray }, // 391
  { Intrinsic::amdgcn_image_sample_d_2d, IMAGE_SAMPLE_D, AMDGPUDim2D }, // 392
  { Intrinsic::amdgcn_image_sample_d_2darray, IMAGE_SAMPLE_D, AMDGPUDim2DArray }, // 393
  { Intrinsic::amdgcn_image_sample_d_3d, IMAGE_SAMPLE_D, AMDGPUDim3D }, // 394
  { Intrinsic::amdgcn_image_sample_d_cl_1d, IMAGE_SAMPLE_D_CL, AMDGPUDim1D }, // 395
  { Intrinsic::amdgcn_image_sample_d_cl_1darray, IMAGE_SAMPLE_D_CL, AMDGPUDim1DArray }, // 396
  { Intrinsic::amdgcn_image_sample_d_cl_2d, IMAGE_SAMPLE_D_CL, AMDGPUDim2D }, // 397
  { Intrinsic::amdgcn_image_sample_d_cl_2darray, IMAGE_SAMPLE_D_CL, AMDGPUDim2DArray }, // 398
  { Intrinsic::amdgcn_image_sample_d_cl_3d, IMAGE_SAMPLE_D_CL, AMDGPUDim3D }, // 399
  { Intrinsic::amdgcn_image_sample_d_cl_cube, IMAGE_SAMPLE_D_CL, AMDGPUDimCube }, // 400
  { Intrinsic::amdgcn_image_sample_d_cl_o_1d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim1D }, // 401
  { Intrinsic::amdgcn_image_sample_d_cl_o_1darray, IMAGE_SAMPLE_D_CL_O, AMDGPUDim1DArray }, // 402
  { Intrinsic::amdgcn_image_sample_d_cl_o_2d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim2D }, // 403
  { Intrinsic::amdgcn_image_sample_d_cl_o_2darray, IMAGE_SAMPLE_D_CL_O, AMDGPUDim2DArray }, // 404
  { Intrinsic::amdgcn_image_sample_d_cl_o_3d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim3D }, // 405
  { Intrinsic::amdgcn_image_sample_d_cl_o_cube, IMAGE_SAMPLE_D_CL_O, AMDGPUDimCube }, // 406
  { Intrinsic::amdgcn_image_sample_d_cube, IMAGE_SAMPLE_D, AMDGPUDimCube }, // 407
  { Intrinsic::amdgcn_image_sample_d_o_1d, IMAGE_SAMPLE_D_O, AMDGPUDim1D }, // 408
  { Intrinsic::amdgcn_image_sample_d_o_1darray, IMAGE_SAMPLE_D_O, AMDGPUDim1DArray }, // 409
  { Intrinsic::amdgcn_image_sample_d_o_2d, IMAGE_SAMPLE_D_O, AMDGPUDim2D }, // 410
  { Intrinsic::amdgcn_image_sample_d_o_2darray, IMAGE_SAMPLE_D_O, AMDGPUDim2DArray }, // 411
  { Intrinsic::amdgcn_image_sample_d_o_3d, IMAGE_SAMPLE_D_O, AMDGPUDim3D }, // 412
  { Intrinsic::amdgcn_image_sample_d_o_cube, IMAGE_SAMPLE_D_O, AMDGPUDimCube }, // 413
  { Intrinsic::amdgcn_image_sample_l_1d, IMAGE_SAMPLE_L, AMDGPUDim1D }, // 414
  { Intrinsic::amdgcn_image_sample_l_1darray, IMAGE_SAMPLE_L, AMDGPUDim1DArray }, // 415
  { Intrinsic::amdgcn_image_sample_l_2d, IMAGE_SAMPLE_L, AMDGPUDim2D }, // 416
  { Intrinsic::amdgcn_image_sample_l_2darray, IMAGE_SAMPLE_L, AMDGPUDim2DArray }, // 417
  { Intrinsic::amdgcn_image_sample_l_3d, IMAGE_SAMPLE_L, AMDGPUDim3D }, // 418
  { Intrinsic::amdgcn_image_sample_l_cube, IMAGE_SAMPLE_L, AMDGPUDimCube }, // 419
  { Intrinsic::amdgcn_image_sample_l_o_1d, IMAGE_SAMPLE_L_O, AMDGPUDim1D }, // 420
  { Intrinsic::amdgcn_image_sample_l_o_1darray, IMAGE_SAMPLE_L_O, AMDGPUDim1DArray }, // 421
  { Intrinsic::amdgcn_image_sample_l_o_2d, IMAGE_SAMPLE_L_O, AMDGPUDim2D }, // 422
  { Intrinsic::amdgcn_image_sample_l_o_2darray, IMAGE_SAMPLE_L_O, AMDGPUDim2DArray }, // 423
  { Intrinsic::amdgcn_image_sample_l_o_3d, IMAGE_SAMPLE_L_O, AMDGPUDim3D }, // 424
  { Intrinsic::amdgcn_image_sample_l_o_cube, IMAGE_SAMPLE_L_O, AMDGPUDimCube }, // 425
  { Intrinsic::amdgcn_image_sample_lz_1d, IMAGE_SAMPLE_LZ, AMDGPUDim1D }, // 426
  { Intrinsic::amdgcn_image_sample_lz_1darray, IMAGE_SAMPLE_LZ, AMDGPUDim1DArray }, // 427
  { Intrinsic::amdgcn_image_sample_lz_2d, IMAGE_SAMPLE_LZ, AMDGPUDim2D }, // 428
  { Intrinsic::amdgcn_image_sample_lz_2darray, IMAGE_SAMPLE_LZ, AMDGPUDim2DArray }, // 429
  { Intrinsic::amdgcn_image_sample_lz_3d, IMAGE_SAMPLE_LZ, AMDGPUDim3D }, // 430
  { Intrinsic::amdgcn_image_sample_lz_cube, IMAGE_SAMPLE_LZ, AMDGPUDimCube }, // 431
  { Intrinsic::amdgcn_image_sample_lz_o_1d, IMAGE_SAMPLE_LZ_O, AMDGPUDim1D }, // 432
  { Intrinsic::amdgcn_image_sample_lz_o_1darray, IMAGE_SAMPLE_LZ_O, AMDGPUDim1DArray }, // 433
  { Intrinsic::amdgcn_image_sample_lz_o_2d, IMAGE_SAMPLE_LZ_O, AMDGPUDim2D }, // 434
  { Intrinsic::amdgcn_image_sample_lz_o_2darray, IMAGE_SAMPLE_LZ_O, AMDGPUDim2DArray }, // 435
  { Intrinsic::amdgcn_image_sample_lz_o_3d, IMAGE_SAMPLE_LZ_O, AMDGPUDim3D }, // 436
  { Intrinsic::amdgcn_image_sample_lz_o_cube, IMAGE_SAMPLE_LZ_O, AMDGPUDimCube }, // 437
  { Intrinsic::amdgcn_image_sample_o_1d, IMAGE_SAMPLE_O, AMDGPUDim1D }, // 438
  { Intrinsic::amdgcn_image_sample_o_1darray, IMAGE_SAMPLE_O, AMDGPUDim1DArray }, // 439
  { Intrinsic::amdgcn_image_sample_o_2d, IMAGE_SAMPLE_O, AMDGPUDim2D }, // 440
  { Intrinsic::amdgcn_image_sample_o_2darray, IMAGE_SAMPLE_O, AMDGPUDim2DArray }, // 441
  { Intrinsic::amdgcn_image_sample_o_3d, IMAGE_SAMPLE_O, AMDGPUDim3D }, // 442
  { Intrinsic::amdgcn_image_sample_o_cube, IMAGE_SAMPLE_O, AMDGPUDimCube }, // 443
  { Intrinsic::amdgcn_image_store_1d, IMAGE_STORE, AMDGPUDim1D }, // 444
  { Intrinsic::amdgcn_image_store_1darray, IMAGE_STORE, AMDGPUDim1DArray }, // 445
  { Intrinsic::amdgcn_image_store_2d, IMAGE_STORE, AMDGPUDim2D }, // 446
  { Intrinsic::amdgcn_image_store_2darray, IMAGE_STORE, AMDGPUDim2DArray }, // 447
  { Intrinsic::amdgcn_image_store_2darraymsaa, IMAGE_STORE, AMDGPUDim2DArrayMsaa }, // 448
  { Intrinsic::amdgcn_image_store_2dmsaa, IMAGE_STORE, AMDGPUDim2DMsaa }, // 449
  { Intrinsic::amdgcn_image_store_3d, IMAGE_STORE, AMDGPUDim3D }, // 450
  { Intrinsic::amdgcn_image_store_cube, IMAGE_STORE, AMDGPUDimCube }, // 451
  { Intrinsic::amdgcn_image_store_mip_1d, IMAGE_STORE_MIP, AMDGPUDim1D }, // 452
  { Intrinsic::amdgcn_image_store_mip_1darray, IMAGE_STORE_MIP, AMDGPUDim1DArray }, // 453
  { Intrinsic::amdgcn_image_store_mip_2d, IMAGE_STORE_MIP, AMDGPUDim2D }, // 454
  { Intrinsic::amdgcn_image_store_mip_2darray, IMAGE_STORE_MIP, AMDGPUDim2DArray }, // 455
  { Intrinsic::amdgcn_image_store_mip_3d, IMAGE_STORE_MIP, AMDGPUDim3D }, // 456
  { Intrinsic::amdgcn_image_store_mip_cube, IMAGE_STORE_MIP, AMDGPUDimCube }, // 457
 };

const ImageDimIntrinsicInfo *getImageDimIntrinsicInfo(unsigned Intr) {
  if ((Intr < Intrinsic::amdgcn_image_atomic_add_1d) ||
      (Intr > Intrinsic::amdgcn_image_store_mip_cube))
    return nullptr;

  struct KeyType {
    unsigned Intr;
  };
  KeyType Key = { Intr };
  auto Table = makeArrayRef(ImageDimIntrinsicTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const ImageDimIntrinsicInfo &LHS, const KeyType &RHS) {
      if (LHS.Intr < RHS.Intr)
        return true;
      if (LHS.Intr > RHS.Intr)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Intr != Idx->Intr)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_MIMGBaseOpcodesTable_DECL
const MIMGBaseOpcodeInfo *getMIMGBaseOpcodeInfo(unsigned BaseOpcode);
#endif

#ifdef GET_MIMGBaseOpcodesTable_IMPL
const MIMGBaseOpcodeInfo MIMGBaseOpcodesTable[] = {
  { IMAGE_ATOMIC_ADD, false, true, false, false, 0x0, false, true, false, false }, // 0
  { IMAGE_ATOMIC_AND, false, true, false, false, 0x0, false, true, false, false }, // 1
  { IMAGE_ATOMIC_CMPSWAP, false, true, true, false, 0x0, false, true, false, false }, // 2
  { IMAGE_ATOMIC_DEC, false, true, false, false, 0x0, false, true, false, false }, // 3
  { IMAGE_ATOMIC_INC, false, true, false, false, 0x0, false, true, false, false }, // 4
  { IMAGE_ATOMIC_OR, false, true, false, false, 0x0, false, true, false, false }, // 5
  { IMAGE_ATOMIC_SMAX, false, true, false, false, 0x0, false, true, false, false }, // 6
  { IMAGE_ATOMIC_SMIN, false, true, false, false, 0x0, false, true, false, false }, // 7
  { IMAGE_ATOMIC_SUB, false, true, false, false, 0x0, false, true, false, false }, // 8
  { IMAGE_ATOMIC_SWAP, false, true, false, false, 0x0, false, true, false, false }, // 9
  { IMAGE_ATOMIC_UMAX, false, true, false, false, 0x0, false, true, false, false }, // 10
  { IMAGE_ATOMIC_UMIN, false, true, false, false, 0x0, false, true, false, false }, // 11
  { IMAGE_ATOMIC_XOR, false, true, false, false, 0x0, false, true, false, false }, // 12
  { IMAGE_GATHER4, false, false, false, true, 0x0, false, true, false, true }, // 13
  { IMAGE_GATHER4_B, false, false, false, true, 0x1, false, true, false, true }, // 14
  { IMAGE_GATHER4_B_CL, false, false, false, true, 0x1, false, true, true, true }, // 15
  { IMAGE_GATHER4_B_CL_O, false, false, false, true, 0x2, false, true, true, true }, // 16
  { IMAGE_GATHER4_B_O, false, false, false, true, 0x2, false, true, false, true }, // 17
  { IMAGE_GATHER4_C, false, false, false, true, 0x1, false, true, false, true }, // 18
  { IMAGE_GATHER4_CL, false, false, false, true, 0x0, false, true, true, true }, // 19
  { IMAGE_GATHER4_CL_O, false, false, false, true, 0x1, false, true, true, true }, // 20
  { IMAGE_GATHER4_C_B, false, false, false, true, 0x2, false, true, false, true }, // 21
  { IMAGE_GATHER4_C_B_CL, false, false, false, true, 0x2, false, true, true, true }, // 22
  { IMAGE_GATHER4_C_B_CL_O, false, false, false, true, 0x3, false, true, true, true }, // 23
  { IMAGE_GATHER4_C_B_O, false, false, false, true, 0x3, false, true, false, true }, // 24
  { IMAGE_GATHER4_C_CL, false, false, false, true, 0x1, false, true, true, true }, // 25
  { IMAGE_GATHER4_C_CL_O, false, false, false, true, 0x2, false, true, true, true }, // 26
  { IMAGE_GATHER4_C_L, false, false, false, true, 0x1, false, true, true, true }, // 27
  { IMAGE_GATHER4_C_LZ, false, false, false, true, 0x1, false, true, false, true }, // 28
  { IMAGE_GATHER4_C_LZ_O, false, false, false, true, 0x2, false, true, false, true }, // 29
  { IMAGE_GATHER4_C_L_O, false, false, false, true, 0x2, false, true, true, true }, // 30
  { IMAGE_GATHER4_C_O, false, false, false, true, 0x2, false, true, false, true }, // 31
  { IMAGE_GATHER4_L, false, false, false, true, 0x0, false, true, true, true }, // 32
  { IMAGE_GATHER4_LZ, false, false, false, true, 0x0, false, true, false, true }, // 33
  { IMAGE_GATHER4_LZ_O, false, false, false, true, 0x1, false, true, false, true }, // 34
  { IMAGE_GATHER4_L_O, false, false, false, true, 0x1, false, true, true, true }, // 35
  { IMAGE_GATHER4_O, false, false, false, true, 0x1, false, true, false, true }, // 36
  { IMAGE_GET_LOD, false, false, false, true, 0x0, false, true, false, false }, // 37
  { IMAGE_GET_RESINFO, false, false, false, false, 0x0, false, false, true, false }, // 38
  { IMAGE_LOAD, false, false, false, false, 0x0, false, true, false, true }, // 39
  { IMAGE_LOAD_MIP, false, false, false, false, 0x0, false, true, true, true }, // 40
  { IMAGE_LOAD_MIP_PCK, false, false, false, false, 0x0, false, true, true, false }, // 41
  { IMAGE_LOAD_MIP_PCK_SGN, false, false, false, false, 0x0, false, true, true, false }, // 42
  { IMAGE_LOAD_PCK, false, false, false, false, 0x0, false, true, false, false }, // 43
  { IMAGE_LOAD_PCK_SGN, false, false, false, false, 0x0, false, true, false, false }, // 44
  { IMAGE_SAMPLE, false, false, false, true, 0x0, false, true, false, true }, // 45
  { IMAGE_SAMPLE_B, false, false, false, true, 0x1, false, true, false, true }, // 46
  { IMAGE_SAMPLE_B_CL, false, false, false, true, 0x1, false, true, true, true }, // 47
  { IMAGE_SAMPLE_B_CL_O, false, false, false, true, 0x2, false, true, true, true }, // 48
  { IMAGE_SAMPLE_B_O, false, false, false, true, 0x2, false, true, false, true }, // 49
  { IMAGE_SAMPLE_C, false, false, false, true, 0x1, false, true, false, true }, // 50
  { IMAGE_SAMPLE_CD, false, false, false, true, 0x0, true, true, false, true }, // 51
  { IMAGE_SAMPLE_CD_CL, false, false, false, true, 0x0, true, true, true, true }, // 52
  { IMAGE_SAMPLE_CD_CL_O, false, false, false, true, 0x1, true, true, true, true }, // 53
  { IMAGE_SAMPLE_CD_O, false, false, false, true, 0x1, true, true, false, true }, // 54
  { IMAGE_SAMPLE_CL, false, false, false, true, 0x0, false, true, true, true }, // 55
  { IMAGE_SAMPLE_CL_O, false, false, false, true, 0x1, false, true, true, true }, // 56
  { IMAGE_SAMPLE_C_B, false, false, false, true, 0x2, false, true, false, true }, // 57
  { IMAGE_SAMPLE_C_B_CL, false, false, false, true, 0x2, false, true, true, true }, // 58
  { IMAGE_SAMPLE_C_B_CL_O, false, false, false, true, 0x3, false, true, true, true }, // 59
  { IMAGE_SAMPLE_C_B_O, false, false, false, true, 0x3, false, true, false, true }, // 60
  { IMAGE_SAMPLE_C_CD, false, false, false, true, 0x1, true, true, false, true }, // 61
  { IMAGE_SAMPLE_C_CD_CL, false, false, false, true, 0x1, true, true, true, true }, // 62
  { IMAGE_SAMPLE_C_CD_CL_O, false, false, false, true, 0x2, true, true, true, true }, // 63
  { IMAGE_SAMPLE_C_CD_O, false, false, false, true, 0x2, true, true, false, true }, // 64
  { IMAGE_SAMPLE_C_CL, false, false, false, true, 0x1, false, true, true, true }, // 65
  { IMAGE_SAMPLE_C_CL_O, false, false, false, true, 0x2, false, true, true, true }, // 66
  { IMAGE_SAMPLE_C_D, false, false, false, true, 0x1, true, true, false, true }, // 67
  { IMAGE_SAMPLE_C_D_CL, false, false, false, true, 0x1, true, true, true, true }, // 68
  { IMAGE_SAMPLE_C_D_CL_O, false, false, false, true, 0x2, true, true, true, true }, // 69
  { IMAGE_SAMPLE_C_D_O, false, false, false, true, 0x2, true, true, false, true }, // 70
  { IMAGE_SAMPLE_C_L, false, false, false, true, 0x1, false, true, true, true }, // 71
  { IMAGE_SAMPLE_C_LZ, false, false, false, true, 0x1, false, true, false, true }, // 72
  { IMAGE_SAMPLE_C_LZ_O, false, false, false, true, 0x2, false, true, false, true }, // 73
  { IMAGE_SAMPLE_C_L_O, false, false, false, true, 0x2, false, true, true, true }, // 74
  { IMAGE_SAMPLE_C_O, false, false, false, true, 0x2, false, true, false, true }, // 75
  { IMAGE_SAMPLE_D, false, false, false, true, 0x0, true, true, false, true }, // 76
  { IMAGE_SAMPLE_D_CL, false, false, false, true, 0x0, true, true, true, true }, // 77
  { IMAGE_SAMPLE_D_CL_O, false, false, false, true, 0x1, true, true, true, true }, // 78
  { IMAGE_SAMPLE_D_O, false, false, false, true, 0x1, true, true, false, true }, // 79
  { IMAGE_SAMPLE_L, false, false, false, true, 0x0, false, true, true, true }, // 80
  { IMAGE_SAMPLE_LZ, false, false, false, true, 0x0, false, true, false, true }, // 81
  { IMAGE_SAMPLE_LZ_O, false, false, false, true, 0x1, false, true, false, true }, // 82
  { IMAGE_SAMPLE_L_O, false, false, false, true, 0x1, false, true, true, true }, // 83
  { IMAGE_SAMPLE_O, false, false, false, true, 0x1, false, true, false, true }, // 84
  { IMAGE_STORE, true, false, false, false, 0x0, false, true, false, true }, // 85
  { IMAGE_STORE_MIP, true, false, false, false, 0x0, false, true, true, true }, // 86
  { IMAGE_STORE_MIP_PCK, true, false, false, false, 0x0, false, true, true, false }, // 87
  { IMAGE_STORE_PCK, true, false, false, false, 0x0, false, true, false, false }, // 88
 };

const MIMGBaseOpcodeInfo *getMIMGBaseOpcodeInfo(unsigned BaseOpcode) {
  auto Table = makeArrayRef(MIMGBaseOpcodesTable);
  size_t Idx = BaseOpcode;
  return Idx >= Table.size() ? nullptr : &Table[Idx];
}
#endif

#ifdef GET_MIMGDimInfoTable_DECL
const MIMGDimInfo *getMIMGDimInfo(unsigned Dim);
#endif

#ifdef GET_MIMGDimInfoTable_IMPL
const MIMGDimInfo MIMGDimInfoTable[] = {
  { AMDGPUDim1D, 0x1, 0x2, false }, // 0
  { AMDGPUDim1DArray, 0x2, 0x2, true }, // 1
  { AMDGPUDim2D, 0x2, 0x4, false }, // 2
  { AMDGPUDim2DArray, 0x3, 0x4, true }, // 3
  { AMDGPUDim2DArrayMsaa, 0x4, 0x4, true }, // 4
  { AMDGPUDim2DMsaa, 0x3, 0x4, false }, // 5
  { AMDGPUDim3D, 0x3, 0x6, false }, // 6
  { AMDGPUDimCube, 0x3, 0x4, true }, // 7
 };

const MIMGDimInfo *getMIMGDimInfo(unsigned Dim) {
  auto Table = makeArrayRef(MIMGDimInfoTable);
  size_t Idx = Dim;
  return Idx >= Table.size() ? nullptr : &Table[Idx];
}
#endif

#ifdef GET_MIMGInfoTable_DECL
const MIMGInfo *getMIMGOpcodeHelper(unsigned BaseOpcode, unsigned MIMGEncoding, uint8_t VDataDwords, uint8_t VAddrDwords);
const MIMGInfo *getMIMGInfo(unsigned Opcode);
#endif

#ifdef GET_MIMGInfoTable_IMPL
const MIMGInfo MIMGInfoTable[] = {
  { IMAGE_ATOMIC_ADD_V1_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x1 }, // 0
  { IMAGE_ATOMIC_ADD_V1_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x2 }, // 1
  { IMAGE_ATOMIC_ADD_V1_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x3 }, // 2
  { IMAGE_ATOMIC_ADD_V1_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x4 }, // 3
  { IMAGE_ATOMIC_ADD_V2_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x1 }, // 4
  { IMAGE_ATOMIC_ADD_V2_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x2 }, // 5
  { IMAGE_ATOMIC_ADD_V2_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x3 }, // 6
  { IMAGE_ATOMIC_ADD_V2_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x4 }, // 7
  { IMAGE_ATOMIC_ADD_V1_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x1 }, // 8
  { IMAGE_ATOMIC_ADD_V1_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x2 }, // 9
  { IMAGE_ATOMIC_ADD_V1_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x3 }, // 10
  { IMAGE_ATOMIC_ADD_V1_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x4 }, // 11
  { IMAGE_ATOMIC_ADD_V2_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x1 }, // 12
  { IMAGE_ATOMIC_ADD_V2_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x2 }, // 13
  { IMAGE_ATOMIC_ADD_V2_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x3 }, // 14
  { IMAGE_ATOMIC_ADD_V2_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x4 }, // 15
  { IMAGE_ATOMIC_AND_V1_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x1 }, // 16
  { IMAGE_ATOMIC_AND_V1_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x2 }, // 17
  { IMAGE_ATOMIC_AND_V1_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x3 }, // 18
  { IMAGE_ATOMIC_AND_V1_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x4 }, // 19
  { IMAGE_ATOMIC_AND_V2_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x1 }, // 20
  { IMAGE_ATOMIC_AND_V2_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x2 }, // 21
  { IMAGE_ATOMIC_AND_V2_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x3 }, // 22
  { IMAGE_ATOMIC_AND_V2_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x4 }, // 23
  { IMAGE_ATOMIC_AND_V1_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x1 }, // 24
  { IMAGE_ATOMIC_AND_V1_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x2 }, // 25
  { IMAGE_ATOMIC_AND_V1_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x3 }, // 26
  { IMAGE_ATOMIC_AND_V1_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x4 }, // 27
  { IMAGE_ATOMIC_AND_V2_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x1 }, // 28
  { IMAGE_ATOMIC_AND_V2_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x2 }, // 29
  { IMAGE_ATOMIC_AND_V2_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x3 }, // 30
  { IMAGE_ATOMIC_AND_V2_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x4 }, // 31
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x1 }, // 32
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x2 }, // 33
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x3 }, // 34
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x4 }, // 35
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x1 }, // 36
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x2 }, // 37
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x3 }, // 38
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x4 }, // 39
  { IMAGE_ATOMIC_CMPSWAP_V1_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x1 }, // 40
  { IMAGE_ATOMIC_CMPSWAP_V1_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x2 }, // 41
  { IMAGE_ATOMIC_CMPSWAP_V1_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x3 }, // 42
  { IMAGE_ATOMIC_CMPSWAP_V1_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x4 }, // 43
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x1 }, // 44
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x2 }, // 45
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x3 }, // 46
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x4 }, // 47
  { IMAGE_ATOMIC_DEC_V1_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x1 }, // 48
  { IMAGE_ATOMIC_DEC_V1_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x2 }, // 49
  { IMAGE_ATOMIC_DEC_V1_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x3 }, // 50
  { IMAGE_ATOMIC_DEC_V1_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x4 }, // 51
  { IMAGE_ATOMIC_DEC_V2_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x1 }, // 52
  { IMAGE_ATOMIC_DEC_V2_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x2 }, // 53
  { IMAGE_ATOMIC_DEC_V2_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x3 }, // 54
  { IMAGE_ATOMIC_DEC_V2_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x4 }, // 55
  { IMAGE_ATOMIC_DEC_V1_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x1 }, // 56
  { IMAGE_ATOMIC_DEC_V1_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x2 }, // 57
  { IMAGE_ATOMIC_DEC_V1_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x3 }, // 58
  { IMAGE_ATOMIC_DEC_V1_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x4 }, // 59
  { IMAGE_ATOMIC_DEC_V2_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x1 }, // 60
  { IMAGE_ATOMIC_DEC_V2_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x2 }, // 61
  { IMAGE_ATOMIC_DEC_V2_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x3 }, // 62
  { IMAGE_ATOMIC_DEC_V2_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x4 }, // 63
  { IMAGE_ATOMIC_INC_V1_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x1 }, // 64
  { IMAGE_ATOMIC_INC_V1_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x2 }, // 65
  { IMAGE_ATOMIC_INC_V1_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x3 }, // 66
  { IMAGE_ATOMIC_INC_V1_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x4 }, // 67
  { IMAGE_ATOMIC_INC_V2_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x1 }, // 68
  { IMAGE_ATOMIC_INC_V2_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x2 }, // 69
  { IMAGE_ATOMIC_INC_V2_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x3 }, // 70
  { IMAGE_ATOMIC_INC_V2_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x4 }, // 71
  { IMAGE_ATOMIC_INC_V1_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x1 }, // 72
  { IMAGE_ATOMIC_INC_V1_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x2 }, // 73
  { IMAGE_ATOMIC_INC_V1_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x3 }, // 74
  { IMAGE_ATOMIC_INC_V1_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x4 }, // 75
  { IMAGE_ATOMIC_INC_V2_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x1 }, // 76
  { IMAGE_ATOMIC_INC_V2_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x2 }, // 77
  { IMAGE_ATOMIC_INC_V2_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x3 }, // 78
  { IMAGE_ATOMIC_INC_V2_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x4 }, // 79
  { IMAGE_ATOMIC_OR_V1_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x1 }, // 80
  { IMAGE_ATOMIC_OR_V1_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x2 }, // 81
  { IMAGE_ATOMIC_OR_V1_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x3 }, // 82
  { IMAGE_ATOMIC_OR_V1_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x4 }, // 83
  { IMAGE_ATOMIC_OR_V2_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x1 }, // 84
  { IMAGE_ATOMIC_OR_V2_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x2 }, // 85
  { IMAGE_ATOMIC_OR_V2_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x3 }, // 86
  { IMAGE_ATOMIC_OR_V2_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x4 }, // 87
  { IMAGE_ATOMIC_OR_V1_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x1 }, // 88
  { IMAGE_ATOMIC_OR_V1_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x2 }, // 89
  { IMAGE_ATOMIC_OR_V1_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x3 }, // 90
  { IMAGE_ATOMIC_OR_V1_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x4 }, // 91
  { IMAGE_ATOMIC_OR_V2_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x1 }, // 92
  { IMAGE_ATOMIC_OR_V2_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x2 }, // 93
  { IMAGE_ATOMIC_OR_V2_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x3 }, // 94
  { IMAGE_ATOMIC_OR_V2_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x4 }, // 95
  { IMAGE_ATOMIC_SMAX_V1_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x1 }, // 96
  { IMAGE_ATOMIC_SMAX_V1_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x2 }, // 97
  { IMAGE_ATOMIC_SMAX_V1_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x3 }, // 98
  { IMAGE_ATOMIC_SMAX_V1_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x4 }, // 99
  { IMAGE_ATOMIC_SMAX_V2_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x1 }, // 100
  { IMAGE_ATOMIC_SMAX_V2_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x2 }, // 101
  { IMAGE_ATOMIC_SMAX_V2_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x3 }, // 102
  { IMAGE_ATOMIC_SMAX_V2_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x4 }, // 103
  { IMAGE_ATOMIC_SMAX_V1_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x1 }, // 104
  { IMAGE_ATOMIC_SMAX_V1_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x2 }, // 105
  { IMAGE_ATOMIC_SMAX_V1_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x3 }, // 106
  { IMAGE_ATOMIC_SMAX_V1_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x4 }, // 107
  { IMAGE_ATOMIC_SMAX_V2_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x1 }, // 108
  { IMAGE_ATOMIC_SMAX_V2_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x2 }, // 109
  { IMAGE_ATOMIC_SMAX_V2_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x3 }, // 110
  { IMAGE_ATOMIC_SMAX_V2_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x4 }, // 111
  { IMAGE_ATOMIC_SMIN_V1_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x1 }, // 112
  { IMAGE_ATOMIC_SMIN_V1_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x2 }, // 113
  { IMAGE_ATOMIC_SMIN_V1_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x3 }, // 114
  { IMAGE_ATOMIC_SMIN_V1_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x4 }, // 115
  { IMAGE_ATOMIC_SMIN_V2_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x1 }, // 116
  { IMAGE_ATOMIC_SMIN_V2_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x2 }, // 117
  { IMAGE_ATOMIC_SMIN_V2_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x3 }, // 118
  { IMAGE_ATOMIC_SMIN_V2_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x4 }, // 119
  { IMAGE_ATOMIC_SMIN_V1_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x1 }, // 120
  { IMAGE_ATOMIC_SMIN_V1_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x2 }, // 121
  { IMAGE_ATOMIC_SMIN_V1_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x3 }, // 122
  { IMAGE_ATOMIC_SMIN_V1_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x4 }, // 123
  { IMAGE_ATOMIC_SMIN_V2_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x1 }, // 124
  { IMAGE_ATOMIC_SMIN_V2_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x2 }, // 125
  { IMAGE_ATOMIC_SMIN_V2_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x3 }, // 126
  { IMAGE_ATOMIC_SMIN_V2_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x4 }, // 127
  { IMAGE_ATOMIC_SUB_V1_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x1 }, // 128
  { IMAGE_ATOMIC_SUB_V1_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x2 }, // 129
  { IMAGE_ATOMIC_SUB_V1_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x3 }, // 130
  { IMAGE_ATOMIC_SUB_V1_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x4 }, // 131
  { IMAGE_ATOMIC_SUB_V2_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x1 }, // 132
  { IMAGE_ATOMIC_SUB_V2_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x2 }, // 133
  { IMAGE_ATOMIC_SUB_V2_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x3 }, // 134
  { IMAGE_ATOMIC_SUB_V2_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x4 }, // 135
  { IMAGE_ATOMIC_SUB_V1_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x1 }, // 136
  { IMAGE_ATOMIC_SUB_V1_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x2 }, // 137
  { IMAGE_ATOMIC_SUB_V1_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x3 }, // 138
  { IMAGE_ATOMIC_SUB_V1_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x4 }, // 139
  { IMAGE_ATOMIC_SUB_V2_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x1 }, // 140
  { IMAGE_ATOMIC_SUB_V2_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x2 }, // 141
  { IMAGE_ATOMIC_SUB_V2_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x3 }, // 142
  { IMAGE_ATOMIC_SUB_V2_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x4 }, // 143
  { IMAGE_ATOMIC_SWAP_V1_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x1 }, // 144
  { IMAGE_ATOMIC_SWAP_V1_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x2 }, // 145
  { IMAGE_ATOMIC_SWAP_V1_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x3 }, // 146
  { IMAGE_ATOMIC_SWAP_V1_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x4 }, // 147
  { IMAGE_ATOMIC_SWAP_V2_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x1 }, // 148
  { IMAGE_ATOMIC_SWAP_V2_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x2 }, // 149
  { IMAGE_ATOMIC_SWAP_V2_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x3 }, // 150
  { IMAGE_ATOMIC_SWAP_V2_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x4 }, // 151
  { IMAGE_ATOMIC_SWAP_V1_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x1 }, // 152
  { IMAGE_ATOMIC_SWAP_V1_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x2 }, // 153
  { IMAGE_ATOMIC_SWAP_V1_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x3 }, // 154
  { IMAGE_ATOMIC_SWAP_V1_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x4 }, // 155
  { IMAGE_ATOMIC_SWAP_V2_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x1 }, // 156
  { IMAGE_ATOMIC_SWAP_V2_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x2 }, // 157
  { IMAGE_ATOMIC_SWAP_V2_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x3 }, // 158
  { IMAGE_ATOMIC_SWAP_V2_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x4 }, // 159
  { IMAGE_ATOMIC_UMAX_V1_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x1 }, // 160
  { IMAGE_ATOMIC_UMAX_V1_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x2 }, // 161
  { IMAGE_ATOMIC_UMAX_V1_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x3 }, // 162
  { IMAGE_ATOMIC_UMAX_V1_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x4 }, // 163
  { IMAGE_ATOMIC_UMAX_V2_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x1 }, // 164
  { IMAGE_ATOMIC_UMAX_V2_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x2 }, // 165
  { IMAGE_ATOMIC_UMAX_V2_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x3 }, // 166
  { IMAGE_ATOMIC_UMAX_V2_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x4 }, // 167
  { IMAGE_ATOMIC_UMAX_V1_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x1 }, // 168
  { IMAGE_ATOMIC_UMAX_V1_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x2 }, // 169
  { IMAGE_ATOMIC_UMAX_V1_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x3 }, // 170
  { IMAGE_ATOMIC_UMAX_V1_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x4 }, // 171
  { IMAGE_ATOMIC_UMAX_V2_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x1 }, // 172
  { IMAGE_ATOMIC_UMAX_V2_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x2 }, // 173
  { IMAGE_ATOMIC_UMAX_V2_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x3 }, // 174
  { IMAGE_ATOMIC_UMAX_V2_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x4 }, // 175
  { IMAGE_ATOMIC_UMIN_V1_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x1 }, // 176
  { IMAGE_ATOMIC_UMIN_V1_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x2 }, // 177
  { IMAGE_ATOMIC_UMIN_V1_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x3 }, // 178
  { IMAGE_ATOMIC_UMIN_V1_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x4 }, // 179
  { IMAGE_ATOMIC_UMIN_V2_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x1 }, // 180
  { IMAGE_ATOMIC_UMIN_V2_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x2 }, // 181
  { IMAGE_ATOMIC_UMIN_V2_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x3 }, // 182
  { IMAGE_ATOMIC_UMIN_V2_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x4 }, // 183
  { IMAGE_ATOMIC_UMIN_V1_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x1 }, // 184
  { IMAGE_ATOMIC_UMIN_V1_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x2 }, // 185
  { IMAGE_ATOMIC_UMIN_V1_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x3 }, // 186
  { IMAGE_ATOMIC_UMIN_V1_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x4 }, // 187
  { IMAGE_ATOMIC_UMIN_V2_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x1 }, // 188
  { IMAGE_ATOMIC_UMIN_V2_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x2 }, // 189
  { IMAGE_ATOMIC_UMIN_V2_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x3 }, // 190
  { IMAGE_ATOMIC_UMIN_V2_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x4 }, // 191
  { IMAGE_ATOMIC_XOR_V1_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x1 }, // 192
  { IMAGE_ATOMIC_XOR_V1_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x2 }, // 193
  { IMAGE_ATOMIC_XOR_V1_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x3 }, // 194
  { IMAGE_ATOMIC_XOR_V1_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x4 }, // 195
  { IMAGE_ATOMIC_XOR_V2_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x1 }, // 196
  { IMAGE_ATOMIC_XOR_V2_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x2 }, // 197
  { IMAGE_ATOMIC_XOR_V2_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x3 }, // 198
  { IMAGE_ATOMIC_XOR_V2_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x4 }, // 199
  { IMAGE_ATOMIC_XOR_V1_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x1 }, // 200
  { IMAGE_ATOMIC_XOR_V1_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x2 }, // 201
  { IMAGE_ATOMIC_XOR_V1_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x3 }, // 202
  { IMAGE_ATOMIC_XOR_V1_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x4 }, // 203
  { IMAGE_ATOMIC_XOR_V2_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x1 }, // 204
  { IMAGE_ATOMIC_XOR_V2_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x2 }, // 205
  { IMAGE_ATOMIC_XOR_V2_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x3 }, // 206
  { IMAGE_ATOMIC_XOR_V2_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x4 }, // 207
  { IMAGE_GATHER4_V2_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x1 }, // 208
  { IMAGE_GATHER4_V2_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x2 }, // 209
  { IMAGE_GATHER4_V2_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x3 }, // 210
  { IMAGE_GATHER4_V2_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x4 }, // 211
  { IMAGE_GATHER4_V4_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x1 }, // 212
  { IMAGE_GATHER4_V4_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x2 }, // 213
  { IMAGE_GATHER4_V4_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x3 }, // 214
  { IMAGE_GATHER4_V4_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x4 }, // 215
  { IMAGE_GATHER4_B_V2_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x2 }, // 216
  { IMAGE_GATHER4_B_V2_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x3 }, // 217
  { IMAGE_GATHER4_B_V2_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x4 }, // 218
  { IMAGE_GATHER4_B_V4_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x2 }, // 219
  { IMAGE_GATHER4_B_V4_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x3 }, // 220
  { IMAGE_GATHER4_B_V4_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x4 }, // 221
  { IMAGE_GATHER4_B_CL_V2_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x2 }, // 222
  { IMAGE_GATHER4_B_CL_V2_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x3 }, // 223
  { IMAGE_GATHER4_B_CL_V2_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x4 }, // 224
  { IMAGE_GATHER4_B_CL_V2_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x8 }, // 225
  { IMAGE_GATHER4_B_CL_V4_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x2 }, // 226
  { IMAGE_GATHER4_B_CL_V4_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x3 }, // 227
  { IMAGE_GATHER4_B_CL_V4_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x4 }, // 228
  { IMAGE_GATHER4_B_CL_V4_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x8 }, // 229
  { IMAGE_GATHER4_B_CL_O_V2_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 230
  { IMAGE_GATHER4_B_CL_O_V2_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 231
  { IMAGE_GATHER4_B_CL_O_V2_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 232
  { IMAGE_GATHER4_B_CL_O_V4_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 233
  { IMAGE_GATHER4_B_CL_O_V4_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 234
  { IMAGE_GATHER4_B_CL_O_V4_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 235
  { IMAGE_GATHER4_B_O_V2_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x3 }, // 236
  { IMAGE_GATHER4_B_O_V2_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x4 }, // 237
  { IMAGE_GATHER4_B_O_V2_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x8 }, // 238
  { IMAGE_GATHER4_B_O_V4_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x3 }, // 239
  { IMAGE_GATHER4_B_O_V4_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x4 }, // 240
  { IMAGE_GATHER4_B_O_V4_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x8 }, // 241
  { IMAGE_GATHER4_C_V2_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x2 }, // 242
  { IMAGE_GATHER4_C_V2_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x3 }, // 243
  { IMAGE_GATHER4_C_V2_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x4 }, // 244
  { IMAGE_GATHER4_C_V4_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x2 }, // 245
  { IMAGE_GATHER4_C_V4_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x3 }, // 246
  { IMAGE_GATHER4_C_V4_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x4 }, // 247
  { IMAGE_GATHER4_CL_V2_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x1 }, // 248
  { IMAGE_GATHER4_CL_V2_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x2 }, // 249
  { IMAGE_GATHER4_CL_V2_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x3 }, // 250
  { IMAGE_GATHER4_CL_V2_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x4 }, // 251
  { IMAGE_GATHER4_CL_V4_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x1 }, // 252
  { IMAGE_GATHER4_CL_V4_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x2 }, // 253
  { IMAGE_GATHER4_CL_V4_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x3 }, // 254
  { IMAGE_GATHER4_CL_V4_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x4 }, // 255
  { IMAGE_GATHER4_CL_O_V2_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x2 }, // 256
  { IMAGE_GATHER4_CL_O_V2_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 257
  { IMAGE_GATHER4_CL_O_V2_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 258
  { IMAGE_GATHER4_CL_O_V2_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 259
  { IMAGE_GATHER4_CL_O_V4_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x2 }, // 260
  { IMAGE_GATHER4_CL_O_V4_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 261
  { IMAGE_GATHER4_CL_O_V4_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 262
  { IMAGE_GATHER4_CL_O_V4_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 263
  { IMAGE_GATHER4_C_B_V2_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x3 }, // 264
  { IMAGE_GATHER4_C_B_V2_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x4 }, // 265
  { IMAGE_GATHER4_C_B_V2_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x8 }, // 266
  { IMAGE_GATHER4_C_B_V4_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x3 }, // 267
  { IMAGE_GATHER4_C_B_V4_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x4 }, // 268
  { IMAGE_GATHER4_C_B_V4_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x8 }, // 269
  { IMAGE_GATHER4_C_B_CL_V2_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x3 }, // 270
  { IMAGE_GATHER4_C_B_CL_V2_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x4 }, // 271
  { IMAGE_GATHER4_C_B_CL_V2_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x8 }, // 272
  { IMAGE_GATHER4_C_B_CL_V4_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x3 }, // 273
  { IMAGE_GATHER4_C_B_CL_V4_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x4 }, // 274
  { IMAGE_GATHER4_C_B_CL_V4_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x8 }, // 275
  { IMAGE_GATHER4_C_B_CL_O_V2_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 276
  { IMAGE_GATHER4_C_B_CL_O_V2_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 277
  { IMAGE_GATHER4_C_B_CL_O_V4_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 278
  { IMAGE_GATHER4_C_B_CL_O_V4_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 279
  { IMAGE_GATHER4_C_B_O_V2_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x4 }, // 280
  { IMAGE_GATHER4_C_B_O_V2_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x8 }, // 281
  { IMAGE_GATHER4_C_B_O_V4_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x4 }, // 282
  { IMAGE_GATHER4_C_B_O_V4_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x8 }, // 283
  { IMAGE_GATHER4_C_CL_V2_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x2 }, // 284
  { IMAGE_GATHER4_C_CL_V2_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x3 }, // 285
  { IMAGE_GATHER4_C_CL_V2_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x4 }, // 286
  { IMAGE_GATHER4_C_CL_V2_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x8 }, // 287
  { IMAGE_GATHER4_C_CL_V4_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x2 }, // 288
  { IMAGE_GATHER4_C_CL_V4_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x3 }, // 289
  { IMAGE_GATHER4_C_CL_V4_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x4 }, // 290
  { IMAGE_GATHER4_C_CL_V4_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x8 }, // 291
  { IMAGE_GATHER4_C_CL_O_V2_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 292
  { IMAGE_GATHER4_C_CL_O_V2_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 293
  { IMAGE_GATHER4_C_CL_O_V2_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 294
  { IMAGE_GATHER4_C_CL_O_V4_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 295
  { IMAGE_GATHER4_C_CL_O_V4_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 296
  { IMAGE_GATHER4_C_CL_O_V4_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 297
  { IMAGE_GATHER4_C_L_V2_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x2 }, // 298
  { IMAGE_GATHER4_C_L_V2_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x3 }, // 299
  { IMAGE_GATHER4_C_L_V2_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x4 }, // 300
  { IMAGE_GATHER4_C_L_V2_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x8 }, // 301
  { IMAGE_GATHER4_C_L_V4_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x2 }, // 302
  { IMAGE_GATHER4_C_L_V4_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x3 }, // 303
  { IMAGE_GATHER4_C_L_V4_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x4 }, // 304
  { IMAGE_GATHER4_C_L_V4_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x8 }, // 305
  { IMAGE_GATHER4_C_LZ_V2_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x2 }, // 306
  { IMAGE_GATHER4_C_LZ_V2_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x3 }, // 307
  { IMAGE_GATHER4_C_LZ_V2_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x4 }, // 308
  { IMAGE_GATHER4_C_LZ_V4_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x2 }, // 309
  { IMAGE_GATHER4_C_LZ_V4_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x3 }, // 310
  { IMAGE_GATHER4_C_LZ_V4_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x4 }, // 311
  { IMAGE_GATHER4_C_LZ_O_V2_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x3 }, // 312
  { IMAGE_GATHER4_C_LZ_O_V2_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x4 }, // 313
  { IMAGE_GATHER4_C_LZ_O_V2_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x8 }, // 314
  { IMAGE_GATHER4_C_LZ_O_V4_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x3 }, // 315
  { IMAGE_GATHER4_C_LZ_O_V4_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x4 }, // 316
  { IMAGE_GATHER4_C_LZ_O_V4_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x8 }, // 317
  { IMAGE_GATHER4_C_L_O_V2_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x3 }, // 318
  { IMAGE_GATHER4_C_L_O_V2_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x4 }, // 319
  { IMAGE_GATHER4_C_L_O_V2_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x8 }, // 320
  { IMAGE_GATHER4_C_L_O_V4_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x3 }, // 321
  { IMAGE_GATHER4_C_L_O_V4_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x4 }, // 322
  { IMAGE_GATHER4_C_L_O_V4_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x8 }, // 323
  { IMAGE_GATHER4_C_O_V2_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x3 }, // 324
  { IMAGE_GATHER4_C_O_V2_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x4 }, // 325
  { IMAGE_GATHER4_C_O_V2_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x8 }, // 326
  { IMAGE_GATHER4_C_O_V4_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x3 }, // 327
  { IMAGE_GATHER4_C_O_V4_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x4 }, // 328
  { IMAGE_GATHER4_C_O_V4_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x8 }, // 329
  { IMAGE_GATHER4_L_V2_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x1 }, // 330
  { IMAGE_GATHER4_L_V2_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x2 }, // 331
  { IMAGE_GATHER4_L_V2_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x3 }, // 332
  { IMAGE_GATHER4_L_V2_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x4 }, // 333
  { IMAGE_GATHER4_L_V4_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x1 }, // 334
  { IMAGE_GATHER4_L_V4_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x2 }, // 335
  { IMAGE_GATHER4_L_V4_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x3 }, // 336
  { IMAGE_GATHER4_L_V4_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x4 }, // 337
  { IMAGE_GATHER4_LZ_V2_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x1 }, // 338
  { IMAGE_GATHER4_LZ_V2_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x2 }, // 339
  { IMAGE_GATHER4_LZ_V2_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x3 }, // 340
  { IMAGE_GATHER4_LZ_V2_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x4 }, // 341
  { IMAGE_GATHER4_LZ_V4_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x1 }, // 342
  { IMAGE_GATHER4_LZ_V4_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x2 }, // 343
  { IMAGE_GATHER4_LZ_V4_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x3 }, // 344
  { IMAGE_GATHER4_LZ_V4_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x4 }, // 345
  { IMAGE_GATHER4_LZ_O_V2_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x2 }, // 346
  { IMAGE_GATHER4_LZ_O_V2_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x3 }, // 347
  { IMAGE_GATHER4_LZ_O_V2_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x4 }, // 348
  { IMAGE_GATHER4_LZ_O_V4_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x2 }, // 349
  { IMAGE_GATHER4_LZ_O_V4_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x3 }, // 350
  { IMAGE_GATHER4_LZ_O_V4_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x4 }, // 351
  { IMAGE_GATHER4_L_O_V2_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x2 }, // 352
  { IMAGE_GATHER4_L_O_V2_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x3 }, // 353
  { IMAGE_GATHER4_L_O_V2_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x4 }, // 354
  { IMAGE_GATHER4_L_O_V2_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x8 }, // 355
  { IMAGE_GATHER4_L_O_V4_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x2 }, // 356
  { IMAGE_GATHER4_L_O_V4_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x3 }, // 357
  { IMAGE_GATHER4_L_O_V4_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x4 }, // 358
  { IMAGE_GATHER4_L_O_V4_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x8 }, // 359
  { IMAGE_GATHER4_O_V2_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x2 }, // 360
  { IMAGE_GATHER4_O_V2_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x3 }, // 361
  { IMAGE_GATHER4_O_V2_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x4 }, // 362
  { IMAGE_GATHER4_O_V4_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x2 }, // 363
  { IMAGE_GATHER4_O_V4_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x3 }, // 364
  { IMAGE_GATHER4_O_V4_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x4 }, // 365
  { IMAGE_GET_LOD_V1_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x1 }, // 366
  { IMAGE_GET_LOD_V1_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x2 }, // 367
  { IMAGE_GET_LOD_V1_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x3 }, // 368
  { IMAGE_GET_LOD_V1_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x4 }, // 369
  { IMAGE_GET_LOD_V2_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x1 }, // 370
  { IMAGE_GET_LOD_V2_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x2 }, // 371
  { IMAGE_GET_LOD_V2_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x3 }, // 372
  { IMAGE_GET_LOD_V2_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x4 }, // 373
  { IMAGE_GET_LOD_V3_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x1 }, // 374
  { IMAGE_GET_LOD_V3_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x2 }, // 375
  { IMAGE_GET_LOD_V3_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x3 }, // 376
  { IMAGE_GET_LOD_V3_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x4 }, // 377
  { IMAGE_GET_LOD_V4_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x1 }, // 378
  { IMAGE_GET_LOD_V4_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x2 }, // 379
  { IMAGE_GET_LOD_V4_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x3 }, // 380
  { IMAGE_GET_LOD_V4_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x4 }, // 381
  { IMAGE_GET_RESINFO_V1_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x1 }, // 382
  { IMAGE_GET_RESINFO_V1_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x2 }, // 383
  { IMAGE_GET_RESINFO_V1_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x3 }, // 384
  { IMAGE_GET_RESINFO_V1_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x4 }, // 385
  { IMAGE_GET_RESINFO_V2_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x1 }, // 386
  { IMAGE_GET_RESINFO_V2_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x2 }, // 387
  { IMAGE_GET_RESINFO_V2_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x3 }, // 388
  { IMAGE_GET_RESINFO_V2_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x4 }, // 389
  { IMAGE_GET_RESINFO_V3_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x1 }, // 390
  { IMAGE_GET_RESINFO_V3_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x2 }, // 391
  { IMAGE_GET_RESINFO_V3_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x3 }, // 392
  { IMAGE_GET_RESINFO_V3_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x4 }, // 393
  { IMAGE_GET_RESINFO_V4_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x1 }, // 394
  { IMAGE_GET_RESINFO_V4_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x2 }, // 395
  { IMAGE_GET_RESINFO_V4_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x3 }, // 396
  { IMAGE_GET_RESINFO_V4_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x4 }, // 397
  { IMAGE_LOAD_V1_V1, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x1 }, // 398
  { IMAGE_LOAD_V1_V2, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x2 }, // 399
  { IMAGE_LOAD_V1_V3, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x3 }, // 400
  { IMAGE_LOAD_V1_V4, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x4 }, // 401
  { IMAGE_LOAD_V2_V1, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x1 }, // 402
  { IMAGE_LOAD_V2_V2, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x2 }, // 403
  { IMAGE_LOAD_V2_V3, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x3 }, // 404
  { IMAGE_LOAD_V2_V4, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x4 }, // 405
  { IMAGE_LOAD_V3_V1, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x1 }, // 406
  { IMAGE_LOAD_V3_V2, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x2 }, // 407
  { IMAGE_LOAD_V3_V3, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x3 }, // 408
  { IMAGE_LOAD_V3_V4, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x4 }, // 409
  { IMAGE_LOAD_V4_V1, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x1 }, // 410
  { IMAGE_LOAD_V4_V2, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x2 }, // 411
  { IMAGE_LOAD_V4_V3, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x3 }, // 412
  { IMAGE_LOAD_V4_V4, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x4 }, // 413
  { IMAGE_LOAD_MIP_V1_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x1 }, // 414
  { IMAGE_LOAD_MIP_V1_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x2 }, // 415
  { IMAGE_LOAD_MIP_V1_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x3 }, // 416
  { IMAGE_LOAD_MIP_V1_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x4 }, // 417
  { IMAGE_LOAD_MIP_V2_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x1 }, // 418
  { IMAGE_LOAD_MIP_V2_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x2 }, // 419
  { IMAGE_LOAD_MIP_V2_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x3 }, // 420
  { IMAGE_LOAD_MIP_V2_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x4 }, // 421
  { IMAGE_LOAD_MIP_V3_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x1 }, // 422
  { IMAGE_LOAD_MIP_V3_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x2 }, // 423
  { IMAGE_LOAD_MIP_V3_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x3 }, // 424
  { IMAGE_LOAD_MIP_V3_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x4 }, // 425
  { IMAGE_LOAD_MIP_V4_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x1 }, // 426
  { IMAGE_LOAD_MIP_V4_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x2 }, // 427
  { IMAGE_LOAD_MIP_V4_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x3 }, // 428
  { IMAGE_LOAD_MIP_V4_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x4 }, // 429
  { IMAGE_LOAD_MIP_PCK_V1_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x1 }, // 430
  { IMAGE_LOAD_MIP_PCK_V1_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x2 }, // 431
  { IMAGE_LOAD_MIP_PCK_V1_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x3 }, // 432
  { IMAGE_LOAD_MIP_PCK_V1_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x4 }, // 433
  { IMAGE_LOAD_MIP_PCK_V2_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x1 }, // 434
  { IMAGE_LOAD_MIP_PCK_V2_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x2 }, // 435
  { IMAGE_LOAD_MIP_PCK_V2_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x3 }, // 436
  { IMAGE_LOAD_MIP_PCK_V2_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x4 }, // 437
  { IMAGE_LOAD_MIP_PCK_V3_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x1 }, // 438
  { IMAGE_LOAD_MIP_PCK_V3_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x2 }, // 439
  { IMAGE_LOAD_MIP_PCK_V3_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x3 }, // 440
  { IMAGE_LOAD_MIP_PCK_V3_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x4 }, // 441
  { IMAGE_LOAD_MIP_PCK_V4_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x1 }, // 442
  { IMAGE_LOAD_MIP_PCK_V4_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x2 }, // 443
  { IMAGE_LOAD_MIP_PCK_V4_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x3 }, // 444
  { IMAGE_LOAD_MIP_PCK_V4_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x4 }, // 445
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x1 }, // 446
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x2 }, // 447
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x3 }, // 448
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x4 }, // 449
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x1 }, // 450
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x2 }, // 451
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x3 }, // 452
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x4 }, // 453
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x1 }, // 454
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x2 }, // 455
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x3 }, // 456
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x4 }, // 457
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x1 }, // 458
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x2 }, // 459
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x3 }, // 460
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x4 }, // 461
  { IMAGE_LOAD_PCK_V1_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x1 }, // 462
  { IMAGE_LOAD_PCK_V1_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x2 }, // 463
  { IMAGE_LOAD_PCK_V1_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x3 }, // 464
  { IMAGE_LOAD_PCK_V1_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x4 }, // 465
  { IMAGE_LOAD_PCK_V2_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x1 }, // 466
  { IMAGE_LOAD_PCK_V2_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x2 }, // 467
  { IMAGE_LOAD_PCK_V2_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x3 }, // 468
  { IMAGE_LOAD_PCK_V2_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x4 }, // 469
  { IMAGE_LOAD_PCK_V3_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x1 }, // 470
  { IMAGE_LOAD_PCK_V3_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x2 }, // 471
  { IMAGE_LOAD_PCK_V3_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x3 }, // 472
  { IMAGE_LOAD_PCK_V3_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x4 }, // 473
  { IMAGE_LOAD_PCK_V4_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x1 }, // 474
  { IMAGE_LOAD_PCK_V4_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x2 }, // 475
  { IMAGE_LOAD_PCK_V4_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x3 }, // 476
  { IMAGE_LOAD_PCK_V4_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x4 }, // 477
  { IMAGE_LOAD_PCK_SGN_V1_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x1 }, // 478
  { IMAGE_LOAD_PCK_SGN_V1_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x2 }, // 479
  { IMAGE_LOAD_PCK_SGN_V1_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x3 }, // 480
  { IMAGE_LOAD_PCK_SGN_V1_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x4 }, // 481
  { IMAGE_LOAD_PCK_SGN_V2_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x1 }, // 482
  { IMAGE_LOAD_PCK_SGN_V2_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x2 }, // 483
  { IMAGE_LOAD_PCK_SGN_V2_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x3 }, // 484
  { IMAGE_LOAD_PCK_SGN_V2_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x4 }, // 485
  { IMAGE_LOAD_PCK_SGN_V3_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x1 }, // 486
  { IMAGE_LOAD_PCK_SGN_V3_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x2 }, // 487
  { IMAGE_LOAD_PCK_SGN_V3_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x3 }, // 488
  { IMAGE_LOAD_PCK_SGN_V3_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x4 }, // 489
  { IMAGE_LOAD_PCK_SGN_V4_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x1 }, // 490
  { IMAGE_LOAD_PCK_SGN_V4_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x2 }, // 491
  { IMAGE_LOAD_PCK_SGN_V4_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x3 }, // 492
  { IMAGE_LOAD_PCK_SGN_V4_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x4 }, // 493
  { IMAGE_SAMPLE_V1_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x1 }, // 494
  { IMAGE_SAMPLE_V1_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x2 }, // 495
  { IMAGE_SAMPLE_V1_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x3 }, // 496
  { IMAGE_SAMPLE_V1_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x4 }, // 497
  { IMAGE_SAMPLE_V2_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x1 }, // 498
  { IMAGE_SAMPLE_V2_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x2 }, // 499
  { IMAGE_SAMPLE_V2_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x3 }, // 500
  { IMAGE_SAMPLE_V2_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x4 }, // 501
  { IMAGE_SAMPLE_V3_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x1 }, // 502
  { IMAGE_SAMPLE_V3_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x2 }, // 503
  { IMAGE_SAMPLE_V3_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x3 }, // 504
  { IMAGE_SAMPLE_V3_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x4 }, // 505
  { IMAGE_SAMPLE_V4_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x1 }, // 506
  { IMAGE_SAMPLE_V4_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x2 }, // 507
  { IMAGE_SAMPLE_V4_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x3 }, // 508
  { IMAGE_SAMPLE_V4_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x4 }, // 509
  { IMAGE_SAMPLE_B_V1_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x2 }, // 510
  { IMAGE_SAMPLE_B_V1_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x3 }, // 511
  { IMAGE_SAMPLE_B_V1_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x4 }, // 512
  { IMAGE_SAMPLE_B_V2_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x2 }, // 513
  { IMAGE_SAMPLE_B_V2_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x3 }, // 514
  { IMAGE_SAMPLE_B_V2_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x4 }, // 515
  { IMAGE_SAMPLE_B_V3_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x2 }, // 516
  { IMAGE_SAMPLE_B_V3_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x3 }, // 517
  { IMAGE_SAMPLE_B_V3_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x4 }, // 518
  { IMAGE_SAMPLE_B_V4_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x2 }, // 519
  { IMAGE_SAMPLE_B_V4_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x3 }, // 520
  { IMAGE_SAMPLE_B_V4_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x4 }, // 521
  { IMAGE_SAMPLE_B_CL_V1_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x2 }, // 522
  { IMAGE_SAMPLE_B_CL_V1_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x3 }, // 523
  { IMAGE_SAMPLE_B_CL_V1_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x4 }, // 524
  { IMAGE_SAMPLE_B_CL_V1_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x8 }, // 525
  { IMAGE_SAMPLE_B_CL_V2_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x2 }, // 526
  { IMAGE_SAMPLE_B_CL_V2_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x3 }, // 527
  { IMAGE_SAMPLE_B_CL_V2_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x4 }, // 528
  { IMAGE_SAMPLE_B_CL_V2_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x8 }, // 529
  { IMAGE_SAMPLE_B_CL_V3_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x2 }, // 530
  { IMAGE_SAMPLE_B_CL_V3_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x3 }, // 531
  { IMAGE_SAMPLE_B_CL_V3_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x4 }, // 532
  { IMAGE_SAMPLE_B_CL_V3_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x8 }, // 533
  { IMAGE_SAMPLE_B_CL_V4_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x2 }, // 534
  { IMAGE_SAMPLE_B_CL_V4_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x3 }, // 535
  { IMAGE_SAMPLE_B_CL_V4_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x4 }, // 536
  { IMAGE_SAMPLE_B_CL_V4_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x8 }, // 537
  { IMAGE_SAMPLE_B_CL_O_V1_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x3 }, // 538
  { IMAGE_SAMPLE_B_CL_O_V1_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 539
  { IMAGE_SAMPLE_B_CL_O_V1_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 540
  { IMAGE_SAMPLE_B_CL_O_V2_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 541
  { IMAGE_SAMPLE_B_CL_O_V2_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 542
  { IMAGE_SAMPLE_B_CL_O_V2_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 543
  { IMAGE_SAMPLE_B_CL_O_V3_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x3 }, // 544
  { IMAGE_SAMPLE_B_CL_O_V3_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 545
  { IMAGE_SAMPLE_B_CL_O_V3_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 546
  { IMAGE_SAMPLE_B_CL_O_V4_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 547
  { IMAGE_SAMPLE_B_CL_O_V4_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 548
  { IMAGE_SAMPLE_B_CL_O_V4_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 549
  { IMAGE_SAMPLE_B_O_V1_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x3 }, // 550
  { IMAGE_SAMPLE_B_O_V1_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x4 }, // 551
  { IMAGE_SAMPLE_B_O_V1_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x8 }, // 552
  { IMAGE_SAMPLE_B_O_V2_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x3 }, // 553
  { IMAGE_SAMPLE_B_O_V2_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x4 }, // 554
  { IMAGE_SAMPLE_B_O_V2_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x8 }, // 555
  { IMAGE_SAMPLE_B_O_V3_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x3 }, // 556
  { IMAGE_SAMPLE_B_O_V3_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x4 }, // 557
  { IMAGE_SAMPLE_B_O_V3_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x8 }, // 558
  { IMAGE_SAMPLE_B_O_V4_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x3 }, // 559
  { IMAGE_SAMPLE_B_O_V4_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x4 }, // 560
  { IMAGE_SAMPLE_B_O_V4_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x8 }, // 561
  { IMAGE_SAMPLE_C_V1_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x2 }, // 562
  { IMAGE_SAMPLE_C_V1_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x3 }, // 563
  { IMAGE_SAMPLE_C_V1_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x4 }, // 564
  { IMAGE_SAMPLE_C_V2_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x2 }, // 565
  { IMAGE_SAMPLE_C_V2_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x3 }, // 566
  { IMAGE_SAMPLE_C_V2_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x4 }, // 567
  { IMAGE_SAMPLE_C_V3_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x2 }, // 568
  { IMAGE_SAMPLE_C_V3_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x3 }, // 569
  { IMAGE_SAMPLE_C_V3_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x4 }, // 570
  { IMAGE_SAMPLE_C_V4_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x2 }, // 571
  { IMAGE_SAMPLE_C_V4_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x3 }, // 572
  { IMAGE_SAMPLE_C_V4_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x4 }, // 573
  { IMAGE_SAMPLE_CD_V1_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x2 }, // 574
  { IMAGE_SAMPLE_CD_V1_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x3 }, // 575
  { IMAGE_SAMPLE_CD_V1_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x4 }, // 576
  { IMAGE_SAMPLE_CD_V1_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x8 }, // 577
  { IMAGE_SAMPLE_CD_V1_V16, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x10 }, // 578
  { IMAGE_SAMPLE_CD_V2_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x2 }, // 579
  { IMAGE_SAMPLE_CD_V2_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x3 }, // 580
  { IMAGE_SAMPLE_CD_V2_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x4 }, // 581
  { IMAGE_SAMPLE_CD_V2_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x8 }, // 582
  { IMAGE_SAMPLE_CD_V2_V16, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x10 }, // 583
  { IMAGE_SAMPLE_CD_V3_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x2 }, // 584
  { IMAGE_SAMPLE_CD_V3_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x3 }, // 585
  { IMAGE_SAMPLE_CD_V3_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x4 }, // 586
  { IMAGE_SAMPLE_CD_V3_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x8 }, // 587
  { IMAGE_SAMPLE_CD_V3_V16, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x10 }, // 588
  { IMAGE_SAMPLE_CD_V4_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x2 }, // 589
  { IMAGE_SAMPLE_CD_V4_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x3 }, // 590
  { IMAGE_SAMPLE_CD_V4_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x4 }, // 591
  { IMAGE_SAMPLE_CD_V4_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x8 }, // 592
  { IMAGE_SAMPLE_CD_V4_V16, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x10 }, // 593
  { IMAGE_SAMPLE_CD_CL_V1_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x2 }, // 594
  { IMAGE_SAMPLE_CD_CL_V1_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x3 }, // 595
  { IMAGE_SAMPLE_CD_CL_V1_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x4 }, // 596
  { IMAGE_SAMPLE_CD_CL_V1_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x8 }, // 597
  { IMAGE_SAMPLE_CD_CL_V1_V16, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x10 }, // 598
  { IMAGE_SAMPLE_CD_CL_V2_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x2 }, // 599
  { IMAGE_SAMPLE_CD_CL_V2_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x3 }, // 600
  { IMAGE_SAMPLE_CD_CL_V2_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x4 }, // 601
  { IMAGE_SAMPLE_CD_CL_V2_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x8 }, // 602
  { IMAGE_SAMPLE_CD_CL_V2_V16, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x10 }, // 603
  { IMAGE_SAMPLE_CD_CL_V3_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x2 }, // 604
  { IMAGE_SAMPLE_CD_CL_V3_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x3 }, // 605
  { IMAGE_SAMPLE_CD_CL_V3_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x4 }, // 606
  { IMAGE_SAMPLE_CD_CL_V3_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x8 }, // 607
  { IMAGE_SAMPLE_CD_CL_V3_V16, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x10 }, // 608
  { IMAGE_SAMPLE_CD_CL_V4_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x2 }, // 609
  { IMAGE_SAMPLE_CD_CL_V4_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x3 }, // 610
  { IMAGE_SAMPLE_CD_CL_V4_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x4 }, // 611
  { IMAGE_SAMPLE_CD_CL_V4_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x8 }, // 612
  { IMAGE_SAMPLE_CD_CL_V4_V16, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x10 }, // 613
  { IMAGE_SAMPLE_CD_CL_O_V1_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x3 }, // 614
  { IMAGE_SAMPLE_CD_CL_O_V1_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 615
  { IMAGE_SAMPLE_CD_CL_O_V1_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 616
  { IMAGE_SAMPLE_CD_CL_O_V1_V16, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x10 }, // 617
  { IMAGE_SAMPLE_CD_CL_O_V2_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 618
  { IMAGE_SAMPLE_CD_CL_O_V2_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 619
  { IMAGE_SAMPLE_CD_CL_O_V2_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 620
  { IMAGE_SAMPLE_CD_CL_O_V2_V16, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x10 }, // 621
  { IMAGE_SAMPLE_CD_CL_O_V3_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x3 }, // 622
  { IMAGE_SAMPLE_CD_CL_O_V3_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 623
  { IMAGE_SAMPLE_CD_CL_O_V3_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 624
  { IMAGE_SAMPLE_CD_CL_O_V3_V16, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x10 }, // 625
  { IMAGE_SAMPLE_CD_CL_O_V4_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 626
  { IMAGE_SAMPLE_CD_CL_O_V4_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 627
  { IMAGE_SAMPLE_CD_CL_O_V4_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 628
  { IMAGE_SAMPLE_CD_CL_O_V4_V16, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x10 }, // 629
  { IMAGE_SAMPLE_CD_O_V1_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x3 }, // 630
  { IMAGE_SAMPLE_CD_O_V1_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x4 }, // 631
  { IMAGE_SAMPLE_CD_O_V1_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x8 }, // 632
  { IMAGE_SAMPLE_CD_O_V1_V16, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x10 }, // 633
  { IMAGE_SAMPLE_CD_O_V2_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x3 }, // 634
  { IMAGE_SAMPLE_CD_O_V2_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x4 }, // 635
  { IMAGE_SAMPLE_CD_O_V2_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x8 }, // 636
  { IMAGE_SAMPLE_CD_O_V2_V16, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x10 }, // 637
  { IMAGE_SAMPLE_CD_O_V3_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x3 }, // 638
  { IMAGE_SAMPLE_CD_O_V3_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x4 }, // 639
  { IMAGE_SAMPLE_CD_O_V3_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x8 }, // 640
  { IMAGE_SAMPLE_CD_O_V3_V16, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x10 }, // 641
  { IMAGE_SAMPLE_CD_O_V4_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x3 }, // 642
  { IMAGE_SAMPLE_CD_O_V4_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x4 }, // 643
  { IMAGE_SAMPLE_CD_O_V4_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x8 }, // 644
  { IMAGE_SAMPLE_CD_O_V4_V16, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x10 }, // 645
  { IMAGE_SAMPLE_CL_V1_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x1 }, // 646
  { IMAGE_SAMPLE_CL_V1_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x2 }, // 647
  { IMAGE_SAMPLE_CL_V1_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x3 }, // 648
  { IMAGE_SAMPLE_CL_V1_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x4 }, // 649
  { IMAGE_SAMPLE_CL_V2_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x1 }, // 650
  { IMAGE_SAMPLE_CL_V2_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x2 }, // 651
  { IMAGE_SAMPLE_CL_V2_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x3 }, // 652
  { IMAGE_SAMPLE_CL_V2_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x4 }, // 653
  { IMAGE_SAMPLE_CL_V3_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x1 }, // 654
  { IMAGE_SAMPLE_CL_V3_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x2 }, // 655
  { IMAGE_SAMPLE_CL_V3_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x3 }, // 656
  { IMAGE_SAMPLE_CL_V3_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x4 }, // 657
  { IMAGE_SAMPLE_CL_V4_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x1 }, // 658
  { IMAGE_SAMPLE_CL_V4_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x2 }, // 659
  { IMAGE_SAMPLE_CL_V4_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x3 }, // 660
  { IMAGE_SAMPLE_CL_V4_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x4 }, // 661
  { IMAGE_SAMPLE_CL_O_V1_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x2 }, // 662
  { IMAGE_SAMPLE_CL_O_V1_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x3 }, // 663
  { IMAGE_SAMPLE_CL_O_V1_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 664
  { IMAGE_SAMPLE_CL_O_V1_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 665
  { IMAGE_SAMPLE_CL_O_V2_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x2 }, // 666
  { IMAGE_SAMPLE_CL_O_V2_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 667
  { IMAGE_SAMPLE_CL_O_V2_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 668
  { IMAGE_SAMPLE_CL_O_V2_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 669
  { IMAGE_SAMPLE_CL_O_V3_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x2 }, // 670
  { IMAGE_SAMPLE_CL_O_V3_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x3 }, // 671
  { IMAGE_SAMPLE_CL_O_V3_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 672
  { IMAGE_SAMPLE_CL_O_V3_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 673
  { IMAGE_SAMPLE_CL_O_V4_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x2 }, // 674
  { IMAGE_SAMPLE_CL_O_V4_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 675
  { IMAGE_SAMPLE_CL_O_V4_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 676
  { IMAGE_SAMPLE_CL_O_V4_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 677
  { IMAGE_SAMPLE_C_B_V1_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x3 }, // 678
  { IMAGE_SAMPLE_C_B_V1_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x4 }, // 679
  { IMAGE_SAMPLE_C_B_V1_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x1, 0x8 }, // 680
  { IMAGE_SAMPLE_C_B_V2_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x3 }, // 681
  { IMAGE_SAMPLE_C_B_V2_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x4 }, // 682
  { IMAGE_SAMPLE_C_B_V2_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x2, 0x8 }, // 683
  { IMAGE_SAMPLE_C_B_V3_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x3 }, // 684
  { IMAGE_SAMPLE_C_B_V3_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x4 }, // 685
  { IMAGE_SAMPLE_C_B_V3_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x3, 0x8 }, // 686
  { IMAGE_SAMPLE_C_B_V4_V3, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x3 }, // 687
  { IMAGE_SAMPLE_C_B_V4_V4, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x4 }, // 688
  { IMAGE_SAMPLE_C_B_V4_V8, IMAGE_SAMPLE_C_B, MIMGEncGfx6, 0x4, 0x8 }, // 689
  { IMAGE_SAMPLE_C_B_CL_V1_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x3 }, // 690
  { IMAGE_SAMPLE_C_B_CL_V1_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x4 }, // 691
  { IMAGE_SAMPLE_C_B_CL_V1_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x1, 0x8 }, // 692
  { IMAGE_SAMPLE_C_B_CL_V2_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x3 }, // 693
  { IMAGE_SAMPLE_C_B_CL_V2_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x4 }, // 694
  { IMAGE_SAMPLE_C_B_CL_V2_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x2, 0x8 }, // 695
  { IMAGE_SAMPLE_C_B_CL_V3_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x3 }, // 696
  { IMAGE_SAMPLE_C_B_CL_V3_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x4 }, // 697
  { IMAGE_SAMPLE_C_B_CL_V3_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x3, 0x8 }, // 698
  { IMAGE_SAMPLE_C_B_CL_V4_V3, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x3 }, // 699
  { IMAGE_SAMPLE_C_B_CL_V4_V4, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x4 }, // 700
  { IMAGE_SAMPLE_C_B_CL_V4_V8, IMAGE_SAMPLE_C_B_CL, MIMGEncGfx6, 0x4, 0x8 }, // 701
  { IMAGE_SAMPLE_C_B_CL_O_V1_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 702
  { IMAGE_SAMPLE_C_B_CL_O_V1_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 703
  { IMAGE_SAMPLE_C_B_CL_O_V2_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 704
  { IMAGE_SAMPLE_C_B_CL_O_V2_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 705
  { IMAGE_SAMPLE_C_B_CL_O_V3_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 706
  { IMAGE_SAMPLE_C_B_CL_O_V3_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 707
  { IMAGE_SAMPLE_C_B_CL_O_V4_V4, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 708
  { IMAGE_SAMPLE_C_B_CL_O_V4_V8, IMAGE_SAMPLE_C_B_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 709
  { IMAGE_SAMPLE_C_B_O_V1_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x4 }, // 710
  { IMAGE_SAMPLE_C_B_O_V1_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x1, 0x8 }, // 711
  { IMAGE_SAMPLE_C_B_O_V2_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x4 }, // 712
  { IMAGE_SAMPLE_C_B_O_V2_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x2, 0x8 }, // 713
  { IMAGE_SAMPLE_C_B_O_V3_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x4 }, // 714
  { IMAGE_SAMPLE_C_B_O_V3_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x3, 0x8 }, // 715
  { IMAGE_SAMPLE_C_B_O_V4_V4, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x4 }, // 716
  { IMAGE_SAMPLE_C_B_O_V4_V8, IMAGE_SAMPLE_C_B_O, MIMGEncGfx6, 0x4, 0x8 }, // 717
  { IMAGE_SAMPLE_C_CD_V1_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x3 }, // 718
  { IMAGE_SAMPLE_C_CD_V1_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x4 }, // 719
  { IMAGE_SAMPLE_C_CD_V1_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x8 }, // 720
  { IMAGE_SAMPLE_C_CD_V1_V16, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x1, 0x10 }, // 721
  { IMAGE_SAMPLE_C_CD_V2_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x3 }, // 722
  { IMAGE_SAMPLE_C_CD_V2_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x4 }, // 723
  { IMAGE_SAMPLE_C_CD_V2_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x8 }, // 724
  { IMAGE_SAMPLE_C_CD_V2_V16, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x2, 0x10 }, // 725
  { IMAGE_SAMPLE_C_CD_V3_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x3 }, // 726
  { IMAGE_SAMPLE_C_CD_V3_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x4 }, // 727
  { IMAGE_SAMPLE_C_CD_V3_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x8 }, // 728
  { IMAGE_SAMPLE_C_CD_V3_V16, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x3, 0x10 }, // 729
  { IMAGE_SAMPLE_C_CD_V4_V3, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x3 }, // 730
  { IMAGE_SAMPLE_C_CD_V4_V4, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x4 }, // 731
  { IMAGE_SAMPLE_C_CD_V4_V8, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x8 }, // 732
  { IMAGE_SAMPLE_C_CD_V4_V16, IMAGE_SAMPLE_C_CD, MIMGEncGfx6, 0x4, 0x10 }, // 733
  { IMAGE_SAMPLE_C_CD_CL_V1_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x3 }, // 734
  { IMAGE_SAMPLE_C_CD_CL_V1_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x4 }, // 735
  { IMAGE_SAMPLE_C_CD_CL_V1_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x8 }, // 736
  { IMAGE_SAMPLE_C_CD_CL_V1_V16, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x1, 0x10 }, // 737
  { IMAGE_SAMPLE_C_CD_CL_V2_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x3 }, // 738
  { IMAGE_SAMPLE_C_CD_CL_V2_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x4 }, // 739
  { IMAGE_SAMPLE_C_CD_CL_V2_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x8 }, // 740
  { IMAGE_SAMPLE_C_CD_CL_V2_V16, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x2, 0x10 }, // 741
  { IMAGE_SAMPLE_C_CD_CL_V3_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x3 }, // 742
  { IMAGE_SAMPLE_C_CD_CL_V3_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x4 }, // 743
  { IMAGE_SAMPLE_C_CD_CL_V3_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x8 }, // 744
  { IMAGE_SAMPLE_C_CD_CL_V3_V16, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x3, 0x10 }, // 745
  { IMAGE_SAMPLE_C_CD_CL_V4_V3, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x3 }, // 746
  { IMAGE_SAMPLE_C_CD_CL_V4_V4, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x4 }, // 747
  { IMAGE_SAMPLE_C_CD_CL_V4_V8, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x8 }, // 748
  { IMAGE_SAMPLE_C_CD_CL_V4_V16, IMAGE_SAMPLE_C_CD_CL, MIMGEncGfx6, 0x4, 0x10 }, // 749
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 750
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 751
  { IMAGE_SAMPLE_C_CD_CL_O_V1_V16, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x1, 0x10 }, // 752
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 753
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 754
  { IMAGE_SAMPLE_C_CD_CL_O_V2_V16, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x2, 0x10 }, // 755
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 756
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 757
  { IMAGE_SAMPLE_C_CD_CL_O_V3_V16, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x3, 0x10 }, // 758
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V4, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 759
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V8, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 760
  { IMAGE_SAMPLE_C_CD_CL_O_V4_V16, IMAGE_SAMPLE_C_CD_CL_O, MIMGEncGfx6, 0x4, 0x10 }, // 761
  { IMAGE_SAMPLE_C_CD_O_V1_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x4 }, // 762
  { IMAGE_SAMPLE_C_CD_O_V1_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x8 }, // 763
  { IMAGE_SAMPLE_C_CD_O_V1_V16, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x1, 0x10 }, // 764
  { IMAGE_SAMPLE_C_CD_O_V2_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x4 }, // 765
  { IMAGE_SAMPLE_C_CD_O_V2_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x8 }, // 766
  { IMAGE_SAMPLE_C_CD_O_V2_V16, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x2, 0x10 }, // 767
  { IMAGE_SAMPLE_C_CD_O_V3_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x4 }, // 768
  { IMAGE_SAMPLE_C_CD_O_V3_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x8 }, // 769
  { IMAGE_SAMPLE_C_CD_O_V3_V16, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x3, 0x10 }, // 770
  { IMAGE_SAMPLE_C_CD_O_V4_V4, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x4 }, // 771
  { IMAGE_SAMPLE_C_CD_O_V4_V8, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x8 }, // 772
  { IMAGE_SAMPLE_C_CD_O_V4_V16, IMAGE_SAMPLE_C_CD_O, MIMGEncGfx6, 0x4, 0x10 }, // 773
  { IMAGE_SAMPLE_C_CL_V1_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x2 }, // 774
  { IMAGE_SAMPLE_C_CL_V1_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x3 }, // 775
  { IMAGE_SAMPLE_C_CL_V1_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x4 }, // 776
  { IMAGE_SAMPLE_C_CL_V1_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x1, 0x8 }, // 777
  { IMAGE_SAMPLE_C_CL_V2_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x2 }, // 778
  { IMAGE_SAMPLE_C_CL_V2_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x3 }, // 779
  { IMAGE_SAMPLE_C_CL_V2_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x4 }, // 780
  { IMAGE_SAMPLE_C_CL_V2_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x2, 0x8 }, // 781
  { IMAGE_SAMPLE_C_CL_V3_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x2 }, // 782
  { IMAGE_SAMPLE_C_CL_V3_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x3 }, // 783
  { IMAGE_SAMPLE_C_CL_V3_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x4 }, // 784
  { IMAGE_SAMPLE_C_CL_V3_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x3, 0x8 }, // 785
  { IMAGE_SAMPLE_C_CL_V4_V2, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x2 }, // 786
  { IMAGE_SAMPLE_C_CL_V4_V3, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x3 }, // 787
  { IMAGE_SAMPLE_C_CL_V4_V4, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x4 }, // 788
  { IMAGE_SAMPLE_C_CL_V4_V8, IMAGE_SAMPLE_C_CL, MIMGEncGfx6, 0x4, 0x8 }, // 789
  { IMAGE_SAMPLE_C_CL_O_V1_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x3 }, // 790
  { IMAGE_SAMPLE_C_CL_O_V1_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 791
  { IMAGE_SAMPLE_C_CL_O_V1_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 792
  { IMAGE_SAMPLE_C_CL_O_V2_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 793
  { IMAGE_SAMPLE_C_CL_O_V2_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 794
  { IMAGE_SAMPLE_C_CL_O_V2_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 795
  { IMAGE_SAMPLE_C_CL_O_V3_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x3 }, // 796
  { IMAGE_SAMPLE_C_CL_O_V3_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 797
  { IMAGE_SAMPLE_C_CL_O_V3_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 798
  { IMAGE_SAMPLE_C_CL_O_V4_V3, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 799
  { IMAGE_SAMPLE_C_CL_O_V4_V4, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 800
  { IMAGE_SAMPLE_C_CL_O_V4_V8, IMAGE_SAMPLE_C_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 801
  { IMAGE_SAMPLE_C_D_V1_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x3 }, // 802
  { IMAGE_SAMPLE_C_D_V1_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x4 }, // 803
  { IMAGE_SAMPLE_C_D_V1_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x8 }, // 804
  { IMAGE_SAMPLE_C_D_V1_V16, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x1, 0x10 }, // 805
  { IMAGE_SAMPLE_C_D_V2_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x3 }, // 806
  { IMAGE_SAMPLE_C_D_V2_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x4 }, // 807
  { IMAGE_SAMPLE_C_D_V2_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x8 }, // 808
  { IMAGE_SAMPLE_C_D_V2_V16, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x2, 0x10 }, // 809
  { IMAGE_SAMPLE_C_D_V3_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x3 }, // 810
  { IMAGE_SAMPLE_C_D_V3_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x4 }, // 811
  { IMAGE_SAMPLE_C_D_V3_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x8 }, // 812
  { IMAGE_SAMPLE_C_D_V3_V16, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x3, 0x10 }, // 813
  { IMAGE_SAMPLE_C_D_V4_V3, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x3 }, // 814
  { IMAGE_SAMPLE_C_D_V4_V4, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x4 }, // 815
  { IMAGE_SAMPLE_C_D_V4_V8, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x8 }, // 816
  { IMAGE_SAMPLE_C_D_V4_V16, IMAGE_SAMPLE_C_D, MIMGEncGfx6, 0x4, 0x10 }, // 817
  { IMAGE_SAMPLE_C_D_CL_V1_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x3 }, // 818
  { IMAGE_SAMPLE_C_D_CL_V1_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x4 }, // 819
  { IMAGE_SAMPLE_C_D_CL_V1_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x8 }, // 820
  { IMAGE_SAMPLE_C_D_CL_V1_V16, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x1, 0x10 }, // 821
  { IMAGE_SAMPLE_C_D_CL_V2_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x3 }, // 822
  { IMAGE_SAMPLE_C_D_CL_V2_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x4 }, // 823
  { IMAGE_SAMPLE_C_D_CL_V2_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x8 }, // 824
  { IMAGE_SAMPLE_C_D_CL_V2_V16, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x2, 0x10 }, // 825
  { IMAGE_SAMPLE_C_D_CL_V3_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x3 }, // 826
  { IMAGE_SAMPLE_C_D_CL_V3_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x4 }, // 827
  { IMAGE_SAMPLE_C_D_CL_V3_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x8 }, // 828
  { IMAGE_SAMPLE_C_D_CL_V3_V16, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x3, 0x10 }, // 829
  { IMAGE_SAMPLE_C_D_CL_V4_V3, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x3 }, // 830
  { IMAGE_SAMPLE_C_D_CL_V4_V4, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x4 }, // 831
  { IMAGE_SAMPLE_C_D_CL_V4_V8, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x8 }, // 832
  { IMAGE_SAMPLE_C_D_CL_V4_V16, IMAGE_SAMPLE_C_D_CL, MIMGEncGfx6, 0x4, 0x10 }, // 833
  { IMAGE_SAMPLE_C_D_CL_O_V1_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 834
  { IMAGE_SAMPLE_C_D_CL_O_V1_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 835
  { IMAGE_SAMPLE_C_D_CL_O_V1_V16, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x1, 0x10 }, // 836
  { IMAGE_SAMPLE_C_D_CL_O_V2_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 837
  { IMAGE_SAMPLE_C_D_CL_O_V2_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 838
  { IMAGE_SAMPLE_C_D_CL_O_V2_V16, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x2, 0x10 }, // 839
  { IMAGE_SAMPLE_C_D_CL_O_V3_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 840
  { IMAGE_SAMPLE_C_D_CL_O_V3_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 841
  { IMAGE_SAMPLE_C_D_CL_O_V3_V16, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x3, 0x10 }, // 842
  { IMAGE_SAMPLE_C_D_CL_O_V4_V4, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 843
  { IMAGE_SAMPLE_C_D_CL_O_V4_V8, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 844
  { IMAGE_SAMPLE_C_D_CL_O_V4_V16, IMAGE_SAMPLE_C_D_CL_O, MIMGEncGfx6, 0x4, 0x10 }, // 845
  { IMAGE_SAMPLE_C_D_O_V1_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x4 }, // 846
  { IMAGE_SAMPLE_C_D_O_V1_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x8 }, // 847
  { IMAGE_SAMPLE_C_D_O_V1_V16, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x1, 0x10 }, // 848
  { IMAGE_SAMPLE_C_D_O_V2_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x4 }, // 849
  { IMAGE_SAMPLE_C_D_O_V2_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x8 }, // 850
  { IMAGE_SAMPLE_C_D_O_V2_V16, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x2, 0x10 }, // 851
  { IMAGE_SAMPLE_C_D_O_V3_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x4 }, // 852
  { IMAGE_SAMPLE_C_D_O_V3_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x8 }, // 853
  { IMAGE_SAMPLE_C_D_O_V3_V16, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x3, 0x10 }, // 854
  { IMAGE_SAMPLE_C_D_O_V4_V4, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x4 }, // 855
  { IMAGE_SAMPLE_C_D_O_V4_V8, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x8 }, // 856
  { IMAGE_SAMPLE_C_D_O_V4_V16, IMAGE_SAMPLE_C_D_O, MIMGEncGfx6, 0x4, 0x10 }, // 857
  { IMAGE_SAMPLE_C_L_V1_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x2 }, // 858
  { IMAGE_SAMPLE_C_L_V1_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x3 }, // 859
  { IMAGE_SAMPLE_C_L_V1_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x4 }, // 860
  { IMAGE_SAMPLE_C_L_V1_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x1, 0x8 }, // 861
  { IMAGE_SAMPLE_C_L_V2_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x2 }, // 862
  { IMAGE_SAMPLE_C_L_V2_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x3 }, // 863
  { IMAGE_SAMPLE_C_L_V2_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x4 }, // 864
  { IMAGE_SAMPLE_C_L_V2_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x2, 0x8 }, // 865
  { IMAGE_SAMPLE_C_L_V3_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x2 }, // 866
  { IMAGE_SAMPLE_C_L_V3_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x3 }, // 867
  { IMAGE_SAMPLE_C_L_V3_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x4 }, // 868
  { IMAGE_SAMPLE_C_L_V3_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x3, 0x8 }, // 869
  { IMAGE_SAMPLE_C_L_V4_V2, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x2 }, // 870
  { IMAGE_SAMPLE_C_L_V4_V3, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x3 }, // 871
  { IMAGE_SAMPLE_C_L_V4_V4, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x4 }, // 872
  { IMAGE_SAMPLE_C_L_V4_V8, IMAGE_SAMPLE_C_L, MIMGEncGfx6, 0x4, 0x8 }, // 873
  { IMAGE_SAMPLE_C_LZ_V1_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x1, 0x2 }, // 874
  { IMAGE_SAMPLE_C_LZ_V1_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x1, 0x3 }, // 875
  { IMAGE_SAMPLE_C_LZ_V1_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x1, 0x4 }, // 876
  { IMAGE_SAMPLE_C_LZ_V2_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x2, 0x2 }, // 877
  { IMAGE_SAMPLE_C_LZ_V2_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x2, 0x3 }, // 878
  { IMAGE_SAMPLE_C_LZ_V2_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x2, 0x4 }, // 879
  { IMAGE_SAMPLE_C_LZ_V3_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x3, 0x2 }, // 880
  { IMAGE_SAMPLE_C_LZ_V3_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x3, 0x3 }, // 881
  { IMAGE_SAMPLE_C_LZ_V3_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x3, 0x4 }, // 882
  { IMAGE_SAMPLE_C_LZ_V4_V2, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x4, 0x2 }, // 883
  { IMAGE_SAMPLE_C_LZ_V4_V3, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x4, 0x3 }, // 884
  { IMAGE_SAMPLE_C_LZ_V4_V4, IMAGE_SAMPLE_C_LZ, MIMGEncGfx6, 0x4, 0x4 }, // 885
  { IMAGE_SAMPLE_C_LZ_O_V1_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x1, 0x3 }, // 886
  { IMAGE_SAMPLE_C_LZ_O_V1_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x1, 0x4 }, // 887
  { IMAGE_SAMPLE_C_LZ_O_V1_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x1, 0x8 }, // 888
  { IMAGE_SAMPLE_C_LZ_O_V2_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x2, 0x3 }, // 889
  { IMAGE_SAMPLE_C_LZ_O_V2_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x2, 0x4 }, // 890
  { IMAGE_SAMPLE_C_LZ_O_V2_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x2, 0x8 }, // 891
  { IMAGE_SAMPLE_C_LZ_O_V3_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x3, 0x3 }, // 892
  { IMAGE_SAMPLE_C_LZ_O_V3_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x3, 0x4 }, // 893
  { IMAGE_SAMPLE_C_LZ_O_V3_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x3, 0x8 }, // 894
  { IMAGE_SAMPLE_C_LZ_O_V4_V3, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x4, 0x3 }, // 895
  { IMAGE_SAMPLE_C_LZ_O_V4_V4, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x4, 0x4 }, // 896
  { IMAGE_SAMPLE_C_LZ_O_V4_V8, IMAGE_SAMPLE_C_LZ_O, MIMGEncGfx6, 0x4, 0x8 }, // 897
  { IMAGE_SAMPLE_C_L_O_V1_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x1, 0x3 }, // 898
  { IMAGE_SAMPLE_C_L_O_V1_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x1, 0x4 }, // 899
  { IMAGE_SAMPLE_C_L_O_V1_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x1, 0x8 }, // 900
  { IMAGE_SAMPLE_C_L_O_V2_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x2, 0x3 }, // 901
  { IMAGE_SAMPLE_C_L_O_V2_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x2, 0x4 }, // 902
  { IMAGE_SAMPLE_C_L_O_V2_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x2, 0x8 }, // 903
  { IMAGE_SAMPLE_C_L_O_V3_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x3, 0x3 }, // 904
  { IMAGE_SAMPLE_C_L_O_V3_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x3, 0x4 }, // 905
  { IMAGE_SAMPLE_C_L_O_V3_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x3, 0x8 }, // 906
  { IMAGE_SAMPLE_C_L_O_V4_V3, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x4, 0x3 }, // 907
  { IMAGE_SAMPLE_C_L_O_V4_V4, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x4, 0x4 }, // 908
  { IMAGE_SAMPLE_C_L_O_V4_V8, IMAGE_SAMPLE_C_L_O, MIMGEncGfx6, 0x4, 0x8 }, // 909
  { IMAGE_SAMPLE_C_O_V1_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x1, 0x3 }, // 910
  { IMAGE_SAMPLE_C_O_V1_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x1, 0x4 }, // 911
  { IMAGE_SAMPLE_C_O_V1_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x1, 0x8 }, // 912
  { IMAGE_SAMPLE_C_O_V2_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x2, 0x3 }, // 913
  { IMAGE_SAMPLE_C_O_V2_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x2, 0x4 }, // 914
  { IMAGE_SAMPLE_C_O_V2_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x2, 0x8 }, // 915
  { IMAGE_SAMPLE_C_O_V3_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x3, 0x3 }, // 916
  { IMAGE_SAMPLE_C_O_V3_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x3, 0x4 }, // 917
  { IMAGE_SAMPLE_C_O_V3_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x3, 0x8 }, // 918
  { IMAGE_SAMPLE_C_O_V4_V3, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x4, 0x3 }, // 919
  { IMAGE_SAMPLE_C_O_V4_V4, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x4, 0x4 }, // 920
  { IMAGE_SAMPLE_C_O_V4_V8, IMAGE_SAMPLE_C_O, MIMGEncGfx6, 0x4, 0x8 }, // 921
  { IMAGE_SAMPLE_D_V1_V2, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x2 }, // 922
  { IMAGE_SAMPLE_D_V1_V3, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x3 }, // 923
  { IMAGE_SAMPLE_D_V1_V4, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x4 }, // 924
  { IMAGE_SAMPLE_D_V1_V8, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x8 }, // 925
  { IMAGE_SAMPLE_D_V1_V16, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x1, 0x10 }, // 926
  { IMAGE_SAMPLE_D_V2_V2, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x2 }, // 927
  { IMAGE_SAMPLE_D_V2_V3, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x3 }, // 928
  { IMAGE_SAMPLE_D_V2_V4, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x4 }, // 929
  { IMAGE_SAMPLE_D_V2_V8, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x8 }, // 930
  { IMAGE_SAMPLE_D_V2_V16, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x2, 0x10 }, // 931
  { IMAGE_SAMPLE_D_V3_V2, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x2 }, // 932
  { IMAGE_SAMPLE_D_V3_V3, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x3 }, // 933
  { IMAGE_SAMPLE_D_V3_V4, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x4 }, // 934
  { IMAGE_SAMPLE_D_V3_V8, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x8 }, // 935
  { IMAGE_SAMPLE_D_V3_V16, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x3, 0x10 }, // 936
  { IMAGE_SAMPLE_D_V4_V2, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x4, 0x2 }, // 937
  { IMAGE_SAMPLE_D_V4_V3, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x4, 0x3 }, // 938
  { IMAGE_SAMPLE_D_V4_V4, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x4, 0x4 }, // 939
  { IMAGE_SAMPLE_D_V4_V8, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x4, 0x8 }, // 940
  { IMAGE_SAMPLE_D_V4_V16, IMAGE_SAMPLE_D, MIMGEncGfx6, 0x4, 0x10 }, // 941
  { IMAGE_SAMPLE_D_CL_V1_V2, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x1, 0x2 }, // 942
  { IMAGE_SAMPLE_D_CL_V1_V3, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x1, 0x3 }, // 943
  { IMAGE_SAMPLE_D_CL_V1_V4, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x1, 0x4 }, // 944
  { IMAGE_SAMPLE_D_CL_V1_V8, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x1, 0x8 }, // 945
  { IMAGE_SAMPLE_D_CL_V1_V16, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x1, 0x10 }, // 946
  { IMAGE_SAMPLE_D_CL_V2_V2, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x2, 0x2 }, // 947
  { IMAGE_SAMPLE_D_CL_V2_V3, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x2, 0x3 }, // 948
  { IMAGE_SAMPLE_D_CL_V2_V4, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x2, 0x4 }, // 949
  { IMAGE_SAMPLE_D_CL_V2_V8, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x2, 0x8 }, // 950
  { IMAGE_SAMPLE_D_CL_V2_V16, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x2, 0x10 }, // 951
  { IMAGE_SAMPLE_D_CL_V3_V2, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x3, 0x2 }, // 952
  { IMAGE_SAMPLE_D_CL_V3_V3, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x3, 0x3 }, // 953
  { IMAGE_SAMPLE_D_CL_V3_V4, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x3, 0x4 }, // 954
  { IMAGE_SAMPLE_D_CL_V3_V8, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x3, 0x8 }, // 955
  { IMAGE_SAMPLE_D_CL_V3_V16, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x3, 0x10 }, // 956
  { IMAGE_SAMPLE_D_CL_V4_V2, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x4, 0x2 }, // 957
  { IMAGE_SAMPLE_D_CL_V4_V3, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x4, 0x3 }, // 958
  { IMAGE_SAMPLE_D_CL_V4_V4, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x4, 0x4 }, // 959
  { IMAGE_SAMPLE_D_CL_V4_V8, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x4, 0x8 }, // 960
  { IMAGE_SAMPLE_D_CL_V4_V16, IMAGE_SAMPLE_D_CL, MIMGEncGfx6, 0x4, 0x10 }, // 961
  { IMAGE_SAMPLE_D_CL_O_V1_V3, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x1, 0x3 }, // 962
  { IMAGE_SAMPLE_D_CL_O_V1_V4, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x1, 0x4 }, // 963
  { IMAGE_SAMPLE_D_CL_O_V1_V8, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x1, 0x8 }, // 964
  { IMAGE_SAMPLE_D_CL_O_V1_V16, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x1, 0x10 }, // 965
  { IMAGE_SAMPLE_D_CL_O_V2_V3, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x2, 0x3 }, // 966
  { IMAGE_SAMPLE_D_CL_O_V2_V4, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x2, 0x4 }, // 967
  { IMAGE_SAMPLE_D_CL_O_V2_V8, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x2, 0x8 }, // 968
  { IMAGE_SAMPLE_D_CL_O_V2_V16, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x2, 0x10 }, // 969
  { IMAGE_SAMPLE_D_CL_O_V3_V3, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x3, 0x3 }, // 970
  { IMAGE_SAMPLE_D_CL_O_V3_V4, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x3, 0x4 }, // 971
  { IMAGE_SAMPLE_D_CL_O_V3_V8, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x3, 0x8 }, // 972
  { IMAGE_SAMPLE_D_CL_O_V3_V16, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x3, 0x10 }, // 973
  { IMAGE_SAMPLE_D_CL_O_V4_V3, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x4, 0x3 }, // 974
  { IMAGE_SAMPLE_D_CL_O_V4_V4, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x4, 0x4 }, // 975
  { IMAGE_SAMPLE_D_CL_O_V4_V8, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x4, 0x8 }, // 976
  { IMAGE_SAMPLE_D_CL_O_V4_V16, IMAGE_SAMPLE_D_CL_O, MIMGEncGfx6, 0x4, 0x10 }, // 977
  { IMAGE_SAMPLE_D_O_V1_V3, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x1, 0x3 }, // 978
  { IMAGE_SAMPLE_D_O_V1_V4, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x1, 0x4 }, // 979
  { IMAGE_SAMPLE_D_O_V1_V8, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x1, 0x8 }, // 980
  { IMAGE_SAMPLE_D_O_V1_V16, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x1, 0x10 }, // 981
  { IMAGE_SAMPLE_D_O_V2_V3, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x2, 0x3 }, // 982
  { IMAGE_SAMPLE_D_O_V2_V4, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x2, 0x4 }, // 983
  { IMAGE_SAMPLE_D_O_V2_V8, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x2, 0x8 }, // 984
  { IMAGE_SAMPLE_D_O_V2_V16, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x2, 0x10 }, // 985
  { IMAGE_SAMPLE_D_O_V3_V3, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x3, 0x3 }, // 986
  { IMAGE_SAMPLE_D_O_V3_V4, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x3, 0x4 }, // 987
  { IMAGE_SAMPLE_D_O_V3_V8, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x3, 0x8 }, // 988
  { IMAGE_SAMPLE_D_O_V3_V16, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x3, 0x10 }, // 989
  { IMAGE_SAMPLE_D_O_V4_V3, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x4, 0x3 }, // 990
  { IMAGE_SAMPLE_D_O_V4_V4, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x4, 0x4 }, // 991
  { IMAGE_SAMPLE_D_O_V4_V8, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x4, 0x8 }, // 992
  { IMAGE_SAMPLE_D_O_V4_V16, IMAGE_SAMPLE_D_O, MIMGEncGfx6, 0x4, 0x10 }, // 993
  { IMAGE_SAMPLE_L_V1_V1, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x1, 0x1 }, // 994
  { IMAGE_SAMPLE_L_V1_V2, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x1, 0x2 }, // 995
  { IMAGE_SAMPLE_L_V1_V3, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x1, 0x3 }, // 996
  { IMAGE_SAMPLE_L_V1_V4, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x1, 0x4 }, // 997
  { IMAGE_SAMPLE_L_V2_V1, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x2, 0x1 }, // 998
  { IMAGE_SAMPLE_L_V2_V2, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x2, 0x2 }, // 999
  { IMAGE_SAMPLE_L_V2_V3, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x2, 0x3 }, // 1000
  { IMAGE_SAMPLE_L_V2_V4, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x2, 0x4 }, // 1001
  { IMAGE_SAMPLE_L_V3_V1, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x3, 0x1 }, // 1002
  { IMAGE_SAMPLE_L_V3_V2, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x3, 0x2 }, // 1003
  { IMAGE_SAMPLE_L_V3_V3, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x3, 0x3 }, // 1004
  { IMAGE_SAMPLE_L_V3_V4, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x3, 0x4 }, // 1005
  { IMAGE_SAMPLE_L_V4_V1, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x4, 0x1 }, // 1006
  { IMAGE_SAMPLE_L_V4_V2, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x4, 0x2 }, // 1007
  { IMAGE_SAMPLE_L_V4_V3, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x4, 0x3 }, // 1008
  { IMAGE_SAMPLE_L_V4_V4, IMAGE_SAMPLE_L, MIMGEncGfx6, 0x4, 0x4 }, // 1009
  { IMAGE_SAMPLE_LZ_V1_V1, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x1, 0x1 }, // 1010
  { IMAGE_SAMPLE_LZ_V1_V2, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x1, 0x2 }, // 1011
  { IMAGE_SAMPLE_LZ_V1_V3, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x1, 0x3 }, // 1012
  { IMAGE_SAMPLE_LZ_V1_V4, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x1, 0x4 }, // 1013
  { IMAGE_SAMPLE_LZ_V2_V1, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x2, 0x1 }, // 1014
  { IMAGE_SAMPLE_LZ_V2_V2, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x2, 0x2 }, // 1015
  { IMAGE_SAMPLE_LZ_V2_V3, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x2, 0x3 }, // 1016
  { IMAGE_SAMPLE_LZ_V2_V4, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x2, 0x4 }, // 1017
  { IMAGE_SAMPLE_LZ_V3_V1, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x3, 0x1 }, // 1018
  { IMAGE_SAMPLE_LZ_V3_V2, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x3, 0x2 }, // 1019
  { IMAGE_SAMPLE_LZ_V3_V3, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x3, 0x3 }, // 1020
  { IMAGE_SAMPLE_LZ_V3_V4, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x3, 0x4 }, // 1021
  { IMAGE_SAMPLE_LZ_V4_V1, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x4, 0x1 }, // 1022
  { IMAGE_SAMPLE_LZ_V4_V2, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x4, 0x2 }, // 1023
  { IMAGE_SAMPLE_LZ_V4_V3, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x4, 0x3 }, // 1024
  { IMAGE_SAMPLE_LZ_V4_V4, IMAGE_SAMPLE_LZ, MIMGEncGfx6, 0x4, 0x4 }, // 1025
  { IMAGE_SAMPLE_LZ_O_V1_V2, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x1, 0x2 }, // 1026
  { IMAGE_SAMPLE_LZ_O_V1_V3, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x1, 0x3 }, // 1027
  { IMAGE_SAMPLE_LZ_O_V1_V4, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x1, 0x4 }, // 1028
  { IMAGE_SAMPLE_LZ_O_V2_V2, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x2, 0x2 }, // 1029
  { IMAGE_SAMPLE_LZ_O_V2_V3, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x2, 0x3 }, // 1030
  { IMAGE_SAMPLE_LZ_O_V2_V4, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x2, 0x4 }, // 1031
  { IMAGE_SAMPLE_LZ_O_V3_V2, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x3, 0x2 }, // 1032
  { IMAGE_SAMPLE_LZ_O_V3_V3, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x3, 0x3 }, // 1033
  { IMAGE_SAMPLE_LZ_O_V3_V4, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x3, 0x4 }, // 1034
  { IMAGE_SAMPLE_LZ_O_V4_V2, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x4, 0x2 }, // 1035
  { IMAGE_SAMPLE_LZ_O_V4_V3, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x4, 0x3 }, // 1036
  { IMAGE_SAMPLE_LZ_O_V4_V4, IMAGE_SAMPLE_LZ_O, MIMGEncGfx6, 0x4, 0x4 }, // 1037
  { IMAGE_SAMPLE_L_O_V1_V2, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x1, 0x2 }, // 1038
  { IMAGE_SAMPLE_L_O_V1_V3, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x1, 0x3 }, // 1039
  { IMAGE_SAMPLE_L_O_V1_V4, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x1, 0x4 }, // 1040
  { IMAGE_SAMPLE_L_O_V1_V8, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x1, 0x8 }, // 1041
  { IMAGE_SAMPLE_L_O_V2_V2, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x2, 0x2 }, // 1042
  { IMAGE_SAMPLE_L_O_V2_V3, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x2, 0x3 }, // 1043
  { IMAGE_SAMPLE_L_O_V2_V4, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x2, 0x4 }, // 1044
  { IMAGE_SAMPLE_L_O_V2_V8, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x2, 0x8 }, // 1045
  { IMAGE_SAMPLE_L_O_V3_V2, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x3, 0x2 }, // 1046
  { IMAGE_SAMPLE_L_O_V3_V3, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x3, 0x3 }, // 1047
  { IMAGE_SAMPLE_L_O_V3_V4, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x3, 0x4 }, // 1048
  { IMAGE_SAMPLE_L_O_V3_V8, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x3, 0x8 }, // 1049
  { IMAGE_SAMPLE_L_O_V4_V2, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x4, 0x2 }, // 1050
  { IMAGE_SAMPLE_L_O_V4_V3, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x4, 0x3 }, // 1051
  { IMAGE_SAMPLE_L_O_V4_V4, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x4, 0x4 }, // 1052
  { IMAGE_SAMPLE_L_O_V4_V8, IMAGE_SAMPLE_L_O, MIMGEncGfx6, 0x4, 0x8 }, // 1053
  { IMAGE_SAMPLE_O_V1_V2, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x1, 0x2 }, // 1054
  { IMAGE_SAMPLE_O_V1_V3, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x1, 0x3 }, // 1055
  { IMAGE_SAMPLE_O_V1_V4, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x1, 0x4 }, // 1056
  { IMAGE_SAMPLE_O_V2_V2, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x2, 0x2 }, // 1057
  { IMAGE_SAMPLE_O_V2_V3, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x2, 0x3 }, // 1058
  { IMAGE_SAMPLE_O_V2_V4, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x2, 0x4 }, // 1059
  { IMAGE_SAMPLE_O_V3_V2, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x3, 0x2 }, // 1060
  { IMAGE_SAMPLE_O_V3_V3, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x3, 0x3 }, // 1061
  { IMAGE_SAMPLE_O_V3_V4, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x3, 0x4 }, // 1062
  { IMAGE_SAMPLE_O_V4_V2, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x4, 0x2 }, // 1063
  { IMAGE_SAMPLE_O_V4_V3, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x4, 0x3 }, // 1064
  { IMAGE_SAMPLE_O_V4_V4, IMAGE_SAMPLE_O, MIMGEncGfx6, 0x4, 0x4 }, // 1065
  { IMAGE_STORE_V1_V1, IMAGE_STORE, MIMGEncGfx6, 0x1, 0x1 }, // 1066
  { IMAGE_STORE_V1_V2, IMAGE_STORE, MIMGEncGfx6, 0x1, 0x2 }, // 1067
  { IMAGE_STORE_V1_V3, IMAGE_STORE, MIMGEncGfx6, 0x1, 0x3 }, // 1068
  { IMAGE_STORE_V1_V4, IMAGE_STORE, MIMGEncGfx6, 0x1, 0x4 }, // 1069
  { IMAGE_STORE_V2_V1, IMAGE_STORE, MIMGEncGfx6, 0x2, 0x1 }, // 1070
  { IMAGE_STORE_V2_V2, IMAGE_STORE, MIMGEncGfx6, 0x2, 0x2 }, // 1071
  { IMAGE_STORE_V2_V3, IMAGE_STORE, MIMGEncGfx6, 0x2, 0x3 }, // 1072
  { IMAGE_STORE_V2_V4, IMAGE_STORE, MIMGEncGfx6, 0x2, 0x4 }, // 1073
  { IMAGE_STORE_V3_V1, IMAGE_STORE, MIMGEncGfx6, 0x3, 0x1 }, // 1074
  { IMAGE_STORE_V3_V2, IMAGE_STORE, MIMGEncGfx6, 0x3, 0x2 }, // 1075
  { IMAGE_STORE_V3_V3, IMAGE_STORE, MIMGEncGfx6, 0x3, 0x3 }, // 1076
  { IMAGE_STORE_V3_V4, IMAGE_STORE, MIMGEncGfx6, 0x3, 0x4 }, // 1077
  { IMAGE_STORE_V4_V1, IMAGE_STORE, MIMGEncGfx6, 0x4, 0x1 }, // 1078
  { IMAGE_STORE_V4_V2, IMAGE_STORE, MIMGEncGfx6, 0x4, 0x2 }, // 1079
  { IMAGE_STORE_V4_V3, IMAGE_STORE, MIMGEncGfx6, 0x4, 0x3 }, // 1080
  { IMAGE_STORE_V4_V4, IMAGE_STORE, MIMGEncGfx6, 0x4, 0x4 }, // 1081
  { IMAGE_STORE_MIP_V1_V1, IMAGE_STORE_MIP, MIMGEncGfx6, 0x1, 0x1 }, // 1082
  { IMAGE_STORE_MIP_V1_V2, IMAGE_STORE_MIP, MIMGEncGfx6, 0x1, 0x2 }, // 1083
  { IMAGE_STORE_MIP_V1_V3, IMAGE_STORE_MIP, MIMGEncGfx6, 0x1, 0x3 }, // 1084
  { IMAGE_STORE_MIP_V1_V4, IMAGE_STORE_MIP, MIMGEncGfx6, 0x1, 0x4 }, // 1085
  { IMAGE_STORE_MIP_V2_V1, IMAGE_STORE_MIP, MIMGEncGfx6, 0x2, 0x1 }, // 1086
  { IMAGE_STORE_MIP_V2_V2, IMAGE_STORE_MIP, MIMGEncGfx6, 0x2, 0x2 }, // 1087
  { IMAGE_STORE_MIP_V2_V3, IMAGE_STORE_MIP, MIMGEncGfx6, 0x2, 0x3 }, // 1088
  { IMAGE_STORE_MIP_V2_V4, IMAGE_STORE_MIP, MIMGEncGfx6, 0x2, 0x4 }, // 1089
  { IMAGE_STORE_MIP_V3_V1, IMAGE_STORE_MIP, MIMGEncGfx6, 0x3, 0x1 }, // 1090
  { IMAGE_STORE_MIP_V3_V2, IMAGE_STORE_MIP, MIMGEncGfx6, 0x3, 0x2 }, // 1091
  { IMAGE_STORE_MIP_V3_V3, IMAGE_STORE_MIP, MIMGEncGfx6, 0x3, 0x3 }, // 1092
  { IMAGE_STORE_MIP_V3_V4, IMAGE_STORE_MIP, MIMGEncGfx6, 0x3, 0x4 }, // 1093
  { IMAGE_STORE_MIP_V4_V1, IMAGE_STORE_MIP, MIMGEncGfx6, 0x4, 0x1 }, // 1094
  { IMAGE_STORE_MIP_V4_V2, IMAGE_STORE_MIP, MIMGEncGfx6, 0x4, 0x2 }, // 1095
  { IMAGE_STORE_MIP_V4_V3, IMAGE_STORE_MIP, MIMGEncGfx6, 0x4, 0x3 }, // 1096
  { IMAGE_STORE_MIP_V4_V4, IMAGE_STORE_MIP, MIMGEncGfx6, 0x4, 0x4 }, // 1097
  { IMAGE_STORE_MIP_PCK_V1_V1, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x1, 0x1 }, // 1098
  { IMAGE_STORE_MIP_PCK_V1_V2, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x1, 0x2 }, // 1099
  { IMAGE_STORE_MIP_PCK_V1_V3, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x1, 0x3 }, // 1100
  { IMAGE_STORE_MIP_PCK_V1_V4, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x1, 0x4 }, // 1101
  { IMAGE_STORE_MIP_PCK_V2_V1, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x2, 0x1 }, // 1102
  { IMAGE_STORE_MIP_PCK_V2_V2, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x2, 0x2 }, // 1103
  { IMAGE_STORE_MIP_PCK_V2_V3, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x2, 0x3 }, // 1104
  { IMAGE_STORE_MIP_PCK_V2_V4, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x2, 0x4 }, // 1105
  { IMAGE_STORE_MIP_PCK_V3_V1, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x3, 0x1 }, // 1106
  { IMAGE_STORE_MIP_PCK_V3_V2, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x3, 0x2 }, // 1107
  { IMAGE_STORE_MIP_PCK_V3_V3, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x3, 0x3 }, // 1108
  { IMAGE_STORE_MIP_PCK_V3_V4, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x3, 0x4 }, // 1109
  { IMAGE_STORE_MIP_PCK_V4_V1, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x4, 0x1 }, // 1110
  { IMAGE_STORE_MIP_PCK_V4_V2, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x4, 0x2 }, // 1111
  { IMAGE_STORE_MIP_PCK_V4_V3, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x4, 0x3 }, // 1112
  { IMAGE_STORE_MIP_PCK_V4_V4, IMAGE_STORE_MIP_PCK, MIMGEncGfx6, 0x4, 0x4 }, // 1113
  { IMAGE_STORE_PCK_V1_V1, IMAGE_STORE_PCK, MIMGEncGfx6, 0x1, 0x1 }, // 1114
  { IMAGE_STORE_PCK_V1_V2, IMAGE_STORE_PCK, MIMGEncGfx6, 0x1, 0x2 }, // 1115
  { IMAGE_STORE_PCK_V1_V3, IMAGE_STORE_PCK, MIMGEncGfx6, 0x1, 0x3 }, // 1116
  { IMAGE_STORE_PCK_V1_V4, IMAGE_STORE_PCK, MIMGEncGfx6, 0x1, 0x4 }, // 1117
  { IMAGE_STORE_PCK_V2_V1, IMAGE_STORE_PCK, MIMGEncGfx6, 0x2, 0x1 }, // 1118
  { IMAGE_STORE_PCK_V2_V2, IMAGE_STORE_PCK, MIMGEncGfx6, 0x2, 0x2 }, // 1119
  { IMAGE_STORE_PCK_V2_V3, IMAGE_STORE_PCK, MIMGEncGfx6, 0x2, 0x3 }, // 1120
  { IMAGE_STORE_PCK_V2_V4, IMAGE_STORE_PCK, MIMGEncGfx6, 0x2, 0x4 }, // 1121
  { IMAGE_STORE_PCK_V3_V1, IMAGE_STORE_PCK, MIMGEncGfx6, 0x3, 0x1 }, // 1122
  { IMAGE_STORE_PCK_V3_V2, IMAGE_STORE_PCK, MIMGEncGfx6, 0x3, 0x2 }, // 1123
  { IMAGE_STORE_PCK_V3_V3, IMAGE_STORE_PCK, MIMGEncGfx6, 0x3, 0x3 }, // 1124
  { IMAGE_STORE_PCK_V3_V4, IMAGE_STORE_PCK, MIMGEncGfx6, 0x3, 0x4 }, // 1125
  { IMAGE_STORE_PCK_V4_V1, IMAGE_STORE_PCK, MIMGEncGfx6, 0x4, 0x1 }, // 1126
  { IMAGE_STORE_PCK_V4_V2, IMAGE_STORE_PCK, MIMGEncGfx6, 0x4, 0x2 }, // 1127
  { IMAGE_STORE_PCK_V4_V3, IMAGE_STORE_PCK, MIMGEncGfx6, 0x4, 0x3 }, // 1128
  { IMAGE_STORE_PCK_V4_V4, IMAGE_STORE_PCK, MIMGEncGfx6, 0x4, 0x4 }, // 1129
 };

const MIMGInfo *getMIMGOpcodeHelper(unsigned BaseOpcode, unsigned MIMGEncoding, uint8_t VDataDwords, uint8_t VAddrDwords) {
  struct KeyType {
    unsigned BaseOpcode;
    unsigned MIMGEncoding;
    uint8_t VDataDwords;
    uint8_t VAddrDwords;
  };
  KeyType Key = { BaseOpcode, MIMGEncoding, VDataDwords, VAddrDwords };
  auto Table = makeArrayRef(MIMGInfoTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const MIMGInfo &LHS, const KeyType &RHS) {
      if ((unsigned)LHS.BaseOpcode < (unsigned)RHS.BaseOpcode)
        return true;
      if ((unsigned)LHS.BaseOpcode > (unsigned)RHS.BaseOpcode)
        return false;
      if ((unsigned)LHS.MIMGEncoding < (unsigned)RHS.MIMGEncoding)
        return true;
      if ((unsigned)LHS.MIMGEncoding > (unsigned)RHS.MIMGEncoding)
        return false;
      if (LHS.VDataDwords < RHS.VDataDwords)
        return true;
      if (LHS.VDataDwords > RHS.VDataDwords)
        return false;
      if (LHS.VAddrDwords < RHS.VAddrDwords)
        return true;
      if (LHS.VAddrDwords > RHS.VAddrDwords)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.BaseOpcode != Idx->BaseOpcode ||
      Key.MIMGEncoding != Idx->MIMGEncoding ||
      Key.VDataDwords != Idx->VDataDwords ||
      Key.VAddrDwords != Idx->VAddrDwords)
    return nullptr;
  return &*Idx;
}

const MIMGInfo *getMIMGInfo(unsigned Opcode) {
  struct IndexType {
    unsigned Opcode;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { IMAGE_ATOMIC_ADD_V1_V1_si, 0 },
    { IMAGE_ATOMIC_ADD_V1_V1_vi, 8 },
    { IMAGE_ATOMIC_ADD_V1_V2_si, 1 },
    { IMAGE_ATOMIC_ADD_V1_V2_vi, 9 },
    { IMAGE_ATOMIC_ADD_V1_V3_si, 2 },
    { IMAGE_ATOMIC_ADD_V1_V3_vi, 10 },
    { IMAGE_ATOMIC_ADD_V1_V4_si, 3 },
    { IMAGE_ATOMIC_ADD_V1_V4_vi, 11 },
    { IMAGE_ATOMIC_ADD_V2_V1_si, 4 },
    { IMAGE_ATOMIC_ADD_V2_V1_vi, 12 },
    { IMAGE_ATOMIC_ADD_V2_V2_si, 5 },
    { IMAGE_ATOMIC_ADD_V2_V2_vi, 13 },
    { IMAGE_ATOMIC_ADD_V2_V3_si, 6 },
    { IMAGE_ATOMIC_ADD_V2_V3_vi, 14 },
    { IMAGE_ATOMIC_ADD_V2_V4_si, 7 },
    { IMAGE_ATOMIC_ADD_V2_V4_vi, 15 },
    { IMAGE_ATOMIC_AND_V1_V1_si, 16 },
    { IMAGE_ATOMIC_AND_V1_V1_vi, 24 },
    { IMAGE_ATOMIC_AND_V1_V2_si, 17 },
    { IMAGE_ATOMIC_AND_V1_V2_vi, 25 },
    { IMAGE_ATOMIC_AND_V1_V3_si, 18 },
    { IMAGE_ATOMIC_AND_V1_V3_vi, 26 },
    { IMAGE_ATOMIC_AND_V1_V4_si, 19 },
    { IMAGE_ATOMIC_AND_V1_V4_vi, 27 },
    { IMAGE_ATOMIC_AND_V2_V1_si, 20 },
    { IMAGE_ATOMIC_AND_V2_V1_vi, 28 },
    { IMAGE_ATOMIC_AND_V2_V2_si, 21 },
    { IMAGE_ATOMIC_AND_V2_V2_vi, 29 },
    { IMAGE_ATOMIC_AND_V2_V3_si, 22 },
    { IMAGE_ATOMIC_AND_V2_V3_vi, 30 },
    { IMAGE_ATOMIC_AND_V2_V4_si, 23 },
    { IMAGE_ATOMIC_AND_V2_V4_vi, 31 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V1_si, 32 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V1_vi, 40 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V2_si, 33 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V2_vi, 41 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V3_si, 34 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V3_vi, 42 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V4_si, 35 },
    { IMAGE_ATOMIC_CMPSWAP_V1_V4_vi, 43 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V1_si, 36 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V1_vi, 44 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V2_si, 37 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V2_vi, 45 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V3_si, 38 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V3_vi, 46 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V4_si, 39 },
    { IMAGE_ATOMIC_CMPSWAP_V2_V4_vi, 47 },
    { IMAGE_ATOMIC_DEC_V1_V1_si, 48 },
    { IMAGE_ATOMIC_DEC_V1_V1_vi, 56 },
    { IMAGE_ATOMIC_DEC_V1_V2_si, 49 },
    { IMAGE_ATOMIC_DEC_V1_V2_vi, 57 },
    { IMAGE_ATOMIC_DEC_V1_V3_si, 50 },
    { IMAGE_ATOMIC_DEC_V1_V3_vi, 58 },
    { IMAGE_ATOMIC_DEC_V1_V4_si, 51 },
    { IMAGE_ATOMIC_DEC_V1_V4_vi, 59 },
    { IMAGE_ATOMIC_DEC_V2_V1_si, 52 },
    { IMAGE_ATOMIC_DEC_V2_V1_vi, 60 },
    { IMAGE_ATOMIC_DEC_V2_V2_si, 53 },
    { IMAGE_ATOMIC_DEC_V2_V2_vi, 61 },
    { IMAGE_ATOMIC_DEC_V2_V3_si, 54 },
    { IMAGE_ATOMIC_DEC_V2_V3_vi, 62 },
    { IMAGE_ATOMIC_DEC_V2_V4_si, 55 },
    { IMAGE_ATOMIC_DEC_V2_V4_vi, 63 },
    { IMAGE_ATOMIC_INC_V1_V1_si, 64 },
    { IMAGE_ATOMIC_INC_V1_V1_vi, 72 },
    { IMAGE_ATOMIC_INC_V1_V2_si, 65 },
    { IMAGE_ATOMIC_INC_V1_V2_vi, 73 },
    { IMAGE_ATOMIC_INC_V1_V3_si, 66 },
    { IMAGE_ATOMIC_INC_V1_V3_vi, 74 },
    { IMAGE_ATOMIC_INC_V1_V4_si, 67 },
    { IMAGE_ATOMIC_INC_V1_V4_vi, 75 },
    { IMAGE_ATOMIC_INC_V2_V1_si, 68 },
    { IMAGE_ATOMIC_INC_V2_V1_vi, 76 },
    { IMAGE_ATOMIC_INC_V2_V2_si, 69 },
    { IMAGE_ATOMIC_INC_V2_V2_vi, 77 },
    { IMAGE_ATOMIC_INC_V2_V3_si, 70 },
    { IMAGE_ATOMIC_INC_V2_V3_vi, 78 },
    { IMAGE_ATOMIC_INC_V2_V4_si, 71 },
    { IMAGE_ATOMIC_INC_V2_V4_vi, 79 },
    { IMAGE_ATOMIC_OR_V1_V1_si, 80 },
    { IMAGE_ATOMIC_OR_V1_V1_vi, 88 },
    { IMAGE_ATOMIC_OR_V1_V2_si, 81 },
    { IMAGE_ATOMIC_OR_V1_V2_vi, 89 },
    { IMAGE_ATOMIC_OR_V1_V3_si, 82 },
    { IMAGE_ATOMIC_OR_V1_V3_vi, 90 },
    { IMAGE_ATOMIC_OR_V1_V4_si, 83 },
    { IMAGE_ATOMIC_OR_V1_V4_vi, 91 },
    { IMAGE_ATOMIC_OR_V2_V1_si, 84 },
    { IMAGE_ATOMIC_OR_V2_V1_vi, 92 },
    { IMAGE_ATOMIC_OR_V2_V2_si, 85 },
    { IMAGE_ATOMIC_OR_V2_V2_vi, 93 },
    { IMAGE_ATOMIC_OR_V2_V3_si, 86 },
    { IMAGE_ATOMIC_OR_V2_V3_vi, 94 },
    { IMAGE_ATOMIC_OR_V2_V4_si, 87 },
    { IMAGE_ATOMIC_OR_V2_V4_vi, 95 },
    { IMAGE_ATOMIC_SMAX_V1_V1_si, 96 },
    { IMAGE_ATOMIC_SMAX_V1_V1_vi, 104 },
    { IMAGE_ATOMIC_SMAX_V1_V2_si, 97 },
    { IMAGE_ATOMIC_SMAX_V1_V2_vi, 105 },
    { IMAGE_ATOMIC_SMAX_V1_V3_si, 98 },
    { IMAGE_ATOMIC_SMAX_V1_V3_vi, 106 },
    { IMAGE_ATOMIC_SMAX_V1_V4_si, 99 },
    { IMAGE_ATOMIC_SMAX_V1_V4_vi, 107 },
    { IMAGE_ATOMIC_SMAX_V2_V1_si, 100 },
    { IMAGE_ATOMIC_SMAX_V2_V1_vi, 108 },
    { IMAGE_ATOMIC_SMAX_V2_V2_si, 101 },
    { IMAGE_ATOMIC_SMAX_V2_V2_vi, 109 },
    { IMAGE_ATOMIC_SMAX_V2_V3_si, 102 },
    { IMAGE_ATOMIC_SMAX_V2_V3_vi, 110 },
    { IMAGE_ATOMIC_SMAX_V2_V4_si, 103 },
    { IMAGE_ATOMIC_SMAX_V2_V4_vi, 111 },
    { IMAGE_ATOMIC_SMIN_V1_V1_si, 112 },
    { IMAGE_ATOMIC_SMIN_V1_V1_vi, 120 },
    { IMAGE_ATOMIC_SMIN_V1_V2_si, 113 },
    { IMAGE_ATOMIC_SMIN_V1_V2_vi, 121 },
    { IMAGE_ATOMIC_SMIN_V1_V3_si, 114 },
    { IMAGE_ATOMIC_SMIN_V1_V3_vi, 122 },
    { IMAGE_ATOMIC_SMIN_V1_V4_si, 115 },
    { IMAGE_ATOMIC_SMIN_V1_V4_vi, 123 },
    { IMAGE_ATOMIC_SMIN_V2_V1_si, 116 },
    { IMAGE_ATOMIC_SMIN_V2_V1_vi, 124 },
    { IMAGE_ATOMIC_SMIN_V2_V2_si, 117 },
    { IMAGE_ATOMIC_SMIN_V2_V2_vi, 125 },
    { IMAGE_ATOMIC_SMIN_V2_V3_si, 118 },
    { IMAGE_ATOMIC_SMIN_V2_V3_vi, 126 },
    { IMAGE_ATOMIC_SMIN_V2_V4_si, 119 },
    { IMAGE_ATOMIC_SMIN_V2_V4_vi, 127 },
    { IMAGE_ATOMIC_SUB_V1_V1_si, 128 },
    { IMAGE_ATOMIC_SUB_V1_V1_vi, 136 },
    { IMAGE_ATOMIC_SUB_V1_V2_si, 129 },
    { IMAGE_ATOMIC_SUB_V1_V2_vi, 137 },
    { IMAGE_ATOMIC_SUB_V1_V3_si, 130 },
    { IMAGE_ATOMIC_SUB_V1_V3_vi, 138 },
    { IMAGE_ATOMIC_SUB_V1_V4_si, 131 },
    { IMAGE_ATOMIC_SUB_V1_V4_vi, 139 },
    { IMAGE_ATOMIC_SUB_V2_V1_si, 132 },
    { IMAGE_ATOMIC_SUB_V2_V1_vi, 140 },
    { IMAGE_ATOMIC_SUB_V2_V2_si, 133 },
    { IMAGE_ATOMIC_SUB_V2_V2_vi, 141 },
    { IMAGE_ATOMIC_SUB_V2_V3_si, 134 },
    { IMAGE_ATOMIC_SUB_V2_V3_vi, 142 },
    { IMAGE_ATOMIC_SUB_V2_V4_si, 135 },
    { IMAGE_ATOMIC_SUB_V2_V4_vi, 143 },
    { IMAGE_ATOMIC_SWAP_V1_V1_si, 144 },
    { IMAGE_ATOMIC_SWAP_V1_V1_vi, 152 },
    { IMAGE_ATOMIC_SWAP_V1_V2_si, 145 },
    { IMAGE_ATOMIC_SWAP_V1_V2_vi, 153 },
    { IMAGE_ATOMIC_SWAP_V1_V3_si, 146 },
    { IMAGE_ATOMIC_SWAP_V1_V3_vi, 154 },
    { IMAGE_ATOMIC_SWAP_V1_V4_si, 147 },
    { IMAGE_ATOMIC_SWAP_V1_V4_vi, 155 },
    { IMAGE_ATOMIC_SWAP_V2_V1_si, 148 },
    { IMAGE_ATOMIC_SWAP_V2_V1_vi, 156 },
    { IMAGE_ATOMIC_SWAP_V2_V2_si, 149 },
    { IMAGE_ATOMIC_SWAP_V2_V2_vi, 157 },
    { IMAGE_ATOMIC_SWAP_V2_V3_si, 150 },
    { IMAGE_ATOMIC_SWAP_V2_V3_vi, 158 },
    { IMAGE_ATOMIC_SWAP_V2_V4_si, 151 },
    { IMAGE_ATOMIC_SWAP_V2_V4_vi, 159 },
    { IMAGE_ATOMIC_UMAX_V1_V1_si, 160 },
    { IMAGE_ATOMIC_UMAX_V1_V1_vi, 168 },
    { IMAGE_ATOMIC_UMAX_V1_V2_si, 161 },
    { IMAGE_ATOMIC_UMAX_V1_V2_vi, 169 },
    { IMAGE_ATOMIC_UMAX_V1_V3_si, 162 },
    { IMAGE_ATOMIC_UMAX_V1_V3_vi, 170 },
    { IMAGE_ATOMIC_UMAX_V1_V4_si, 163 },
    { IMAGE_ATOMIC_UMAX_V1_V4_vi, 171 },
    { IMAGE_ATOMIC_UMAX_V2_V1_si, 164 },
    { IMAGE_ATOMIC_UMAX_V2_V1_vi, 172 },
    { IMAGE_ATOMIC_UMAX_V2_V2_si, 165 },
    { IMAGE_ATOMIC_UMAX_V2_V2_vi, 173 },
    { IMAGE_ATOMIC_UMAX_V2_V3_si, 166 },
    { IMAGE_ATOMIC_UMAX_V2_V3_vi, 174 },
    { IMAGE_ATOMIC_UMAX_V2_V4_si, 167 },
    { IMAGE_ATOMIC_UMAX_V2_V4_vi, 175 },
    { IMAGE_ATOMIC_UMIN_V1_V1_si, 176 },
    { IMAGE_ATOMIC_UMIN_V1_V1_vi, 184 },
    { IMAGE_ATOMIC_UMIN_V1_V2_si, 177 },
    { IMAGE_ATOMIC_UMIN_V1_V2_vi, 185 },
    { IMAGE_ATOMIC_UMIN_V1_V3_si, 178 },
    { IMAGE_ATOMIC_UMIN_V1_V3_vi, 186 },
    { IMAGE_ATOMIC_UMIN_V1_V4_si, 179 },
    { IMAGE_ATOMIC_UMIN_V1_V4_vi, 187 },
    { IMAGE_ATOMIC_UMIN_V2_V1_si, 180 },
    { IMAGE_ATOMIC_UMIN_V2_V1_vi, 188 },
    { IMAGE_ATOMIC_UMIN_V2_V2_si, 181 },
    { IMAGE_ATOMIC_UMIN_V2_V2_vi, 189 },
    { IMAGE_ATOMIC_UMIN_V2_V3_si, 182 },
    { IMAGE_ATOMIC_UMIN_V2_V3_vi, 190 },
    { IMAGE_ATOMIC_UMIN_V2_V4_si, 183 },
    { IMAGE_ATOMIC_UMIN_V2_V4_vi, 191 },
    { IMAGE_ATOMIC_XOR_V1_V1_si, 192 },
    { IMAGE_ATOMIC_XOR_V1_V1_vi, 200 },
    { IMAGE_ATOMIC_XOR_V1_V2_si, 193 },
    { IMAGE_ATOMIC_XOR_V1_V2_vi, 201 },
    { IMAGE_ATOMIC_XOR_V1_V3_si, 194 },
    { IMAGE_ATOMIC_XOR_V1_V3_vi, 202 },
    { IMAGE_ATOMIC_XOR_V1_V4_si, 195 },
    { IMAGE_ATOMIC_XOR_V1_V4_vi, 203 },
    { IMAGE_ATOMIC_XOR_V2_V1_si, 196 },
    { IMAGE_ATOMIC_XOR_V2_V1_vi, 204 },
    { IMAGE_ATOMIC_XOR_V2_V2_si, 197 },
    { IMAGE_ATOMIC_XOR_V2_V2_vi, 205 },
    { IMAGE_ATOMIC_XOR_V2_V3_si, 198 },
    { IMAGE_ATOMIC_XOR_V2_V3_vi, 206 },
    { IMAGE_ATOMIC_XOR_V2_V4_si, 199 },
    { IMAGE_ATOMIC_XOR_V2_V4_vi, 207 },
    { IMAGE_GATHER4_B_CL_O_V2_V3, 230 },
    { IMAGE_GATHER4_B_CL_O_V2_V4, 231 },
    { IMAGE_GATHER4_B_CL_O_V2_V8, 232 },
    { IMAGE_GATHER4_B_CL_O_V4_V3, 233 },
    { IMAGE_GATHER4_B_CL_O_V4_V4, 234 },
    { IMAGE_GATHER4_B_CL_O_V4_V8, 235 },
    { IMAGE_GATHER4_B_CL_V2_V2, 222 },
    { IMAGE_GATHER4_B_CL_V2_V3, 223 },
    { IMAGE_GATHER4_B_CL_V2_V4, 224 },
    { IMAGE_GATHER4_B_CL_V2_V8, 225 },
    { IMAGE_GATHER4_B_CL_V4_V2, 226 },
    { IMAGE_GATHER4_B_CL_V4_V3, 227 },
    { IMAGE_GATHER4_B_CL_V4_V4, 228 },
    { IMAGE_GATHER4_B_CL_V4_V8, 229 },
    { IMAGE_GATHER4_B_O_V2_V3, 236 },
    { IMAGE_GATHER4_B_O_V2_V4, 237 },
    { IMAGE_GATHER4_B_O_V2_V8, 238 },
    { IMAGE_GATHER4_B_O_V4_V3, 239 },
    { IMAGE_GATHER4_B_O_V4_V4, 240 },
    { IMAGE_GATHER4_B_O_V4_V8, 241 },
    { IMAGE_GATHER4_B_V2_V2, 216 },
    { IMAGE_GATHER4_B_V2_V3, 217 },
    { IMAGE_GATHER4_B_V2_V4, 218 },
    { IMAGE_GATHER4_B_V4_V2, 219 },
    { IMAGE_GATHER4_B_V4_V3, 220 },
    { IMAGE_GATHER4_B_V4_V4, 221 },
    { IMAGE_GATHER4_CL_O_V2_V2, 256 },
    { IMAGE_GATHER4_CL_O_V2_V3, 257 },
    { IMAGE_GATHER4_CL_O_V2_V4, 258 },
    { IMAGE_GATHER4_CL_O_V2_V8, 259 },
    { IMAGE_GATHER4_CL_O_V4_V2, 260 },
    { IMAGE_GATHER4_CL_O_V4_V3, 261 },
    { IMAGE_GATHER4_CL_O_V4_V4, 262 },
    { IMAGE_GATHER4_CL_O_V4_V8, 263 },
    { IMAGE_GATHER4_CL_V2_V1, 248 },
    { IMAGE_GATHER4_CL_V2_V2, 249 },
    { IMAGE_GATHER4_CL_V2_V3, 250 },
    { IMAGE_GATHER4_CL_V2_V4, 251 },
    { IMAGE_GATHER4_CL_V4_V1, 252 },
    { IMAGE_GATHER4_CL_V4_V2, 253 },
    { IMAGE_GATHER4_CL_V4_V3, 254 },
    { IMAGE_GATHER4_CL_V4_V4, 255 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V4, 276 },
    { IMAGE_GATHER4_C_B_CL_O_V2_V8, 277 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V4, 278 },
    { IMAGE_GATHER4_C_B_CL_O_V4_V8, 279 },
    { IMAGE_GATHER4_C_B_CL_V2_V3, 270 },
    { IMAGE_GATHER4_C_B_CL_V2_V4, 271 },
    { IMAGE_GATHER4_C_B_CL_V2_V8, 272 },
    { IMAGE_GATHER4_C_B_CL_V4_V3, 273 },
    { IMAGE_GATHER4_C_B_CL_V4_V4, 274 },
    { IMAGE_GATHER4_C_B_CL_V4_V8, 275 },
    { IMAGE_GATHER4_C_B_O_V2_V4, 280 },
    { IMAGE_GATHER4_C_B_O_V2_V8, 281 },
    { IMAGE_GATHER4_C_B_O_V4_V4, 282 },
    { IMAGE_GATHER4_C_B_O_V4_V8, 283 },
    { IMAGE_GATHER4_C_B_V2_V3, 264 },
    { IMAGE_GATHER4_C_B_V2_V4, 265 },
    { IMAGE_GATHER4_C_B_V2_V8, 266 },
    { IMAGE_GATHER4_C_B_V4_V3, 267 },
    { IMAGE_GATHER4_C_B_V4_V4, 268 },
    { IMAGE_GATHER4_C_B_V4_V8, 269 },
    { IMAGE_GATHER4_C_CL_O_V2_V3, 292 },
    { IMAGE_GATHER4_C_CL_O_V2_V4, 293 },
    { IMAGE_GATHER4_C_CL_O_V2_V8, 294 },
    { IMAGE_GATHER4_C_CL_O_V4_V3, 295 },
    { IMAGE_GATHER4_C_CL_O_V4_V4, 296 },
    { IMAGE_GATHER4_C_CL_O_V4_V8, 297 },
    { IMAGE_GATHER4_C_CL_V2_V2, 284 },
    { IMAGE_GATHER4_C_CL_V2_V3, 285 },
    { IMAGE_GATHER4_C_CL_V2_V4, 286 },
    { IMAGE_GATHER4_C_CL_V2_V8, 287 },
    { IMAGE_GATHER4_C_CL_V4_V2, 288 },
    { IMAGE_GATHER4_C_CL_V4_V3, 289 },
    { IMAGE_GATHER4_C_CL_V4_V4, 290 },
    { IMAGE_GATHER4_C_CL_V4_V8, 291 },
    { IMAGE_GATHER4_C_LZ_O_V2_V3, 312 },
    { IMAGE_GATHER4_C_LZ_O_V2_V4, 313 },
    { IMAGE_GATHER4_C_LZ_O_V2_V8, 314 },
    { IMAGE_GATHER4_C_LZ_O_V4_V3, 315 },
    { IMAGE_GATHER4_C_LZ_O_V4_V4, 316 },
    { IMAGE_GATHER4_C_LZ_O_V4_V8, 317 },
    { IMAGE_GATHER4_C_LZ_V2_V2, 306 },
    { IMAGE_GATHER4_C_LZ_V2_V3, 307 },
    { IMAGE_GATHER4_C_LZ_V2_V4, 308 },
    { IMAGE_GATHER4_C_LZ_V4_V2, 309 },
    { IMAGE_GATHER4_C_LZ_V4_V3, 310 },
    { IMAGE_GATHER4_C_LZ_V4_V4, 311 },
    { IMAGE_GATHER4_C_L_O_V2_V3, 318 },
    { IMAGE_GATHER4_C_L_O_V2_V4, 319 },
    { IMAGE_GATHER4_C_L_O_V2_V8, 320 },
    { IMAGE_GATHER4_C_L_O_V4_V3, 321 },
    { IMAGE_GATHER4_C_L_O_V4_V4, 322 },
    { IMAGE_GATHER4_C_L_O_V4_V8, 323 },
    { IMAGE_GATHER4_C_L_V2_V2, 298 },
    { IMAGE_GATHER4_C_L_V2_V3, 299 },
    { IMAGE_GATHER4_C_L_V2_V4, 300 },
    { IMAGE_GATHER4_C_L_V2_V8, 301 },
    { IMAGE_GATHER4_C_L_V4_V2, 302 },
    { IMAGE_GATHER4_C_L_V4_V3, 303 },
    { IMAGE_GATHER4_C_L_V4_V4, 304 },
    { IMAGE_GATHER4_C_L_V4_V8, 305 },
    { IMAGE_GATHER4_C_O_V2_V3, 324 },
    { IMAGE_GATHER4_C_O_V2_V4, 325 },
    { IMAGE_GATHER4_C_O_V2_V8, 326 },
    { IMAGE_GATHER4_C_O_V4_V3, 327 },
    { IMAGE_GATHER4_C_O_V4_V4, 328 },
    { IMAGE_GATHER4_C_O_V4_V8, 329 },
    { IMAGE_GATHER4_C_V2_V2, 242 },
    { IMAGE_GATHER4_C_V2_V3, 243 },
    { IMAGE_GATHER4_C_V2_V4, 244 },
    { IMAGE_GATHER4_C_V4_V2, 245 },
    { IMAGE_GATHER4_C_V4_V3, 246 },
    { IMAGE_GATHER4_C_V4_V4, 247 },
    { IMAGE_GATHER4_LZ_O_V2_V2, 346 },
    { IMAGE_GATHER4_LZ_O_V2_V3, 347 },
    { IMAGE_GATHER4_LZ_O_V2_V4, 348 },
    { IMAGE_GATHER4_LZ_O_V4_V2, 349 },
    { IMAGE_GATHER4_LZ_O_V4_V3, 350 },
    { IMAGE_GATHER4_LZ_O_V4_V4, 351 },
    { IMAGE_GATHER4_LZ_V2_V1, 338 },
    { IMAGE_GATHER4_LZ_V2_V2, 339 },
    { IMAGE_GATHER4_LZ_V2_V3, 340 },
    { IMAGE_GATHER4_LZ_V2_V4, 341 },
    { IMAGE_GATHER4_LZ_V4_V1, 342 },
    { IMAGE_GATHER4_LZ_V4_V2, 343 },
    { IMAGE_GATHER4_LZ_V4_V3, 344 },
    { IMAGE_GATHER4_LZ_V4_V4, 345 },
    { IMAGE_GATHER4_L_O_V2_V2, 352 },
    { IMAGE_GATHER4_L_O_V2_V3, 353 },
    { IMAGE_GATHER4_L_O_V2_V4, 354 },
    { IMAGE_GATHER4_L_O_V2_V8, 355 },
    { IMAGE_GATHER4_L_O_V4_V2, 356 },
    { IMAGE_GATHER4_L_O_V4_V3, 357 },
    { IMAGE_GATHER4_L_O_V4_V4, 358 },
    { IMAGE_GATHER4_L_O_V4_V8, 359 },
    { IMAGE_GATHER4_L_V2_V1, 330 },
    { IMAGE_GATHER4_L_V2_V2, 331 },
    { IMAGE_GATHER4_L_V2_V3, 332 },
    { IMAGE_GATHER4_L_V2_V4, 333 },
    { IMAGE_GATHER4_L_V4_V1, 334 },
    { IMAGE_GATHER4_L_V4_V2, 335 },
    { IMAGE_GATHER4_L_V4_V3, 336 },
    { IMAGE_GATHER4_L_V4_V4, 337 },
    { IMAGE_GATHER4_O_V2_V2, 360 },
    { IMAGE_GATHER4_O_V2_V3, 361 },
    { IMAGE_GATHER4_O_V2_V4, 362 },
    { IMAGE_GATHER4_O_V4_V2, 363 },
    { IMAGE_GATHER4_O_V4_V3, 364 },
    { IMAGE_GATHER4_O_V4_V4, 365 },
    { IMAGE_GATHER4_V2_V1, 208 },
    { IMAGE_GATHER4_V2_V2, 209 },
    { IMAGE_GATHER4_V2_V3, 210 },
    { IMAGE_GATHER4_V2_V4, 211 },
    { IMAGE_GATHER4_V4_V1, 212 },
    { IMAGE_GATHER4_V4_V2, 213 },
    { IMAGE_GATHER4_V4_V3, 214 },
    { IMAGE_GATHER4_V4_V4, 215 },
    { IMAGE_GET_LOD_V1_V1, 366 },
    { IMAGE_GET_LOD_V1_V2, 367 },
    { IMAGE_GET_LOD_V1_V3, 368 },
    { IMAGE_GET_LOD_V1_V4, 369 },
    { IMAGE_GET_LOD_V2_V1, 370 },
    { IMAGE_GET_LOD_V2_V2, 371 },
    { IMAGE_GET_LOD_V2_V3, 372 },
    { IMAGE_GET_LOD_V2_V4, 373 },
    { IMAGE_GET_LOD_V3_V1, 374 },
    { IMAGE_GET_LOD_V3_V2, 375 },
    { IMAGE_GET_LOD_V3_V3, 376 },
    { IMAGE_GET_LOD_V3_V4, 377 },
    { IMAGE_GET_LOD_V4_V1, 378 },
    { IMAGE_GET_LOD_V4_V2, 379 },
    { IMAGE_GET_LOD_V4_V3, 380 },
    { IMAGE_GET_LOD_V4_V4, 381 },
    { IMAGE_GET_RESINFO_V1_V1, 382 },
    { IMAGE_GET_RESINFO_V1_V2, 383 },
    { IMAGE_GET_RESINFO_V1_V3, 384 },
    { IMAGE_GET_RESINFO_V1_V4, 385 },
    { IMAGE_GET_RESINFO_V2_V1, 386 },
    { IMAGE_GET_RESINFO_V2_V2, 387 },
    { IMAGE_GET_RESINFO_V2_V3, 388 },
    { IMAGE_GET_RESINFO_V2_V4, 389 },
    { IMAGE_GET_RESINFO_V3_V1, 390 },
    { IMAGE_GET_RESINFO_V3_V2, 391 },
    { IMAGE_GET_RESINFO_V3_V3, 392 },
    { IMAGE_GET_RESINFO_V3_V4, 393 },
    { IMAGE_GET_RESINFO_V4_V1, 394 },
    { IMAGE_GET_RESINFO_V4_V2, 395 },
    { IMAGE_GET_RESINFO_V4_V3, 396 },
    { IMAGE_GET_RESINFO_V4_V4, 397 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V1, 446 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V2, 447 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V3, 448 },
    { IMAGE_LOAD_MIP_PCK_SGN_V1_V4, 449 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V1, 450 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V2, 451 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V3, 452 },
    { IMAGE_LOAD_MIP_PCK_SGN_V2_V4, 453 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V1, 454 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V2, 455 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V3, 456 },
    { IMAGE_LOAD_MIP_PCK_SGN_V3_V4, 457 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V1, 458 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V2, 459 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V3, 460 },
    { IMAGE_LOAD_MIP_PCK_SGN_V4_V4, 461 },
    { IMAGE_LOAD_MIP_PCK_V1_V1, 430 },
    { IMAGE_LOAD_MIP_PCK_V1_V2, 431 },
    { IMAGE_LOAD_MIP_PCK_V1_V3, 432 },
    { IMAGE_LOAD_MIP_PCK_V1_V4, 433 },
    { IMAGE_LOAD_MIP_PCK_V2_V1, 434 },
    { IMAGE_LOAD_MIP_PCK_V2_V2, 435 },
    { IMAGE_LOAD_MIP_PCK_V2_V3, 436 },
    { IMAGE_LOAD_MIP_PCK_V2_V4, 437 },
    { IMAGE_LOAD_MIP_PCK_V3_V1, 438 },
    { IMAGE_LOAD_MIP_PCK_V3_V2, 439 },
    { IMAGE_LOAD_MIP_PCK_V3_V3, 440 },
    { IMAGE_LOAD_MIP_PCK_V3_V4, 441 },
    { IMAGE_LOAD_MIP_PCK_V4_V1, 442 },
    { IMAGE_LOAD_MIP_PCK_V4_V2, 443 },
    { IMAGE_LOAD_MIP_PCK_V4_V3, 444 },
    { IMAGE_LOAD_MIP_PCK_V4_V4, 445 },
    { IMAGE_LOAD_MIP_V1_V1, 414 },
    { IMAGE_LOAD_MIP_V1_V2, 415 },
    { IMAGE_LOAD_MIP_V1_V3, 416 },
    { IMAGE_LOAD_MIP_V1_V4, 417 },
    { IMAGE_LOAD_MIP_V2_V1, 418 },
    { IMAGE_LOAD_MIP_V2_V2, 419 },
    { IMAGE_LOAD_MIP_V2_V3, 420 },
    { IMAGE_LOAD_MIP_V2_V4, 421 },
    { IMAGE_LOAD_MIP_V3_V1, 422 },
    { IMAGE_LOAD_MIP_V3_V2, 423 },
    { IMAGE_LOAD_MIP_V3_V3, 424 },
    { IMAGE_LOAD_MIP_V3_V4, 425 },
    { IMAGE_LOAD_MIP_V4_V1, 426 },
    { IMAGE_LOAD_MIP_V4_V2, 427 },
    { IMAGE_LOAD_MIP_V4_V3, 428 },
    { IMAGE_LOAD_MIP_V4_V4, 429 },
    { IMAGE_LOAD_PCK_SGN_V1_V1, 478 },
    { IMAGE_LOAD_PCK_SGN_V1_V2, 479 },
    { IMAGE_LOAD_PCK_SGN_V1_V3, 480 },
    { IMAGE_LOAD_PCK_SGN_V1_V4, 481 },
    { IMAGE_LOAD_PCK_SGN_V2_V1, 482 },
    { IMAGE_LOAD_PCK_SGN_V2_V2, 483 },
    { IMAGE_LOAD_PCK_SGN_V2_V3, 484 },
    { IMAGE_LOAD_PCK_SGN_V2_V4, 485 },
    { IMAGE_LOAD_PCK_SGN_V3_V1, 486 },
    { IMAGE_LOAD_PCK_SGN_V3_V2, 487 },
    { IMAGE_LOAD_PCK_SGN_V3_V3, 488 },
    { IMAGE_LOAD_PCK_SGN_V3_V4, 489 },
    { IMAGE_LOAD_PCK_SGN_V4_V1, 490 },
    { IMAGE_LOAD_PCK_SGN_V4_V2, 491 },
    { IMAGE_LOAD_PCK_SGN_V4_V3, 492 },
    { IMAGE_LOAD_PCK_SGN_V4_V4, 493 },
    { IMAGE_LOAD_PCK_V1_V1, 462 },
    { IMAGE_LOAD_PCK_V1_V2, 463 },
    { IMAGE_LOAD_PCK_V1_V3, 464 },
    { IMAGE_LOAD_PCK_V1_V4, 465 },
    { IMAGE_LOAD_PCK_V2_V1, 466 },
    { IMAGE_LOAD_PCK_V2_V2, 467 },
    { IMAGE_LOAD_PCK_V2_V3, 468 },
    { IMAGE_LOAD_PCK_V2_V4, 469 },
    { IMAGE_LOAD_PCK_V3_V1, 470 },
    { IMAGE_LOAD_PCK_V3_V2, 471 },
    { IMAGE_LOAD_PCK_V3_V3, 472 },
    { IMAGE_LOAD_PCK_V3_V4, 473 },
    { IMAGE_LOAD_PCK_V4_V1, 474 },
    { IMAGE_LOAD_PCK_V4_V2, 475 },
    { IMAGE_LOAD_PCK_V4_V3, 476 },
    { IMAGE_LOAD_PCK_V4_V4, 477 },
    { IMAGE_LOAD_V1_V1, 398 },
    { IMAGE_LOAD_V1_V2, 399 },
    { IMAGE_LOAD_V1_V3, 400 },
    { IMAGE_LOAD_V1_V4, 401 },
    { IMAGE_LOAD_V2_V1, 402 },
    { IMAGE_LOAD_V2_V2, 403 },
    { IMAGE_LOAD_V2_V3, 404 },
    { IMAGE_LOAD_V2_V4, 405 },
    { IMAGE_LOAD_V3_V1, 406 },
    { IMAGE_LOAD_V3_V2, 407 },
    { IMAGE_LOAD_V3_V3, 408 },
    { IMAGE_LOAD_V3_V4, 409 },
    { IMAGE_LOAD_V4_V1, 410 },
    { IMAGE_LOAD_V4_V2, 411 },
    { IMAGE_LOAD_V4_V3, 412 },
    { IMAGE_LOAD_V4_V4, 413 },
    { IMAGE_SAMPLE_B_CL_O_V1_V3, 538 },
    { IMAGE_SAMPLE_B_CL_O_V1_V4, 539 },
    { IMAGE_SAMPLE_B_CL_O_V1_V8, 540 },
    { IMAGE_SAMPLE_B_CL_O_V2_V3, 541 },
    { IMAGE_SAMPLE_B_CL_O_V2_V4, 542 },
    { IMAGE_SAMPLE_B_CL_O_V2_V8, 543 },
    { IMAGE_SAMPLE_B_CL_O_V3_V3, 544 },
    { IMAGE_SAMPLE_B_CL_O_V3_V4, 545 },
    { IMAGE_SAMPLE_B_CL_O_V3_V8, 546 },
    { IMAGE_SAMPLE_B_CL_O_V4_V3, 547 },
    { IMAGE_SAMPLE_B_CL_O_V4_V4, 548 },
    { IMAGE_SAMPLE_B_CL_O_V4_V8, 549 },
    { IMAGE_SAMPLE_B_CL_V1_V2, 522 },
    { IMAGE_SAMPLE_B_CL_V1_V3, 523 },
    { IMAGE_SAMPLE_B_CL_V1_V4, 524 },
    { IMAGE_SAMPLE_B_CL_V1_V8, 525 },
    { IMAGE_SAMPLE_B_CL_V2_V2, 526 },
    { IMAGE_SAMPLE_B_CL_V2_V3, 527 },
    { IMAGE_SAMPLE_B_CL_V2_V4, 528 },
    { IMAGE_SAMPLE_B_CL_V2_V8, 529 },
    { IMAGE_SAMPLE_B_CL_V3_V2, 530 },
    { IMAGE_SAMPLE_B_CL_V3_V3, 531 },
    { IMAGE_SAMPLE_B_CL_V3_V4, 532 },
    { IMAGE_SAMPLE_B_CL_V3_V8, 533 },
    { IMAGE_SAMPLE_B_CL_V4_V2, 534 },
    { IMAGE_SAMPLE_B_CL_V4_V3, 535 },
    { IMAGE_SAMPLE_B_CL_V4_V4, 536 },
    { IMAGE_SAMPLE_B_CL_V4_V8, 537 },
    { IMAGE_SAMPLE_B_O_V1_V3, 550 },
    { IMAGE_SAMPLE_B_O_V1_V4, 551 },
    { IMAGE_SAMPLE_B_O_V1_V8, 552 },
    { IMAGE_SAMPLE_B_O_V2_V3, 553 },
    { IMAGE_SAMPLE_B_O_V2_V4, 554 },
    { IMAGE_SAMPLE_B_O_V2_V8, 555 },
    { IMAGE_SAMPLE_B_O_V3_V3, 556 },
    { IMAGE_SAMPLE_B_O_V3_V4, 557 },
    { IMAGE_SAMPLE_B_O_V3_V8, 558 },
    { IMAGE_SAMPLE_B_O_V4_V3, 559 },
    { IMAGE_SAMPLE_B_O_V4_V4, 560 },
    { IMAGE_SAMPLE_B_O_V4_V8, 561 },
    { IMAGE_SAMPLE_B_V1_V2, 510 },
    { IMAGE_SAMPLE_B_V1_V3, 511 },
    { IMAGE_SAMPLE_B_V1_V4, 512 },
    { IMAGE_SAMPLE_B_V2_V2, 513 },
    { IMAGE_SAMPLE_B_V2_V3, 514 },
    { IMAGE_SAMPLE_B_V2_V4, 515 },
    { IMAGE_SAMPLE_B_V3_V2, 516 },
    { IMAGE_SAMPLE_B_V3_V3, 517 },
    { IMAGE_SAMPLE_B_V3_V4, 518 },
    { IMAGE_SAMPLE_B_V4_V2, 519 },
    { IMAGE_SAMPLE_B_V4_V3, 520 },
    { IMAGE_SAMPLE_B_V4_V4, 521 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V16, 617 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V3, 614 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V4, 615 },
    { IMAGE_SAMPLE_CD_CL_O_V1_V8, 616 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V16, 621 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V3, 618 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V4, 619 },
    { IMAGE_SAMPLE_CD_CL_O_V2_V8, 620 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V16, 625 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V3, 622 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V4, 623 },
    { IMAGE_SAMPLE_CD_CL_O_V3_V8, 624 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V16, 629 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V3, 626 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V4, 627 },
    { IMAGE_SAMPLE_CD_CL_O_V4_V8, 628 },
    { IMAGE_SAMPLE_CD_CL_V1_V16, 598 },
    { IMAGE_SAMPLE_CD_CL_V1_V2, 594 },
    { IMAGE_SAMPLE_CD_CL_V1_V3, 595 },
    { IMAGE_SAMPLE_CD_CL_V1_V4, 596 },
    { IMAGE_SAMPLE_CD_CL_V1_V8, 597 },
    { IMAGE_SAMPLE_CD_CL_V2_V16, 603 },
    { IMAGE_SAMPLE_CD_CL_V2_V2, 599 },
    { IMAGE_SAMPLE_CD_CL_V2_V3, 600 },
    { IMAGE_SAMPLE_CD_CL_V2_V4, 601 },
    { IMAGE_SAMPLE_CD_CL_V2_V8, 602 },
    { IMAGE_SAMPLE_CD_CL_V3_V16, 608 },
    { IMAGE_SAMPLE_CD_CL_V3_V2, 604 },
    { IMAGE_SAMPLE_CD_CL_V3_V3, 605 },
    { IMAGE_SAMPLE_CD_CL_V3_V4, 606 },
    { IMAGE_SAMPLE_CD_CL_V3_V8, 607 },
    { IMAGE_SAMPLE_CD_CL_V4_V16, 613 },
    { IMAGE_SAMPLE_CD_CL_V4_V2, 609 },
    { IMAGE_SAMPLE_CD_CL_V4_V3, 610 },
    { IMAGE_SAMPLE_CD_CL_V4_V4, 611 },
    { IMAGE_SAMPLE_CD_CL_V4_V8, 612 },
    { IMAGE_SAMPLE_CD_O_V1_V16, 633 },
    { IMAGE_SAMPLE_CD_O_V1_V3, 630 },
    { IMAGE_SAMPLE_CD_O_V1_V4, 631 },
    { IMAGE_SAMPLE_CD_O_V1_V8, 632 },
    { IMAGE_SAMPLE_CD_O_V2_V16, 637 },
    { IMAGE_SAMPLE_CD_O_V2_V3, 634 },
    { IMAGE_SAMPLE_CD_O_V2_V4, 635 },
    { IMAGE_SAMPLE_CD_O_V2_V8, 636 },
    { IMAGE_SAMPLE_CD_O_V3_V16, 641 },
    { IMAGE_SAMPLE_CD_O_V3_V3, 638 },
    { IMAGE_SAMPLE_CD_O_V3_V4, 639 },
    { IMAGE_SAMPLE_CD_O_V3_V8, 640 },
    { IMAGE_SAMPLE_CD_O_V4_V16, 645 },
    { IMAGE_SAMPLE_CD_O_V4_V3, 642 },
    { IMAGE_SAMPLE_CD_O_V4_V4, 643 },
    { IMAGE_SAMPLE_CD_O_V4_V8, 644 },
    { IMAGE_SAMPLE_CD_V1_V16, 578 },
    { IMAGE_SAMPLE_CD_V1_V2, 574 },
    { IMAGE_SAMPLE_CD_V1_V3, 575 },
    { IMAGE_SAMPLE_CD_V1_V4, 576 },
    { IMAGE_SAMPLE_CD_V1_V8, 577 },
    { IMAGE_SAMPLE_CD_V2_V16, 583 },
    { IMAGE_SAMPLE_CD_V2_V2, 579 },
    { IMAGE_SAMPLE_CD_V2_V3, 580 },
    { IMAGE_SAMPLE_CD_V2_V4, 581 },
    { IMAGE_SAMPLE_CD_V2_V8, 582 },
    { IMAGE_SAMPLE_CD_V3_V16, 588 },
    { IMAGE_SAMPLE_CD_V3_V2, 584 },
    { IMAGE_SAMPLE_CD_V3_V3, 585 },
    { IMAGE_SAMPLE_CD_V3_V4, 586 },
    { IMAGE_SAMPLE_CD_V3_V8, 587 },
    { IMAGE_SAMPLE_CD_V4_V16, 593 },
    { IMAGE_SAMPLE_CD_V4_V2, 589 },
    { IMAGE_SAMPLE_CD_V4_V3, 590 },
    { IMAGE_SAMPLE_CD_V4_V4, 591 },
    { IMAGE_SAMPLE_CD_V4_V8, 592 },
    { IMAGE_SAMPLE_CL_O_V1_V2, 662 },
    { IMAGE_SAMPLE_CL_O_V1_V3, 663 },
    { IMAGE_SAMPLE_CL_O_V1_V4, 664 },
    { IMAGE_SAMPLE_CL_O_V1_V8, 665 },
    { IMAGE_SAMPLE_CL_O_V2_V2, 666 },
    { IMAGE_SAMPLE_CL_O_V2_V3, 667 },
    { IMAGE_SAMPLE_CL_O_V2_V4, 668 },
    { IMAGE_SAMPLE_CL_O_V2_V8, 669 },
    { IMAGE_SAMPLE_CL_O_V3_V2, 670 },
    { IMAGE_SAMPLE_CL_O_V3_V3, 671 },
    { IMAGE_SAMPLE_CL_O_V3_V4, 672 },
    { IMAGE_SAMPLE_CL_O_V3_V8, 673 },
    { IMAGE_SAMPLE_CL_O_V4_V2, 674 },
    { IMAGE_SAMPLE_CL_O_V4_V3, 675 },
    { IMAGE_SAMPLE_CL_O_V4_V4, 676 },
    { IMAGE_SAMPLE_CL_O_V4_V8, 677 },
    { IMAGE_SAMPLE_CL_V1_V1, 646 },
    { IMAGE_SAMPLE_CL_V1_V2, 647 },
    { IMAGE_SAMPLE_CL_V1_V3, 648 },
    { IMAGE_SAMPLE_CL_V1_V4, 649 },
    { IMAGE_SAMPLE_CL_V2_V1, 650 },
    { IMAGE_SAMPLE_CL_V2_V2, 651 },
    { IMAGE_SAMPLE_CL_V2_V3, 652 },
    { IMAGE_SAMPLE_CL_V2_V4, 653 },
    { IMAGE_SAMPLE_CL_V3_V1, 654 },
    { IMAGE_SAMPLE_CL_V3_V2, 655 },
    { IMAGE_SAMPLE_CL_V3_V3, 656 },
    { IMAGE_SAMPLE_CL_V3_V4, 657 },
    { IMAGE_SAMPLE_CL_V4_V1, 658 },
    { IMAGE_SAMPLE_CL_V4_V2, 659 },
    { IMAGE_SAMPLE_CL_V4_V3, 660 },
    { IMAGE_SAMPLE_CL_V4_V4, 661 },
    { IMAGE_SAMPLE_C_B_CL_O_V1_V4, 702 },
    { IMAGE_SAMPLE_C_B_CL_O_V1_V8, 703 },
    { IMAGE_SAMPLE_C_B_CL_O_V2_V4, 704 },
    { IMAGE_SAMPLE_C_B_CL_O_V2_V8, 705 },
    { IMAGE_SAMPLE_C_B_CL_O_V3_V4, 706 },
    { IMAGE_SAMPLE_C_B_CL_O_V3_V8, 707 },
    { IMAGE_SAMPLE_C_B_CL_O_V4_V4, 708 },
    { IMAGE_SAMPLE_C_B_CL_O_V4_V8, 709 },
    { IMAGE_SAMPLE_C_B_CL_V1_V3, 690 },
    { IMAGE_SAMPLE_C_B_CL_V1_V4, 691 },
    { IMAGE_SAMPLE_C_B_CL_V1_V8, 692 },
    { IMAGE_SAMPLE_C_B_CL_V2_V3, 693 },
    { IMAGE_SAMPLE_C_B_CL_V2_V4, 694 },
    { IMAGE_SAMPLE_C_B_CL_V2_V8, 695 },
    { IMAGE_SAMPLE_C_B_CL_V3_V3, 696 },
    { IMAGE_SAMPLE_C_B_CL_V3_V4, 697 },
    { IMAGE_SAMPLE_C_B_CL_V3_V8, 698 },
    { IMAGE_SAMPLE_C_B_CL_V4_V3, 699 },
    { IMAGE_SAMPLE_C_B_CL_V4_V4, 700 },
    { IMAGE_SAMPLE_C_B_CL_V4_V8, 701 },
    { IMAGE_SAMPLE_C_B_O_V1_V4, 710 },
    { IMAGE_SAMPLE_C_B_O_V1_V8, 711 },
    { IMAGE_SAMPLE_C_B_O_V2_V4, 712 },
    { IMAGE_SAMPLE_C_B_O_V2_V8, 713 },
    { IMAGE_SAMPLE_C_B_O_V3_V4, 714 },
    { IMAGE_SAMPLE_C_B_O_V3_V8, 715 },
    { IMAGE_SAMPLE_C_B_O_V4_V4, 716 },
    { IMAGE_SAMPLE_C_B_O_V4_V8, 717 },
    { IMAGE_SAMPLE_C_B_V1_V3, 678 },
    { IMAGE_SAMPLE_C_B_V1_V4, 679 },
    { IMAGE_SAMPLE_C_B_V1_V8, 680 },
    { IMAGE_SAMPLE_C_B_V2_V3, 681 },
    { IMAGE_SAMPLE_C_B_V2_V4, 682 },
    { IMAGE_SAMPLE_C_B_V2_V8, 683 },
    { IMAGE_SAMPLE_C_B_V3_V3, 684 },
    { IMAGE_SAMPLE_C_B_V3_V4, 685 },
    { IMAGE_SAMPLE_C_B_V3_V8, 686 },
    { IMAGE_SAMPLE_C_B_V4_V3, 687 },
    { IMAGE_SAMPLE_C_B_V4_V4, 688 },
    { IMAGE_SAMPLE_C_B_V4_V8, 689 },
    { IMAGE_SAMPLE_C_CD_CL_O_V1_V16, 752 },
    { IMAGE_SAMPLE_C_CD_CL_O_V1_V4, 750 },
    { IMAGE_SAMPLE_C_CD_CL_O_V1_V8, 751 },
    { IMAGE_SAMPLE_C_CD_CL_O_V2_V16, 755 },
    { IMAGE_SAMPLE_C_CD_CL_O_V2_V4, 753 },
    { IMAGE_SAMPLE_C_CD_CL_O_V2_V8, 754 },
    { IMAGE_SAMPLE_C_CD_CL_O_V3_V16, 758 },
    { IMAGE_SAMPLE_C_CD_CL_O_V3_V4, 756 },
    { IMAGE_SAMPLE_C_CD_CL_O_V3_V8, 757 },
    { IMAGE_SAMPLE_C_CD_CL_O_V4_V16, 761 },
    { IMAGE_SAMPLE_C_CD_CL_O_V4_V4, 759 },
    { IMAGE_SAMPLE_C_CD_CL_O_V4_V8, 760 },
    { IMAGE_SAMPLE_C_CD_CL_V1_V16, 737 },
    { IMAGE_SAMPLE_C_CD_CL_V1_V3, 734 },
    { IMAGE_SAMPLE_C_CD_CL_V1_V4, 735 },
    { IMAGE_SAMPLE_C_CD_CL_V1_V8, 736 },
    { IMAGE_SAMPLE_C_CD_CL_V2_V16, 741 },
    { IMAGE_SAMPLE_C_CD_CL_V2_V3, 738 },
    { IMAGE_SAMPLE_C_CD_CL_V2_V4, 739 },
    { IMAGE_SAMPLE_C_CD_CL_V2_V8, 740 },
    { IMAGE_SAMPLE_C_CD_CL_V3_V16, 745 },
    { IMAGE_SAMPLE_C_CD_CL_V3_V3, 742 },
    { IMAGE_SAMPLE_C_CD_CL_V3_V4, 743 },
    { IMAGE_SAMPLE_C_CD_CL_V3_V8, 744 },
    { IMAGE_SAMPLE_C_CD_CL_V4_V16, 749 },
    { IMAGE_SAMPLE_C_CD_CL_V4_V3, 746 },
    { IMAGE_SAMPLE_C_CD_CL_V4_V4, 747 },
    { IMAGE_SAMPLE_C_CD_CL_V4_V8, 748 },
    { IMAGE_SAMPLE_C_CD_O_V1_V16, 764 },
    { IMAGE_SAMPLE_C_CD_O_V1_V4, 762 },
    { IMAGE_SAMPLE_C_CD_O_V1_V8, 763 },
    { IMAGE_SAMPLE_C_CD_O_V2_V16, 767 },
    { IMAGE_SAMPLE_C_CD_O_V2_V4, 765 },
    { IMAGE_SAMPLE_C_CD_O_V2_V8, 766 },
    { IMAGE_SAMPLE_C_CD_O_V3_V16, 770 },
    { IMAGE_SAMPLE_C_CD_O_V3_V4, 768 },
    { IMAGE_SAMPLE_C_CD_O_V3_V8, 769 },
    { IMAGE_SAMPLE_C_CD_O_V4_V16, 773 },
    { IMAGE_SAMPLE_C_CD_O_V4_V4, 771 },
    { IMAGE_SAMPLE_C_CD_O_V4_V8, 772 },
    { IMAGE_SAMPLE_C_CD_V1_V16, 721 },
    { IMAGE_SAMPLE_C_CD_V1_V3, 718 },
    { IMAGE_SAMPLE_C_CD_V1_V4, 719 },
    { IMAGE_SAMPLE_C_CD_V1_V8, 720 },
    { IMAGE_SAMPLE_C_CD_V2_V16, 725 },
    { IMAGE_SAMPLE_C_CD_V2_V3, 722 },
    { IMAGE_SAMPLE_C_CD_V2_V4, 723 },
    { IMAGE_SAMPLE_C_CD_V2_V8, 724 },
    { IMAGE_SAMPLE_C_CD_V3_V16, 729 },
    { IMAGE_SAMPLE_C_CD_V3_V3, 726 },
    { IMAGE_SAMPLE_C_CD_V3_V4, 727 },
    { IMAGE_SAMPLE_C_CD_V3_V8, 728 },
    { IMAGE_SAMPLE_C_CD_V4_V16, 733 },
    { IMAGE_SAMPLE_C_CD_V4_V3, 730 },
    { IMAGE_SAMPLE_C_CD_V4_V4, 731 },
    { IMAGE_SAMPLE_C_CD_V4_V8, 732 },
    { IMAGE_SAMPLE_C_CL_O_V1_V3, 790 },
    { IMAGE_SAMPLE_C_CL_O_V1_V4, 791 },
    { IMAGE_SAMPLE_C_CL_O_V1_V8, 792 },
    { IMAGE_SAMPLE_C_CL_O_V2_V3, 793 },
    { IMAGE_SAMPLE_C_CL_O_V2_V4, 794 },
    { IMAGE_SAMPLE_C_CL_O_V2_V8, 795 },
    { IMAGE_SAMPLE_C_CL_O_V3_V3, 796 },
    { IMAGE_SAMPLE_C_CL_O_V3_V4, 797 },
    { IMAGE_SAMPLE_C_CL_O_V3_V8, 798 },
    { IMAGE_SAMPLE_C_CL_O_V4_V3, 799 },
    { IMAGE_SAMPLE_C_CL_O_V4_V4, 800 },
    { IMAGE_SAMPLE_C_CL_O_V4_V8, 801 },
    { IMAGE_SAMPLE_C_CL_V1_V2, 774 },
    { IMAGE_SAMPLE_C_CL_V1_V3, 775 },
    { IMAGE_SAMPLE_C_CL_V1_V4, 776 },
    { IMAGE_SAMPLE_C_CL_V1_V8, 777 },
    { IMAGE_SAMPLE_C_CL_V2_V2, 778 },
    { IMAGE_SAMPLE_C_CL_V2_V3, 779 },
    { IMAGE_SAMPLE_C_CL_V2_V4, 780 },
    { IMAGE_SAMPLE_C_CL_V2_V8, 781 },
    { IMAGE_SAMPLE_C_CL_V3_V2, 782 },
    { IMAGE_SAMPLE_C_CL_V3_V3, 783 },
    { IMAGE_SAMPLE_C_CL_V3_V4, 784 },
    { IMAGE_SAMPLE_C_CL_V3_V8, 785 },
    { IMAGE_SAMPLE_C_CL_V4_V2, 786 },
    { IMAGE_SAMPLE_C_CL_V4_V3, 787 },
    { IMAGE_SAMPLE_C_CL_V4_V4, 788 },
    { IMAGE_SAMPLE_C_CL_V4_V8, 789 },
    { IMAGE_SAMPLE_C_D_CL_O_V1_V16, 836 },
    { IMAGE_SAMPLE_C_D_CL_O_V1_V4, 834 },
    { IMAGE_SAMPLE_C_D_CL_O_V1_V8, 835 },
    { IMAGE_SAMPLE_C_D_CL_O_V2_V16, 839 },
    { IMAGE_SAMPLE_C_D_CL_O_V2_V4, 837 },
    { IMAGE_SAMPLE_C_D_CL_O_V2_V8, 838 },
    { IMAGE_SAMPLE_C_D_CL_O_V3_V16, 842 },
    { IMAGE_SAMPLE_C_D_CL_O_V3_V4, 840 },
    { IMAGE_SAMPLE_C_D_CL_O_V3_V8, 841 },
    { IMAGE_SAMPLE_C_D_CL_O_V4_V16, 845 },
    { IMAGE_SAMPLE_C_D_CL_O_V4_V4, 843 },
    { IMAGE_SAMPLE_C_D_CL_O_V4_V8, 844 },
    { IMAGE_SAMPLE_C_D_CL_V1_V16, 821 },
    { IMAGE_SAMPLE_C_D_CL_V1_V3, 818 },
    { IMAGE_SAMPLE_C_D_CL_V1_V4, 819 },
    { IMAGE_SAMPLE_C_D_CL_V1_V8, 820 },
    { IMAGE_SAMPLE_C_D_CL_V2_V16, 825 },
    { IMAGE_SAMPLE_C_D_CL_V2_V3, 822 },
    { IMAGE_SAMPLE_C_D_CL_V2_V4, 823 },
    { IMAGE_SAMPLE_C_D_CL_V2_V8, 824 },
    { IMAGE_SAMPLE_C_D_CL_V3_V16, 829 },
    { IMAGE_SAMPLE_C_D_CL_V3_V3, 826 },
    { IMAGE_SAMPLE_C_D_CL_V3_V4, 827 },
    { IMAGE_SAMPLE_C_D_CL_V3_V8, 828 },
    { IMAGE_SAMPLE_C_D_CL_V4_V16, 833 },
    { IMAGE_SAMPLE_C_D_CL_V4_V3, 830 },
    { IMAGE_SAMPLE_C_D_CL_V4_V4, 831 },
    { IMAGE_SAMPLE_C_D_CL_V4_V8, 832 },
    { IMAGE_SAMPLE_C_D_O_V1_V16, 848 },
    { IMAGE_SAMPLE_C_D_O_V1_V4, 846 },
    { IMAGE_SAMPLE_C_D_O_V1_V8, 847 },
    { IMAGE_SAMPLE_C_D_O_V2_V16, 851 },
    { IMAGE_SAMPLE_C_D_O_V2_V4, 849 },
    { IMAGE_SAMPLE_C_D_O_V2_V8, 850 },
    { IMAGE_SAMPLE_C_D_O_V3_V16, 854 },
    { IMAGE_SAMPLE_C_D_O_V3_V4, 852 },
    { IMAGE_SAMPLE_C_D_O_V3_V8, 853 },
    { IMAGE_SAMPLE_C_D_O_V4_V16, 857 },
    { IMAGE_SAMPLE_C_D_O_V4_V4, 855 },
    { IMAGE_SAMPLE_C_D_O_V4_V8, 856 },
    { IMAGE_SAMPLE_C_D_V1_V16, 805 },
    { IMAGE_SAMPLE_C_D_V1_V3, 802 },
    { IMAGE_SAMPLE_C_D_V1_V4, 803 },
    { IMAGE_SAMPLE_C_D_V1_V8, 804 },
    { IMAGE_SAMPLE_C_D_V2_V16, 809 },
    { IMAGE_SAMPLE_C_D_V2_V3, 806 },
    { IMAGE_SAMPLE_C_D_V2_V4, 807 },
    { IMAGE_SAMPLE_C_D_V2_V8, 808 },
    { IMAGE_SAMPLE_C_D_V3_V16, 813 },
    { IMAGE_SAMPLE_C_D_V3_V3, 810 },
    { IMAGE_SAMPLE_C_D_V3_V4, 811 },
    { IMAGE_SAMPLE_C_D_V3_V8, 812 },
    { IMAGE_SAMPLE_C_D_V4_V16, 817 },
    { IMAGE_SAMPLE_C_D_V4_V3, 814 },
    { IMAGE_SAMPLE_C_D_V4_V4, 815 },
    { IMAGE_SAMPLE_C_D_V4_V8, 816 },
    { IMAGE_SAMPLE_C_LZ_O_V1_V3, 886 },
    { IMAGE_SAMPLE_C_LZ_O_V1_V4, 887 },
    { IMAGE_SAMPLE_C_LZ_O_V1_V8, 888 },
    { IMAGE_SAMPLE_C_LZ_O_V2_V3, 889 },
    { IMAGE_SAMPLE_C_LZ_O_V2_V4, 890 },
    { IMAGE_SAMPLE_C_LZ_O_V2_V8, 891 },
    { IMAGE_SAMPLE_C_LZ_O_V3_V3, 892 },
    { IMAGE_SAMPLE_C_LZ_O_V3_V4, 893 },
    { IMAGE_SAMPLE_C_LZ_O_V3_V8, 894 },
    { IMAGE_SAMPLE_C_LZ_O_V4_V3, 895 },
    { IMAGE_SAMPLE_C_LZ_O_V4_V4, 896 },
    { IMAGE_SAMPLE_C_LZ_O_V4_V8, 897 },
    { IMAGE_SAMPLE_C_LZ_V1_V2, 874 },
    { IMAGE_SAMPLE_C_LZ_V1_V3, 875 },
    { IMAGE_SAMPLE_C_LZ_V1_V4, 876 },
    { IMAGE_SAMPLE_C_LZ_V2_V2, 877 },
    { IMAGE_SAMPLE_C_LZ_V2_V3, 878 },
    { IMAGE_SAMPLE_C_LZ_V2_V4, 879 },
    { IMAGE_SAMPLE_C_LZ_V3_V2, 880 },
    { IMAGE_SAMPLE_C_LZ_V3_V3, 881 },
    { IMAGE_SAMPLE_C_LZ_V3_V4, 882 },
    { IMAGE_SAMPLE_C_LZ_V4_V2, 883 },
    { IMAGE_SAMPLE_C_LZ_V4_V3, 884 },
    { IMAGE_SAMPLE_C_LZ_V4_V4, 885 },
    { IMAGE_SAMPLE_C_L_O_V1_V3, 898 },
    { IMAGE_SAMPLE_C_L_O_V1_V4, 899 },
    { IMAGE_SAMPLE_C_L_O_V1_V8, 900 },
    { IMAGE_SAMPLE_C_L_O_V2_V3, 901 },
    { IMAGE_SAMPLE_C_L_O_V2_V4, 902 },
    { IMAGE_SAMPLE_C_L_O_V2_V8, 903 },
    { IMAGE_SAMPLE_C_L_O_V3_V3, 904 },
    { IMAGE_SAMPLE_C_L_O_V3_V4, 905 },
    { IMAGE_SAMPLE_C_L_O_V3_V8, 906 },
    { IMAGE_SAMPLE_C_L_O_V4_V3, 907 },
    { IMAGE_SAMPLE_C_L_O_V4_V4, 908 },
    { IMAGE_SAMPLE_C_L_O_V4_V8, 909 },
    { IMAGE_SAMPLE_C_L_V1_V2, 858 },
    { IMAGE_SAMPLE_C_L_V1_V3, 859 },
    { IMAGE_SAMPLE_C_L_V1_V4, 860 },
    { IMAGE_SAMPLE_C_L_V1_V8, 861 },
    { IMAGE_SAMPLE_C_L_V2_V2, 862 },
    { IMAGE_SAMPLE_C_L_V2_V3, 863 },
    { IMAGE_SAMPLE_C_L_V2_V4, 864 },
    { IMAGE_SAMPLE_C_L_V2_V8, 865 },
    { IMAGE_SAMPLE_C_L_V3_V2, 866 },
    { IMAGE_SAMPLE_C_L_V3_V3, 867 },
    { IMAGE_SAMPLE_C_L_V3_V4, 868 },
    { IMAGE_SAMPLE_C_L_V3_V8, 869 },
    { IMAGE_SAMPLE_C_L_V4_V2, 870 },
    { IMAGE_SAMPLE_C_L_V4_V3, 871 },
    { IMAGE_SAMPLE_C_L_V4_V4, 872 },
    { IMAGE_SAMPLE_C_L_V4_V8, 873 },
    { IMAGE_SAMPLE_C_O_V1_V3, 910 },
    { IMAGE_SAMPLE_C_O_V1_V4, 911 },
    { IMAGE_SAMPLE_C_O_V1_V8, 912 },
    { IMAGE_SAMPLE_C_O_V2_V3, 913 },
    { IMAGE_SAMPLE_C_O_V2_V4, 914 },
    { IMAGE_SAMPLE_C_O_V2_V8, 915 },
    { IMAGE_SAMPLE_C_O_V3_V3, 916 },
    { IMAGE_SAMPLE_C_O_V3_V4, 917 },
    { IMAGE_SAMPLE_C_O_V3_V8, 918 },
    { IMAGE_SAMPLE_C_O_V4_V3, 919 },
    { IMAGE_SAMPLE_C_O_V4_V4, 920 },
    { IMAGE_SAMPLE_C_O_V4_V8, 921 },
    { IMAGE_SAMPLE_C_V1_V2, 562 },
    { IMAGE_SAMPLE_C_V1_V3, 563 },
    { IMAGE_SAMPLE_C_V1_V4, 564 },
    { IMAGE_SAMPLE_C_V2_V2, 565 },
    { IMAGE_SAMPLE_C_V2_V3, 566 },
    { IMAGE_SAMPLE_C_V2_V4, 567 },
    { IMAGE_SAMPLE_C_V3_V2, 568 },
    { IMAGE_SAMPLE_C_V3_V3, 569 },
    { IMAGE_SAMPLE_C_V3_V4, 570 },
    { IMAGE_SAMPLE_C_V4_V2, 571 },
    { IMAGE_SAMPLE_C_V4_V3, 572 },
    { IMAGE_SAMPLE_C_V4_V4, 573 },
    { IMAGE_SAMPLE_D_CL_O_V1_V16, 965 },
    { IMAGE_SAMPLE_D_CL_O_V1_V3, 962 },
    { IMAGE_SAMPLE_D_CL_O_V1_V4, 963 },
    { IMAGE_SAMPLE_D_CL_O_V1_V8, 964 },
    { IMAGE_SAMPLE_D_CL_O_V2_V16, 969 },
    { IMAGE_SAMPLE_D_CL_O_V2_V3, 966 },
    { IMAGE_SAMPLE_D_CL_O_V2_V4, 967 },
    { IMAGE_SAMPLE_D_CL_O_V2_V8, 968 },
    { IMAGE_SAMPLE_D_CL_O_V3_V16, 973 },
    { IMAGE_SAMPLE_D_CL_O_V3_V3, 970 },
    { IMAGE_SAMPLE_D_CL_O_V3_V4, 971 },
    { IMAGE_SAMPLE_D_CL_O_V3_V8, 972 },
    { IMAGE_SAMPLE_D_CL_O_V4_V16, 977 },
    { IMAGE_SAMPLE_D_CL_O_V4_V3, 974 },
    { IMAGE_SAMPLE_D_CL_O_V4_V4, 975 },
    { IMAGE_SAMPLE_D_CL_O_V4_V8, 976 },
    { IMAGE_SAMPLE_D_CL_V1_V16, 946 },
    { IMAGE_SAMPLE_D_CL_V1_V2, 942 },
    { IMAGE_SAMPLE_D_CL_V1_V3, 943 },
    { IMAGE_SAMPLE_D_CL_V1_V4, 944 },
    { IMAGE_SAMPLE_D_CL_V1_V8, 945 },
    { IMAGE_SAMPLE_D_CL_V2_V16, 951 },
    { IMAGE_SAMPLE_D_CL_V2_V2, 947 },
    { IMAGE_SAMPLE_D_CL_V2_V3, 948 },
    { IMAGE_SAMPLE_D_CL_V2_V4, 949 },
    { IMAGE_SAMPLE_D_CL_V2_V8, 950 },
    { IMAGE_SAMPLE_D_CL_V3_V16, 956 },
    { IMAGE_SAMPLE_D_CL_V3_V2, 952 },
    { IMAGE_SAMPLE_D_CL_V3_V3, 953 },
    { IMAGE_SAMPLE_D_CL_V3_V4, 954 },
    { IMAGE_SAMPLE_D_CL_V3_V8, 955 },
    { IMAGE_SAMPLE_D_CL_V4_V16, 961 },
    { IMAGE_SAMPLE_D_CL_V4_V2, 957 },
    { IMAGE_SAMPLE_D_CL_V4_V3, 958 },
    { IMAGE_SAMPLE_D_CL_V4_V4, 959 },
    { IMAGE_SAMPLE_D_CL_V4_V8, 960 },
    { IMAGE_SAMPLE_D_O_V1_V16, 981 },
    { IMAGE_SAMPLE_D_O_V1_V3, 978 },
    { IMAGE_SAMPLE_D_O_V1_V4, 979 },
    { IMAGE_SAMPLE_D_O_V1_V8, 980 },
    { IMAGE_SAMPLE_D_O_V2_V16, 985 },
    { IMAGE_SAMPLE_D_O_V2_V3, 982 },
    { IMAGE_SAMPLE_D_O_V2_V4, 983 },
    { IMAGE_SAMPLE_D_O_V2_V8, 984 },
    { IMAGE_SAMPLE_D_O_V3_V16, 989 },
    { IMAGE_SAMPLE_D_O_V3_V3, 986 },
    { IMAGE_SAMPLE_D_O_V3_V4, 987 },
    { IMAGE_SAMPLE_D_O_V3_V8, 988 },
    { IMAGE_SAMPLE_D_O_V4_V16, 993 },
    { IMAGE_SAMPLE_D_O_V4_V3, 990 },
    { IMAGE_SAMPLE_D_O_V4_V4, 991 },
    { IMAGE_SAMPLE_D_O_V4_V8, 992 },
    { IMAGE_SAMPLE_D_V1_V16, 926 },
    { IMAGE_SAMPLE_D_V1_V2, 922 },
    { IMAGE_SAMPLE_D_V1_V3, 923 },
    { IMAGE_SAMPLE_D_V1_V4, 924 },
    { IMAGE_SAMPLE_D_V1_V8, 925 },
    { IMAGE_SAMPLE_D_V2_V16, 931 },
    { IMAGE_SAMPLE_D_V2_V2, 927 },
    { IMAGE_SAMPLE_D_V2_V3, 928 },
    { IMAGE_SAMPLE_D_V2_V4, 929 },
    { IMAGE_SAMPLE_D_V2_V8, 930 },
    { IMAGE_SAMPLE_D_V3_V16, 936 },
    { IMAGE_SAMPLE_D_V3_V2, 932 },
    { IMAGE_SAMPLE_D_V3_V3, 933 },
    { IMAGE_SAMPLE_D_V3_V4, 934 },
    { IMAGE_SAMPLE_D_V3_V8, 935 },
    { IMAGE_SAMPLE_D_V4_V16, 941 },
    { IMAGE_SAMPLE_D_V4_V2, 937 },
    { IMAGE_SAMPLE_D_V4_V3, 938 },
    { IMAGE_SAMPLE_D_V4_V4, 939 },
    { IMAGE_SAMPLE_D_V4_V8, 940 },
    { IMAGE_SAMPLE_LZ_O_V1_V2, 1026 },
    { IMAGE_SAMPLE_LZ_O_V1_V3, 1027 },
    { IMAGE_SAMPLE_LZ_O_V1_V4, 1028 },
    { IMAGE_SAMPLE_LZ_O_V2_V2, 1029 },
    { IMAGE_SAMPLE_LZ_O_V2_V3, 1030 },
    { IMAGE_SAMPLE_LZ_O_V2_V4, 1031 },
    { IMAGE_SAMPLE_LZ_O_V3_V2, 1032 },
    { IMAGE_SAMPLE_LZ_O_V3_V3, 1033 },
    { IMAGE_SAMPLE_LZ_O_V3_V4, 1034 },
    { IMAGE_SAMPLE_LZ_O_V4_V2, 1035 },
    { IMAGE_SAMPLE_LZ_O_V4_V3, 1036 },
    { IMAGE_SAMPLE_LZ_O_V4_V4, 1037 },
    { IMAGE_SAMPLE_LZ_V1_V1, 1010 },
    { IMAGE_SAMPLE_LZ_V1_V2, 1011 },
    { IMAGE_SAMPLE_LZ_V1_V3, 1012 },
    { IMAGE_SAMPLE_LZ_V1_V4, 1013 },
    { IMAGE_SAMPLE_LZ_V2_V1, 1014 },
    { IMAGE_SAMPLE_LZ_V2_V2, 1015 },
    { IMAGE_SAMPLE_LZ_V2_V3, 1016 },
    { IMAGE_SAMPLE_LZ_V2_V4, 1017 },
    { IMAGE_SAMPLE_LZ_V3_V1, 1018 },
    { IMAGE_SAMPLE_LZ_V3_V2, 1019 },
    { IMAGE_SAMPLE_LZ_V3_V3, 1020 },
    { IMAGE_SAMPLE_LZ_V3_V4, 1021 },
    { IMAGE_SAMPLE_LZ_V4_V1, 1022 },
    { IMAGE_SAMPLE_LZ_V4_V2, 1023 },
    { IMAGE_SAMPLE_LZ_V4_V3, 1024 },
    { IMAGE_SAMPLE_LZ_V4_V4, 1025 },
    { IMAGE_SAMPLE_L_O_V1_V2, 1038 },
    { IMAGE_SAMPLE_L_O_V1_V3, 1039 },
    { IMAGE_SAMPLE_L_O_V1_V4, 1040 },
    { IMAGE_SAMPLE_L_O_V1_V8, 1041 },
    { IMAGE_SAMPLE_L_O_V2_V2, 1042 },
    { IMAGE_SAMPLE_L_O_V2_V3, 1043 },
    { IMAGE_SAMPLE_L_O_V2_V4, 1044 },
    { IMAGE_SAMPLE_L_O_V2_V8, 1045 },
    { IMAGE_SAMPLE_L_O_V3_V2, 1046 },
    { IMAGE_SAMPLE_L_O_V3_V3, 1047 },
    { IMAGE_SAMPLE_L_O_V3_V4, 1048 },
    { IMAGE_SAMPLE_L_O_V3_V8, 1049 },
    { IMAGE_SAMPLE_L_O_V4_V2, 1050 },
    { IMAGE_SAMPLE_L_O_V4_V3, 1051 },
    { IMAGE_SAMPLE_L_O_V4_V4, 1052 },
    { IMAGE_SAMPLE_L_O_V4_V8, 1053 },
    { IMAGE_SAMPLE_L_V1_V1, 994 },
    { IMAGE_SAMPLE_L_V1_V2, 995 },
    { IMAGE_SAMPLE_L_V1_V3, 996 },
    { IMAGE_SAMPLE_L_V1_V4, 997 },
    { IMAGE_SAMPLE_L_V2_V1, 998 },
    { IMAGE_SAMPLE_L_V2_V2, 999 },
    { IMAGE_SAMPLE_L_V2_V3, 1000 },
    { IMAGE_SAMPLE_L_V2_V4, 1001 },
    { IMAGE_SAMPLE_L_V3_V1, 1002 },
    { IMAGE_SAMPLE_L_V3_V2, 1003 },
    { IMAGE_SAMPLE_L_V3_V3, 1004 },
    { IMAGE_SAMPLE_L_V3_V4, 1005 },
    { IMAGE_SAMPLE_L_V4_V1, 1006 },
    { IMAGE_SAMPLE_L_V4_V2, 1007 },
    { IMAGE_SAMPLE_L_V4_V3, 1008 },
    { IMAGE_SAMPLE_L_V4_V4, 1009 },
    { IMAGE_SAMPLE_O_V1_V2, 1054 },
    { IMAGE_SAMPLE_O_V1_V3, 1055 },
    { IMAGE_SAMPLE_O_V1_V4, 1056 },
    { IMAGE_SAMPLE_O_V2_V2, 1057 },
    { IMAGE_SAMPLE_O_V2_V3, 1058 },
    { IMAGE_SAMPLE_O_V2_V4, 1059 },
    { IMAGE_SAMPLE_O_V3_V2, 1060 },
    { IMAGE_SAMPLE_O_V3_V3, 1061 },
    { IMAGE_SAMPLE_O_V3_V4, 1062 },
    { IMAGE_SAMPLE_O_V4_V2, 1063 },
    { IMAGE_SAMPLE_O_V4_V3, 1064 },
    { IMAGE_SAMPLE_O_V4_V4, 1065 },
    { IMAGE_SAMPLE_V1_V1, 494 },
    { IMAGE_SAMPLE_V1_V2, 495 },
    { IMAGE_SAMPLE_V1_V3, 496 },
    { IMAGE_SAMPLE_V1_V4, 497 },
    { IMAGE_SAMPLE_V2_V1, 498 },
    { IMAGE_SAMPLE_V2_V2, 499 },
    { IMAGE_SAMPLE_V2_V3, 500 },
    { IMAGE_SAMPLE_V2_V4, 501 },
    { IMAGE_SAMPLE_V3_V1, 502 },
    { IMAGE_SAMPLE_V3_V2, 503 },
    { IMAGE_SAMPLE_V3_V3, 504 },
    { IMAGE_SAMPLE_V3_V4, 505 },
    { IMAGE_SAMPLE_V4_V1, 506 },
    { IMAGE_SAMPLE_V4_V2, 507 },
    { IMAGE_SAMPLE_V4_V3, 508 },
    { IMAGE_SAMPLE_V4_V4, 509 },
    { IMAGE_STORE_MIP_PCK_V1_V1, 1098 },
    { IMAGE_STORE_MIP_PCK_V1_V2, 1099 },
    { IMAGE_STORE_MIP_PCK_V1_V3, 1100 },
    { IMAGE_STORE_MIP_PCK_V1_V4, 1101 },
    { IMAGE_STORE_MIP_PCK_V2_V1, 1102 },
    { IMAGE_STORE_MIP_PCK_V2_V2, 1103 },
    { IMAGE_STORE_MIP_PCK_V2_V3, 1104 },
    { IMAGE_STORE_MIP_PCK_V2_V4, 1105 },
    { IMAGE_STORE_MIP_PCK_V3_V1, 1106 },
    { IMAGE_STORE_MIP_PCK_V3_V2, 1107 },
    { IMAGE_STORE_MIP_PCK_V3_V3, 1108 },
    { IMAGE_STORE_MIP_PCK_V3_V4, 1109 },
    { IMAGE_STORE_MIP_PCK_V4_V1, 1110 },
    { IMAGE_STORE_MIP_PCK_V4_V2, 1111 },
    { IMAGE_STORE_MIP_PCK_V4_V3, 1112 },
    { IMAGE_STORE_MIP_PCK_V4_V4, 1113 },
    { IMAGE_STORE_MIP_V1_V1, 1082 },
    { IMAGE_STORE_MIP_V1_V2, 1083 },
    { IMAGE_STORE_MIP_V1_V3, 1084 },
    { IMAGE_STORE_MIP_V1_V4, 1085 },
    { IMAGE_STORE_MIP_V2_V1, 1086 },
    { IMAGE_STORE_MIP_V2_V2, 1087 },
    { IMAGE_STORE_MIP_V2_V3, 1088 },
    { IMAGE_STORE_MIP_V2_V4, 1089 },
    { IMAGE_STORE_MIP_V3_V1, 1090 },
    { IMAGE_STORE_MIP_V3_V2, 1091 },
    { IMAGE_STORE_MIP_V3_V3, 1092 },
    { IMAGE_STORE_MIP_V3_V4, 1093 },
    { IMAGE_STORE_MIP_V4_V1, 1094 },
    { IMAGE_STORE_MIP_V4_V2, 1095 },
    { IMAGE_STORE_MIP_V4_V3, 1096 },
    { IMAGE_STORE_MIP_V4_V4, 1097 },
    { IMAGE_STORE_PCK_V1_V1, 1114 },
    { IMAGE_STORE_PCK_V1_V2, 1115 },
    { IMAGE_STORE_PCK_V1_V3, 1116 },
    { IMAGE_STORE_PCK_V1_V4, 1117 },
    { IMAGE_STORE_PCK_V2_V1, 1118 },
    { IMAGE_STORE_PCK_V2_V2, 1119 },
    { IMAGE_STORE_PCK_V2_V3, 1120 },
    { IMAGE_STORE_PCK_V2_V4, 1121 },
    { IMAGE_STORE_PCK_V3_V1, 1122 },
    { IMAGE_STORE_PCK_V3_V2, 1123 },
    { IMAGE_STORE_PCK_V3_V3, 1124 },
    { IMAGE_STORE_PCK_V3_V4, 1125 },
    { IMAGE_STORE_PCK_V4_V1, 1126 },
    { IMAGE_STORE_PCK_V4_V2, 1127 },
    { IMAGE_STORE_PCK_V4_V3, 1128 },
    { IMAGE_STORE_PCK_V4_V4, 1129 },
    { IMAGE_STORE_V1_V1, 1066 },
    { IMAGE_STORE_V1_V2, 1067 },
    { IMAGE_STORE_V1_V3, 1068 },
    { IMAGE_STORE_V1_V4, 1069 },
    { IMAGE_STORE_V2_V1, 1070 },
    { IMAGE_STORE_V2_V2, 1071 },
    { IMAGE_STORE_V2_V3, 1072 },
    { IMAGE_STORE_V2_V4, 1073 },
    { IMAGE_STORE_V3_V1, 1074 },
    { IMAGE_STORE_V3_V2, 1075 },
    { IMAGE_STORE_V3_V3, 1076 },
    { IMAGE_STORE_V3_V4, 1077 },
    { IMAGE_STORE_V4_V1, 1078 },
    { IMAGE_STORE_V4_V2, 1079 },
    { IMAGE_STORE_V4_V3, 1080 },
    { IMAGE_STORE_V4_V4, 1081 },
  };

  struct KeyType {
    unsigned Opcode;
  };
  KeyType Key = { Opcode };
  auto Table = makeArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const IndexType &LHS, const KeyType &RHS) {
      if (LHS.Opcode < RHS.Opcode)
        return true;
      if (LHS.Opcode > RHS.Opcode)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Opcode != Idx->Opcode)
    return nullptr;
  return &MIMGInfoTable[Idx->_index];
}
#endif

#ifdef GET_MIMGLZMappingTable_DECL
const MIMGLZMappingInfo *getMIMGLZMappingInfo(unsigned L);
#endif

#ifdef GET_MIMGLZMappingTable_IMPL
const MIMGLZMappingInfo MIMGLZMappingTable[] = {
  { IMAGE_GATHER4_C_L, IMAGE_GATHER4_C_LZ }, // 0
  { IMAGE_GATHER4_C_L_O, IMAGE_GATHER4_C_LZ_O }, // 1
  { IMAGE_GATHER4_L, IMAGE_GATHER4_LZ }, // 2
  { IMAGE_GATHER4_L_O, IMAGE_GATHER4_LZ_O }, // 3
  { IMAGE_SAMPLE_C_L, IMAGE_SAMPLE_C_LZ }, // 4
  { IMAGE_SAMPLE_C_L_O, IMAGE_SAMPLE_C_LZ_O }, // 5
  { IMAGE_SAMPLE_L, IMAGE_SAMPLE_LZ }, // 6
  { IMAGE_SAMPLE_L_O, IMAGE_SAMPLE_LZ_O }, // 7
 };

const MIMGLZMappingInfo *getMIMGLZMappingInfo(unsigned L) {
  struct KeyType {
    unsigned L;
  };
  KeyType Key = { L };
  auto Table = makeArrayRef(MIMGLZMappingTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const MIMGLZMappingInfo &LHS, const KeyType &RHS) {
      if ((unsigned)LHS.L < (unsigned)RHS.L)
        return true;
      if ((unsigned)LHS.L > (unsigned)RHS.L)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.L != Idx->L)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_RsrcIntrinsics_DECL
const RsrcIntrinsic *lookupRsrcIntrinsic(unsigned Intr);
#endif

#ifdef GET_RsrcIntrinsics_IMPL
const RsrcIntrinsic RsrcIntrinsics[] = {
  { Intrinsic::amdgcn_buffer_atomic_add, 0x1, false }, // 0
  { Intrinsic::amdgcn_buffer_atomic_and, 0x1, false }, // 1
  { Intrinsic::amdgcn_buffer_atomic_cmpswap, 0x2, false }, // 2
  { Intrinsic::amdgcn_buffer_atomic_or, 0x1, false }, // 3
  { Intrinsic::amdgcn_buffer_atomic_smax, 0x1, false }, // 4
  { Intrinsic::amdgcn_buffer_atomic_smin, 0x1, false }, // 5
  { Intrinsic::amdgcn_buffer_atomic_sub, 0x1, false }, // 6
  { Intrinsic::amdgcn_buffer_atomic_swap, 0x1, false }, // 7
  { Intrinsic::amdgcn_buffer_atomic_umax, 0x1, false }, // 8
  { Intrinsic::amdgcn_buffer_atomic_umin, 0x1, false }, // 9
  { Intrinsic::amdgcn_buffer_atomic_xor, 0x1, false }, // 10
  { Intrinsic::amdgcn_buffer_load, 0x0, false }, // 11
  { Intrinsic::amdgcn_buffer_load_format, 0x0, false }, // 12
  { Intrinsic::amdgcn_buffer_store, 0x1, false }, // 13
  { Intrinsic::amdgcn_buffer_store_format, 0x1, false }, // 14
  { Intrinsic::amdgcn_image_atomic_add_1d, 0x2, true }, // 15
  { Intrinsic::amdgcn_image_atomic_add_1darray, 0x3, true }, // 16
  { Intrinsic::amdgcn_image_atomic_add_2d, 0x3, true }, // 17
  { Intrinsic::amdgcn_image_atomic_add_2darray, 0x4, true }, // 18
  { Intrinsic::amdgcn_image_atomic_add_2darraymsaa, 0x5, true }, // 19
  { Intrinsic::amdgcn_image_atomic_add_2dmsaa, 0x4, true }, // 20
  { Intrinsic::amdgcn_image_atomic_add_3d, 0x4, true }, // 21
  { Intrinsic::amdgcn_image_atomic_add_cube, 0x4, true }, // 22
  { Intrinsic::amdgcn_image_atomic_and_1d, 0x2, true }, // 23
  { Intrinsic::amdgcn_image_atomic_and_1darray, 0x3, true }, // 24
  { Intrinsic::amdgcn_image_atomic_and_2d, 0x3, true }, // 25
  { Intrinsic::amdgcn_image_atomic_and_2darray, 0x4, true }, // 26
  { Intrinsic::amdgcn_image_atomic_and_2darraymsaa, 0x5, true }, // 27
  { Intrinsic::amdgcn_image_atomic_and_2dmsaa, 0x4, true }, // 28
  { Intrinsic::amdgcn_image_atomic_and_3d, 0x4, true }, // 29
  { Intrinsic::amdgcn_image_atomic_and_cube, 0x4, true }, // 30
  { Intrinsic::amdgcn_image_atomic_cmpswap_1d, 0x3, true }, // 31
  { Intrinsic::amdgcn_image_atomic_cmpswap_1darray, 0x4, true }, // 32
  { Intrinsic::amdgcn_image_atomic_cmpswap_2d, 0x4, true }, // 33
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darray, 0x5, true }, // 34
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darraymsaa, 0x6, true }, // 35
  { Intrinsic::amdgcn_image_atomic_cmpswap_2dmsaa, 0x5, true }, // 36
  { Intrinsic::amdgcn_image_atomic_cmpswap_3d, 0x5, true }, // 37
  { Intrinsic::amdgcn_image_atomic_cmpswap_cube, 0x5, true }, // 38
  { Intrinsic::amdgcn_image_atomic_dec_1d, 0x2, true }, // 39
  { Intrinsic::amdgcn_image_atomic_dec_1darray, 0x3, true }, // 40
  { Intrinsic::amdgcn_image_atomic_dec_2d, 0x3, true }, // 41
  { Intrinsic::amdgcn_image_atomic_dec_2darray, 0x4, true }, // 42
  { Intrinsic::amdgcn_image_atomic_dec_2darraymsaa, 0x5, true }, // 43
  { Intrinsic::amdgcn_image_atomic_dec_2dmsaa, 0x4, true }, // 44
  { Intrinsic::amdgcn_image_atomic_dec_3d, 0x4, true }, // 45
  { Intrinsic::amdgcn_image_atomic_dec_cube, 0x4, true }, // 46
  { Intrinsic::amdgcn_image_atomic_inc_1d, 0x2, true }, // 47
  { Intrinsic::amdgcn_image_atomic_inc_1darray, 0x3, true }, // 48
  { Intrinsic::amdgcn_image_atomic_inc_2d, 0x3, true }, // 49
  { Intrinsic::amdgcn_image_atomic_inc_2darray, 0x4, true }, // 50
  { Intrinsic::amdgcn_image_atomic_inc_2darraymsaa, 0x5, true }, // 51
  { Intrinsic::amdgcn_image_atomic_inc_2dmsaa, 0x4, true }, // 52
  { Intrinsic::amdgcn_image_atomic_inc_3d, 0x4, true }, // 53
  { Intrinsic::amdgcn_image_atomic_inc_cube, 0x4, true }, // 54
  { Intrinsic::amdgcn_image_atomic_or_1d, 0x2, true }, // 55
  { Intrinsic::amdgcn_image_atomic_or_1darray, 0x3, true }, // 56
  { Intrinsic::amdgcn_image_atomic_or_2d, 0x3, true }, // 57
  { Intrinsic::amdgcn_image_atomic_or_2darray, 0x4, true }, // 58
  { Intrinsic::amdgcn_image_atomic_or_2darraymsaa, 0x5, true }, // 59
  { Intrinsic::amdgcn_image_atomic_or_2dmsaa, 0x4, true }, // 60
  { Intrinsic::amdgcn_image_atomic_or_3d, 0x4, true }, // 61
  { Intrinsic::amdgcn_image_atomic_or_cube, 0x4, true }, // 62
  { Intrinsic::amdgcn_image_atomic_smax_1d, 0x2, true }, // 63
  { Intrinsic::amdgcn_image_atomic_smax_1darray, 0x3, true }, // 64
  { Intrinsic::amdgcn_image_atomic_smax_2d, 0x3, true }, // 65
  { Intrinsic::amdgcn_image_atomic_smax_2darray, 0x4, true }, // 66
  { Intrinsic::amdgcn_image_atomic_smax_2darraymsaa, 0x5, true }, // 67
  { Intrinsic::amdgcn_image_atomic_smax_2dmsaa, 0x4, true }, // 68
  { Intrinsic::amdgcn_image_atomic_smax_3d, 0x4, true }, // 69
  { Intrinsic::amdgcn_image_atomic_smax_cube, 0x4, true }, // 70
  { Intrinsic::amdgcn_image_atomic_smin_1d, 0x2, true }, // 71
  { Intrinsic::amdgcn_image_atomic_smin_1darray, 0x3, true }, // 72
  { Intrinsic::amdgcn_image_atomic_smin_2d, 0x3, true }, // 73
  { Intrinsic::amdgcn_image_atomic_smin_2darray, 0x4, true }, // 74
  { Intrinsic::amdgcn_image_atomic_smin_2darraymsaa, 0x5, true }, // 75
  { Intrinsic::amdgcn_image_atomic_smin_2dmsaa, 0x4, true }, // 76
  { Intrinsic::amdgcn_image_atomic_smin_3d, 0x4, true }, // 77
  { Intrinsic::amdgcn_image_atomic_smin_cube, 0x4, true }, // 78
  { Intrinsic::amdgcn_image_atomic_sub_1d, 0x2, true }, // 79
  { Intrinsic::amdgcn_image_atomic_sub_1darray, 0x3, true }, // 80
  { Intrinsic::amdgcn_image_atomic_sub_2d, 0x3, true }, // 81
  { Intrinsic::amdgcn_image_atomic_sub_2darray, 0x4, true }, // 82
  { Intrinsic::amdgcn_image_atomic_sub_2darraymsaa, 0x5, true }, // 83
  { Intrinsic::amdgcn_image_atomic_sub_2dmsaa, 0x4, true }, // 84
  { Intrinsic::amdgcn_image_atomic_sub_3d, 0x4, true }, // 85
  { Intrinsic::amdgcn_image_atomic_sub_cube, 0x4, true }, // 86
  { Intrinsic::amdgcn_image_atomic_swap_1d, 0x2, true }, // 87
  { Intrinsic::amdgcn_image_atomic_swap_1darray, 0x3, true }, // 88
  { Intrinsic::amdgcn_image_atomic_swap_2d, 0x3, true }, // 89
  { Intrinsic::amdgcn_image_atomic_swap_2darray, 0x4, true }, // 90
  { Intrinsic::amdgcn_image_atomic_swap_2darraymsaa, 0x5, true }, // 91
  { Intrinsic::amdgcn_image_atomic_swap_2dmsaa, 0x4, true }, // 92
  { Intrinsic::amdgcn_image_atomic_swap_3d, 0x4, true }, // 93
  { Intrinsic::amdgcn_image_atomic_swap_cube, 0x4, true }, // 94
  { Intrinsic::amdgcn_image_atomic_umax_1d, 0x2, true }, // 95
  { Intrinsic::amdgcn_image_atomic_umax_1darray, 0x3, true }, // 96
  { Intrinsic::amdgcn_image_atomic_umax_2d, 0x3, true }, // 97
  { Intrinsic::amdgcn_image_atomic_umax_2darray, 0x4, true }, // 98
  { Intrinsic::amdgcn_image_atomic_umax_2darraymsaa, 0x5, true }, // 99
  { Intrinsic::amdgcn_image_atomic_umax_2dmsaa, 0x4, true }, // 100
  { Intrinsic::amdgcn_image_atomic_umax_3d, 0x4, true }, // 101
  { Intrinsic::amdgcn_image_atomic_umax_cube, 0x4, true }, // 102
  { Intrinsic::amdgcn_image_atomic_umin_1d, 0x2, true }, // 103
  { Intrinsic::amdgcn_image_atomic_umin_1darray, 0x3, true }, // 104
  { Intrinsic::amdgcn_image_atomic_umin_2d, 0x3, true }, // 105
  { Intrinsic::amdgcn_image_atomic_umin_2darray, 0x4, true }, // 106
  { Intrinsic::amdgcn_image_atomic_umin_2darraymsaa, 0x5, true }, // 107
  { Intrinsic::amdgcn_image_atomic_umin_2dmsaa, 0x4, true }, // 108
  { Intrinsic::amdgcn_image_atomic_umin_3d, 0x4, true }, // 109
  { Intrinsic::amdgcn_image_atomic_umin_cube, 0x4, true }, // 110
  { Intrinsic::amdgcn_image_atomic_xor_1d, 0x2, true }, // 111
  { Intrinsic::amdgcn_image_atomic_xor_1darray, 0x3, true }, // 112
  { Intrinsic::amdgcn_image_atomic_xor_2d, 0x3, true }, // 113
  { Intrinsic::amdgcn_image_atomic_xor_2darray, 0x4, true }, // 114
  { Intrinsic::amdgcn_image_atomic_xor_2darraymsaa, 0x5, true }, // 115
  { Intrinsic::amdgcn_image_atomic_xor_2dmsaa, 0x4, true }, // 116
  { Intrinsic::amdgcn_image_atomic_xor_3d, 0x4, true }, // 117
  { Intrinsic::amdgcn_image_atomic_xor_cube, 0x4, true }, // 118
  { Intrinsic::amdgcn_image_gather4_2d, 0x3, true }, // 119
  { Intrinsic::amdgcn_image_gather4_2darray, 0x4, true }, // 120
  { Intrinsic::amdgcn_image_gather4_b_2d, 0x4, true }, // 121
  { Intrinsic::amdgcn_image_gather4_b_2darray, 0x5, true }, // 122
  { Intrinsic::amdgcn_image_gather4_b_cl_2d, 0x5, true }, // 123
  { Intrinsic::amdgcn_image_gather4_b_cl_2darray, 0x6, true }, // 124
  { Intrinsic::amdgcn_image_gather4_b_cl_cube, 0x6, true }, // 125
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2d, 0x6, true }, // 126
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2darray, 0x7, true }, // 127
  { Intrinsic::amdgcn_image_gather4_b_cl_o_cube, 0x7, true }, // 128
  { Intrinsic::amdgcn_image_gather4_b_cube, 0x5, true }, // 129
  { Intrinsic::amdgcn_image_gather4_b_o_2d, 0x5, true }, // 130
  { Intrinsic::amdgcn_image_gather4_b_o_2darray, 0x6, true }, // 131
  { Intrinsic::amdgcn_image_gather4_b_o_cube, 0x6, true }, // 132
  { Intrinsic::amdgcn_image_gather4_c_2d, 0x4, true }, // 133
  { Intrinsic::amdgcn_image_gather4_c_2darray, 0x5, true }, // 134
  { Intrinsic::amdgcn_image_gather4_c_b_2d, 0x5, true }, // 135
  { Intrinsic::amdgcn_image_gather4_c_b_2darray, 0x6, true }, // 136
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2d, 0x6, true }, // 137
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2darray, 0x7, true }, // 138
  { Intrinsic::amdgcn_image_gather4_c_b_cl_cube, 0x7, true }, // 139
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2d, 0x7, true }, // 140
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2darray, 0x8, true }, // 141
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_cube, 0x8, true }, // 142
  { Intrinsic::amdgcn_image_gather4_c_b_cube, 0x6, true }, // 143
  { Intrinsic::amdgcn_image_gather4_c_b_o_2d, 0x6, true }, // 144
  { Intrinsic::amdgcn_image_gather4_c_b_o_2darray, 0x7, true }, // 145
  { Intrinsic::amdgcn_image_gather4_c_b_o_cube, 0x7, true }, // 146
  { Intrinsic::amdgcn_image_gather4_c_cl_2d, 0x5, true }, // 147
  { Intrinsic::amdgcn_image_gather4_c_cl_2darray, 0x6, true }, // 148
  { Intrinsic::amdgcn_image_gather4_c_cl_cube, 0x6, true }, // 149
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2d, 0x6, true }, // 150
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2darray, 0x7, true }, // 151
  { Intrinsic::amdgcn_image_gather4_c_cl_o_cube, 0x7, true }, // 152
  { Intrinsic::amdgcn_image_gather4_c_cube, 0x5, true }, // 153
  { Intrinsic::amdgcn_image_gather4_c_l_2d, 0x5, true }, // 154
  { Intrinsic::amdgcn_image_gather4_c_l_2darray, 0x6, true }, // 155
  { Intrinsic::amdgcn_image_gather4_c_l_cube, 0x6, true }, // 156
  { Intrinsic::amdgcn_image_gather4_c_l_o_2d, 0x6, true }, // 157
  { Intrinsic::amdgcn_image_gather4_c_l_o_2darray, 0x7, true }, // 158
  { Intrinsic::amdgcn_image_gather4_c_l_o_cube, 0x7, true }, // 159
  { Intrinsic::amdgcn_image_gather4_c_lz_2d, 0x4, true }, // 160
  { Intrinsic::amdgcn_image_gather4_c_lz_2darray, 0x5, true }, // 161
  { Intrinsic::amdgcn_image_gather4_c_lz_cube, 0x5, true }, // 162
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2d, 0x5, true }, // 163
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2darray, 0x6, true }, // 164
  { Intrinsic::amdgcn_image_gather4_c_lz_o_cube, 0x6, true }, // 165
  { Intrinsic::amdgcn_image_gather4_c_o_2d, 0x5, true }, // 166
  { Intrinsic::amdgcn_image_gather4_c_o_2darray, 0x6, true }, // 167
  { Intrinsic::amdgcn_image_gather4_c_o_cube, 0x6, true }, // 168
  { Intrinsic::amdgcn_image_gather4_cl_2d, 0x4, true }, // 169
  { Intrinsic::amdgcn_image_gather4_cl_2darray, 0x5, true }, // 170
  { Intrinsic::amdgcn_image_gather4_cl_cube, 0x5, true }, // 171
  { Intrinsic::amdgcn_image_gather4_cl_o_2d, 0x5, true }, // 172
  { Intrinsic::amdgcn_image_gather4_cl_o_2darray, 0x6, true }, // 173
  { Intrinsic::amdgcn_image_gather4_cl_o_cube, 0x6, true }, // 174
  { Intrinsic::amdgcn_image_gather4_cube, 0x4, true }, // 175
  { Intrinsic::amdgcn_image_gather4_l_2d, 0x4, true }, // 176
  { Intrinsic::amdgcn_image_gather4_l_2darray, 0x5, true }, // 177
  { Intrinsic::amdgcn_image_gather4_l_cube, 0x5, true }, // 178
  { Intrinsic::amdgcn_image_gather4_l_o_2d, 0x5, true }, // 179
  { Intrinsic::amdgcn_image_gather4_l_o_2darray, 0x6, true }, // 180
  { Intrinsic::amdgcn_image_gather4_l_o_cube, 0x6, true }, // 181
  { Intrinsic::amdgcn_image_gather4_lz_2d, 0x3, true }, // 182
  { Intrinsic::amdgcn_image_gather4_lz_2darray, 0x4, true }, // 183
  { Intrinsic::amdgcn_image_gather4_lz_cube, 0x4, true }, // 184
  { Intrinsic::amdgcn_image_gather4_lz_o_2d, 0x4, true }, // 185
  { Intrinsic::amdgcn_image_gather4_lz_o_2darray, 0x5, true }, // 186
  { Intrinsic::amdgcn_image_gather4_lz_o_cube, 0x5, true }, // 187
  { Intrinsic::amdgcn_image_gather4_o_2d, 0x4, true }, // 188
  { Intrinsic::amdgcn_image_gather4_o_2darray, 0x5, true }, // 189
  { Intrinsic::amdgcn_image_gather4_o_cube, 0x5, true }, // 190
  { Intrinsic::amdgcn_image_getlod_1d, 0x2, true }, // 191
  { Intrinsic::amdgcn_image_getlod_1darray, 0x3, true }, // 192
  { Intrinsic::amdgcn_image_getlod_2d, 0x3, true }, // 193
  { Intrinsic::amdgcn_image_getlod_2darray, 0x4, true }, // 194
  { Intrinsic::amdgcn_image_getlod_3d, 0x4, true }, // 195
  { Intrinsic::amdgcn_image_getlod_cube, 0x4, true }, // 196
  { Intrinsic::amdgcn_image_getresinfo_1d, 0x2, true }, // 197
  { Intrinsic::amdgcn_image_getresinfo_1darray, 0x2, true }, // 198
  { Intrinsic::amdgcn_image_getresinfo_2d, 0x2, true }, // 199
  { Intrinsic::amdgcn_image_getresinfo_2darray, 0x2, true }, // 200
  { Intrinsic::amdgcn_image_getresinfo_2darraymsaa, 0x2, true }, // 201
  { Intrinsic::amdgcn_image_getresinfo_2dmsaa, 0x2, true }, // 202
  { Intrinsic::amdgcn_image_getresinfo_3d, 0x2, true }, // 203
  { Intrinsic::amdgcn_image_getresinfo_cube, 0x2, true }, // 204
  { Intrinsic::amdgcn_image_load_1d, 0x2, true }, // 205
  { Intrinsic::amdgcn_image_load_1darray, 0x3, true }, // 206
  { Intrinsic::amdgcn_image_load_2d, 0x3, true }, // 207
  { Intrinsic::amdgcn_image_load_2darray, 0x4, true }, // 208
  { Intrinsic::amdgcn_image_load_2darraymsaa, 0x5, true }, // 209
  { Intrinsic::amdgcn_image_load_2dmsaa, 0x4, true }, // 210
  { Intrinsic::amdgcn_image_load_3d, 0x4, true }, // 211
  { Intrinsic::amdgcn_image_load_cube, 0x4, true }, // 212
  { Intrinsic::amdgcn_image_load_mip_1d, 0x3, true }, // 213
  { Intrinsic::amdgcn_image_load_mip_1darray, 0x4, true }, // 214
  { Intrinsic::amdgcn_image_load_mip_2d, 0x4, true }, // 215
  { Intrinsic::amdgcn_image_load_mip_2darray, 0x5, true }, // 216
  { Intrinsic::amdgcn_image_load_mip_3d, 0x5, true }, // 217
  { Intrinsic::amdgcn_image_load_mip_cube, 0x5, true }, // 218
  { Intrinsic::amdgcn_image_sample_1d, 0x2, true }, // 219
  { Intrinsic::amdgcn_image_sample_1darray, 0x3, true }, // 220
  { Intrinsic::amdgcn_image_sample_2d, 0x3, true }, // 221
  { Intrinsic::amdgcn_image_sample_2darray, 0x4, true }, // 222
  { Intrinsic::amdgcn_image_sample_3d, 0x4, true }, // 223
  { Intrinsic::amdgcn_image_sample_b_1d, 0x3, true }, // 224
  { Intrinsic::amdgcn_image_sample_b_1darray, 0x4, true }, // 225
  { Intrinsic::amdgcn_image_sample_b_2d, 0x4, true }, // 226
  { Intrinsic::amdgcn_image_sample_b_2darray, 0x5, true }, // 227
  { Intrinsic::amdgcn_image_sample_b_3d, 0x5, true }, // 228
  { Intrinsic::amdgcn_image_sample_b_cl_1d, 0x4, true }, // 229
  { Intrinsic::amdgcn_image_sample_b_cl_1darray, 0x5, true }, // 230
  { Intrinsic::amdgcn_image_sample_b_cl_2d, 0x5, true }, // 231
  { Intrinsic::amdgcn_image_sample_b_cl_2darray, 0x6, true }, // 232
  { Intrinsic::amdgcn_image_sample_b_cl_3d, 0x6, true }, // 233
  { Intrinsic::amdgcn_image_sample_b_cl_cube, 0x6, true }, // 234
  { Intrinsic::amdgcn_image_sample_b_cl_o_1d, 0x5, true }, // 235
  { Intrinsic::amdgcn_image_sample_b_cl_o_1darray, 0x6, true }, // 236
  { Intrinsic::amdgcn_image_sample_b_cl_o_2d, 0x6, true }, // 237
  { Intrinsic::amdgcn_image_sample_b_cl_o_2darray, 0x7, true }, // 238
  { Intrinsic::amdgcn_image_sample_b_cl_o_3d, 0x7, true }, // 239
  { Intrinsic::amdgcn_image_sample_b_cl_o_cube, 0x7, true }, // 240
  { Intrinsic::amdgcn_image_sample_b_cube, 0x5, true }, // 241
  { Intrinsic::amdgcn_image_sample_b_o_1d, 0x4, true }, // 242
  { Intrinsic::amdgcn_image_sample_b_o_1darray, 0x5, true }, // 243
  { Intrinsic::amdgcn_image_sample_b_o_2d, 0x5, true }, // 244
  { Intrinsic::amdgcn_image_sample_b_o_2darray, 0x6, true }, // 245
  { Intrinsic::amdgcn_image_sample_b_o_3d, 0x6, true }, // 246
  { Intrinsic::amdgcn_image_sample_b_o_cube, 0x6, true }, // 247
  { Intrinsic::amdgcn_image_sample_c_1d, 0x3, true }, // 248
  { Intrinsic::amdgcn_image_sample_c_1darray, 0x4, true }, // 249
  { Intrinsic::amdgcn_image_sample_c_2d, 0x4, true }, // 250
  { Intrinsic::amdgcn_image_sample_c_2darray, 0x5, true }, // 251
  { Intrinsic::amdgcn_image_sample_c_3d, 0x5, true }, // 252
  { Intrinsic::amdgcn_image_sample_c_b_1d, 0x4, true }, // 253
  { Intrinsic::amdgcn_image_sample_c_b_1darray, 0x5, true }, // 254
  { Intrinsic::amdgcn_image_sample_c_b_2d, 0x5, true }, // 255
  { Intrinsic::amdgcn_image_sample_c_b_2darray, 0x6, true }, // 256
  { Intrinsic::amdgcn_image_sample_c_b_3d, 0x6, true }, // 257
  { Intrinsic::amdgcn_image_sample_c_b_cl_1d, 0x5, true }, // 258
  { Intrinsic::amdgcn_image_sample_c_b_cl_1darray, 0x6, true }, // 259
  { Intrinsic::amdgcn_image_sample_c_b_cl_2d, 0x6, true }, // 260
  { Intrinsic::amdgcn_image_sample_c_b_cl_2darray, 0x7, true }, // 261
  { Intrinsic::amdgcn_image_sample_c_b_cl_3d, 0x7, true }, // 262
  { Intrinsic::amdgcn_image_sample_c_b_cl_cube, 0x7, true }, // 263
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1d, 0x6, true }, // 264
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1darray, 0x7, true }, // 265
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2d, 0x7, true }, // 266
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2darray, 0x8, true }, // 267
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_3d, 0x8, true }, // 268
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_cube, 0x8, true }, // 269
  { Intrinsic::amdgcn_image_sample_c_b_cube, 0x6, true }, // 270
  { Intrinsic::amdgcn_image_sample_c_b_o_1d, 0x5, true }, // 271
  { Intrinsic::amdgcn_image_sample_c_b_o_1darray, 0x6, true }, // 272
  { Intrinsic::amdgcn_image_sample_c_b_o_2d, 0x6, true }, // 273
  { Intrinsic::amdgcn_image_sample_c_b_o_2darray, 0x7, true }, // 274
  { Intrinsic::amdgcn_image_sample_c_b_o_3d, 0x7, true }, // 275
  { Intrinsic::amdgcn_image_sample_c_b_o_cube, 0x7, true }, // 276
  { Intrinsic::amdgcn_image_sample_c_cd_1d, 0x5, true }, // 277
  { Intrinsic::amdgcn_image_sample_c_cd_1darray, 0x6, true }, // 278
  { Intrinsic::amdgcn_image_sample_c_cd_2d, 0x8, true }, // 279
  { Intrinsic::amdgcn_image_sample_c_cd_2darray, 0x9, true }, // 280
  { Intrinsic::amdgcn_image_sample_c_cd_3d, 0xB, true }, // 281
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1d, 0x6, true }, // 282
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1darray, 0x7, true }, // 283
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2d, 0x9, true }, // 284
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2darray, 0xA, true }, // 285
  { Intrinsic::amdgcn_image_sample_c_cd_cl_3d, 0xC, true }, // 286
  { Intrinsic::amdgcn_image_sample_c_cd_cl_cube, 0xA, true }, // 287
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1d, 0x7, true }, // 288
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1darray, 0x8, true }, // 289
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2d, 0xA, true }, // 290
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2darray, 0xB, true }, // 291
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_3d, 0xD, true }, // 292
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_cube, 0xB, true }, // 293
  { Intrinsic::amdgcn_image_sample_c_cd_cube, 0x9, true }, // 294
  { Intrinsic::amdgcn_image_sample_c_cd_o_1d, 0x6, true }, // 295
  { Intrinsic::amdgcn_image_sample_c_cd_o_1darray, 0x7, true }, // 296
  { Intrinsic::amdgcn_image_sample_c_cd_o_2d, 0x9, true }, // 297
  { Intrinsic::amdgcn_image_sample_c_cd_o_2darray, 0xA, true }, // 298
  { Intrinsic::amdgcn_image_sample_c_cd_o_3d, 0xC, true }, // 299
  { Intrinsic::amdgcn_image_sample_c_cd_o_cube, 0xA, true }, // 300
  { Intrinsic::amdgcn_image_sample_c_cl_1d, 0x4, true }, // 301
  { Intrinsic::amdgcn_image_sample_c_cl_1darray, 0x5, true }, // 302
  { Intrinsic::amdgcn_image_sample_c_cl_2d, 0x5, true }, // 303
  { Intrinsic::amdgcn_image_sample_c_cl_2darray, 0x6, true }, // 304
  { Intrinsic::amdgcn_image_sample_c_cl_3d, 0x6, true }, // 305
  { Intrinsic::amdgcn_image_sample_c_cl_cube, 0x6, true }, // 306
  { Intrinsic::amdgcn_image_sample_c_cl_o_1d, 0x5, true }, // 307
  { Intrinsic::amdgcn_image_sample_c_cl_o_1darray, 0x6, true }, // 308
  { Intrinsic::amdgcn_image_sample_c_cl_o_2d, 0x6, true }, // 309
  { Intrinsic::amdgcn_image_sample_c_cl_o_2darray, 0x7, true }, // 310
  { Intrinsic::amdgcn_image_sample_c_cl_o_3d, 0x7, true }, // 311
  { Intrinsic::amdgcn_image_sample_c_cl_o_cube, 0x7, true }, // 312
  { Intrinsic::amdgcn_image_sample_c_cube, 0x5, true }, // 313
  { Intrinsic::amdgcn_image_sample_c_d_1d, 0x5, true }, // 314
  { Intrinsic::amdgcn_image_sample_c_d_1darray, 0x6, true }, // 315
  { Intrinsic::amdgcn_image_sample_c_d_2d, 0x8, true }, // 316
  { Intrinsic::amdgcn_image_sample_c_d_2darray, 0x9, true }, // 317
  { Intrinsic::amdgcn_image_sample_c_d_3d, 0xB, true }, // 318
  { Intrinsic::amdgcn_image_sample_c_d_cl_1d, 0x6, true }, // 319
  { Intrinsic::amdgcn_image_sample_c_d_cl_1darray, 0x7, true }, // 320
  { Intrinsic::amdgcn_image_sample_c_d_cl_2d, 0x9, true }, // 321
  { Intrinsic::amdgcn_image_sample_c_d_cl_2darray, 0xA, true }, // 322
  { Intrinsic::amdgcn_image_sample_c_d_cl_3d, 0xC, true }, // 323
  { Intrinsic::amdgcn_image_sample_c_d_cl_cube, 0xA, true }, // 324
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1d, 0x7, true }, // 325
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1darray, 0x8, true }, // 326
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2d, 0xA, true }, // 327
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2darray, 0xB, true }, // 328
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_3d, 0xD, true }, // 329
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_cube, 0xB, true }, // 330
  { Intrinsic::amdgcn_image_sample_c_d_cube, 0x9, true }, // 331
  { Intrinsic::amdgcn_image_sample_c_d_o_1d, 0x6, true }, // 332
  { Intrinsic::amdgcn_image_sample_c_d_o_1darray, 0x7, true }, // 333
  { Intrinsic::amdgcn_image_sample_c_d_o_2d, 0x9, true }, // 334
  { Intrinsic::amdgcn_image_sample_c_d_o_2darray, 0xA, true }, // 335
  { Intrinsic::amdgcn_image_sample_c_d_o_3d, 0xC, true }, // 336
  { Intrinsic::amdgcn_image_sample_c_d_o_cube, 0xA, true }, // 337
  { Intrinsic::amdgcn_image_sample_c_l_1d, 0x4, true }, // 338
  { Intrinsic::amdgcn_image_sample_c_l_1darray, 0x5, true }, // 339
  { Intrinsic::amdgcn_image_sample_c_l_2d, 0x5, true }, // 340
  { Intrinsic::amdgcn_image_sample_c_l_2darray, 0x6, true }, // 341
  { Intrinsic::amdgcn_image_sample_c_l_3d, 0x6, true }, // 342
  { Intrinsic::amdgcn_image_sample_c_l_cube, 0x6, true }, // 343
  { Intrinsic::amdgcn_image_sample_c_l_o_1d, 0x5, true }, // 344
  { Intrinsic::amdgcn_image_sample_c_l_o_1darray, 0x6, true }, // 345
  { Intrinsic::amdgcn_image_sample_c_l_o_2d, 0x6, true }, // 346
  { Intrinsic::amdgcn_image_sample_c_l_o_2darray, 0x7, true }, // 347
  { Intrinsic::amdgcn_image_sample_c_l_o_3d, 0x7, true }, // 348
  { Intrinsic::amdgcn_image_sample_c_l_o_cube, 0x7, true }, // 349
  { Intrinsic::amdgcn_image_sample_c_lz_1d, 0x3, true }, // 350
  { Intrinsic::amdgcn_image_sample_c_lz_1darray, 0x4, true }, // 351
  { Intrinsic::amdgcn_image_sample_c_lz_2d, 0x4, true }, // 352
  { Intrinsic::amdgcn_image_sample_c_lz_2darray, 0x5, true }, // 353
  { Intrinsic::amdgcn_image_sample_c_lz_3d, 0x5, true }, // 354
  { Intrinsic::amdgcn_image_sample_c_lz_cube, 0x5, true }, // 355
  { Intrinsic::amdgcn_image_sample_c_lz_o_1d, 0x4, true }, // 356
  { Intrinsic::amdgcn_image_sample_c_lz_o_1darray, 0x5, true }, // 357
  { Intrinsic::amdgcn_image_sample_c_lz_o_2d, 0x5, true }, // 358
  { Intrinsic::amdgcn_image_sample_c_lz_o_2darray, 0x6, true }, // 359
  { Intrinsic::amdgcn_image_sample_c_lz_o_3d, 0x6, true }, // 360
  { Intrinsic::amdgcn_image_sample_c_lz_o_cube, 0x6, true }, // 361
  { Intrinsic::amdgcn_image_sample_c_o_1d, 0x4, true }, // 362
  { Intrinsic::amdgcn_image_sample_c_o_1darray, 0x5, true }, // 363
  { Intrinsic::amdgcn_image_sample_c_o_2d, 0x5, true }, // 364
  { Intrinsic::amdgcn_image_sample_c_o_2darray, 0x6, true }, // 365
  { Intrinsic::amdgcn_image_sample_c_o_3d, 0x6, true }, // 366
  { Intrinsic::amdgcn_image_sample_c_o_cube, 0x6, true }, // 367
  { Intrinsic::amdgcn_image_sample_cd_1d, 0x4, true }, // 368
  { Intrinsic::amdgcn_image_sample_cd_1darray, 0x5, true }, // 369
  { Intrinsic::amdgcn_image_sample_cd_2d, 0x7, true }, // 370
  { Intrinsic::amdgcn_image_sample_cd_2darray, 0x8, true }, // 371
  { Intrinsic::amdgcn_image_sample_cd_3d, 0xA, true }, // 372
  { Intrinsic::amdgcn_image_sample_cd_cl_1d, 0x5, true }, // 373
  { Intrinsic::amdgcn_image_sample_cd_cl_1darray, 0x6, true }, // 374
  { Intrinsic::amdgcn_image_sample_cd_cl_2d, 0x8, true }, // 375
  { Intrinsic::amdgcn_image_sample_cd_cl_2darray, 0x9, true }, // 376
  { Intrinsic::amdgcn_image_sample_cd_cl_3d, 0xB, true }, // 377
  { Intrinsic::amdgcn_image_sample_cd_cl_cube, 0x9, true }, // 378
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1d, 0x6, true }, // 379
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1darray, 0x7, true }, // 380
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2d, 0x9, true }, // 381
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2darray, 0xA, true }, // 382
  { Intrinsic::amdgcn_image_sample_cd_cl_o_3d, 0xC, true }, // 383
  { Intrinsic::amdgcn_image_sample_cd_cl_o_cube, 0xA, true }, // 384
  { Intrinsic::amdgcn_image_sample_cd_cube, 0x8, true }, // 385
  { Intrinsic::amdgcn_image_sample_cd_o_1d, 0x5, true }, // 386
  { Intrinsic::amdgcn_image_sample_cd_o_1darray, 0x6, true }, // 387
  { Intrinsic::amdgcn_image_sample_cd_o_2d, 0x8, true }, // 388
  { Intrinsic::amdgcn_image_sample_cd_o_2darray, 0x9, true }, // 389
  { Intrinsic::amdgcn_image_sample_cd_o_3d, 0xB, true }, // 390
  { Intrinsic::amdgcn_image_sample_cd_o_cube, 0x9, true }, // 391
  { Intrinsic::amdgcn_image_sample_cl_1d, 0x3, true }, // 392
  { Intrinsic::amdgcn_image_sample_cl_1darray, 0x4, true }, // 393
  { Intrinsic::amdgcn_image_sample_cl_2d, 0x4, true }, // 394
  { Intrinsic::amdgcn_image_sample_cl_2darray, 0x5, true }, // 395
  { Intrinsic::amdgcn_image_sample_cl_3d, 0x5, true }, // 396
  { Intrinsic::amdgcn_image_sample_cl_cube, 0x5, true }, // 397
  { Intrinsic::amdgcn_image_sample_cl_o_1d, 0x4, true }, // 398
  { Intrinsic::amdgcn_image_sample_cl_o_1darray, 0x5, true }, // 399
  { Intrinsic::amdgcn_image_sample_cl_o_2d, 0x5, true }, // 400
  { Intrinsic::amdgcn_image_sample_cl_o_2darray, 0x6, true }, // 401
  { Intrinsic::amdgcn_image_sample_cl_o_3d, 0x6, true }, // 402
  { Intrinsic::amdgcn_image_sample_cl_o_cube, 0x6, true }, // 403
  { Intrinsic::amdgcn_image_sample_cube, 0x4, true }, // 404
  { Intrinsic::amdgcn_image_sample_d_1d, 0x4, true }, // 405
  { Intrinsic::amdgcn_image_sample_d_1darray, 0x5, true }, // 406
  { Intrinsic::amdgcn_image_sample_d_2d, 0x7, true }, // 407
  { Intrinsic::amdgcn_image_sample_d_2darray, 0x8, true }, // 408
  { Intrinsic::amdgcn_image_sample_d_3d, 0xA, true }, // 409
  { Intrinsic::amdgcn_image_sample_d_cl_1d, 0x5, true }, // 410
  { Intrinsic::amdgcn_image_sample_d_cl_1darray, 0x6, true }, // 411
  { Intrinsic::amdgcn_image_sample_d_cl_2d, 0x8, true }, // 412
  { Intrinsic::amdgcn_image_sample_d_cl_2darray, 0x9, true }, // 413
  { Intrinsic::amdgcn_image_sample_d_cl_3d, 0xB, true }, // 414
  { Intrinsic::amdgcn_image_sample_d_cl_cube, 0x9, true }, // 415
  { Intrinsic::amdgcn_image_sample_d_cl_o_1d, 0x6, true }, // 416
  { Intrinsic::amdgcn_image_sample_d_cl_o_1darray, 0x7, true }, // 417
  { Intrinsic::amdgcn_image_sample_d_cl_o_2d, 0x9, true }, // 418
  { Intrinsic::amdgcn_image_sample_d_cl_o_2darray, 0xA, true }, // 419
  { Intrinsic::amdgcn_image_sample_d_cl_o_3d, 0xC, true }, // 420
  { Intrinsic::amdgcn_image_sample_d_cl_o_cube, 0xA, true }, // 421
  { Intrinsic::amdgcn_image_sample_d_cube, 0x8, true }, // 422
  { Intrinsic::amdgcn_image_sample_d_o_1d, 0x5, true }, // 423
  { Intrinsic::amdgcn_image_sample_d_o_1darray, 0x6, true }, // 424
  { Intrinsic::amdgcn_image_sample_d_o_2d, 0x8, true }, // 425
  { Intrinsic::amdgcn_image_sample_d_o_2darray, 0x9, true }, // 426
  { Intrinsic::amdgcn_image_sample_d_o_3d, 0xB, true }, // 427
  { Intrinsic::amdgcn_image_sample_d_o_cube, 0x9, true }, // 428
  { Intrinsic::amdgcn_image_sample_l_1d, 0x3, true }, // 429
  { Intrinsic::amdgcn_image_sample_l_1darray, 0x4, true }, // 430
  { Intrinsic::amdgcn_image_sample_l_2d, 0x4, true }, // 431
  { Intrinsic::amdgcn_image_sample_l_2darray, 0x5, true }, // 432
  { Intrinsic::amdgcn_image_sample_l_3d, 0x5, true }, // 433
  { Intrinsic::amdgcn_image_sample_l_cube, 0x5, true }, // 434
  { Intrinsic::amdgcn_image_sample_l_o_1d, 0x4, true }, // 435
  { Intrinsic::amdgcn_image_sample_l_o_1darray, 0x5, true }, // 436
  { Intrinsic::amdgcn_image_sample_l_o_2d, 0x5, true }, // 437
  { Intrinsic::amdgcn_image_sample_l_o_2darray, 0x6, true }, // 438
  { Intrinsic::amdgcn_image_sample_l_o_3d, 0x6, true }, // 439
  { Intrinsic::amdgcn_image_sample_l_o_cube, 0x6, true }, // 440
  { Intrinsic::amdgcn_image_sample_lz_1d, 0x2, true }, // 441
  { Intrinsic::amdgcn_image_sample_lz_1darray, 0x3, true }, // 442
  { Intrinsic::amdgcn_image_sample_lz_2d, 0x3, true }, // 443
  { Intrinsic::amdgcn_image_sample_lz_2darray, 0x4, true }, // 444
  { Intrinsic::amdgcn_image_sample_lz_3d, 0x4, true }, // 445
  { Intrinsic::amdgcn_image_sample_lz_cube, 0x4, true }, // 446
  { Intrinsic::amdgcn_image_sample_lz_o_1d, 0x3, true }, // 447
  { Intrinsic::amdgcn_image_sample_lz_o_1darray, 0x4, true }, // 448
  { Intrinsic::amdgcn_image_sample_lz_o_2d, 0x4, true }, // 449
  { Intrinsic::amdgcn_image_sample_lz_o_2darray, 0x5, true }, // 450
  { Intrinsic::amdgcn_image_sample_lz_o_3d, 0x5, true }, // 451
  { Intrinsic::amdgcn_image_sample_lz_o_cube, 0x5, true }, // 452
  { Intrinsic::amdgcn_image_sample_o_1d, 0x3, true }, // 453
  { Intrinsic::amdgcn_image_sample_o_1darray, 0x4, true }, // 454
  { Intrinsic::amdgcn_image_sample_o_2d, 0x4, true }, // 455
  { Intrinsic::amdgcn_image_sample_o_2darray, 0x5, true }, // 456
  { Intrinsic::amdgcn_image_sample_o_3d, 0x5, true }, // 457
  { Intrinsic::amdgcn_image_sample_o_cube, 0x5, true }, // 458
  { Intrinsic::amdgcn_image_store_1d, 0x3, true }, // 459
  { Intrinsic::amdgcn_image_store_1darray, 0x4, true }, // 460
  { Intrinsic::amdgcn_image_store_2d, 0x4, true }, // 461
  { Intrinsic::amdgcn_image_store_2darray, 0x5, true }, // 462
  { Intrinsic::amdgcn_image_store_2darraymsaa, 0x6, true }, // 463
  { Intrinsic::amdgcn_image_store_2dmsaa, 0x5, true }, // 464
  { Intrinsic::amdgcn_image_store_3d, 0x5, true }, // 465
  { Intrinsic::amdgcn_image_store_cube, 0x5, true }, // 466
  { Intrinsic::amdgcn_image_store_mip_1d, 0x4, true }, // 467
  { Intrinsic::amdgcn_image_store_mip_1darray, 0x5, true }, // 468
  { Intrinsic::amdgcn_image_store_mip_2d, 0x5, true }, // 469
  { Intrinsic::amdgcn_image_store_mip_2darray, 0x6, true }, // 470
  { Intrinsic::amdgcn_image_store_mip_3d, 0x6, true }, // 471
  { Intrinsic::amdgcn_image_store_mip_cube, 0x6, true }, // 472
  { Intrinsic::amdgcn_raw_buffer_atomic_add, 0x1, false }, // 473
  { Intrinsic::amdgcn_raw_buffer_atomic_and, 0x1, false }, // 474
  { Intrinsic::amdgcn_raw_buffer_atomic_cmpswap, 0x2, false }, // 475
  { Intrinsic::amdgcn_raw_buffer_atomic_or, 0x1, false }, // 476
  { Intrinsic::amdgcn_raw_buffer_atomic_smax, 0x1, false }, // 477
  { Intrinsic::amdgcn_raw_buffer_atomic_smin, 0x1, false }, // 478
  { Intrinsic::amdgcn_raw_buffer_atomic_sub, 0x1, false }, // 479
  { Intrinsic::amdgcn_raw_buffer_atomic_swap, 0x1, false }, // 480
  { Intrinsic::amdgcn_raw_buffer_atomic_umax, 0x1, false }, // 481
  { Intrinsic::amdgcn_raw_buffer_atomic_umin, 0x1, false }, // 482
  { Intrinsic::amdgcn_raw_buffer_atomic_xor, 0x1, false }, // 483
  { Intrinsic::amdgcn_raw_buffer_load, 0x0, false }, // 484
  { Intrinsic::amdgcn_raw_buffer_load_format, 0x0, false }, // 485
  { Intrinsic::amdgcn_raw_buffer_store, 0x1, false }, // 486
  { Intrinsic::amdgcn_raw_buffer_store_format, 0x1, false }, // 487
  { Intrinsic::amdgcn_raw_tbuffer_load, 0x0, false }, // 488
  { Intrinsic::amdgcn_raw_tbuffer_store, 0x1, false }, // 489
  { Intrinsic::amdgcn_s_buffer_load, 0x0, false }, // 490
  { Intrinsic::amdgcn_struct_buffer_atomic_add, 0x1, false }, // 491
  { Intrinsic::amdgcn_struct_buffer_atomic_and, 0x1, false }, // 492
  { Intrinsic::amdgcn_struct_buffer_atomic_cmpswap, 0x2, false }, // 493
  { Intrinsic::amdgcn_struct_buffer_atomic_or, 0x1, false }, // 494
  { Intrinsic::amdgcn_struct_buffer_atomic_smax, 0x1, false }, // 495
  { Intrinsic::amdgcn_struct_buffer_atomic_smin, 0x1, false }, // 496
  { Intrinsic::amdgcn_struct_buffer_atomic_sub, 0x1, false }, // 497
  { Intrinsic::amdgcn_struct_buffer_atomic_swap, 0x1, false }, // 498
  { Intrinsic::amdgcn_struct_buffer_atomic_umax, 0x1, false }, // 499
  { Intrinsic::amdgcn_struct_buffer_atomic_umin, 0x1, false }, // 500
  { Intrinsic::amdgcn_struct_buffer_atomic_xor, 0x1, false }, // 501
  { Intrinsic::amdgcn_struct_buffer_load, 0x0, false }, // 502
  { Intrinsic::amdgcn_struct_buffer_load_format, 0x0, false }, // 503
  { Intrinsic::amdgcn_struct_buffer_store, 0x1, false }, // 504
  { Intrinsic::amdgcn_struct_buffer_store_format, 0x1, false }, // 505
  { Intrinsic::amdgcn_struct_tbuffer_load, 0x0, false }, // 506
  { Intrinsic::amdgcn_struct_tbuffer_store, 0x1, false }, // 507
  { Intrinsic::amdgcn_tbuffer_load, 0x0, false }, // 508
  { Intrinsic::amdgcn_tbuffer_store, 0x1, false }, // 509
 };

const RsrcIntrinsic *lookupRsrcIntrinsic(unsigned Intr) {
  struct KeyType {
    unsigned Intr;
  };
  KeyType Key = { Intr };
  auto Table = makeArrayRef(RsrcIntrinsics);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const RsrcIntrinsic &LHS, const KeyType &RHS) {
      if (LHS.Intr < RHS.Intr)
        return true;
      if (LHS.Intr > RHS.Intr)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Intr != Idx->Intr)
    return nullptr;
  return &*Idx;
}
#endif

#ifdef GET_SourcesOfDivergence_DECL
const SourceOfDivergence *lookupSourceOfDivergence(unsigned Intr);
#endif

#ifdef GET_SourcesOfDivergence_IMPL
const SourceOfDivergence SourcesOfDivergence[] = {
  { Intrinsic::amdgcn_atomic_dec }, // 0
  { Intrinsic::amdgcn_atomic_inc }, // 1
  { Intrinsic::amdgcn_buffer_atomic_add }, // 2
  { Intrinsic::amdgcn_buffer_atomic_and }, // 3
  { Intrinsic::amdgcn_buffer_atomic_cmpswap }, // 4
  { Intrinsic::amdgcn_buffer_atomic_or }, // 5
  { Intrinsic::amdgcn_buffer_atomic_smax }, // 6
  { Intrinsic::amdgcn_buffer_atomic_smin }, // 7
  { Intrinsic::amdgcn_buffer_atomic_sub }, // 8
  { Intrinsic::amdgcn_buffer_atomic_swap }, // 9
  { Intrinsic::amdgcn_buffer_atomic_umax }, // 10
  { Intrinsic::amdgcn_buffer_atomic_umin }, // 11
  { Intrinsic::amdgcn_buffer_atomic_xor }, // 12
  { Intrinsic::amdgcn_ds_fadd }, // 13
  { Intrinsic::amdgcn_ds_fmax }, // 14
  { Intrinsic::amdgcn_ds_fmin }, // 15
  { Intrinsic::amdgcn_ds_swizzle }, // 16
  { Intrinsic::amdgcn_image_atomic_add_1d }, // 17
  { Intrinsic::amdgcn_image_atomic_add_1darray }, // 18
  { Intrinsic::amdgcn_image_atomic_add_2d }, // 19
  { Intrinsic::amdgcn_image_atomic_add_2darray }, // 20
  { Intrinsic::amdgcn_image_atomic_add_2darraymsaa }, // 21
  { Intrinsic::amdgcn_image_atomic_add_2dmsaa }, // 22
  { Intrinsic::amdgcn_image_atomic_add_3d }, // 23
  { Intrinsic::amdgcn_image_atomic_add_cube }, // 24
  { Intrinsic::amdgcn_image_atomic_and_1d }, // 25
  { Intrinsic::amdgcn_image_atomic_and_1darray }, // 26
  { Intrinsic::amdgcn_image_atomic_and_2d }, // 27
  { Intrinsic::amdgcn_image_atomic_and_2darray }, // 28
  { Intrinsic::amdgcn_image_atomic_and_2darraymsaa }, // 29
  { Intrinsic::amdgcn_image_atomic_and_2dmsaa }, // 30
  { Intrinsic::amdgcn_image_atomic_and_3d }, // 31
  { Intrinsic::amdgcn_image_atomic_and_cube }, // 32
  { Intrinsic::amdgcn_image_atomic_cmpswap_1d }, // 33
  { Intrinsic::amdgcn_image_atomic_cmpswap_1darray }, // 34
  { Intrinsic::amdgcn_image_atomic_cmpswap_2d }, // 35
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darray }, // 36
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darraymsaa }, // 37
  { Intrinsic::amdgcn_image_atomic_cmpswap_2dmsaa }, // 38
  { Intrinsic::amdgcn_image_atomic_cmpswap_3d }, // 39
  { Intrinsic::amdgcn_image_atomic_cmpswap_cube }, // 40
  { Intrinsic::amdgcn_image_atomic_dec_1d }, // 41
  { Intrinsic::amdgcn_image_atomic_dec_1darray }, // 42
  { Intrinsic::amdgcn_image_atomic_dec_2d }, // 43
  { Intrinsic::amdgcn_image_atomic_dec_2darray }, // 44
  { Intrinsic::amdgcn_image_atomic_dec_2darraymsaa }, // 45
  { Intrinsic::amdgcn_image_atomic_dec_2dmsaa }, // 46
  { Intrinsic::amdgcn_image_atomic_dec_3d }, // 47
  { Intrinsic::amdgcn_image_atomic_dec_cube }, // 48
  { Intrinsic::amdgcn_image_atomic_inc_1d }, // 49
  { Intrinsic::amdgcn_image_atomic_inc_1darray }, // 50
  { Intrinsic::amdgcn_image_atomic_inc_2d }, // 51
  { Intrinsic::amdgcn_image_atomic_inc_2darray }, // 52
  { Intrinsic::amdgcn_image_atomic_inc_2darraymsaa }, // 53
  { Intrinsic::amdgcn_image_atomic_inc_2dmsaa }, // 54
  { Intrinsic::amdgcn_image_atomic_inc_3d }, // 55
  { Intrinsic::amdgcn_image_atomic_inc_cube }, // 56
  { Intrinsic::amdgcn_image_atomic_or_1d }, // 57
  { Intrinsic::amdgcn_image_atomic_or_1darray }, // 58
  { Intrinsic::amdgcn_image_atomic_or_2d }, // 59
  { Intrinsic::amdgcn_image_atomic_or_2darray }, // 60
  { Intrinsic::amdgcn_image_atomic_or_2darraymsaa }, // 61
  { Intrinsic::amdgcn_image_atomic_or_2dmsaa }, // 62
  { Intrinsic::amdgcn_image_atomic_or_3d }, // 63
  { Intrinsic::amdgcn_image_atomic_or_cube }, // 64
  { Intrinsic::amdgcn_image_atomic_smax_1d }, // 65
  { Intrinsic::amdgcn_image_atomic_smax_1darray }, // 66
  { Intrinsic::amdgcn_image_atomic_smax_2d }, // 67
  { Intrinsic::amdgcn_image_atomic_smax_2darray }, // 68
  { Intrinsic::amdgcn_image_atomic_smax_2darraymsaa }, // 69
  { Intrinsic::amdgcn_image_atomic_smax_2dmsaa }, // 70
  { Intrinsic::amdgcn_image_atomic_smax_3d }, // 71
  { Intrinsic::amdgcn_image_atomic_smax_cube }, // 72
  { Intrinsic::amdgcn_image_atomic_smin_1d }, // 73
  { Intrinsic::amdgcn_image_atomic_smin_1darray }, // 74
  { Intrinsic::amdgcn_image_atomic_smin_2d }, // 75
  { Intrinsic::amdgcn_image_atomic_smin_2darray }, // 76
  { Intrinsic::amdgcn_image_atomic_smin_2darraymsaa }, // 77
  { Intrinsic::amdgcn_image_atomic_smin_2dmsaa }, // 78
  { Intrinsic::amdgcn_image_atomic_smin_3d }, // 79
  { Intrinsic::amdgcn_image_atomic_smin_cube }, // 80
  { Intrinsic::amdgcn_image_atomic_sub_1d }, // 81
  { Intrinsic::amdgcn_image_atomic_sub_1darray }, // 82
  { Intrinsic::amdgcn_image_atomic_sub_2d }, // 83
  { Intrinsic::amdgcn_image_atomic_sub_2darray }, // 84
  { Intrinsic::amdgcn_image_atomic_sub_2darraymsaa }, // 85
  { Intrinsic::amdgcn_image_atomic_sub_2dmsaa }, // 86
  { Intrinsic::amdgcn_image_atomic_sub_3d }, // 87
  { Intrinsic::amdgcn_image_atomic_sub_cube }, // 88
  { Intrinsic::amdgcn_image_atomic_swap_1d }, // 89
  { Intrinsic::amdgcn_image_atomic_swap_1darray }, // 90
  { Intrinsic::amdgcn_image_atomic_swap_2d }, // 91
  { Intrinsic::amdgcn_image_atomic_swap_2darray }, // 92
  { Intrinsic::amdgcn_image_atomic_swap_2darraymsaa }, // 93
  { Intrinsic::amdgcn_image_atomic_swap_2dmsaa }, // 94
  { Intrinsic::amdgcn_image_atomic_swap_3d }, // 95
  { Intrinsic::amdgcn_image_atomic_swap_cube }, // 96
  { Intrinsic::amdgcn_image_atomic_umax_1d }, // 97
  { Intrinsic::amdgcn_image_atomic_umax_1darray }, // 98
  { Intrinsic::amdgcn_image_atomic_umax_2d }, // 99
  { Intrinsic::amdgcn_image_atomic_umax_2darray }, // 100
  { Intrinsic::amdgcn_image_atomic_umax_2darraymsaa }, // 101
  { Intrinsic::amdgcn_image_atomic_umax_2dmsaa }, // 102
  { Intrinsic::amdgcn_image_atomic_umax_3d }, // 103
  { Intrinsic::amdgcn_image_atomic_umax_cube }, // 104
  { Intrinsic::amdgcn_image_atomic_umin_1d }, // 105
  { Intrinsic::amdgcn_image_atomic_umin_1darray }, // 106
  { Intrinsic::amdgcn_image_atomic_umin_2d }, // 107
  { Intrinsic::amdgcn_image_atomic_umin_2darray }, // 108
  { Intrinsic::amdgcn_image_atomic_umin_2darraymsaa }, // 109
  { Intrinsic::amdgcn_image_atomic_umin_2dmsaa }, // 110
  { Intrinsic::amdgcn_image_atomic_umin_3d }, // 111
  { Intrinsic::amdgcn_image_atomic_umin_cube }, // 112
  { Intrinsic::amdgcn_image_atomic_xor_1d }, // 113
  { Intrinsic::amdgcn_image_atomic_xor_1darray }, // 114
  { Intrinsic::amdgcn_image_atomic_xor_2d }, // 115
  { Intrinsic::amdgcn_image_atomic_xor_2darray }, // 116
  { Intrinsic::amdgcn_image_atomic_xor_2darraymsaa }, // 117
  { Intrinsic::amdgcn_image_atomic_xor_2dmsaa }, // 118
  { Intrinsic::amdgcn_image_atomic_xor_3d }, // 119
  { Intrinsic::amdgcn_image_atomic_xor_cube }, // 120
  { Intrinsic::amdgcn_interp_mov }, // 121
  { Intrinsic::amdgcn_interp_p1 }, // 122
  { Intrinsic::amdgcn_interp_p2 }, // 123
  { Intrinsic::amdgcn_mbcnt_hi }, // 124
  { Intrinsic::amdgcn_mbcnt_lo }, // 125
  { Intrinsic::amdgcn_ps_live }, // 126
  { Intrinsic::amdgcn_workitem_id_x }, // 127
  { Intrinsic::amdgcn_workitem_id_y }, // 128
  { Intrinsic::amdgcn_workitem_id_z }, // 129
  { Intrinsic::r600_read_tidig_x }, // 130
  { Intrinsic::r600_read_tidig_y }, // 131
  { Intrinsic::r600_read_tidig_z }, // 132
 };

const SourceOfDivergence *lookupSourceOfDivergence(unsigned Intr) {
  struct KeyType {
    unsigned Intr;
  };
  KeyType Key = { Intr };
  auto Table = makeArrayRef(SourcesOfDivergence);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key,
    [](const SourceOfDivergence &LHS, const KeyType &RHS) {
      if (LHS.Intr < RHS.Intr)
        return true;
      if (LHS.Intr > RHS.Intr)
        return false;
      return false;
    });

  if (Idx == Table.end() ||
      Key.Intr != Idx->Intr)
    return nullptr;
  return &*Idx;
}
#endif

#undef GET_ImageDimIntrinsicTable_DECL
#undef GET_ImageDimIntrinsicTable_IMPL
#undef GET_MIMGBaseOpcode_DECL
#undef GET_MIMGBaseOpcodesTable_DECL
#undef GET_MIMGBaseOpcodesTable_IMPL
#undef GET_MIMGDimInfoTable_DECL
#undef GET_MIMGDimInfoTable_IMPL
#undef GET_MIMGDim_DECL
#undef GET_MIMGEncoding_DECL
#undef GET_MIMGInfoTable_DECL
#undef GET_MIMGInfoTable_IMPL
#undef GET_MIMGLZMappingTable_DECL
#undef GET_MIMGLZMappingTable_IMPL
#undef GET_RsrcIntrinsics_DECL
#undef GET_RsrcIntrinsics_IMPL
#undef GET_SourcesOfDivergence_DECL
#undef GET_SourcesOfDivergence_IMPL
