/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.doctest.PyDocstringFile;
import com.jetbrains.python.formatter.PyBlock;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.pyi.PyiFile;
import com.jetbrains.python.pyi.PyiUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddImportHelper {
    private static final Logger LOG = Logger.getInstance(AddImportHelper.class);
    private static final Comparator<PyImportStatementBase> IMPORT_TYPE_COMPARATOR = (import1, import2) -> {
        int firstIsFromImport = import1 instanceof PyFromImportStatement ? 1 : 0;
        int secondIsFromImport = import2 instanceof PyFromImportStatement ? 1 : 0;
        return firstIsFromImport - secondIsFromImport;
    };
    private static final ImportPriority UNRESOLVED_SYMBOL_PRIORITY = ImportPriority.THIRD_PARTY;

    @NotNull
    private static Comparator<PyImportStatementBase> getImportNamesComparator(@NotNull PyCodeStyleSettings settings) {
        if (settings == null) {
            AddImportHelper.$$$reportNull$$$0(0);
        }
        Comparator comparator = (import1, import2) -> {
            Comparator stringComparator = settings.OPTIMIZE_IMPORTS_CASE_INSENSITIVE_ORDER ? String.CASE_INSENSITIVE_ORDER : Comparator.naturalOrder();
            return ContainerUtil.compareLexicographically(AddImportHelper.getSortNames(import1), AddImportHelper.getSortNames(import2), Comparator.nullsFirst(stringComparator));
        };
        if (comparator == null) {
            AddImportHelper.$$$reportNull$$$0(1);
        }
        return comparator;
    }

    @NotNull
    private static List<String> getSortNames(@NotNull PyImportStatementBase importStatement) {
        if (importStatement == null) {
            AddImportHelper.$$$reportNull$$$0(2);
        }
        ArrayList<String> result = new ArrayList<String>();
        PyFromImportStatement fromImport = PyUtil.as(importStatement, PyFromImportStatement.class);
        if (fromImport != null) {
            result.add(StringUtil.repeatSymbol((char)'.', (int)fromImport.getRelativeLevel()));
            QualifiedName source = fromImport.getImportSourceQName();
            result.add(Objects.toString(source, ""));
            if (fromImport.isStarImport()) {
                result.add("*");
            }
        } else {
            result.add("");
        }
        for (PyImportElement importElement : importStatement.getImportElements()) {
            QualifiedName qualifiedName = importElement.getImportedQName();
            result.add(Objects.toString(qualifiedName, ""));
            result.add(StringUtil.notNullize((String)importElement.getAsName()));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            AddImportHelper.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    public static Comparator<PyImportStatementBase> getSameGroupImportsComparator(@NotNull PsiFile settingsAnchor) {
        if (settingsAnchor == null) {
            AddImportHelper.$$$reportNull$$$0(4);
        }
        PyCodeStyleSettings settings = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)settingsAnchor, PyCodeStyleSettings.class);
        if (settings.OPTIMIZE_IMPORTS_SORT_BY_TYPE_FIRST) {
            Comparator<PyImportStatementBase> comparator = IMPORT_TYPE_COMPARATOR.thenComparing(AddImportHelper.getImportNamesComparator(settings));
            if (comparator == null) {
                AddImportHelper.$$$reportNull$$$0(5);
            }
            return comparator;
        }
        Comparator<PyImportStatementBase> comparator = AddImportHelper.getImportNamesComparator(settings).thenComparing(IMPORT_TYPE_COMPARATOR);
        if (comparator == null) {
            AddImportHelper.$$$reportNull$$$0(6);
        }
        return comparator;
    }

    private AddImportHelper() {
    }

    public static void addLocalImportStatement(@NotNull PsiElement element, @NotNull String name) {
        if (element == null) {
            AddImportHelper.$$$reportNull$$$0(7);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(8);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(element.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(element);
        PsiElement anchor = AddImportHelper.getLocalInsertPosition(element);
        PsiElement parentElement = PyUtil.sure(anchor).getParent();
        if (parentElement != null) {
            parentElement.addBefore((PsiElement)generator.createImportStatement(languageLevel, name, null), anchor);
        }
    }

    public static void addLocalFromImportStatement(@NotNull PsiElement element, @NotNull String qualifier, @NotNull String name) {
        if (element == null) {
            AddImportHelper.$$$reportNull$$$0(9);
        }
        if (qualifier == null) {
            AddImportHelper.$$$reportNull$$$0(10);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(11);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(element.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(element);
        PsiElement anchor = AddImportHelper.getLocalInsertPosition(element);
        PsiElement parentElement = PyUtil.sure(anchor).getParent();
        if (parentElement != null) {
            parentElement.addBefore((PsiElement)generator.createFromImportStatement(languageLevel, qualifier, name, null), anchor);
        }
    }

    @Nullable
    public static PsiElement getLocalInsertPosition(@NotNull PsiElement anchor) {
        if (anchor == null) {
            AddImportHelper.$$$reportNull$$$0(12);
        }
        return PsiTreeUtil.getParentOfType((PsiElement)anchor, PyStatement.class, (boolean)false);
    }

    @Nullable
    public static PsiElement getFileInsertPosition(PsiFile file) {
        return AddImportHelper.getInsertPosition((PsiElement)file, null, null);
    }

    @Nullable
    private static PsiElement getInsertPosition(@NotNull PsiElement insertParent, @Nullable PyImportStatementBase newImport, @Nullable ImportPriority priority) {
        ImportPriority priorityBelow;
        PsiElement feeler;
        if (insertParent == null) {
            AddImportHelper.$$$reportNull$$$0(13);
        }
        if ((feeler = insertParent.getFirstChild()) == null) {
            return null;
        }
        boolean skippedOverImports = false;
        boolean skippedOverDoc = false;
        PsiElement seeker = feeler;
        boolean isInjected = InjectedLanguageManager.getInstance((Project)feeler.getProject()).isInjectedFragment(feeler.getContainingFile());
        PyImportStatementBase importAbove = null;
        PyImportStatementBase importBelow = null;
        do {
            PyStringLiteralExpression docElem;
            if (feeler instanceof PyImportStatementBase && !isInjected) {
                PyImportStatementBase existingImport = (PyImportStatementBase)feeler;
                if (priority != null && newImport != null) {
                    if (AddImportHelper.shouldInsertBefore(newImport, existingImport, priority)) {
                        importBelow = existingImport;
                        break;
                    }
                    importAbove = existingImport;
                }
                seeker = feeler;
                feeler = feeler.getNextSibling();
                skippedOverImports = true;
                continue;
            }
            if (PsiTreeUtil.instanceOf((Object)feeler, (Class[])new Class[]{PsiWhiteSpace.class, PsiComment.class})) {
                seeker = feeler;
                feeler = feeler.getNextSibling();
                continue;
            }
            if (skippedOverImports || skippedOverDoc || !(insertParent instanceof PyFile) || (docElem = DocStringUtil.findDocStringExpression((PyElement)insertParent)) == null || docElem.getParent() != feeler) break;
            seeker = feeler = feeler.getNextSibling();
            skippedOverDoc = true;
        } while (feeler != null);
        ImportPriority priorityAbove = importAbove != null ? AddImportHelper.getImportPriority(importAbove) : null;
        ImportPriority importPriority = priorityBelow = importBelow != null ? AddImportHelper.getImportPriority(importBelow) : null;
        if (newImport != null && (priorityAbove == null || priorityAbove.compareTo(priority) < 0)) {
            newImport.putCopyableUserData(PyBlock.IMPORT_GROUP_BEGIN, true);
        }
        if (priorityBelow != null) {
            if (priorityBelow.compareTo(priority) > 0) {
                importBelow.putCopyableUserData(PyBlock.IMPORT_GROUP_BEGIN, true);
            } else if (priorityBelow == priority) {
                importBelow.putCopyableUserData(PyBlock.IMPORT_GROUP_BEGIN, null);
            }
        }
        return seeker;
    }

    private static boolean shouldInsertBefore(@Nullable PyImportStatementBase newImport, @NotNull PyImportStatementBase existingImport, @NotNull ImportPriority priority) {
        ImportPriority existingImportPriority;
        int byPriority;
        if (existingImport == null) {
            AddImportHelper.$$$reportNull$$$0(14);
        }
        if (priority == null) {
            AddImportHelper.$$$reportNull$$$0(15);
        }
        if ((byPriority = priority.compareTo(existingImportPriority = AddImportHelper.getImportPriority(existingImport))) != 0) {
            return byPriority < 0;
        }
        if (newImport == null) {
            return false;
        }
        return AddImportHelper.getSameGroupImportsComparator(existingImport.getContainingFile()).compare(newImport, existingImport) < 0;
    }

    @NotNull
    public static ImportPriority getImportPriority(@NotNull PsiElement importLocation, @NotNull PsiFileSystemItem toImport) {
        if (importLocation == null) {
            AddImportHelper.$$$reportNull$$$0(16);
        }
        if (toImport == null) {
            AddImportHelper.$$$reportNull$$$0(17);
        }
        ImportPriorityChoice choice = AddImportHelper.getImportPriorityWithReason(importLocation, toImport);
        LOG.debug(String.format("Import group for %s at %s is %s: %s", new Object[]{toImport, importLocation.getContainingFile(), choice.myPriority, choice.myDescription}));
        ImportPriority importPriority = choice.myPriority;
        if (importPriority == null) {
            AddImportHelper.$$$reportNull$$$0(18);
        }
        return importPriority;
    }

    @NotNull
    public static ImportPriority getImportPriority(@NotNull PyImportStatementBase importStatement) {
        if (importStatement == null) {
            AddImportHelper.$$$reportNull$$$0(19);
        }
        ImportPriorityChoice choice = AddImportHelper.getImportPriorityWithReason(importStatement);
        LOG.debug(String.format("Import group for '%s' is %s: %s", new Object[]{importStatement.getText(), choice.myPriority, choice.myDescription}));
        ImportPriority importPriority = choice.myPriority;
        if (importPriority == null) {
            AddImportHelper.$$$reportNull$$$0(20);
        }
        return importPriority;
    }

    @NotNull
    static ImportPriorityChoice getImportPriorityWithReason(@NotNull PyImportStatementBase importStatement) {
        PsiElement resolved;
        PyElement resolveAnchor;
        if (importStatement == null) {
            AddImportHelper.$$$reportNull$$$0(21);
        }
        if (importStatement instanceof PyFromImportStatement) {
            PyFromImportStatement fromImportStatement = (PyFromImportStatement)importStatement;
            if (fromImportStatement.isFromFuture()) {
                ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.FUTURE, "import from __future__");
                if (importPriorityChoice == null) {
                    AddImportHelper.$$$reportNull$$$0(22);
                }
                return importPriorityChoice;
            }
            if (fromImportStatement.getRelativeLevel() > 0) {
                ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.PROJECT, "explicit relative import");
                if (importPriorityChoice == null) {
                    AddImportHelper.$$$reportNull$$$0(23);
                }
                return importPriorityChoice;
            }
            resolveAnchor = ((PyFromImportStatement)importStatement).getImportSource();
            resolved = fromImportStatement.resolveImportSource();
        } else {
            PyImportElement firstImportElement = (PyImportElement)ArrayUtil.getFirstElement((Object[])importStatement.getImportElements());
            if (firstImportElement == null) {
                ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(UNRESOLVED_SYMBOL_PRIORITY, "incomplete import statement");
                if (importPriorityChoice == null) {
                    AddImportHelper.$$$reportNull$$$0(24);
                }
                return importPriorityChoice;
            }
            resolveAnchor = firstImportElement;
            resolved = firstImportElement.resolve();
        }
        if (resolved == null) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(UNRESOLVED_SYMBOL_PRIORITY, resolveAnchor == null ? "incomplete import statement" : resolveAnchor.getText() + " is unresolved");
            if (importPriorityChoice == null) {
                AddImportHelper.$$$reportNull$$$0(25);
            }
            return importPriorityChoice;
        }
        Object resolvedFileOrDir = resolved instanceof PsiDirectory ? (PsiFileSystemItem)resolved : (resolved instanceof PsiDirectoryContainer ? (PsiFileSystemItem)ArrayUtil.getFirstElement((Object[])((PsiDirectoryContainer)resolved).getDirectories()) : resolved.getContainingFile());
        if (resolvedFileOrDir instanceof PyiFile) {
            resolvedFileOrDir = PyUtil.as(PyiUtil.getOriginalElement((PyiFile)resolvedFileOrDir), PsiFileSystemItem.class);
        }
        if (resolvedFileOrDir == null) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(UNRESOLVED_SYMBOL_PRIORITY, resolved + " is not a file or directory");
            if (importPriorityChoice == null) {
                AddImportHelper.$$$reportNull$$$0(26);
            }
            return importPriorityChoice;
        }
        ImportPriorityChoice importPriorityChoice = AddImportHelper.getImportPriorityWithReason((PsiElement)importStatement, resolvedFileOrDir);
        if (importPriorityChoice == null) {
            AddImportHelper.$$$reportNull$$$0(27);
        }
        return importPriorityChoice;
    }

    @NotNull
    static ImportPriorityChoice getImportPriorityWithReason(@NotNull PsiElement importLocation, @NotNull PsiFileSystemItem toImport) {
        Sdk pythonSdk2;
        VirtualFile vFile;
        if (importLocation == null) {
            AddImportHelper.$$$reportNull$$$0(28);
        }
        if (toImport == null) {
            AddImportHelper.$$$reportNull$$$0(29);
        }
        if ((vFile = toImport.getVirtualFile()) == null) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(UNRESOLVED_SYMBOL_PRIORITY, toImport + " doesn't have an associated virtual file");
            if (importPriorityChoice == null) {
                AddImportHelper.$$$reportNull$$$0(30);
            }
            return importPriorityChoice;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)toImport.getProject());
        ProjectFileIndex fileIndex = projectRootManager.getFileIndex();
        if (fileIndex.isInContent(vFile) && !fileIndex.isInLibraryClasses(vFile)) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.PROJECT, vFile + " belongs to the project and not under interpreter paths");
            if (importPriorityChoice == null) {
                AddImportHelper.$$$reportNull$$$0(31);
            }
            return importPriorityChoice;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)importLocation);
        Sdk sdk = pythonSdk2 = module2 != null ? PythonSdkType.findPythonSdk(module2) : projectRootManager.getProjectSdk();
        if (PythonSdkType.isStdLib(vFile, pythonSdk2)) {
            ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.BUILTIN, vFile + " is either in lib but not under site-packages, or belongs to the root of skeletons, or is a .pyi stub definition for stdlib module");
            if (importPriorityChoice == null) {
                AddImportHelper.$$$reportNull$$$0(32);
            }
            return importPriorityChoice;
        }
        ImportPriorityChoice importPriorityChoice = new ImportPriorityChoice(ImportPriority.THIRD_PARTY, pythonSdk2 == null ? "SDK for " + vFile + " isn't found" : "Fall back value for " + vFile);
        if (importPriorityChoice == null) {
            AddImportHelper.$$$reportNull$$$0(33);
        }
        return importPriorityChoice;
    }

    public static boolean addImportStatement(@NotNull PsiFile file, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(34);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(35);
        }
        if (!(file instanceof PyFile)) {
            return false;
        }
        List<PyImportElement> existingImports = ((PyFile)file).getImportTargets();
        for (PyImportElement existingImport : existingImports) {
            String existingName = Objects.toString(existingImport.getImportedQName(), "");
            if (!name.equals(existingName) || !Comparing.equal((String)asName, (String)existingImport.getAsName())) continue;
            return false;
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(file.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        PyImportStatement importNodeToInsert = generator.createImportStatement(languageLevel, name, asName);
        PyImportStatementBase importStatement = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyImportStatementBase.class, (boolean)false);
        PsiFile insertParent = importStatement != null && importStatement.getContainingFile() == file ? importStatement.getParent() : file;
        try {
            if (anchor instanceof PyImportStatementBase) {
                insertParent.addAfter((PsiElement)importNodeToInsert, anchor);
            } else {
                insertParent.addBefore((PsiElement)importNodeToInsert, AddImportHelper.getInsertPosition((PsiElement)insertParent, importNodeToInsert, priority));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return true;
    }

    public static void addFromImportStatement(@NotNull PsiFile file, @NotNull String from, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(36);
        }
        if (from == null) {
            AddImportHelper.$$$reportNull$$$0(37);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(38);
        }
        PyElementGenerator generator = PyElementGenerator.getInstance(file.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement((PsiElement)file);
        PyFromImportStatement newImport = generator.createFromImportStatement(languageLevel, from, name, asName);
        AddImportHelper.addFromImportStatement(file, newImport, priority, anchor);
    }

    public static void addFromImportStatement(@NotNull PsiFile file, @NotNull PyFromImportStatement newImport, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(39);
        }
        if (newImport == null) {
            AddImportHelper.$$$reportNull$$$0(40);
        }
        try {
            boolean insideDoctest;
            PyImportStatementBase parentImport = (PyImportStatementBase)PsiTreeUtil.getParentOfType((PsiElement)anchor, PyImportStatementBase.class, (boolean)false);
            InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)file.getProject());
            PsiLanguageInjectionHost injectionHost = manager.getInjectionHost((PsiElement)file);
            boolean bl = insideDoctest = file instanceof PyDocstringFile && injectionHost != null && DocStringUtil.getParentDefinitionDocString((PsiElement)injectionHost) == injectionHost;
            Object insertParent = parentImport != null && parentImport.getContainingFile() == file ? parentImport.getParent() : (injectionHost != null && !insideDoctest ? manager.getTopLevelFile((PsiElement)file) : file);
            if (insideDoctest) {
                PsiElement element = insertParent.addBefore((PsiElement)newImport, AddImportHelper.getInsertPosition((PsiElement)insertParent, newImport, priority));
                PsiElement whitespace = element.getNextSibling();
                if (!(whitespace instanceof PsiWhiteSpace)) {
                    whitespace = PsiParserFacade.SERVICE.getInstance((Project)file.getProject()).createWhiteSpaceFromText("  >>> ");
                }
                insertParent.addBefore(whitespace, element);
            } else if (anchor instanceof PyImportStatementBase) {
                insertParent.addAfter((PsiElement)newImport, anchor);
            } else {
                insertParent.addBefore((PsiElement)newImport, AddImportHelper.getInsertPosition((PsiElement)insertParent, newImport, priority));
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    public static boolean addOrUpdateFromImportStatement(@NotNull PsiFile file, @NotNull String from, @NotNull String name, @Nullable String asName, @Nullable ImportPriority priority, @Nullable PsiElement anchor) {
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(41);
        }
        if (from == null) {
            AddImportHelper.$$$reportNull$$$0(42);
        }
        if (name == null) {
            AddImportHelper.$$$reportNull$$$0(43);
        }
        List<PyFromImportStatement> existingImports = ((PyFile)file).getFromImports();
        PyCodeStyleSettings pySettings = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PyCodeStyleSettings.class);
        if (!pySettings.OPTIMIZE_IMPORTS_ALWAYS_SPLIT_FROM_IMPORTS) {
            for (PyFromImportStatement existingImport : existingImports) {
                String existingSource;
                if (existingImport.isStarImport() || !from.equals(existingSource = Objects.toString(existingImport.getImportSourceQName(), "")) || existingImport.getRelativeLevel() != 0) continue;
                for (PyImportElement el : existingImport.getImportElements()) {
                    String existingName = Objects.toString(el.getImportedQName(), "");
                    if (!name.equals(existingName) || !Comparing.equal((String)asName, (String)el.getAsName())) continue;
                    return false;
                }
                PyElementGenerator generator = PyElementGenerator.getInstance(file.getProject());
                PyImportElement importElement = generator.createImportElement(LanguageLevel.forElement((PsiElement)file), name, asName);
                existingImport.add((PsiElement)importElement);
                CodeStyleManager.getInstance((Project)file.getProject()).reformat((PsiElement)existingImport);
                return true;
            }
        }
        AddImportHelper.addFromImportStatement(file, from, name, asName, priority, anchor);
        return true;
    }

    public static void addImport(@NotNull PsiNamedElement target, @NotNull PsiFile file, @NotNull PyElement element) {
        if (target == null) {
            AddImportHelper.$$$reportNull$$$0(44);
        }
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(45);
        }
        if (element == null) {
            AddImportHelper.$$$reportNull$$$0(46);
        }
        if (target instanceof PsiFileSystemItem) {
            AddImportHelper.addFileSystemItemImport((PsiFileSystemItem)target, file, element);
            return;
        }
        String name = target.getName();
        if (name == null) {
            return;
        }
        PsiFile toImport = target.getContainingFile();
        if (toImport == null) {
            return;
        }
        QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)target, (PsiElement)element);
        if (importPath == null) {
            return;
        }
        String path = importPath.toString();
        ImportPriority priority = AddImportHelper.getImportPriority((PsiElement)file, (PsiFileSystemItem)toImport);
        if (!PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT) {
            AddImportHelper.addImportStatement(file, path, null, priority, (PsiElement)element);
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(file.getProject());
            element.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)target), path + "." + name));
        } else {
            AddImportHelper.addOrUpdateFromImportStatement(file, path, name, null, priority, (PsiElement)element);
        }
    }

    private static void addFileSystemItemImport(@NotNull PsiFileSystemItem target, @NotNull PsiFile file, @NotNull PyElement element) {
        PsiFileSystemItem toImport;
        if (target == null) {
            AddImportHelper.$$$reportNull$$$0(47);
        }
        if (file == null) {
            AddImportHelper.$$$reportNull$$$0(48);
        }
        if (element == null) {
            AddImportHelper.$$$reportNull$$$0(49);
        }
        if ((toImport = target.getParent()) == null) {
            return;
        }
        QualifiedName importPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)target, (PsiElement)element);
        if (importPath == null) {
            return;
        }
        ImportPriority priority = AddImportHelper.getImportPriority((PsiElement)file, toImport);
        if (importPath.getComponentCount() == 1 || !PyCodeInsightSettings.getInstance().PREFER_FROM_IMPORT) {
            String path = importPath.toString();
            AddImportHelper.addImportStatement(file, path, null, priority, (PsiElement)element);
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(file.getProject());
            element.replace((PsiElement)elementGenerator.createExpressionFromText(LanguageLevel.forElement((PsiElement)target), path));
        } else {
            AddImportHelper.addOrUpdateFromImportStatement(file, importPath.removeLastComponent().toString(), target.getName(), null, priority, (PsiElement)element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/AddImportHelper";
                break;
            }
            case 2: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importStatement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsAnchor";
                break;
            }
            case 7: 
            case 9: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: 
            case 11: 
            case 35: 
            case 38: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertParent";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingImport";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priority";
                break;
            }
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importLocation";
                break;
            }
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toImport";
                break;
            }
            case 34: 
            case 36: 
            case 39: 
            case 41: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 37: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newImport";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/AddImportHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportNamesComparator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortNames";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSameGroupImportsComparator";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPriority";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportPriorityWithReason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getImportNamesComparator";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSortNames";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSameGroupImportsComparator";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addLocalImportStatement";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addLocalFromImportStatement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getLocalInsertPosition";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInsertPosition";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shouldInsertBefore";
                break;
            }
            case 16: 
            case 17: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getImportPriority";
                break;
            }
            case 21: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getImportPriorityWithReason";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "addImportStatement";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addFromImportStatement";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addOrUpdateFromImportStatement";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addImport";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "addFileSystemItemImport";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class ImportPriorityChoice {
        private final ImportPriority myPriority;
        private final String myDescription;

        ImportPriorityChoice(@NotNull ImportPriority priority, @NotNull String description) {
            if (priority == null) {
                ImportPriorityChoice.$$$reportNull$$$0(0);
            }
            if (description == null) {
                ImportPriorityChoice.$$$reportNull$$$0(1);
            }
            this.myPriority = priority;
            this.myDescription = description;
        }

        @NotNull
        public ImportPriority getPriority() {
            ImportPriority importPriority = this.myPriority;
            if (importPriority == null) {
                ImportPriorityChoice.$$$reportNull$$$0(2);
            }
            return importPriority;
        }

        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                ImportPriorityChoice.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "priority";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/imports/AddImportHelper$ImportPriorityChoice";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/imports/AddImportHelper$ImportPriorityChoice";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPriority";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum ImportPriority {
        FUTURE,
        BUILTIN,
        THIRD_PARTY,
        PROJECT;

    }
}

