/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.input;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.sejda.io.SeekableSource;
import org.sejda.sambox.cos.COSDocument;
import org.sejda.sambox.input.COSParser;
import org.sejda.sambox.input.IncrementablePDDocument;
import org.sejda.sambox.input.XrefParser;
import org.sejda.sambox.pdmodel.PDDocument;
import org.sejda.sambox.pdmodel.encryption.DecryptionMaterial;
import org.sejda.sambox.pdmodel.encryption.PDEncryption;
import org.sejda.sambox.pdmodel.encryption.SecurityHandler;
import org.sejda.sambox.pdmodel.encryption.StandardDecryptionMaterial;
import org.sejda.sambox.util.SpecVersionUtils;
import org.sejda.util.IOUtils;
import org.sejda.util.RequireUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDFParser {
    private static final Logger LOG = LoggerFactory.getLogger(PDFParser.class);

    public static PDDocument parse(SeekableSource source) throws IOException {
        return PDFParser.parse(source, (String)null);
    }

    public static IncrementablePDDocument parseToIncrement(SeekableSource source) throws IOException {
        return PDFParser.parseToIncrement(source, (String)null);
    }

    public static PDDocument parse(SeekableSource source, String password) throws IOException {
        return PDFParser.parse(source, Optional.ofNullable(password).map(StandardDecryptionMaterial::new).orElse(null));
    }

    public static IncrementablePDDocument parseToIncrement(SeekableSource source, String password) throws IOException {
        return PDFParser.parseToIncrement(source, Optional.ofNullable(password).map(StandardDecryptionMaterial::new).orElse(null));
    }

    public static PDDocument parse(SeekableSource source, DecryptionMaterial decryptionMaterial) throws IOException {
        Objects.requireNonNull(source);
        COSParser parser = new COSParser(source);
        PDDocument document = PDFParser.doParse(decryptionMaterial, parser);
        document.setOnCloseAction(() -> {
            IOUtils.close((Closeable)parser.provider());
            IOUtils.close((Closeable)parser);
        });
        return document;
    }

    public static IncrementablePDDocument parseToIncrement(SeekableSource source, DecryptionMaterial decryptionMaterial) throws IOException {
        Objects.requireNonNull(source);
        COSParser parser = new COSParser(source);
        return new IncrementablePDDocument(PDFParser.doParse(decryptionMaterial, parser), parser);
    }

    private static PDDocument doParse(DecryptionMaterial decryptionMaterial, COSParser parser) throws IOException {
        String headerVersion = PDFParser.readHeader(parser);
        LOG.trace("Parsed header version: " + headerVersion);
        XrefParser xrefParser = new XrefParser(parser);
        xrefParser.parse();
        COSDocument document = new COSDocument(xrefParser.trailer(), headerVersion);
        if (document.isEncrypted()) {
            LOG.debug("Preparing for document decryption");
            PDEncryption encryption = new PDEncryption(document.getEncryptionDictionary());
            SecurityHandler securityHandler = encryption.getSecurityHandler();
            securityHandler.prepareForDecryption(encryption, document.getDocumentID(), Optional.ofNullable(decryptionMaterial).orElse(new StandardDecryptionMaterial("")));
            parser.provider().initializeWith(securityHandler);
            return new PDDocument(document, securityHandler);
        }
        return new PDDocument(document);
    }

    private static String readHeader(COSParser parser) throws IOException {
        parser.position(0L);
        int headerIndex = -1;
        String header = parser.readLine();
        while ((headerIndex = header.indexOf("%PDF-")) < 0) {
            RequireUtils.requireIOCondition((parser.position() <= 1024L ? 1 : 0) != 0, (String)"Unable to find expected file header");
            header = parser.readLine();
        }
        String trimmedLeftHeader = header.substring(headerIndex, header.length()).replaceAll("\\s", "");
        RequireUtils.requireIOCondition((trimmedLeftHeader.length() >= 8 ? 1 : 0) != 0, (String)"Unable to find expected header '%PDF-n.n'");
        LOG.debug("Found header " + trimmedLeftHeader);
        return SpecVersionUtils.parseHeaderString(trimmedLeftHeader);
    }
}

