/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.support.validation;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.support.RequireUtils;
import org.pdfsam.support.validation.Validator;

class RegexValidator
implements Validator<String> {
    private Pattern pattern;

    public RegexValidator(String regex) {
        RequireUtils.requireNotBlank(regex, "Regex cannot be blank");
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public boolean isValid(String input) {
        return StringUtils.isNotBlank((CharSequence)input) && this.pattern.matcher(input).matches();
    }
}

