/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.SourceGroupModifier;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.java.hints.errors.AddParameterOrLocalFix;
import org.netbeans.modules.java.hints.errors.CreateClassFix;
import org.netbeans.modules.java.hints.errors.CreateElementUtilities;
import org.netbeans.modules.java.hints.errors.CreateEnumConstant;
import org.netbeans.modules.java.hints.errors.CreateFieldFix;
import org.netbeans.modules.java.hints.errors.CreateMethodFix;
import org.netbeans.modules.java.hints.errors.ErrorFixesFakeHint;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.infrastructure.ErrorHintsProvider;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Pair;

public final class CreateElement
implements ErrorRule<Void> {
    private static final Logger LOG = Logger.getLogger(CreateElement.class.getName());
    private static final int PRIO_TESTSOURCEGROUP = 500;
    private static final int PRIO_MAINSOURCEGROUP = 1000;
    private static final int PRIO_INNER = 2000;
    public static final String CAST_KEY = "compiler.err.prob.found.req";

    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.resolve.location", "compiler.err.cant.resolve.location.args", "compiler.err.cant.apply.symbol", "compiler.err.cant.apply.symbol.1", "compiler.err.cant.apply.symbols", "compiler.err.cant.resolve", "compiler.err.cant.resolve.args", CAST_KEY, "compiler.err.try.with.resources.expr.needs.var", "compiler.err.invalid.mref"));
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        try {
            return CreateElement.analyze(info, diagnosticKey, offset);
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
            return null;
        }
        catch (ClassCastException e) {
            Logger.getLogger(CreateElement.class.getName()).log(Level.FINE, null, e);
            return null;
        }
    }

    static List<Fix> analyze(CompilationInfo info, int offset) throws IOException {
        return CreateElement.analyze(info, null, offset);
    }

    static List<Fix> analyze(CompilationInfo info, String diagnosticKey, int offset) throws IOException {
        List<Fix> result = CreateElement.analyzeImpl(info, diagnosticKey, offset);
        if (CAST_KEY.equals(diagnosticKey)) {
            result = new ArrayList<Fix>(result);
            Iterator<Fix> it = result.iterator();
            while (it.hasNext()) {
                Fix f = it.next();
                if (f instanceof CreateMethodFix) continue;
                it.remove();
            }
        }
        return result;
    }

    private static List<Fix> analyzeImpl(CompilationInfo info, String diagnosticKey, int offset) throws IOException {
        TypeElement outermostTypeElement;
        TypeMirror type;
        if ("compiler.err.invalid.mref".equals(diagnosticKey)) {
            return CreateElement.computeMissingMemberRefFixes(info, offset);
        }
        TreePath errorPath = ErrorHintsProvider.findUnresolvedElement(info, offset);
        if (errorPath == null) {
            return Collections.emptyList();
        }
        if (CAST_KEY.equals(diagnosticKey) && errorPath.getParentPath() != null && errorPath.getParentPath().getLeaf().getKind() == Tree.Kind.METHOD_INVOCATION) {
            MethodInvocationTree mit = (MethodInvocationTree)errorPath.getParentPath().getLeaf();
            errorPath = new TreePath(errorPath.getParentPath(), mit.getMethodSelect());
            offset = (int)info.getTrees().getSourcePositions().getStartPosition(errorPath.getCompilationUnit(), errorPath.getLeaf());
        }
        if (info.getElements().getTypeElement("java.lang.Object") == null) {
            return Collections.emptyList();
        }
        TreePath parent = null;
        TreePath firstClass = null;
        TreePath firstMethod = null;
        TreePath firstVar = null;
        TreePath firstInitializer = null;
        TreePath methodInvocation = null;
        TreePath newClass = null;
        boolean baseType = false;
        boolean lookupMethodInvocation = true;
        boolean lookupNCT = true;
        for (TreePath path = info.getTreeUtilities().pathFor(Math.max((int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), errorPath.getLeaf()), offset) + 1); path != null; path = path.getParentPath()) {
            Tree leaf = path.getLeaf();
            Tree.Kind leafKind = leaf.getKind();
            if (!baseType && TreeUtilities.CLASS_TREE_KINDS.contains((Object)leafKind) && parent != null && (((ClassTree)leaf).getExtendsClause() == parent.getLeaf() || ((ClassTree)leaf).getImplementsClause().contains(parent.getLeaf()))) {
                baseType = true;
            }
            if (parent != null && parent.getLeaf() == errorPath.getLeaf()) {
                parent = path;
            }
            if (leaf == errorPath.getLeaf() && parent == null) {
                parent = path;
            }
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)leafKind) && firstClass == null) {
                firstClass = path;
            }
            if (leafKind == Tree.Kind.METHOD && firstMethod == null && firstClass == null) {
                firstMethod = path;
            }
            if (leafKind == Tree.Kind.BLOCK && TreeUtilities.CLASS_TREE_KINDS.contains((Object)path.getParentPath().getLeaf().getKind()) && firstMethod == null && firstClass == null) {
                firstInitializer = path;
            }
            if (leafKind == Tree.Kind.ANNOTATION) {
                methodInvocation = null;
                lookupMethodInvocation = false;
            }
            if (lookupMethodInvocation && leafKind == Tree.Kind.METHOD_INVOCATION) {
                methodInvocation = path;
            }
            if (leafKind == Tree.Kind.VARIABLE) {
                firstVar = path;
            }
            if (lookupNCT && leafKind == Tree.Kind.NEW_CLASS) {
                newClass = path;
            }
            if (leafKind == Tree.Kind.MEMBER_SELECT) {
                boolean bl = lookupMethodInvocation = leaf == errorPath.getLeaf();
            }
            if (leafKind != Tree.Kind.MEMBER_SELECT && leafKind != Tree.Kind.IDENTIFIER) {
                lookupMethodInvocation = false;
            }
            if (leafKind == Tree.Kind.MEMBER_SELECT || leafKind == Tree.Kind.IDENTIFIER || leafKind == Tree.Kind.PARAMETERIZED_TYPE) continue;
            lookupNCT = false;
        }
        if (parent == null || parent.getLeaf() == errorPath.getLeaf()) {
            return Collections.emptyList();
        }
        Element e = info.getTrees().getElement(errorPath);
        if (e == null) {
            return Collections.emptyList();
        }
        EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
        Name name = e.getSimpleName();
        if (name == null) {
            if (ErrorHintsProvider.ERR.isLoggable(1)) {
                ErrorHintsProvider.ERR.log(1, "e.simpleName=null");
                ErrorHintsProvider.ERR.log(1, "offset=" + offset);
                ErrorHintsProvider.ERR.log(1, "errorTree=" + errorPath.getLeaf());
            }
            return Collections.emptyList();
        }
        String simpleName = name.toString();
        TypeElement source = firstClass != null ? (TypeElement)info.getTrees().getElement(firstClass) : null;
        Element target = null;
        boolean wasMemberSelect = false;
        if (errorPath.getLeaf().getKind() == Tree.Kind.MEMBER_SELECT) {
            TreePath exp = new TreePath(errorPath, ((MemberSelectTree)errorPath.getLeaf()).getExpression());
            TypeMirror targetType = info.getTrees().getTypeMirror(exp);
            if (targetType != null) {
                if (targetType.getKind() == TypeKind.DECLARED) {
                    Element targetElement;
                    Element expElement = info.getTrees().getElement(exp);
                    if (CreateElement.isClassLikeElement(expElement)) {
                        modifiers.add(Modifier.STATIC);
                    }
                    if (CreateElement.isClassLikeElement(targetElement = info.getTypes().asElement(targetType))) {
                        target = (TypeElement)targetElement;
                    }
                } else if (targetType.getKind() == TypeKind.PACKAGE) {
                    target = info.getTrees().getElement(exp);
                }
            }
            wasMemberSelect = true;
        } else {
            Element enclosingElement = e.getEnclosingElement();
            if (enclosingElement != null && enclosingElement.getKind() == ElementKind.ANNOTATION_TYPE) {
                target = enclosingElement;
            } else if (errorPath.getLeaf().getKind() == Tree.Kind.IDENTIFIER) {
                target = source;
                if (firstMethod != null) {
                    if (((MethodTree)firstMethod.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                        modifiers.add(Modifier.STATIC);
                    }
                } else if (firstInitializer != null) {
                    if (((BlockTree)firstInitializer.getLeaf()).isStatic()) {
                        modifiers.add(Modifier.STATIC);
                    }
                } else if (firstVar != null && ((VariableTree)firstVar.getLeaf()).getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
                    modifiers.add(Modifier.STATIC);
                }
            }
        }
        if (target == null) {
            if (ErrorHintsProvider.ERR.isLoggable(1)) {
                ErrorHintsProvider.ERR.log(1, "target=null");
                ErrorHintsProvider.ERR.log(1, "offset=" + offset);
                ErrorHintsProvider.ERR.log(1, "errorTree=" + errorPath.getLeaf());
            }
            return Collections.emptyList();
        }
        if (target instanceof TypeElement) {
            modifiers.addAll(Utilities.getAccessModifiers(info, source, (TypeElement)target).getRequiredModifiers());
        } else {
            modifiers.add(Modifier.PUBLIC);
        }
        ArrayList<Fix> result = new ArrayList<Fix>();
        if (methodInvocation != null) {
            MethodInvocationTree mit = (MethodInvocationTree)methodInvocation.getLeaf();
            EnumSet<ElementKind> fixTypes = EnumSet.noneOf(ElementKind.class);
            List<? extends TypeMirror> types = CreateElementUtilities.resolveType(fixTypes, info, methodInvocation.getParentPath(), methodInvocation.getLeaf(), offset, null, null);
            if (types == null || types.isEmpty()) {
                return Collections.emptyList();
            }
            try {
                result.addAll(CreateElement.prepareCreateMethodFix(info, methodInvocation, modifiers, (TypeElement)target, simpleName, mit.getArguments(), types));
            }
            catch (IllegalArgumentException ex) {
                LOG.log(Level.INFO, "Unexpected exception, perhaps a type that cannot be converted to a Handle. See issue #243028 for more details. Please attachthe following ide.log to the issue");
                LOG.log(Level.INFO, "Caused by source:\n==============\n" + info.getSnapshot().getText().toString() + "\n==============\n");
                LOG.log(Level.INFO, "Caused by error at offset " + offset + ", tree: " + methodInvocation.getLeaf().toString(), ex);
                LOG.log(Level.INFO, "Invocation starts at " + info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), methodInvocation.getLeaf()));
                throw ex;
            }
        }
        EnumSet<ElementKind> fixTypes = EnumSet.noneOf(ElementKind.class);
        TypeMirror[] superType = new TypeMirror[1];
        int[] numTypeParameters = new int[1];
        List<? extends TypeMirror> types = CreateElementUtilities.resolveType(fixTypes, info, parent, errorPath.getLeaf(), offset, superType, numTypeParameters);
        ElementKind classType = CreateElement.getClassType(fixTypes);
        if (!ErrorFixesFakeHint.enabled(info.getFileObject(), ErrorFixesFakeHint.FixKind.CREATE_LOCAL_VARIABLE)) {
            fixTypes.remove((Object)ElementKind.LOCAL_VARIABLE);
        }
        if (types != null && !types.isEmpty()) {
            ArrayList<? extends TypeMirror> resolvedTypes = null;
            int i = 0;
            for (TypeMirror typeMirror : types) {
                TypeMirror resolved = Utilities.resolveTypeForDeclaration(info, typeMirror);
                if (resolved != typeMirror) {
                    if (resolvedTypes == null) {
                        resolvedTypes = new ArrayList<TypeMirror>(types);
                        types = resolvedTypes;
                    }
                    resolvedTypes.set(i, resolved);
                }
                ++i;
            }
            type = types.get(0);
            if (superType[0] == null) {
                superType[0] = type;
            }
        } else {
            type = null;
        }
        if (target.getKind() == ElementKind.PACKAGE) {
            result.addAll(CreateElement.prepareCreateOuterClassFix(info, null, target, modifiers, simpleName, null, superType[0], classType != null ? classType : ElementKind.CLASS, numTypeParameters[0]));
            return result;
        }
        TypeElement typeElement = outermostTypeElement = source != null ? info.getElementUtilities().outermostTypeElement((Element)source) : null;
        if (newClass != null) {
            NewClassTree nct = (NewClassTree)newClass.getLeaf();
            Element clazz = info.getTrees().getElement(new TreePath(newClass, nct.getIdentifier()));
            if (clazz == null || clazz.asType().getKind() == TypeKind.ERROR || !clazz.getKind().isClass() && !clazz.getKind().isInterface()) {
                ExpressionTree expressionTree = nct.getIdentifier();
                int numTypeArguments = 0;
                if (expressionTree.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                    numTypeArguments = ((ParameterizedTypeTree)((Object)expressionTree)).getTypeArguments().size();
                }
                if (wasMemberSelect) {
                    return CreateElement.prepareCreateInnerClassFix(info, newClass, (TypeElement)target, modifiers, simpleName, nct.getArguments(), type, ElementKind.CLASS, numTypeArguments);
                }
                LinkedList<Fix> currentResult = new LinkedList<Fix>();
                currentResult.addAll(CreateElement.prepareCreateOuterClassFix(info, newClass, source, EnumSet.of(Modifier.PUBLIC), simpleName, nct.getArguments(), type, ElementKind.CLASS, numTypeArguments));
                if (!baseType || outermostTypeElement != source) {
                    currentResult.addAll(CreateElement.prepareCreateInnerClassFix(info, newClass, outermostTypeElement, EnumSet.of(outermostTypeElement != null && outermostTypeElement.getKind().isInterface() ? Modifier.PUBLIC : Modifier.PRIVATE, Modifier.STATIC), simpleName, nct.getArguments(), type, ElementKind.CLASS, numTypeArguments));
                }
                return currentResult;
            }
            if (nct.getClassBody() != null) {
                return Collections.emptyList();
            }
            TypeElement typeElement2 = (TypeElement)clazz;
            result.addAll(CreateElement.prepareCreateMethodFix(info, newClass, Utilities.getAccessModifiers(info, source, typeElement2).getRequiredModifiers(), typeElement2, "<init>", nct.getArguments(), null));
        }
        if (classType != null && e.asType().getKind() == TypeKind.ERROR) {
            if (wasMemberSelect) {
                result.addAll(CreateElement.prepareCreateInnerClassFix(info, null, (TypeElement)target, modifiers, simpleName, null, superType[0], classType, numTypeParameters[0]));
            } else {
                result.addAll(CreateElement.prepareCreateOuterClassFix(info, null, source, EnumSet.noneOf(Modifier.class), simpleName, null, superType[0], classType, numTypeParameters[0]));
                if (!baseType || outermostTypeElement != source) {
                    result.addAll(CreateElement.prepareCreateInnerClassFix(info, null, outermostTypeElement, EnumSet.of(outermostTypeElement != null && outermostTypeElement.getKind().isInterface() ? Modifier.PUBLIC : Modifier.PRIVATE, Modifier.STATIC), simpleName, null, superType[0], classType, numTypeParameters[0]));
                }
            }
        }
        if (type == null || type.getKind() == TypeKind.VOID || type.getKind() == TypeKind.OTHER || type.getKind() == TypeKind.NONE || type.getKind() == TypeKind.EXECUTABLE) {
            return result;
        }
        if (Utilities.containsErrorsRecursively(type)) {
            return result;
        }
        Collection<TypeVariable> typeVars = Utilities.containedTypevarsRecursively(type);
        if (!Utilities.allTypeVarsAccessible(typeVars, target)) {
            fixTypes.remove((Object)ElementKind.FIELD);
        }
        if (fixTypes.contains((Object)ElementKind.FIELD) && Utilities.isTargetWritable((TypeElement)target, info)) {
            Element enclosingElement = e.getEnclosingElement();
            if (enclosingElement != null && enclosingElement.getKind() == ElementKind.ANNOTATION_TYPE) {
                FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)target), (ClasspathInfo)info.getClasspathInfo());
                if (fileObject != null) {
                    result.add(new CreateMethodFix(info, simpleName, modifiers, (TypeElement)target, type, types, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), fileObject));
                }
                return result;
            }
            FileObject fileObject = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)target), (ClasspathInfo)info.getClasspathInfo());
            if (fileObject != null) {
                if (target.getKind() == ElementKind.ENUM) {
                    if (source != null) {
                        if (source.equals(target)) {
                            result.add((Fix)new CreateFieldFix(info, simpleName, modifiers, (TypeElement)target, type, fileObject));
                        } else {
                            result.add(new CreateEnumConstant(info, simpleName, modifiers, (TypeElement)target, type, fileObject));
                        }
                    }
                } else {
                    if (firstMethod != null && info.getTrees().getElement(firstMethod).getKind() == ElementKind.CONSTRUCTOR && ErrorFixesFakeHint.isCreateFinalFieldsForCtor(ErrorFixesFakeHint.getPreferences(fileObject, ErrorFixesFakeHint.FixKind.CREATE_FINAL_FIELD_CTOR)) && CreateElementUtilities.canDeclareVariableFinal(info, firstMethod, e)) {
                        modifiers.add(Modifier.FINAL);
                    }
                    if (ErrorFixesFakeHint.enabled(info.getFileObject(), ErrorFixesFakeHint.FixKind.CREATE_FINAL_FIELD_CTOR)) {
                        result.add((Fix)new CreateFieldFix(info, simpleName, modifiers, (TypeElement)target, type, fileObject));
                    }
                }
            }
        }
        if (!wasMemberSelect && (fixTypes.contains((Object)ElementKind.LOCAL_VARIABLE) || fixTypes.contains((Object)ElementKind.PARAMETER) || fixTypes.contains((Object)ElementKind.RESOURCE_VARIABLE))) {
            ExecutableElement ee = null;
            if (firstMethod != null) {
                ee = (ExecutableElement)info.getTrees().getElement(firstMethod);
            }
            int n = (int)info.getTrees().getSourcePositions().getStartPosition(info.getCompilationUnit(), errorPath.getLeaf());
            if (ee != null && fixTypes.contains((Object)ElementKind.PARAMETER) && !Utilities.isMethodHeaderInsideGuardedBlock(info, (MethodTree)firstMethod.getLeaf())) {
                result.add((Fix)new AddParameterOrLocalFix(info, type, simpleName, ElementKind.PARAMETER, n));
            }
            if ((firstMethod != null || firstInitializer != null) && fixTypes.contains((Object)ElementKind.LOCAL_VARIABLE) && ErrorFixesFakeHint.enabled(ErrorFixesFakeHint.FixKind.CREATE_LOCAL_VARIABLE)) {
                result.add((Fix)new AddParameterOrLocalFix(info, type, simpleName, ElementKind.LOCAL_VARIABLE, n));
            }
            if (fixTypes.contains((Object)ElementKind.RESOURCE_VARIABLE)) {
                result.add((Fix)new AddParameterOrLocalFix(info, type, simpleName, ElementKind.RESOURCE_VARIABLE, n));
            }
        }
        return result;
    }

    private static List<Fix> computeMissingMemberRefFixes(CompilationInfo info, int offset) {
        TreePath errorPath;
        for (errorPath = info.getTreeUtilities().pathFor(offset + 1); errorPath != null && errorPath.getLeaf().getKind() != Tree.Kind.MEMBER_REFERENCE; errorPath = errorPath.getParentPath()) {
        }
        if (errorPath == null) {
            return Collections.emptyList();
        }
        MemberReferenceTree mref = (MemberReferenceTree)errorPath.getLeaf();
        TypeMirror mrefType = info.getTrees().getTypeMirror(errorPath);
        if (mrefType.getKind() == TypeKind.ERROR) {
            TreePath tp;
            TypeMirror expectedTargetType = info.getTrees().getOriginalType((ErrorType)mrefType);
            if (expectedTargetType == null || expectedTargetType.getKind() != TypeKind.DECLARED) {
                return Collections.emptyList();
            }
            ExecutableElement expectedMethod = Utilities.getFunctionalMethodFromElement(info, info.getTypes().asElement(expectedTargetType));
            if (expectedMethod == null) {
                return Collections.emptyList();
            }
            ExecutableType methodType = (ExecutableType)info.getTypes().asMemberOf((DeclaredType)expectedTargetType, expectedMethod);
            if (Utilities.containsErrorsRecursively(methodType)) {
                return Collections.emptyList();
            }
            TypeMirror targetType = info.getTrees().getTypeMirror(new TreePath(errorPath, mref.getQualifierExpression()));
            TypeElement target = (TypeElement)info.getTypes().asElement(targetType);
            if (!Utilities.isTargetWritable(target, info)) {
                return Collections.emptyList();
            }
            FileObject targetFile = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)target), (ClasspathInfo)info.getClasspathInfo());
            if (targetFile == null) {
                return Collections.emptyList();
            }
            EnumSet<Modifier> modifiers = EnumSet.noneOf(Modifier.class);
            for (tp = errorPath; tp != null && !TreeUtilities.CLASS_TREE_KINDS.contains((Object)tp.getLeaf().getKind()); tp = tp.getParentPath()) {
            }
            modifiers.addAll(Utilities.getAccessModifiers(info, (TypeElement)info.getTrees().getElement(tp), target).getRequiredModifiers());
            Element targetExprEl = info.getTrees().getElement(new TreePath(errorPath, mref.getQualifierExpression()));
            ArrayList<Fix> fixes = new ArrayList<Fix>();
            if (targetExprEl.getKind().isClass() || targetExprEl.getKind().isInterface()) {
                if (methodType.getParameterTypes().size() > 0 && target.equals(info.getTypes().asElement(methodType.getParameterTypes().get(0)))) {
                    fixes.add(new CreateMethodFix(info, mref.getName().toString(), EnumSet.copyOf(modifiers), target, methodType.getReturnType(), methodType.getParameterTypes().subList(1, methodType.getParameterTypes().size()), expectedMethod.getParameters().stream().skip(1L).map(var -> var.getSimpleName().toString()).collect(Collectors.toList()), Collections.emptyList(), Collections.emptyList(), targetFile));
                }
                modifiers.add(Modifier.STATIC);
            }
            fixes.add(new CreateMethodFix(info, mref.getName().toString(), modifiers, target, methodType.getReturnType(), methodType.getParameterTypes(), expectedMethod.getParameters().stream().map(var -> var.getSimpleName().toString()).collect(Collectors.toList()), Collections.emptyList(), Collections.emptyList(), targetFile));
            return fixes;
        }
        return Collections.emptyList();
    }

    private static List<Fix> prepareCreateMethodFix(CompilationInfo info, TreePath invocation, Set<Modifier> modifiers, TypeElement target, String simpleName, List<? extends ExpressionTree> arguments, List<? extends TypeMirror> returnTypes) {
        TypeMirror returnType;
        TypeMirror typeMirror = returnType = returnTypes != null ? Utilities.resolveTypeForDeclaration(info, returnTypes.get(0)) : null;
        if (returnType != null && Utilities.containsErrorsRecursively(returnType)) {
            return Collections.emptyList();
        }
        Utilities.MethodArguments formalArguments = Utilities.resolveArguments(info, invocation, arguments, target, returnType);
        if (formalArguments == null) {
            return Collections.emptyList();
        }
        if (!Utilities.isTargetWritable(target, info)) {
            return Collections.emptyList();
        }
        FileObject targetFile = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)target), (ClasspathInfo)info.getClasspathInfo());
        if (targetFile == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new CreateMethodFix(info, simpleName, modifiers, target, returnType, formalArguments.parameterTypes, formalArguments.parameterNames, formalArguments.typeParameterTypes, formalArguments.typeParameterNames, targetFile));
    }

    private static Map<SourceGroup, Integer> getPossibleSourceGroups(FileObject fileObject) {
        Boolean isInTestSources = CreateElement.isInTestSources(fileObject);
        if (null == isInTestSources) {
            return Collections.emptyMap();
        }
        Project p = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (null == p) {
            return Collections.emptyMap();
        }
        Sources src = ProjectUtils.getSources((Project)p);
        SourceGroup[] sGroups = src.getSourceGroups("java");
        SourceGroup sourceGroup = null;
        HashSet<FileObject> testRoots = new HashSet<FileObject>();
        SourceGroup linkedSources = null;
        for (SourceGroup sg : sGroups) {
            URL[] urls;
            for (URL u : urls = UnitTestForSourceQuery.findUnitTests((FileObject)sg.getRootFolder())) {
                FileObject r = URLMapper.findFileObject((URL)u);
                if (r == null || !testRoots.add(r) || !FileUtil.isParentOf((FileObject)r, (FileObject)fileObject)) continue;
                isInTestSources = true;
                linkedSources = sg;
            }
            if (!FileUtil.isParentOf((FileObject)sg.getRootFolder(), (FileObject)fileObject)) continue;
            sourceGroup = sg;
        }
        HashMap<SourceGroup, Integer> list = new HashMap<SourceGroup, Integer>();
        if (isInTestSources.booleanValue()) {
            if (null != linkedSources) {
                list.put(linkedSources, 1000);
            }
            if (null != sourceGroup) {
                list.put(sourceGroup, 500);
            }
        } else if (null != sourceGroup) {
            list.put(sourceGroup, 1000);
        }
        return list;
    }

    private static Boolean isInTestSources(FileObject fileObject) {
        Project p = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (null == p) {
            return null;
        }
        SourceGroup testSourceGroup = SourceGroupModifier.createSourceGroup((Project)p, (String)"java", (String)"test");
        boolean isInTestSources = false;
        if (null != testSourceGroup) {
            isInTestSources = FileUtil.isParentOf((FileObject)testSourceGroup.getRootFolder(), (FileObject)fileObject);
        }
        return isInTestSources;
    }

    private static List<Fix> prepareCreateOuterClassFix(CompilationInfo info, TreePath invocation, Element source, Set<Modifier> modifiers, String simpleName, List<? extends ExpressionTree> realArguments, TypeMirror superType, ElementKind kind, int numTypeParameters) {
        Pair<List<? extends TypeMirror>, List<String>> formalArguments;
        Pair<List<? extends TypeMirror>, List<String>> pair = formalArguments = invocation != null ? Utilities.resolveArguments(info, invocation, realArguments, null) : Pair.of(null, null);
        if (formalArguments == null) {
            return Collections.emptyList();
        }
        if (superType != null && superType.getKind() == TypeKind.OTHER) {
            return Collections.emptyList();
        }
        FileObject fileObject = info.getFileObject();
        Project p = FileOwnerQuery.getOwner((FileObject)fileObject);
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        for (Map.Entry<SourceGroup, Integer> entrySet : CreateElement.getPossibleSourceGroups(fileObject).entrySet()) {
            SourceGroup sourceGroup = entrySet.getKey();
            Integer value = entrySet.getValue();
            FileObject sourceGroupRoot = sourceGroup.getRootFolder();
            String sourceRootName = sourceGroup.getDisplayName();
            PackageElement packageElement = (PackageElement)(source instanceof PackageElement ? source : info.getElementUtilities().outermostTypeElement(source).getEnclosingElement());
            CreateClassFix.CreateOuterClassFix fix = new CreateClassFix.CreateOuterClassFix(info, sourceGroupRoot, packageElement.getQualifiedName().toString(), simpleName, modifiers, (List)formalArguments.first(), (List)formalArguments.second(), superType, kind, numTypeParameters, sourceRootName);
            fix.setPriority(value);
            fixes.add((Fix)fix);
        }
        if (null == p || fixes.isEmpty()) {
            FileObject root = info.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE).findOwnerRoot(info.getFileObject());
            if (root == null) {
                return Collections.emptyList();
            }
            PackageElement packageElement = (PackageElement)(source instanceof PackageElement ? source : info.getElementUtilities().outermostTypeElement(source).getEnclosingElement());
            CreateClassFix.CreateOuterClassFix fix = new CreateClassFix.CreateOuterClassFix(info, root, packageElement.getQualifiedName().toString(), simpleName, modifiers, (List)formalArguments.first(), (List)formalArguments.second(), superType, kind, numTypeParameters, root.getName());
            fix.setPriority(1000);
            fixes.add((Fix)fix);
        }
        return fixes;
    }

    private static List<Fix> prepareCreateInnerClassFix(CompilationInfo info, TreePath invocation, TypeElement target, Set<Modifier> modifiers, String simpleName, List<? extends ExpressionTree> realArguments, TypeMirror superType, ElementKind kind, int numTypeParameters) {
        Pair<List<? extends TypeMirror>, List<String>> formalArguments;
        Pair<List<? extends TypeMirror>, List<String>> pair = formalArguments = invocation != null ? Utilities.resolveArguments(info, invocation, realArguments, target) : Pair.of(null, null);
        if (formalArguments == null) {
            return Collections.emptyList();
        }
        if (!Utilities.isTargetWritable(target, info)) {
            return Collections.emptyList();
        }
        FileObject targetFile = SourceUtils.getFile((Element)target, (ClasspathInfo)info.getClasspathInfo());
        if (targetFile == null) {
            return Collections.emptyList();
        }
        CreateClassFix.CreateInnerClassFix fix = new CreateClassFix.CreateInnerClassFix(info, simpleName, modifiers, target, (List)formalArguments.first(), (List)formalArguments.second(), superType, kind, numTypeParameters, targetFile);
        fix.setPriority(2000);
        return Collections.singletonList(fix);
    }

    private static ElementKind getClassType(Set<ElementKind> types) {
        if (types.contains((Object)ElementKind.CLASS)) {
            return ElementKind.CLASS;
        }
        if (types.contains((Object)ElementKind.ANNOTATION_TYPE)) {
            return ElementKind.ANNOTATION_TYPE;
        }
        if (types.contains((Object)ElementKind.INTERFACE)) {
            return ElementKind.INTERFACE;
        }
        if (types.contains((Object)ElementKind.ENUM)) {
            return ElementKind.ENUM;
        }
        return null;
    }

    private static boolean isClassLikeElement(Element expElement) {
        return expElement != null && (expElement.getKind().isClass() || expElement.getKind().isInterface());
    }

    public void cancel() {
    }

    public String getId() {
        return CreateElement.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CreateElement.class, (String)"LBL_Create_Field");
    }

    public String getDescription() {
        return NbBundle.getMessage(CreateElement.class, (String)"DSC_Create_Field");
    }
}

