/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.api;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.Dependency;
import org.netbeans.modules.maven.model.pom.DependencyManagement;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginManagement;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.modules.maven.model.pom.Repository;
import org.netbeans.modules.maven.options.MavenSettings;
import org.netbeans.modules.maven.options.MavenVersionSettings;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.cookies.EditCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;

public final class ModelUtils {
    private static final Logger LOG = Logger.getLogger(ModelUtils.class.getName());
    public static final String LIBRARY_PROP_DEPENDENCIES = "maven-dependencies";
    public static final String LIBRARY_PROP_REPOSITORIES = "maven-repositories";
    private static final String PROBABLE_ROOTS = "maven2|maven[.]repo|content/(?:groups|repositories|shadows)/[^/]+|.+(?=/(?:javax|org|net|com)/)";
    private static Pattern DEFAULT = Pattern.compile("(.+://[^/]+/(?:(?:.+/)?(?:maven2|maven[.]repo|content/(?:groups|repositories|shadows)/[^/]+|.+(?=/(?:javax|org|net|com)/))/)?)(.+)/([^/]+)/([^/]+)/\\3-\\4[.]pom");
    private static Pattern LEGACY = Pattern.compile("(.+/)([^/]+)/poms/([a-zA-Z0-9_]+[a-zA-Z_-]+)-([0-9].+)[.]pom");

    private ModelUtils() {
    }

    public static void addDependency(FileObject pom, final String group, final String artifact, final String version, final String type, final String scope, final String classifier, final boolean acceptNull) {
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){
            private static final String BUNDLE_TYPE = "bundle";

            public void performOperation(POMModel model) {
                Dependency dep = ModelUtils.checkModelDependency(model, group, artifact, true);
                dep.setVersion(version);
                if (acceptNull || scope != null) {
                    dep.setScope(scope);
                }
                if (acceptNull || type != null && !BUNDLE_TYPE.equals(type)) {
                    dep.setType(type);
                }
                if (acceptNull || classifier != null) {
                    dep.setClassifier(classifier);
                }
            }
        };
        Utilities.performPOMModelOperations((FileObject)pom, Collections.singletonList(operation));
    }

    public static Dependency checkModelDependency(POMModel pom, String groupId, String artifactId, boolean add) {
        DependencyManagement mng;
        Project mdl = pom.getProject();
        Dependency ret = mdl.findDependencyById(groupId, artifactId, null);
        Dependency managed = null;
        if ((ret == null || ret.getVersion() == null) && (mng = mdl.getDependencyManagement()) != null) {
            managed = mng.findDependencyById(groupId, artifactId, null);
        }
        if (add && ret == null) {
            ret = mdl.getModel().getFactory().createDependency();
            ret.setGroupId(groupId);
            ret.setArtifactId(artifactId);
            mdl.addDependency(ret);
        }
        return managed == null ? ret : managed;
    }

    public static boolean hasModelDependency(POMModel mdl, String groupid, String artifactid) {
        return ModelUtils.checkModelDependency(mdl, groupid, artifactid, false) != null;
    }

    public static void openAtSource(InputLocation location) {
        FileObject fobj;
        InputSource source = location.getSource();
        if (source != null && source.getLocation() != null && (fobj = FileUtilities.convertStringToFileObject(source.getLocation())) != null) {
            try {
                DataObject dobj = DataObject.find((FileObject)NodeUtils.readOnlyLocalRepositoryFile(fobj));
                EditCookie edit = (EditCookie)dobj.getLookup().lookup(EditCookie.class);
                if (edit != null) {
                    edit.edit();
                }
                LineCookie lc = (LineCookie)dobj.getLookup().lookup(LineCookie.class);
                lc.getLineSet().getOriginal(location.getLineNumber() - 1).show(Line.ShowOpenType.REUSE, Line.ShowVisibilityType.FOCUS, location.getColumnNumber() - 1);
            }
            catch (DataObjectNotFoundException ex) {
                LOG.log(Level.FINE, "dataobject not found", ex);
            }
        }
    }

    public static void openAtPlugin(POMModel model, String groupId, String artifactId) {
        Plugin plg;
        int pos = -1;
        Project p = model.getProject();
        Build bld = p.getBuild();
        if (bld != null && (plg = bld.findPluginById(groupId, artifactId)) != null) {
            pos = plg.findPosition();
        }
        if (pos == -1) {
            pos = p.findPosition();
        }
        if (pos == -1) {
            return;
        }
        Utilities.openAtPosition((POMModel)model, (int)pos);
    }

    public static void updatePluginVersion(String groupId, String artifactId, String version, Project prj) {
        Build bld = prj.getBuild();
        boolean setInPM = false;
        boolean setInPlgs = false;
        if (bld != null) {
            Plugin p;
            PluginManagement pm = bld.getPluginManagement();
            if (pm != null && (p = pm.findPluginById(groupId, artifactId)) != null) {
                p.setVersion(version);
                setInPM = true;
            }
            if ((p = bld.findPluginById(groupId, artifactId)) != null) {
                if (p.getVersion() != null) {
                    p.setVersion(version);
                    setInPlgs = true;
                } else if (!setInPM) {
                    p.setVersion(version);
                    setInPlgs = true;
                }
            }
        }
        if (!setInPM && !setInPlgs) {
            if (bld == null) {
                bld = prj.getModel().getFactory().createBuild();
                prj.setBuild(bld);
            }
            Plugin p = prj.getModel().getFactory().createPlugin();
            p.setGroupId(groupId);
            p.setArtifactId(artifactId);
            p.setVersion(version);
            bld.addPlugin(p);
        }
    }

    public static Repository addModelRepository(MavenProject project, POMModel mdl, String url) {
        if (url.contains("https://repo.maven.apache.org/maven2") || url.contains("http://repo1.maven.org/maven2")) {
            return null;
        }
        List repos = mdl.getProject().getRepositories();
        if (repos != null) {
            for (Repository r : repos) {
                if (!url.equals(r.getUrl())) continue;
                return null;
            }
        }
        List reps = project.getRepositories();
        org.apache.maven.model.Repository prjret = null;
        Repository ret = null;
        if (reps != null) {
            for (org.apache.maven.model.Repository re : reps) {
                if (!url.equals(re.getUrl())) continue;
                prjret = re;
                break;
            }
        }
        if (prjret == null) {
            ret = mdl.getFactory().createRepository();
            ret.setUrl(url);
            ret.setId(url);
            mdl.getProject().addRepository(ret);
        }
        return ret;
    }

    public static boolean checkByCLIMavenValidationLevel(ModelProblem problem) {
        String version = MavenSettings.getCommandLineMavenVersion();
        try {
            if (version != null && !"".equals(version.trim()) && new DefaultArtifactVersion(version).compareTo((ArtifactVersion)new DefaultArtifactVersion("3.2.1")) > 0 && (problem.getMessage().startsWith("'dependencies.dependency.exclusions.exclusion.groupId' for ") || problem.getMessage().startsWith("'dependencies.dependency.exclusions.exclusion.artifactId' for ")) && problem.getMessage().contains(" with value '*' does not match a valid id pattern")) {
                return false;
            }
        }
        catch (Throwable e) {
            LOG.log(Level.INFO, version, e);
        }
        return true;
    }

    public static void setSourceLevel(POMModel mdl, String sourceLevel) {
        Plugin plugin;
        Plugin old = null;
        Build bld = mdl.getProject().getBuild();
        if (bld != null) {
            old = bld.findPluginById("org.apache.maven.plugins", "maven-compiler-plugin");
        } else {
            mdl.getProject().setBuild(mdl.getFactory().createBuild());
        }
        if (old != null) {
            plugin = old;
        } else {
            plugin = mdl.getFactory().createPlugin();
            plugin.setGroupId("org.apache.maven.plugins");
            plugin.setArtifactId("maven-compiler-plugin");
            plugin.setVersion(MavenVersionSettings.getDefault().getVersion("maven-compiler-plugin"));
            mdl.getProject().getBuild().addPlugin(plugin);
        }
        Configuration conf = plugin.getConfiguration();
        if (conf == null) {
            conf = mdl.getFactory().createConfiguration();
            plugin.setConfiguration(conf);
        }
        conf.setSimpleParameter("source", sourceLevel);
        conf.setSimpleParameter("target", sourceLevel);
    }

    public static POMExtensibilityElement getOrCreateChild(POMComponent parent, String localQName, POMModel pomModel) {
        POMExtensibilityElement result = null;
        for (POMExtensibilityElement el : parent.getExtensibilityElements()) {
            if (!localQName.equals(el.getQName().getLocalPart())) continue;
            result = el;
            break;
        }
        if (result == null) {
            result = pomModel.getFactory().createPOMExtensibilityElement(new QName(localQName));
            parent.addExtensibilityElement(result);
        }
        return result;
    }

    @Deprecated
    @SuppressWarnings(value={"SBSC_USE_STRINGBUFFER_CONCATENATION"})
    public static LibraryDescriptor checkLibrary(URL pom) {
        String pomS;
        try {
            pomS = new URL(pom.getProtocol(), pom.getHost(), pom.getPort(), pom.getFile()).toString();
        }
        catch (MalformedURLException x) {
            pomS = pom.toString();
        }
        Matcher m1 = LEGACY.matcher(pomS);
        if (m1.matches()) {
            return new LibraryDescriptor("legacy", m1.group(1), m1.group(2), m1.group(3), m1.group(4), pom.getRef(), "jar");
        }
        Matcher m2 = DEFAULT.matcher(pomS);
        if (m2.matches()) {
            return new LibraryDescriptor("default", m2.group(1), m2.group(2).replace('/', '.'), m2.group(3), m2.group(4), pom.getRef(), "jar");
        }
        return null;
    }

    public static Descriptor checkLibraries(Library library) {
        return ModelUtils.checkLibraries(library.getProperties());
    }

    static Descriptor checkLibraries(Map<String, String> properties) {
        ArrayList<LibraryDescriptor> libs = new ArrayList<LibraryDescriptor>();
        ArrayList<RepositoryDescriptor> reps = new ArrayList<RepositoryDescriptor>();
        String dependencies = properties.get(LIBRARY_PROP_DEPENDENCIES);
        if (dependencies != null) {
            for (String dep : dependencies.split("([\\s])+")) {
                String[] v = dep.trim().split(":");
                if (v.length < 4) continue;
                String grid = v[0];
                String art = v[1];
                String ver = v[2];
                String type = v.length == 4 ? v[3] : v[4];
                String classifier = v.length >= 5 ? v[3] : null;
                libs.add(new LibraryDescriptor(null, null, grid, art, ver, classifier, type));
            }
            String repositories = properties.get(LIBRARY_PROP_REPOSITORIES);
            if (repositories != null) {
                for (String r : repositories.split("([\\s])+")) {
                    String[] rep = r.split(":", 2);
                    if (rep.length < 2) continue;
                    reps.add(new RepositoryDescriptor(rep[0], rep[1]));
                }
            }
        }
        return new Descriptor(libs, reps);
    }

    public static final class LibraryDescriptor {
        private final String repoType;
        private final String repoRoot;
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String classifier;
        private final String type;

        LibraryDescriptor(String repoType, String repoRoot, String groupId, String artifactId, String version, String classifier, String type) {
            this.repoType = repoType;
            this.repoRoot = repoRoot;
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.classifier = classifier;
            this.type = type;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getGroupId() {
            return this.groupId;
        }

        @Deprecated
        public String getRepoRoot() {
            return this.repoRoot;
        }

        @Deprecated
        public String getRepoType() {
            return this.repoType;
        }

        public String getVersion() {
            return this.version;
        }

        public String getType() {
            return this.type;
        }

        public String toString() {
            return "LibraryDescriptor{repoType=" + this.repoType + ", repoRoot=" + this.repoRoot + ", groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", classifier=" + this.classifier + ", type=" + this.type + '}';
        }
    }

    public static final class RepositoryDescriptor {
        private final String repoType;
        private final String repoRoot;

        RepositoryDescriptor(String repoType, String repoRoot) {
            this.repoType = repoType;
            this.repoRoot = repoRoot;
        }

        public String getRepoType() {
            return this.repoType;
        }

        public String getRepoRoot() {
            return this.repoRoot;
        }

        public int hashCode() {
            int hash = 5;
            hash = 37 * hash + (this.repoType != null ? this.repoType.hashCode() : 0);
            hash = 37 * hash + (this.repoRoot != null ? this.repoRoot.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RepositoryDescriptor other = (RepositoryDescriptor)obj;
            if (this.repoType == null ? other.repoType != null : !this.repoType.equals(other.repoType)) {
                return false;
            }
            return !(this.repoRoot == null ? other.repoRoot != null : !this.repoRoot.equals(other.repoRoot));
        }
    }

    public static final class Descriptor {
        final List<LibraryDescriptor> dependencies;
        final List<RepositoryDescriptor> repositories;

        Descriptor(@NonNull List<LibraryDescriptor> dependencies, @NonNull List<RepositoryDescriptor> repositories) {
            this.dependencies = dependencies;
            this.repositories = repositories;
        }

        public List<LibraryDescriptor> getDependencies() {
            return this.dependencies;
        }

        public List<RepositoryDescriptor> getRepositories() {
            return this.repositories;
        }
    }
}

