/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.wizard;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.apisupport.project.api.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.common.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.wizard.DataModel;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class WizardTypePanel
extends BasicWizardIterator.Panel {
    private DataModel data;
    private boolean lastStaticValue = true;
    private JRadioButton custom;
    private JRadioButton dynamic;
    private JLabel filler;
    private JRadioButton newFile;
    private JRadioButton newHTML;
    private JRadioButton newHTML4J;
    private JTextField numberOfSteps;
    private JLabel numberOfStepsTxt;
    private ButtonGroup registrationType;
    private JLabel registrationTypeTxt;
    private JRadioButton statik;
    private ButtonGroup wizardSteps;
    private JLabel wizardStepsTxt;

    public WizardTypePanel(WizardDescriptor setting, DataModel data) {
        super(setting);
        this.data = data;
        this.initComponents();
        this.initAccessibility();
        this.putClientProperty("NewFileWizard_Title", WizardTypePanel.getMessage("LBL_WizardWizardTitle"));
        this.numberOfSteps.getDocument().addDocumentListener((DocumentListener)new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                WizardTypePanel.this.checkValidity();
            }
        });
    }

    @Override
    protected String getPanelName() {
        return WizardTypePanel.getMessage("LBL_WizardType_Title");
    }

    @Override
    protected void storeToDataModel() {
        this.data.setBranching(this.dynamic.isSelected());
        if (this.newFile.isSelected()) {
            this.data.setFileTemplateType(DataModel.TemplateType.FILE);
        } else if (this.newHTML4J.isSelected()) {
            this.data.setFileTemplateType(DataModel.TemplateType.HTML4J);
        } else if (this.newHTML.isSelected()) {
            this.data.setFileTemplateType(DataModel.TemplateType.HTML);
        } else {
            this.data.setFileTemplateType(DataModel.TemplateType.CUSTOM);
        }
        this.data.setNumberOfSteps(this.getNumberOfSteps());
    }

    private int getNumberOfSteps() {
        return Integer.parseInt(this.numberOfSteps.getText().trim());
    }

    @Override
    protected void readFromDataModel() {
        this.checkValidity();
        switch (this.data.getFileTemplateType()) {
            case CUSTOM: {
                this.custom.setSelected(true);
                break;
            }
            case FILE: {
                this.newFile.setSelected(true);
                break;
            }
            case HTML4J: {
                this.newHTML4J.setSelected(true);
                break;
            }
            case HTML: {
                this.newHTML.setSelected(true);
            }
        }
        this.newHTML.setEnabled(this.data.isHTMLUIPossible());
        this.newHTML4J.setEnabled(this.data.isHTMLUIPossible());
        this.typeChanged(null);
    }

    private void checkValidity() {
        if (this.numberOfSteps.getText().trim().length() == 0) {
            this.setInfo(WizardTypePanel.getMessage("MSG_EmptyNumberOfSteps"), false);
        } else if (!this.isNumberOfStepsValid()) {
            this.setError(WizardTypePanel.getMessage("MSG_IncorrectNumberOfSteps"));
        } else {
            this.markValid();
        }
    }

    private boolean isNumberOfStepsValid() {
        try {
            return this.getNumberOfSteps() > 0;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    @Override
    protected HelpCtx getHelp() {
        return new HelpCtx(WizardTypePanel.class);
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(WizardTypePanel.getMessage("ACS_WizardTypePanel"));
        this.custom.getAccessibleContext().setAccessibleDescription(WizardTypePanel.getMessage("ACS_CTL_Custom"));
        this.newFile.getAccessibleContext().setAccessibleDescription(WizardTypePanel.getMessage("ACS_CTL_NewFile"));
        this.statik.getAccessibleContext().setAccessibleDescription(WizardTypePanel.getMessage("ACS_CTL_Static"));
        this.dynamic.getAccessibleContext().setAccessibleDescription(WizardTypePanel.getMessage("ACS_CTL_Dynamic"));
        this.numberOfStepsTxt.getAccessibleContext().setAccessibleDescription(WizardTypePanel.getMessage("ACS_LBL_NumberOfSteps"));
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(WizardTypePanel.class, (String)key);
    }

    private void initComponents() {
        this.registrationType = new ButtonGroup();
        this.wizardSteps = new ButtonGroup();
        this.registrationTypeTxt = new JLabel();
        this.newHTML4J = new JRadioButton();
        this.newHTML = new JRadioButton();
        this.custom = new JRadioButton();
        this.newFile = new JRadioButton();
        this.wizardStepsTxt = new JLabel();
        this.statik = new JRadioButton();
        this.dynamic = new JRadioButton();
        this.numberOfStepsTxt = new JLabel();
        this.numberOfSteps = new JTextField();
        this.filler = new JLabel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.registrationTypeTxt, (String)NbBundle.getMessage(WizardTypePanel.class, (String)"LBL_RegistrationType"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        this.add(this.registrationTypeTxt, gridBagConstraints);
        this.registrationType.add(this.newHTML4J);
        Mnemonics.setLocalizedText((AbstractButton)this.newHTML4J, (String)NbBundle.getMessage(WizardTypePanel.class, (String)"CTL_NewHTML4J"));
        this.newHTML4J.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.newHTML4J.setMargin(new Insets(0, 0, 0, 0));
        this.newHTML4J.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizardTypePanel.this.newHTML4JtypeChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 0);
        this.add(this.newHTML4J, gridBagConstraints);
        this.registrationType.add(this.newHTML);
        Mnemonics.setLocalizedText((AbstractButton)this.newHTML, (String)NbBundle.getMessage(WizardTypePanel.class, (String)"CTL_NewHTML"));
        this.newHTML.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.newHTML.setMargin(new Insets(0, 0, 0, 0));
        this.newHTML.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizardTypePanel.this.newHTMLtypeChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 0);
        this.add(this.newHTML, gridBagConstraints);
        this.registrationType.add(this.custom);
        this.custom.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.custom, (String)NbBundle.getMessage(WizardTypePanel.class, (String)"CTL_Custom"));
        this.custom.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.custom.setMargin(new Insets(0, 0, 0, 0));
        this.custom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizardTypePanel.this.typeChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 0);
        this.add(this.custom, gridBagConstraints);
        this.registrationType.add(this.newFile);
        Mnemonics.setLocalizedText((AbstractButton)this.newFile, (String)NbBundle.getMessage(WizardTypePanel.class, (String)"CTL_NewFile"));
        this.newFile.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.newFile.setMargin(new Insets(0, 0, 0, 0));
        this.newFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WizardTypePanel.this.typeChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 0);
        this.add(this.newFile, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.wizardStepsTxt, (String)NbBundle.getMessage(WizardTypePanel.class, (String)"LBL_WizardSteps"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add(this.wizardStepsTxt, gridBagConstraints);
        this.wizardSteps.add(this.statik);
        this.statik.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.statik, (String)NbBundle.getMessage(WizardTypePanel.class, (String)"CTL_Static"));
        this.statik.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.statik.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 0, 0);
        this.add(this.statik, gridBagConstraints);
        this.wizardSteps.add(this.dynamic);
        Mnemonics.setLocalizedText((AbstractButton)this.dynamic, (String)NbBundle.getMessage(WizardTypePanel.class, (String)"CTL_Dynamic"));
        this.dynamic.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dynamic.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 18, 24, 0);
        this.add(this.dynamic, gridBagConstraints);
        this.numberOfStepsTxt.setLabelFor(this.numberOfSteps);
        Mnemonics.setLocalizedText((JLabel)this.numberOfStepsTxt, (String)NbBundle.getMessage(WizardTypePanel.class, (String)"LBL_NumberOfSteps"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 3, 0);
        this.add(this.numberOfStepsTxt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 6, 3, 0);
        this.add(this.numberOfSteps, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.filler, gridBagConstraints);
    }

    private void typeChanged(ActionEvent evt) {
        boolean isCustom = this.custom.isSelected();
        this.statik.setEnabled(isCustom);
        this.dynamic.setEnabled(isCustom);
        if (isCustom) {
            this.statik.setSelected(this.lastStaticValue);
        } else {
            this.lastStaticValue = this.statik.isSelected();
            this.dynamic.setSelected(true);
        }
        if (this.newHTML.isSelected() || this.newHTML4J.isSelected()) {
            this.numberOfSteps.setEnabled(false);
            this.numberOfSteps.setText("3");
        } else {
            this.numberOfSteps.setEnabled(true);
        }
    }

    private void newHTML4JtypeChanged(ActionEvent evt) {
        this.typeChanged(evt);
    }

    private void newHTMLtypeChanged(ActionEvent evt) {
        this.typeChanged(evt);
    }
}

