/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.testng.ui;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.filesystems.FileObject;
import org.openide.xml.XMLUtil;
import org.testng.xml.TestNGContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlSuiteHandler
extends TestNGContentHandler {
    private static final Logger LOGGER = Logger.getLogger(XmlSuiteHandler.class.getName());
    private Locator loc;
    private String suite;
    private int line;
    private int column;

    private XmlSuiteHandler(String fName, String name) {
        super(fName, false);
        this.suite = name;
    }

    public static int[] getSuiteLocation(FileObject suiteFile, String suiteName) {
        int[] location = new int[]{0, 0};
        try {
            XMLReader r = XMLUtil.createXMLReader((boolean)false, (boolean)false);
            XmlSuiteHandler sl = new XmlSuiteHandler(suiteFile.getName(), suiteName);
            r.setContentHandler((ContentHandler)((Object)sl));
            r.parse(new InputSource(suiteFile.getInputStream()));
            location[0] = sl.getLine();
            location[1] = sl.getColumn();
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        catch (SAXException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        return location;
    }

    public void setDocumentLocator(Locator locator) {
        this.loc = locator;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("test".equals(qName) && attributes != null && this.suite.equals(attributes.getValue("name"))) {
            this.line = this.loc.getLineNumber();
            this.column = this.loc.getColumnNumber() - this.suite.length() - 3;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }
}

