/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.settings;

import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JComponent;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.settings.BugtrackingOptionsPanel;
import org.netbeans.modules.bugtracking.settings.DashboardOptions;
import org.netbeans.spi.options.AdvancedOption;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class BugtrackingOptions
extends OptionsPanelController {
    private BugtrackingOptionsPanel panel;
    private boolean initialized = false;
    private Map<String, OptionsPanelController> categoryToController = new HashMap<String, OptionsPanelController>();
    private DashboardOptions tasksPanel;
    public static final String OPTIONS_PATH = "Tasks";

    public BugtrackingOptions() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.tasksPanel = new DashboardOptions();
        this.panel = new BugtrackingOptionsPanel(this.tasksPanel);
        Lookup lookup = Lookups.forPath((String)"BugtrackingOptionsDialog");
        for (AdvancedOption option : lookup.lookupAll(AdvancedOption.class)) {
            OptionsPanelController controller;
            String category = option.getDisplayName();
            try {
                controller = option.create();
            }
            catch (Throwable t) {
                BugtrackingManager.LOG.log(Level.WARNING, "Problems while creating option category : " + category, t);
                continue;
            }
            this.categoryToController.put(category, controller);
        }
    }

    public JComponent getComponent(Lookup masterLookup) {
        Set<Map.Entry<String, OptionsPanelController>> controllerEntries = this.categoryToController.entrySet();
        if (controllerEntries.isEmpty()) {
            this.panel.setPluginListVisible(false);
        } else {
            this.panel.setPluginListVisible(true);
            for (Map.Entry<String, OptionsPanelController> controllerEntry : controllerEntries) {
                this.panel.addPanel(controllerEntry.getKey(), controllerEntry.getValue().getComponent(masterLookup));
            }
        }
        return this.panel;
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        for (OptionsPanelController c : this.categoryToController.values()) {
            c.removePropertyChangeListener(l);
        }
        this.tasksPanel.getPropertySupport().removePropertyChangeListener(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        for (OptionsPanelController c : this.categoryToController.values()) {
            c.addPropertyChangeListener(l);
        }
        this.tasksPanel.getPropertySupport().addPropertyChangeListener(l);
    }

    public void update() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            it.next().update();
        }
        this.tasksPanel.update();
    }

    public void applyChanges() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            it.next().applyChanges();
        }
        this.tasksPanel.applyChanges();
    }

    public void cancel() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            it.next().cancel();
        }
        this.tasksPanel.cancel();
    }

    public boolean isValid() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            if (it.next().isValid()) continue;
            return false;
        }
        return this.tasksPanel.isDataValid();
    }

    public boolean isChanged() {
        Iterator<OptionsPanelController> it = this.categoryToController.values().iterator();
        while (it.hasNext()) {
            if (!it.next().isChanged()) continue;
            return true;
        }
        return this.tasksPanel.isChanged();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.bugtracking.settings.BugtrackingOptions");
    }
}

