/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import com.hp.hpl.jena.iri.IRI;
import com.hp.hpl.jena.iri.IRIException;
import com.hp.hpl.jena.iri.IRIFactory;
import java.io.IOException;
import nu.validator.io.DataUri;
import nu.validator.xml.ContentTypeParser;
import nu.validator.xml.TypedInputSource;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DataUriEntityResolver
implements EntityResolver {
    private final EntityResolver delegate;
    private final ErrorHandler errorHandler;
    private boolean laxContentType;
    private boolean allowRnc = false;
    private boolean allowHtml = false;
    private boolean allowXhtml = false;
    private boolean acceptAllKnownXmlTypes = false;
    private boolean allowGenericXml = true;
    private final IRIFactory iriFactory;
    private final ContentTypeParser contentTypeParser;

    public DataUriEntityResolver(EntityResolver delegate, boolean laxContentType, ErrorHandler errorHandler) {
        this.laxContentType = laxContentType;
        this.errorHandler = errorHandler;
        this.iriFactory = new IRIFactory();
        this.iriFactory.useSpecificationXMLSystemID(true);
        this.iriFactory.useSchemeSpecificRules("data", true);
        this.contentTypeParser = new ContentTypeParser(errorHandler, laxContentType, this.allowRnc, this.allowHtml, this.allowXhtml, this.acceptAllKnownXmlTypes, this.allowGenericXml);
        this.delegate = delegate;
    }

    public DataUriEntityResolver() {
        this(null, false, null);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (DataUri.startsWithData(systemId)) {
            IRI iri;
            try {
                iri = this.iriFactory.construct(systemId);
            }
            catch (IRIException e) {
                IOException ioe = (IOException)new IOException(e.getMessage()).initCause(e);
                SAXParseException spe = new SAXParseException(e.getMessage(), publicId, systemId, -1, -1, ioe);
                if (this.errorHandler != null) {
                    this.errorHandler.fatalError(spe);
                }
                throw spe;
            }
            systemId = iri.toASCIIString();
            DataUri du = new DataUri(systemId);
            TypedInputSource is = this.contentTypeParser.buildTypedInputSource(systemId, publicId, du.getContentType());
            is.setByteStream(du.getInputStream());
            return is;
        }
        if (this.delegate != null) {
            return this.delegate.resolveEntity(publicId, systemId);
        }
        throw new IOException("Unsupported URI scheme.");
    }

    public boolean isAllowRnc() {
        return this.allowRnc;
    }

    public void setAllowRnc(boolean allowRnc) {
        this.allowRnc = allowRnc;
        this.contentTypeParser.setAllowRnc(allowRnc);
    }

    public void setAllowHtml(boolean allowHtml) {
        this.allowHtml = allowHtml;
        this.contentTypeParser.setAllowHtml(allowHtml);
    }

    public boolean isAcceptAllKnownXmlTypes() {
        return this.acceptAllKnownXmlTypes;
    }

    public void setAcceptAllKnownXmlTypes(boolean acceptAllKnownXmlTypes) {
        this.acceptAllKnownXmlTypes = acceptAllKnownXmlTypes;
        this.contentTypeParser.setAcceptAllKnownXmlTypes(acceptAllKnownXmlTypes);
    }

    public boolean isAllowGenericXml() {
        return this.allowGenericXml;
    }

    public void setAllowGenericXml(boolean allowGenericXml) {
        this.allowGenericXml = allowGenericXml;
        this.contentTypeParser.setAllowGenericXml(allowGenericXml);
    }

    public boolean isAllowXhtml() {
        return this.allowXhtml;
    }

    public void setAllowXhtml(boolean allowXhtml) {
        this.allowXhtml = allowXhtml;
        this.contentTypeParser.setAllowXhtml(allowXhtml);
    }

    public boolean isAllowHtml() {
        return this.allowHtml;
    }

    public boolean isOnlyHtmlAllowed() {
        return !this.isAllowGenericXml() && !this.isAllowRnc() && !this.isAllowXhtml();
    }
}

