/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.options;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.options.AnnotationExpression;
import org.netbeans.modules.subversion.options.AnnotationSettingsPanel;
import org.netbeans.modules.subversion.options.EditAnnotationPanel;
import org.netbeans.modules.subversion.options.SvnOptionsController;
import org.netbeans.modules.subversion.ui.wizards.URLPatternWizard;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AnnotationSettings
implements ActionListener,
TableModelListener,
ListSelectionListener {
    private final AnnotationSettingsPanel panel = new AnnotationSettingsPanel();
    private DialogDescriptor dialogDescriptor;
    private boolean valid;

    public AnnotationSettings() {
        this.getModel().addTableModelListener(this);
        this.getSelectionModel().addListSelectionListener(this);
        this.panel.upButton.setEnabled(false);
        this.panel.downButton.setEnabled(false);
        this.panel.removeButton.setEnabled(false);
        this.panel.editButton.setEnabled(false);
        this.panel.upButton.addActionListener(this);
        this.panel.downButton.addActionListener(this);
        this.panel.newButton.addActionListener(this);
        this.panel.removeButton.addActionListener(this);
        this.panel.editButton.addActionListener(this);
        this.panel.resetButton.addActionListener(this);
        this.panel.wizardButton.addActionListener(this);
        this.panel.warningLabel.setVisible(false);
    }

    private void setValid(boolean valid) {
        if (!valid) {
            this.panel.warningLabel.setText(NbBundle.getMessage(AnnotationSettings.class, (String)"MSG_MissingFolderVariable"));
        }
        this.panel.warningLabel.setVisible(!valid);
        this.panel.upButton.setVisible(valid);
        this.panel.downButton.setVisible(valid);
        this.panel.newButton.setVisible(valid);
        this.panel.removeButton.setVisible(valid);
        this.panel.editButton.setVisible(valid);
        this.panel.resetButton.setVisible(valid);
        this.panel.wizardButton.setVisible(valid);
        this.panel.expresionsTable.setVisible(valid);
        this.panel.expressionsPane.setVisible(valid);
        this.panel.tableLabel.setVisible(valid);
    }

    JPanel getPanel() {
        return this.panel;
    }

    void show(boolean valid) {
        this.setValid(valid);
        String title = NbBundle.getMessage(SvnOptionsController.class, (String)"CTL_ManageLabels");
        String accesibleDescription = NbBundle.getMessage(SvnOptionsController.class, (String)"ACSD_ManageLabels");
        HelpCtx helpCtx = new HelpCtx(AnnotationSettings.class);
        this.dialogDescriptor = new DialogDescriptor((Object)this.panel, title);
        this.dialogDescriptor.setModal(true);
        this.dialogDescriptor.setHelpCtx(helpCtx);
        this.dialogDescriptor.setValid(valid);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(this.dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleDescription(accesibleDescription);
        dialog.setAlwaysOnTop(false);
        dialog.setVisible(true);
    }

    void update() {
        this.reset(SvnModuleConfig.getDefault().getAnnotationExpresions());
    }

    boolean isChanged() {
        List<AnnotationExpression> expressions;
        List<AnnotationExpression> storedExpressions = SvnModuleConfig.getDefault().getAnnotationExpresions();
        return !SvnUtils.equals(storedExpressions, expressions = this.getAnnotationExpressions());
    }

    void applyChanges() {
        List<AnnotationExpression> exps = this.getAnnotationExpressions();
        SvnModuleConfig.getDefault().setAnnotationExpresions(exps);
    }

    private List<AnnotationExpression> getAnnotationExpressions() {
        TableModel model = this.panel.expresionsTable.getModel();
        ArrayList<AnnotationExpression> exps = new ArrayList<AnnotationExpression>(model.getRowCount());
        for (int r = 0; r < model.getRowCount(); ++r) {
            String urlExp = (String)model.getValueAt(r, 0);
            if (urlExp.trim().equals("")) continue;
            String annotationExp = (String)model.getValueAt(r, 1);
            exps.add(new AnnotationExpression(urlExp, annotationExp));
        }
        return exps;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource() == this.panel.upButton) {
            this.onUpClick();
        } else if (evt.getSource() == this.panel.downButton) {
            this.onDownClick();
        } else if (evt.getSource() == this.panel.newButton) {
            this.onNewClick();
        } else if (evt.getSource() == this.panel.removeButton) {
            this.onRemoveClick();
        } else if (evt.getSource() == this.panel.editButton) {
            this.onEditClick();
        } else if (evt.getSource() == this.panel.resetButton) {
            this.onResetClick();
        } else if (evt.getSource() == this.panel.wizardButton) {
            this.onWizardClick();
        }
    }

    private void onUpClick() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int r = listSelectionModel.getMinSelectionIndex();
        if (r > 0) {
            DefaultTableModel model = this.getModel();
            int rNew = r - 1;
            model.moveRow(r, r, rNew);
            listSelectionModel.setSelectionInterval(rNew, rNew);
        }
    }

    private void onDownClick() {
        ListSelectionModel listSelectionModel = this.getSelectionModel();
        int r = listSelectionModel.getMinSelectionIndex();
        DefaultTableModel model = this.getModel();
        if (r > -1 && r < model.getRowCount() - 1) {
            int rNew = r + 1;
            model.moveRow(r, r, rNew);
            listSelectionModel.setSelectionInterval(rNew, rNew);
        }
    }

    private void onNewClick() {
        EditAnnotationPanel editPanel = new EditAnnotationPanel();
        String title = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.new.title");
        if (this.showEdit(editPanel, title)) {
            this.addRow(editPanel.patternTextField.getText(), editPanel.folderTextField.getText());
        }
    }

    private void addRow(String pattern, String folder) {
        int r = this.getSelectionModel().getMinSelectionIndex();
        if (r < 0) {
            this.getModel().addRow(new String[]{pattern, folder});
        } else {
            this.getModel().insertRow(r, new String[]{pattern, folder});
        }
    }

    private void onRemoveClick() {
        int size;
        ListSelectionModel selectionModel = this.getSelectionModel();
        int r = selectionModel.getMinSelectionIndex();
        if (r > -1) {
            this.getModel().removeRow(r);
        }
        if ((size = this.getModel().getRowCount()) > 0) {
            if (r > size - 1) {
                r = size - 1;
            }
            selectionModel.setSelectionInterval(r, r);
        }
    }

    private void onEditClick() {
        String title;
        ListSelectionModel selectionModel = this.getSelectionModel();
        int r = selectionModel.getMinSelectionIndex();
        if (r < 0) {
            return;
        }
        String pattern = (String)this.getModel().getValueAt(r, 0);
        String folder = (String)this.getModel().getValueAt(r, 1);
        EditAnnotationPanel editPanel = new EditAnnotationPanel();
        if (pattern != null) {
            editPanel.patternTextField.setText(pattern);
        }
        if (folder != null) {
            editPanel.folderTextField.setText(folder);
        }
        if (this.showEdit(editPanel, title = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettings.edit.title"))) {
            this.getModel().setValueAt(editPanel.patternTextField.getText(), r, 0);
            this.getModel().setValueAt(editPanel.folderTextField.getText(), r, 1);
        }
    }

    private void onResetClick() {
        this.reset(SvnModuleConfig.getDefault().getDefaultAnnotationExpresions());
    }

    private void onWizardClick() {
        URLPatternWizard wizard = new URLPatternWizard();
        if (!wizard.show()) {
            return;
        }
        String pattern = wizard.getPattern();
        String folder = wizard.useName() ? wizard.getRepositoryFolder() : "\\1";
        this.addRow(pattern, folder);
    }

    private void reset(List<AnnotationExpression> exps) {
        this.getSelectionModel().setSelectionMode(0);
        DefaultTableModel model = this.getModel();
        model.setColumnCount(2);
        model.setRowCount(exps.size());
        int r = -1;
        for (AnnotationExpression annotationExpression : exps) {
            model.setValueAt(annotationExpression.getUrlExp(), ++r, 0);
            model.setValueAt(annotationExpression.getAnnotationExp(), r, 1);
        }
    }

    private DefaultTableModel getModel() {
        return (DefaultTableModel)this.panel.expresionsTable.getModel();
    }

    private ListSelectionModel getSelectionModel() {
        return this.panel.expresionsTable.getSelectionModel();
    }

    @Override
    public void tableChanged(TableModelEvent evt) {
        if (evt.getType() == 0) {
            this.validateTable(evt.getFirstRow(), evt.getColumn());
        }
    }

    private void validateTable(int r, int c) {
        if (r < 0 || c != 0) {
            return;
        }
        this.valid = true;
        String pattern = (String)this.getModel().getValueAt(r, c);
        try {
            Pattern.compile(pattern);
        }
        catch (Exception e) {
            this.valid = false;
        }
        if (this.valid) {
            this.panel.warningLabel.setVisible(false);
        } else {
            String label = NbBundle.getMessage(AnnotationSettings.class, (String)"AnnotationSettingsPanel.warningLabel.text", (Object)pattern);
            this.panel.warningLabel.setText(label);
            this.panel.warningLabel.setVisible(true);
        }
        if (this.dialogDescriptor != null) {
            this.dialogDescriptor.setValid(this.valid);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        ListSelectionModel selectionModel = this.getSelectionModel();
        int r = selectionModel.getMinSelectionIndex();
        this.panel.upButton.setEnabled(r > 0);
        this.panel.downButton.setEnabled(r > -1 && r < this.getModel().getRowCount() - 1);
        this.panel.removeButton.setEnabled(r > -1);
        this.panel.editButton.setEnabled(r > -1);
    }

    private boolean showEdit(final EditAnnotationPanel editPanel, String title) {
        final DialogDescriptor dd = new DialogDescriptor((Object)editPanel, title);
        dd.setModal(true);
        dd.setValid(this.isValid(editPanel));
        DocumentListener dl = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                this.validate();
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                this.validate();
            }

            @Override
            public void changedUpdate(DocumentEvent arg0) {
                this.validate();
            }

            private void validate() {
                dd.setValid(AnnotationSettings.this.isValid(editPanel));
            }
        };
        editPanel.patternTextField.getDocument().addDocumentListener(dl);
        editPanel.folderTextField.getDocument().addDocumentListener(dl);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        dialog.setVisible(true);
        return dd.getValue() == DialogDescriptor.OK_OPTION;
    }

    private boolean isValid(EditAnnotationPanel editPanel) {
        return !editPanel.patternTextField.getText().trim().equals("") && !editPanel.folderTextField.getText().trim().equals("");
    }
}

