/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.filters.GenericFilter;
import org.netbeans.lib.profiler.filters.InstrumentationFilter;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.memory.MemoryCCTProvider;
import org.netbeans.lib.profiler.results.memory.MemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.memory.LiveMemoryView;
import org.netbeans.lib.profiler.ui.memory.MemoryView;
import org.openide.util.Lookup;

public class LiveMemoryViewUpdater {
    private static final int MIN_UPDATE_DIFF = 900;
    private static final int MAX_UPDATE_DIFF = 1400;
    private CCTHandler handler;
    private final LiveMemoryView memoryView;
    private final ProfilerClient client;
    private volatile boolean paused;
    private volatile boolean forceRefresh;

    public LiveMemoryViewUpdater(LiveMemoryView memoryView, ProfilerClient client) {
        this.memoryView = memoryView;
        this.client = client;
        this.handler = CCTHandler.registerUpdater(this);
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setForceRefresh(boolean forceRefresh) {
        this.forceRefresh = forceRefresh;
    }

    public void update() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.forceRefresh || !this.paused && this.memoryView.getLastUpdate() + 1400L < System.currentTimeMillis()) {
            switch (this.client.getCurrentInstrType()) {
                case 7: {
                    this.updateData();
                    break;
                }
                case 5: 
                case 6: {
                    if (this.memoryView.getLastUpdate() + 1400L >= System.currentTimeMillis()) break;
                    this.client.forceObtainedResultsDump(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid profiling instr. type: " + this.client.getCurrentInstrType());
                }
            }
        }
    }

    public void cleanup() {
        this.handler.unregisterUpdater(this);
        this.handler = null;
    }

    private void updateData() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.forceRefresh && (this.paused || this.memoryView.getLastUpdate() + 900L > System.currentTimeMillis())) {
            return;
        }
        MemoryResultsSnapshot snapshot = this.client.getMemoryProfilingResultsSnapshot(false);
        MemoryView.userFormClassNames(snapshot);
        InstrumentationFilter filter = this.client.getSettings().getInstrumentationFilter();
        this.memoryView.setData(snapshot, (GenericFilter)filter);
        this.forceRefresh = false;
    }

    private void resetData() {
        this.memoryView.resetData();
    }

    public static final class CCTHandler
    implements MemoryCCTProvider.Listener {
        private final List<LiveMemoryViewUpdater> updaters = new ArrayList<LiveMemoryViewUpdater>();

        public static CCTHandler registerUpdater(LiveMemoryViewUpdater updater) {
            CCTHandler handler = (CCTHandler)Lookup.getDefault().lookup(CCTHandler.class);
            handler.updaters.add(updater);
            return handler;
        }

        public void unregisterUpdater(LiveMemoryViewUpdater updater) {
            this.updaters.remove(updater);
        }

        public void cctEstablished(RuntimeCCTNode appRootNode, boolean empty) {
            if (!empty) {
                for (LiveMemoryViewUpdater updater : this.updaters) {
                    try {
                        updater.updateData();
                    }
                    catch (ClientUtils.TargetAppOrVMTerminated ex) {
                        Logger.getLogger(LiveMemoryView.class.getName()).log(Level.FINE, null, ex);
                    }
                }
            }
        }

        public void cctReset() {
            for (LiveMemoryViewUpdater updater : this.updaters) {
                updater.resetData();
            }
        }
    }
}

