/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.lib.api.foreign;

import java.io.IOException;
import java.io.Reader;

public class CharSequenceReader
extends Reader {
    protected CharSequence source;
    protected int length;
    protected int next = 0;
    private int mark = 0;

    public CharSequenceReader(CharSequence immutableCharSequence) {
        this.source = immutableCharSequence;
        this.length = this.source.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.next >= this.length) {
                return -1;
            }
            char c = this.source.charAt(this.next++);
            return this.processReadChar(c);
        }
    }

    protected char processReadChar(char c) throws IOException {
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            if (this.next >= this.length) {
                return -1;
            }
            int n = Math.min(this.length - this.next, len);
            for (int i = 0; i < n; ++i) {
                cbuf[i + off] = (char)this.read();
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long ns) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.next >= this.length) {
                return 0L;
            }
            long n = Math.min((long)(this.length - this.next), ns);
            n = Math.max((long)(-this.next), n);
            this.next = (int)((long)this.next + n);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return true;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    protected void markedAt(int mark) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (readAheadLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit < 0");
        }
        Object object = this.lock;
        synchronized (object) {
            this.mark = this.next;
            this.markedAt(this.mark);
        }
    }

    protected void inputReset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.next = this.mark;
            this.inputReset();
        }
    }

    @Override
    public void close() {
    }
}

