# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.render_pass import RenderPass


class ClientServerCompositePass(RenderPass):
    """
    ClientServerCompositePass - ClientServerCompositePass is a
    render-pass that can handle client-server image delivery.
    
    Superclass: RenderPass
    
    This is designed to be used in configurations in two-processes
    configurations.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkClientServerCompositePass, obj, update, **traits)
    
    process_is_server = tvtk_base.false_bool_trait(desc=\
        """
        Set the current process type. This is needed since when using the
        socket communicator there's no easy way of determining which
        process is the server and which one is the client.
        """
    )

    def _process_is_server_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetProcessIsServer,
                        self.process_is_server_)

    server_side_rendering = tvtk_base.true_bool_trait(desc=\
        """
        Enable/Disable fetching of the image from the server side to the
        client. If this flag is disabled, then this pass just acts as a
        "pass-through" pass. This flag must be set to the same value on
        both the processes.
        """
    )

    def _server_side_rendering_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetServerSideRendering,
                        self.server_side_rendering_)

    def _get_controller(self):
        return wrap_vtk(self._vtk_obj.GetController())
    def _set_controller(self, arg):
        old_val = self._get_controller()
        self._wrap_call(self._vtk_obj.SetController,
                        deref_vtk(arg))
        self.trait_property_changed('controller', old_val, arg)
    controller = traits.Property(_get_controller, _set_controller, desc=\
        """
        Controller If it is NULL, nothing will be rendered and a warning
        will be emitted. Initial value is a NULL pointer. This must be
        set to the socket controller used for communicating between the
        client and the server.
        """
    )

    def _get_post_processing_render_pass(self):
        return wrap_vtk(self._vtk_obj.GetPostProcessingRenderPass())
    def _set_post_processing_render_pass(self, arg):
        old_val = self._get_post_processing_render_pass()
        self._wrap_call(self._vtk_obj.SetPostProcessingRenderPass,
                        deref_vtk(arg))
        self.trait_property_changed('post_processing_render_pass', old_val, arg)
    post_processing_render_pass = traits.Property(_get_post_processing_render_pass, _set_post_processing_render_pass, desc=\
        """
        Set/Get the optional post-fetch render pass. On the
        client-process this is called after the server-side image is
        fetched (if server_side_rendering is true). On server-process, this
        is called after the image rendered by this->_render_pass is
        delivered to the client (if server_side_rendering is true). This is
        optional, so you can set this either on one of the two processes
        or both or neither.
        """
    )

    def _get_render_pass(self):
        return wrap_vtk(self._vtk_obj.GetRenderPass())
    def _set_render_pass(self, arg):
        old_val = self._get_render_pass()
        self._wrap_call(self._vtk_obj.SetRenderPass,
                        deref_vtk(arg))
        self.trait_property_changed('render_pass', old_val, arg)
    render_pass = traits.Property(_get_render_pass, _set_render_pass, desc=\
        """
        Get/Set the render pass used to do the actual rendering. When
        server_side_rendering is true, the rendering-pass is called only on
        the server side.
        """
    )

    _updateable_traits_ = \
    (('process_is_server', 'GetProcessIsServer'),
    ('server_side_rendering', 'GetServerSideRendering'), ('debug',
    'GetDebug'), ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'process_is_server',
    'server_side_rendering'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ClientServerCompositePass, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ClientServerCompositePass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['process_is_server', 'server_side_rendering'], [], []),
            title='Edit ClientServerCompositePass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ClientServerCompositePass properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

