/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.CommDriver;
import gnu.io.CommPort;
import gnu.io.CommPortIdentifier;
import gnu.io.LPRPort;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.RXTXVersion;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;

public class RXTXCommDriver
implements CommDriver {
    private static final boolean debug = false;
    private static final boolean devel = false;
    private static final boolean noVersionOutput;
    private String deviceDirectory;
    private String osName;

    private native boolean registerKnownPorts(int var1);

    private native boolean isPortPrefixValid(String var1);

    private native boolean testRead(String var1, int var2);

    private native String getDeviceDirectory();

    public static native String nativeGetVersion();

    private final String[] getValidPortPrefixes(String[] stringArray) {
        String[] stringArray2 = new String[256];
        if (stringArray == null) {
            // empty if block
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isPortPrefixValid(stringArray[i])) continue;
            stringArray2[n++] = stringArray[i];
        }
        String[] stringArray3 = new String[n];
        System.arraycopy(stringArray2, 0, stringArray3, 0, n);
        if (stringArray2[0] == null) {
            // empty if block
        }
        return stringArray3;
    }

    private void checkSolaris(String string, int n) {
        char[] cArray = new char[]{'['};
        cArray[0] = 97;
        while (cArray[0] < '{') {
            if (this.testRead(string.concat(new String(cArray)), n)) {
                CommPortIdentifier.addPortName(string.concat(new String(cArray)), n, this);
            }
            cArray[0] = (char)(cArray[0] + '\u0001');
        }
        cArray[0] = 48;
        while (cArray[0] <= '9') {
            if (this.testRead(string.concat(new String(cArray)), n)) {
                CommPortIdentifier.addPortName(string.concat(new String(cArray)), n, this);
            }
            cArray[0] = (char)(cArray[0] + '\u0001');
        }
    }

    private void registerValidPorts(String[] stringArray, String[] stringArray2, int n) {
        int n2 = 0;
        int n3 = 0;
        if (stringArray != null && stringArray2 != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                for (n3 = 0; n3 < stringArray2.length; ++n3) {
                    String string = stringArray2[n3];
                    int n4 = string.length();
                    String string2 = stringArray[n2];
                    if (string2.length() < n4) continue;
                    String string3 = string2.substring(n4).toUpperCase();
                    String string4 = string2.substring(n4).toLowerCase();
                    if (!string2.regionMatches(0, string, 0, n4) || !string3.equals(string4)) continue;
                    String string5 = this.osName.toLowerCase().indexOf("windows") == -1 ? this.deviceDirectory + string2 : string2;
                    if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
                        this.checkSolaris(string5, n);
                        continue;
                    }
                    if (!this.testRead(string5, n)) continue;
                    CommPortIdentifier.addPortName(string5, n, this);
                }
            }
        }
    }

    @Override
    public void initialize() {
        this.osName = System.getProperty("os.name");
        this.deviceDirectory = this.getDeviceDirectory();
        for (int i = 1; i <= 2; ++i) {
            if (this.registerSpecifiedPorts(i) || this.registerKnownPorts(i)) continue;
            this.registerScannedPorts(i);
        }
    }

    private void addSpecifiedPorts(String string, int n) {
        String string2 = System.getProperty("path.separator", ":");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            if (!this.testRead(string3, n)) continue;
            CommPortIdentifier.addPortName(string3, n, this);
        }
    }

    private boolean registerSpecifiedPorts(int n) {
        String string = null;
        Properties properties = System.getProperties();
        try {
            String string2 = System.getProperty("java.ext.dirs") + System.getProperty("file.separator");
            FileInputStream fileInputStream = new FileInputStream(string2 + "gnu.io.rxtx.properties");
            Properties properties2 = new Properties();
            properties2.load(fileInputStream);
            System.setProperties(properties2);
            for (String string3 : properties2.keySet()) {
                System.setProperty(string3, properties2.getProperty(string3));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        switch (n) {
            case 1: {
                string = System.getProperty("gnu.io.rxtx.SerialPorts");
                if (string != null) break;
                string = System.getProperty("gnu.io.SerialPorts");
                break;
            }
            case 2: {
                string = System.getProperty("gnu.io.rxtx.ParallelPorts");
                if (string != null) break;
                string = System.getProperty("gnu.io.ParallelPorts");
                break;
            }
        }
        System.setProperties(properties);
        if (string != null) {
            this.addSpecifiedPorts(string, n);
            return true;
        }
        return false;
    }

    private void registerScannedPorts(int n) {
        Object object;
        Object object2;
        if (this.osName.equals("Windows CE")) {
            object2 = new String[]{"COM1:", "COM2:", "COM3:", "COM4:", "COM5:", "COM6:", "COM7:", "COM8:"};
            object = object2;
        } else if (this.osName.toLowerCase().indexOf("windows") != -1) {
            int n2;
            object2 = new String[259];
            for (n2 = 1; n2 <= 256; ++n2) {
                object2[n2 - 1] = "COM" + n2;
            }
            for (n2 = 1; n2 <= 3; ++n2) {
                object2[n2 + 255] = "LPT" + n2;
            }
            object = object2;
        } else if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
            object2 = new String[2];
            int n3 = 0;
            File file = null;
            file = new File("/dev/term");
            if (file.list().length > 0) {
                object2[n3++] = "term/";
            }
            String[] stringArray = new String[n3];
            --n3;
            while (n3 >= 0) {
                stringArray[n3] = object2[n3];
                --n3;
            }
            object = stringArray;
        } else {
            object2 = new File(this.deviceDirectory);
            String[] stringArray = ((File)object2).list();
            object = stringArray;
        }
        if (object == null) {
            return;
        }
        object2 = new String[]{};
        switch (n) {
            case 1: {
                if (this.osName.equals("Linux")) {
                    String[] stringArray = new String[]{"ttySA", "comx", "holter", "modem", "rfcomm", "ttyircomm", "ttycosa0c", "ttycosa1c", "ttyACM", "ttyC", "ttyCH", "ttyD", "ttyE", "ttyF", "ttyH", "ttyI", "ttyL", "ttyM", "ttyMX", "ttyP", "ttyR", "ttyS", "ttySI", "ttySR", "ttyT", "ttyUSB", "ttyV", "ttyW", "ttyX"};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("qnx") != -1) {
                    String[] stringArray = new String[]{"ser"};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.equals("Irix")) {
                    String[] stringArray = new String[]{"ttyc", "ttyd", "ttyf", "ttym", "ttyq", "tty4d", "tty4f", "midi", "us"};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.equals("FreeBSD")) {
                    String[] stringArray = new String[]{"ttyd", "cuaa", "ttyA", "cuaA", "ttyD", "cuaD", "ttyE", "cuaE", "ttyF", "cuaF", "ttyR", "cuaR", "stl"};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.equals("NetBSD")) {
                    String[] stringArray = new String[]{"tty0"};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.equals("Solaris") || this.osName.equals("SunOS")) {
                    String[] stringArray = new String[]{"term/", "cua/"};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.equals("HP-UX")) {
                    String[] stringArray = new String[]{"tty0p", "tty1p"};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.equals("UnixWare") || this.osName.equals("OpenUNIX")) {
                    String[] stringArray = new String[]{"tty00s", "tty01s", "tty02s", "tty03s"};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.equals("OpenServer")) {
                    String[] stringArray = new String[]{"tty1A", "tty2A", "tty3A", "tty4A", "tty5A", "tty6A", "tty7A", "tty8A", "tty9A", "tty10A", "tty11A", "tty12A", "tty13A", "tty14A", "tty15A", "tty16A", "ttyu1A", "ttyu2A", "ttyu3A", "ttyu4A", "ttyu5A", "ttyu6A", "ttyu7A", "ttyu8A", "ttyu9A", "ttyu10A", "ttyu11A", "ttyu12A", "ttyu13A", "ttyu14A", "ttyu15A", "ttyu16A"};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.equals("Compaq's Digital UNIX") || this.osName.equals("OSF1")) {
                    String[] stringArray = new String[]{"tty0"};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.equals("BeOS")) {
                    String[] stringArray = new String[]{"serial"};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.equals("Mac OS X")) {
                    String[] stringArray = new String[]{"cu.KeyUSA28X191.", "tty.KeyUSA28X191.", "cu.KeyUSA28X181.", "tty.KeyUSA28X181.", "cu.KeyUSA19181.", "tty.KeyUSA19181."};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("windows") == -1) break;
                String[] stringArray = new String[]{"COM"};
                object2 = stringArray;
                break;
            }
            case 2: {
                if (this.osName.equals("Linux")) {
                    String[] stringArray = new String[]{"lp"};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.equals("FreeBSD")) {
                    String[] stringArray = new String[]{"lpt"};
                    object2 = stringArray;
                    break;
                }
                if (this.osName.toLowerCase().indexOf("windows") != -1) {
                    String[] stringArray = new String[]{"LPT"};
                    object2 = stringArray;
                    break;
                }
                String[] stringArray = new String[]{};
                object2 = stringArray;
                break;
            }
        }
        this.registerValidPorts((String[])object, (String[])object2, n);
    }

    @Override
    public CommPort getCommPort(String string, int n) {
        try {
            switch (n) {
                case 1: {
                    if (this.osName.toLowerCase().indexOf("windows") == -1) {
                        return new RXTXPort(string);
                    }
                    return new RXTXPort(this.deviceDirectory + string);
                }
                case 2: {
                    return new LPRPort(string);
                }
            }
        }
        catch (PortInUseException portInUseException) {
            // empty catch block
        }
        return null;
    }

    public void Report(String string) {
        System.out.println(string);
    }

    static {
        String string;
        noVersionOutput = "true".equals(System.getProperty("gnu.io.rxtx.NoVersionOutput"));
        System.loadLibrary("rxtxSerial");
        String string2 = RXTXVersion.getVersion();
        try {
            string = RXTXVersion.nativeGetVersion();
        }
        catch (Error error) {
            string = RXTXCommDriver.nativeGetVersion();
        }
        if (!string2.equals(string)) {
            System.out.println("WARNING:  RXTX Version mismatch\n\tJar version = " + string2 + "\n\tnative lib Version = " + string);
        }
    }
}

