/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ExternalSourceModule;
import org.eclipse.dltk.ti.types.IEvaluatedType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.php.core.ast.nodes.IMethodBinding;
import org.eclipse.php.core.ast.nodes.ITypeBinding;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.ast.nodes.TypeBinding;
import org.eclipse.php.core.compiler.PHPFlags;
import org.eclipse.php.internal.core.typeinference.PHPClassType;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.actions.AddUnimplementedMethodsOperation;
import org.eclipse.php.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.php.internal.ui.dialogs.OverrideMethodDialog;
import org.eclipse.php.internal.ui.editor.PHPStructuredEditor;
import org.eclipse.php.internal.ui.handlers.Messages;
import org.eclipse.php.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.php.ui.util.CodeGenerationUtils;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.handlers.HandlerUtil;

public class OverrideImplementHandler
extends AbstractHandler {
    private static final String DIALOG_TITLE = Messages.OverrideImplementHandler_0;
    private IWorkbenchWindow fWindow;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.fWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        if (selection instanceof IStructuredSelection) {
            this.execute(event, (IStructuredSelection)selection);
        } else if (selection instanceof ITextSelection) {
            this.execute(event, (ITextSelection)selection);
        }
        return null;
    }

    private void execute(ExecutionEvent event, IStructuredSelection selection) throws ExecutionException {
        Object object = selection.getFirstElement();
        if (object instanceof IModelElement) {
            IModelElement element = (IModelElement)object;
            if (element.getOpenable() instanceof ExternalSourceModule) {
                MessageDialog.openError((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.OverrideImplementHandler_1);
                return;
            }
            try {
                IEditorPart editor = CodeGenerationUtils.openInEditor(element, true);
                if (editor instanceof PHPStructuredEditor) {
                    this.run((ISourceModule)((PHPStructuredEditor)editor).getModelElement(), element, (TextEditor)((PHPStructuredEditor)editor));
                }
            }
            catch (PartInitException e) {
                MessageDialog.openError((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.OverrideImplementHandler_1);
                throw new ExecutionException(Messages.OverrideImplementHandler_2, (Throwable)e);
            }
            catch (ModelException e) {
                PHPUiPlugin.log(e);
            }
        }
    }

    private void execute(ExecutionEvent event, ITextSelection selection) throws ExecutionException {
        PHPStructuredEditor editor = CodeGenerationUtils.getPHPEditor(event);
        if (editor == null) {
            return;
        }
        IModelElement source = editor.getModelElement();
        if (!(source instanceof ISourceModule)) {
            MessageDialog.openError((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.OverrideImplementHandler_3);
            return;
        }
        if (source instanceof ExternalSourceModule) {
            MessageDialog.openError((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.OverrideImplementHandler_1);
            return;
        }
        IModelElement element = CodeGenerationUtils.getCurrentModelElement(source, editor, selection);
        if (element == null) {
            element = CodeGenerationUtils.getCurrentModelElement(event);
        }
        try {
            this.run((ISourceModule)source, element, (TextEditor)editor);
        }
        catch (ModelException e) {
            PHPUiPlugin.log(e);
        }
    }

    private void run(ISourceModule source, IModelElement element, TextEditor editor) throws ModelException {
        IType type = CodeGenerationUtils.getType(element);
        if (type == null) {
            MessageDialog.openError((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.OverrideImplementHandler_4);
            return;
        }
        int flags = type.getFlags();
        if (PHPFlags.isInterface((int)flags)) {
            MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.OverrideImplementHandler_5);
            return;
        }
        OverrideMethodDialog dialog = new OverrideMethodDialog(this.fWindow.getShell(), editor, type, false);
        dialog.setProject(source.getScriptProject().getProject());
        if (!dialog.hasMethodsToOverride()) {
            MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)Messages.OverrideImplementHandler_6, (String)Messages.OverrideImplementHandler_7);
            return;
        }
        if (dialog.open() != 0 || dialog.getResult() == null) {
            return;
        }
        Object[] selected = dialog.getResult();
        ArrayList<Object> methods = new ArrayList<Object>();
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object elem = objectArray[n2];
            if (elem instanceof IMethodBinding) {
                methods.add(elem);
            }
            ++n2;
        }
        IMethodBinding[] methodToOverride = methods.toArray(new IMethodBinding[methods.size()]);
        IRewriteTarget target = (IRewriteTarget)editor.getAdapter(IRewriteTarget.class);
        if (target != null) {
            target.setRedraw(false);
            target.beginCompoundChange();
        }
        try {
            try {
                Program astRoot = dialog.getCompilationUnit();
                PHPClassType evaluatedType = PHPClassType.fromIType((IType)type);
                TypeBinding typeBinding = new TypeBinding(astRoot.getAST().getBindingResolver(), (IEvaluatedType)evaluatedType, (IModelElement)type);
                int insertPos = dialog.getInsertOffset();
                IDocument document = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
                AddUnimplementedMethodsOperation operation = this.createRunnable(astRoot, type, (ITypeBinding)typeBinding, methodToOverride, insertPos, dialog.getGenerateComment(), document);
                Object context = PHPUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
                if (context == null) {
                    context = new BusyIndicatorRunnableContext();
                }
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation, operation.getSchedulingRule()), operation.getSchedulingRule());
                String[] created = operation.getCreatedMethods();
                if (created == null || created.length == 0) {
                    MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.OverrideImplementHandler_8);
                }
            }
            catch (InvocationTargetException exception) {
                MessageDialog.openInformation((Shell)this.fWindow.getShell(), (String)DIALOG_TITLE, (String)Messages.OverrideImplementHandler_9);
                PHPUiPlugin.log(exception);
                if (target != null) {
                    target.setRedraw(true);
                    target.endCompoundChange();
                }
            }
            catch (InterruptedException interruptedException) {
                if (target != null) {
                    target.setRedraw(true);
                    target.endCompoundChange();
                }
            }
        }
        finally {
            if (target != null) {
                target.setRedraw(true);
                target.endCompoundChange();
            }
        }
    }

    private AddUnimplementedMethodsOperation createRunnable(Program astRoot, IType element, ITypeBinding typeBinding, IMethodBinding[] methodToOverride, int insertPos, boolean generateComment, IDocument doc) {
        AddUnimplementedMethodsOperation operation = new AddUnimplementedMethodsOperation(astRoot, element, typeBinding, methodToOverride, insertPos, true, doc);
        operation.setCreateComments(generateComment);
        return operation;
    }
}

