/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.utilities;

import java.io.InputStream;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebugUtilities {
    private static final Logger LOG = LoggerFactory.getLogger(DebugUtilities.class);
    public static String SEP = System.getProperty("line.separator");

    public static String dumpProjectState(String startMessage, IProject project) {
        StringBuilder dump = new StringBuilder(startMessage == null ? "" : startMessage);
        dump.append("Current ").append(Thread.currentThread()).append(SEP);
        String projectName = project.getName();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            dump.append(projectName).append(" is not a IVirtualComponent").append(SEP);
        } else {
            dump.append(projectName).append(" is a ").append(component.getClass().getSimpleName()).append(SEP);
            dump.append("Underlying resources for the root folder are :").append(SEP);
            IResource[] iResourceArray = component.getRootFolder().getUnderlyingResources();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                dump.append("  -").append(resource.getFullPath().append(SEP));
                ++n2;
            }
            dump.append("deploy-name = ").append(component.getDeployedName()).append(SEP);
            DebugUtilities.dumpFile(dump, project.getFile(".settings/org.eclipse.wst.common.component"));
        }
        boolean hasModulecoreNature = ModuleCoreNature.getModuleCoreNature((IProject)project) != null;
        boolean isFlexible = ModuleCoreNature.isFlexibleProject((IProject)project);
        dump.append(projectName).append(" hasModuleCoreNature:").append(hasModulecoreNature).append(", isFlexible:").append(isFlexible).append(SEP);
        DebugUtilities.dumpFacetInformations(project, dump);
        return dump.toString();
    }

    private static void dumpFacetInformations(IProject project, StringBuilder dump) {
        try {
            IFacetedProject fProj = ProjectFacetsManager.create((IProject)project);
            if (fProj == null) {
                dump.append(project.getName()).append(" is not a faceted project").append(SEP);
            } else {
                for (IProjectFacet facet : ProjectFacetsManager.getProjectFacets()) {
                    if (!fProj.hasProjectFacet(facet)) continue;
                    dump.append("  - has ").append(fProj.getInstalledVersion(facet)).append(" facet").append(SEP);
                }
            }
        }
        catch (CoreException ex) {
            dump.append("An exception occured while accessing facet informations ").append(ex.getMessage()).append(SEP);
        }
    }

    private static void dumpFile(StringBuilder dump, IFile file) {
        block6: {
            if (!file.exists()) {
                dump.append(file.getFullPath()).append(" does not exist").append(SEP);
                return;
            }
            InputStream ins = null;
            try {
                try {
                    dump.append("Contents of ").append(file.getFullPath()).append(SEP);
                    ins = file.getContents();
                    dump.append(IOUtil.toString((InputStream)ins));
                }
                catch (Exception e) {
                    dump.append("An exception occured while reading ").append(file.getFullPath()).append(" :").append(e.getMessage()).append(SEP);
                    IOUtil.close((InputStream)ins);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(ins);
                throw throwable;
            }
            IOUtil.close((InputStream)ins);
        }
    }

    public static void debug(String text) {
        if (DebugUtilities.isDebugEnabled()) {
            LOG.warn(text);
        }
    }

    public static boolean isDebugEnabled() {
        MavenPlugin.getDefault();
        return MavenPlugin.getMavenConfiguration().isDebugOutput();
    }
}

