/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.jsp.core.internal.pagevar;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.pagedesigner.jsp.core.JSPCorePlugin;
import org.eclipse.jst.pagedesigner.jsp.core.internal.pagevar.TagVarDescriptor;
import org.eclipse.jst.pagedesigner.jsp.core.util.CMUtil;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Element;

public class PageVariableAdatperRegistry {
    public static final String PAGEVAR = "pageVar";
    public static final String TAGLIB = "taglib";
    public static final String TAG = "tag";
    public static final String VARNAME = "varName";
    public static final String VARNAMEISATTR = "varNameIsAttr";
    public static final String VARTYPEMODE = "varTypeMode";
    public static final String TAGNAME = "tagName";
    public static final String VARTYPESTRING = "varTypeString";
    public static final String VARTYPESTRINGISATTR = "varTypeStringIsAttr";
    public static final String URI = "uri";
    private static PageVariableAdatperRegistry _instance = null;
    private Map _registry = this.readAllDescriptors();
    private TagVarDescriptor _useBeanDescriptor;

    public static PageVariableAdatperRegistry getInstance() {
        if (_instance == null) {
            _instance = new PageVariableAdatperRegistry();
        }
        return _instance;
    }

    private PageVariableAdatperRegistry() {
    }

    private Map readAllDescriptors() {
        HashMap<String, TagVarDescriptor> map = new HashMap<String, TagVarDescriptor>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(JSPCorePlugin.getPluginId(), PAGEVAR);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension ext = extensions[i];
            IConfigurationElement[] facs = ext.getConfigurationElements();
            int j = 0;
            while (j < facs.length) {
                String uri;
                if (facs[j].getName().equals(TAGLIB) && (uri = facs[j].getAttribute(URI)) != null && uri.length() != 0) {
                    IConfigurationElement[] tags = facs[j].getChildren(TAG);
                    int k = 0;
                    while (k < tags.length) {
                        TagVarDescriptor desc = new TagVarDescriptor();
                        String tag = tags[k].getAttribute(TAGNAME);
                        String varName = tags[k].getAttribute(VARNAME);
                        boolean varNameIsAttr = "true".equalsIgnoreCase(tags[k].getAttribute(VARNAMEISATTR));
                        String varTypeString = tags[k].getAttribute(VARTYPESTRING);
                        boolean varTypeStringIsAttr = "true".equalsIgnoreCase(tags[k].getAttribute(VARTYPESTRINGISATTR));
                        String varTypeModeString = tags[k].getAttribute(VARTYPEMODE);
                        int varTypeMode = PageVariableAdatperRegistry.toVarTypeMode(varTypeModeString);
                        desc.setVarName(varName);
                        desc.setVarNameIsAttr(varNameIsAttr);
                        desc.setVarTypeMode(varTypeMode);
                        desc.setVarTypeString(varTypeString);
                        desc.setVarTypeStringIsAttr(varTypeStringIsAttr);
                        desc.setTagName(tag);
                        map.put(String.valueOf(uri) + "#" + tag, desc);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
        return map;
    }

    public static int toVarTypeMode(String varTypeModeString) {
        if ("CLASSNAME".equalsIgnoreCase(varTypeModeString)) {
            return 0;
        }
        if ("EXPRESSION".equalsIgnoreCase(varTypeModeString)) {
            return 1;
        }
        if ("EXPRESSION_COLLECTION_ITEM".equalsIgnoreCase(varTypeModeString)) {
            return 2;
        }
        if ("BUNDLE".equalsIgnoreCase(varTypeModeString)) {
            return 3;
        }
        return 1;
    }

    public TagVarDescriptor getTagVarDescriptor(String uri, String tagname) {
        String key = String.valueOf(uri) + "#" + tagname;
        return (TagVarDescriptor)this._registry.get(key);
    }

    private TagVarDescriptor getJSPTagVarDescriptor(String localName) {
        if ("useBean".equals(localName)) {
            if (this._useBeanDescriptor == null) {
                this._useBeanDescriptor = new TagVarDescriptor();
                this._useBeanDescriptor.setVarName("id");
                this._useBeanDescriptor.setVarNameIsAttr(true);
                this._useBeanDescriptor.setVarTypeMode(0);
                this._useBeanDescriptor.setVarTypeString("class");
                this._useBeanDescriptor.setVarTypeStringIsAttr(true);
            }
            return this._useBeanDescriptor;
        }
        return null;
    }

    public TagVarDescriptor getTagVarDescriptor(Element target) {
        IDOMElement xmlEle;
        CMElementDeclaration decl;
        if (target instanceof IDOMElement && (decl = CMUtil.getElementDeclaration(xmlEle = (IDOMElement)target)) != null) {
            if (CMUtil.isJSP(decl)) {
                return this.getJSPTagVarDescriptor(xmlEle.getLocalName());
            }
            String uri = CMUtil.getTagURI(decl);
            if (uri != null) {
                return this.getTagVarDescriptor(uri, xmlEle.getLocalName());
            }
        }
        return null;
    }
}

