/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.modulecore.util;

import java.io.IOException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jst.common.internal.modulecore.util.ArchiveManifest;
import org.eclipse.jst.common.internal.modulecore.util.ArchiveManifestImpl;
import org.eclipse.jst.common.internal.modulecore.util.ManifestUtilities;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class UpdateManifestOperation
extends AbstractDataModelOperation {
    public UpdateManifestOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) throws ExecutionException {
        IFile file = (IFile)this.model.getProperty("UpdateManifestDataModel.MANIFEST_FILE");
        String classPathValue = this.model.getStringProperty("UpdateManifestDataModel.CLASSPATH_LIST_TEXT_UI");
        try {
            if (file != null && file.exists()) {
                ArchiveManifest mf = ManifestUtilities.readManifest(file);
                if (mf == null) {
                    mf = new ArchiveManifestImpl();
                }
                mf.addVersionIfNecessary();
                if (this.model.getBooleanProperty("UpdateManifestDataModel.MERGE")) {
                    mf.mergeClassPath(ManifestUtilities.getTokens(classPathValue));
                } else {
                    mf.setClassPath(classPathValue);
                }
                if (this.model.isPropertySet("UpdateManifestDataModel.MAIN_CLASS")) {
                    mf.setMainClass(this.model.getStringProperty("UpdateManifestDataModel.MAIN_CLASS"));
                }
                ManifestUtilities.writeManifest(file, mf);
            }
        }
        catch (IOException ex) {
            throw new ExecutionException(ex.getMessage(), (Throwable)ex);
        }
        return OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return null;
    }
}

