/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.e4.ui.internal.workbench.ExtensionsSort;
import org.eclipse.ui.internal.WorkbenchPlugin;

public abstract class RegistryReader {
    protected RegistryReader() {
    }

    protected static void logError(IConfigurationElement element, String text) {
        IExtension extension = element.getDeclaringExtension();
        StringBuilder buf = new StringBuilder();
        buf.append("Plugin " + extension.getContributor().getName() + ", extension " + extension.getExtensionPointUniqueIdentifier());
        String id = element.getAttribute("id");
        if (id != null) {
            buf.append(", id ");
            buf.append(id);
        }
        buf.append(": " + text);
        WorkbenchPlugin.log(buf.toString());
    }

    protected static void logMissingAttribute(IConfigurationElement element, String attributeName) {
        RegistryReader.logError(element, "Required attribute '" + attributeName + "' not defined");
    }

    protected static void logMissingElement(IConfigurationElement element, String elementName) {
        RegistryReader.logError(element, "Required sub element '" + elementName + "' not defined");
    }

    protected static void logUnknownElement(IConfigurationElement element) {
        RegistryReader.logError(element, "Unknown extension tag found: " + element.getName());
    }

    public static IExtension[] orderExtensions(IExtension[] extensions) {
        return (IExtension[])new ExtensionsSort().sort((Object[])extensions);
    }

    protected abstract boolean readElement(IConfigurationElement var1);

    protected void readElementChildren(IConfigurationElement element) {
        this.readElements(element.getChildren());
    }

    protected void readElements(IConfigurationElement[] elements) {
        int i = 0;
        while (i < elements.length) {
            if (!this.readElement(elements[i])) {
                RegistryReader.logUnknownElement(elements[i]);
            }
            ++i;
        }
    }

    protected void readExtension(IExtension extension) {
        this.readElements(extension.getConfigurationElements());
    }

    public void readRegistry(IExtensionRegistry registry, String pluginId, String extensionPoint) {
        IExtensionPoint point = registry.getExtensionPoint(pluginId, extensionPoint);
        if (point == null) {
            return;
        }
        IExtension[] extensions = point.getExtensions();
        IExtension[] iExtensionArray = extensions = RegistryReader.orderExtensions(extensions);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            this.readExtension(extension);
            ++n2;
        }
    }

    public static String getDescription(IConfigurationElement configElement) {
        IConfigurationElement[] children = configElement.getChildren("description");
        if (children.length >= 1) {
            return children[0].getValue();
        }
        return "";
    }

    public static String getClassValue(IConfigurationElement configElement, String classAttributeName) {
        String className = configElement.getAttribute(classAttributeName);
        if (className != null) {
            return className;
        }
        IConfigurationElement[] candidateChildren = configElement.getChildren(classAttributeName);
        if (candidateChildren.length == 0) {
            return null;
        }
        return candidateChildren[0].getAttribute("class");
    }
}

