/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.util.Vector;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.team.internal.ui.TeamUIPlugin;

public abstract class PsfStore {
    private static final int HISTORY_LENGTH = 10;
    private static final String STORE_SECTION = "ImportPSFDialog";
    private static IDialogSettings _section;

    protected abstract String getPreviousTag();

    protected abstract String getListTag();

    public abstract String getSuggestedDefault();

    protected String getPrevious() {
        IDialogSettings section = this.getSettingsSection();
        String retval = section.get(this.getPreviousTag());
        if (retval == null) {
            retval = "";
        }
        return retval;
    }

    public String[] getHistory() {
        IDialogSettings section = this.getSettingsSection();
        String[] arr = section.getArray(this.getListTag());
        if (arr == null) {
            arr = new String[]{};
        }
        return arr;
    }

    public void remember(String filename) {
        Vector<String> filenames = this.createVector(this.getHistory());
        if (filenames.contains(filename)) {
            filenames.remove(filename);
        }
        filenames.add(0, filename);
        while (filenames.size() > 10) {
            filenames.remove(10);
        }
        String[] arr = filenames.toArray(new String[filenames.size()]);
        IDialogSettings section = this.getSettingsSection();
        section.put(this.getListTag(), arr);
        section.put(this.getPreviousTag(), filename);
    }

    private Vector<String> createVector(String[] arr) {
        Vector<String> v = new Vector<String>();
        int ix = 0;
        while (ix < arr.length) {
            v.add(ix, arr[ix]);
            ++ix;
        }
        return v;
    }

    private IDialogSettings getSettingsSection() {
        if (_section != null) {
            return _section;
        }
        IDialogSettings settings = TeamUIPlugin.getPlugin().getDialogSettings();
        _section = settings.getSection(STORE_SECTION);
        if (_section != null) {
            return _section;
        }
        _section = settings.addNewSection(STORE_SECTION);
        return _section;
    }
}

