/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.import_config.wizards;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.import_config.ImportConfigMessages;
import org.jkiss.dbeaver.ext.import_config.wizards.ConfigImportWizardPage;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportConnectionInfo;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportData;
import org.jkiss.dbeaver.ext.import_config.wizards.ImportDriverInfo;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCURL;
import org.jkiss.dbeaver.registry.DataSourceDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderDescriptor;
import org.jkiss.dbeaver.registry.DataSourceProviderRegistry;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.dialogs.SelectObjectDialog;
import org.jkiss.utils.CommonUtils;

public abstract class ConfigImportWizard
extends Wizard
implements IImportWizard {
    private ConfigImportWizardPage mainPage;
    private Map<String, DriverDescriptor> driverClassMap = new HashMap<String, DriverDescriptor>();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(ImportConfigMessages.config_import_wizard_header_import_configuration);
        this.setNeedsProgressMonitor(true);
        this.mainPage = this.createMainPage();
    }

    protected abstract ConfigImportWizardPage createMainPage();

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.mainPage);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean performFinish() {
        ImportConnectionInfo connectionInfo;
        Iterator<ImportConnectionInfo> iterator;
        ImportData importData = this.mainPage.getImportData();
        try {
            block7: {
                iterator = importData.getConnections().iterator();
                do {
                    if (!iterator.hasNext()) break block7;
                } while (!(connectionInfo = iterator.next()).isChecked() || this.findOrCreateDriver(connectionInfo));
                return false;
            }
            DataSourceProviderRegistry.getInstance().saveDrivers();
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Import driver", null, (Throwable)e);
            return false;
        }
        try {
            iterator = importData.getConnections().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return true;
                }
                connectionInfo = iterator.next();
                if (!connectionInfo.isChecked()) continue;
                this.importConnection(connectionInfo);
            }
        }
        catch (DBException e) {
            DBWorkbench.getPlatformUI().showError("Import driver", null, (Throwable)e);
            return false;
        }
    }

    private boolean findOrCreateDriver(ImportConnectionInfo connectionInfo) throws DBException {
        DriverDescriptor driver;
        ImportDriverInfo driverInfo = connectionInfo.getDriverInfo();
        if (CommonUtils.isEmpty((String)driverInfo.getDriverClass())) {
            throw new DBException("Cannot create driver '" + driverInfo.getName() + "' - no driver class specified");
        }
        String sampleURL = driverInfo.getSampleURL();
        if (CommonUtils.isEmpty((String)sampleURL)) {
            throw new DBException("Cannot create driver '" + driverInfo.getName() + "' - no connection URL pattern specified");
        }
        DriverDescriptor driver2 = this.driverClassMap.get(driverInfo.getDriverClass());
        if (driver2 != null) {
            connectionInfo.setDriver(driver2);
            return true;
        }
        DataSourceProviderRegistry registry = DataSourceProviderRegistry.getInstance();
        ArrayList<DriverDescriptor> matchedDrivers = new ArrayList<DriverDescriptor>();
        for (DataSourceProviderDescriptor dataSourceProvider : registry.getDataSourceProviders()) {
            for (DriverDescriptor driver3 : dataSourceProvider.getEnabledDrivers()) {
                String driverClassName = driver3.getDriverClassName();
                if (driverClassName == null || !driverClassName.equals(driverInfo.getDriverClass())) continue;
                matchedDrivers.add(driver3);
            }
        }
        if (matchedDrivers.isEmpty()) {
            DataSourceProviderDescriptor genericProvider = registry.getDataSourceProvider("generic");
            if (genericProvider == null) {
                throw new DBException("Generic datasource provider not found");
            }
            driver = genericProvider.createDriver();
            driver.setName(driverInfo.getName());
            driver.setDriverClassName(driverInfo.getDriverClass());
            driver.setSampleURL(driverInfo.getSampleURL());
            driver.setConnectionProperties(driverInfo.getProperties());
            driver.setDescription(driverInfo.getDescription());
            driver.setDriverDefaultPort(driverInfo.getDefaultPort());
            for (String path : driverInfo.getLibraries()) {
                driver.addDriverLibrary(path, DBPDriverLibrary.FileType.jar);
            }
            driver.setModified(true);
            genericProvider.addDriver(driver);
            connectionInfo.setDriver(driver);
        } else if (matchedDrivers.size() == 1) {
            driver = (DriverDescriptor)matchedDrivers.get(0);
            connectionInfo.setDriver(driver);
        } else {
            driver = (DriverDescriptor)SelectObjectDialog.selectObject((Shell)this.getShell(), (String)("Choose driver for connection '" + connectionInfo.getAlias() + "'"), (String)"ImportDriverSelector", matchedDrivers);
            if (driver == null) {
                return false;
            }
            connectionInfo.setDriver(driver);
        }
        if (driver != null) {
            this.driverClassMap.put(driver.getDriverClassName(), driver);
            return true;
        }
        return false;
    }

    private void importConnection(ImportConnectionInfo connectionInfo) throws DBException {
        try {
            this.adaptConnectionUrl(connectionInfo);
        }
        catch (DBException e) {
            UIUtils.showMessageBox((Shell)this.getShell(), (String)"Extract URL parameters", (String)e.getMessage(), (int)8);
        }
        DBPDataSourceRegistry dataSourceRegistry = DBWorkbench.getPlatform().getProjectManager().getDataSourceRegistry(DBWorkbench.getPlatform().getProjectManager().getActiveProject());
        String name = connectionInfo.getAlias();
        int i = 0;
        while (dataSourceRegistry.findDataSourceByName(name) != null) {
            name = String.valueOf(connectionInfo.getAlias()) + " " + (i + 1);
            ++i;
        }
        DBPConnectionConfiguration config = new DBPConnectionConfiguration();
        config.setProperties(connectionInfo.getProperties());
        config.setProviderProperties(connectionInfo.getProviderProperties());
        config.setUrl(connectionInfo.getUrl());
        config.setUserName(connectionInfo.getUser());
        config.setUserPassword(connectionInfo.getPassword());
        config.setHostName(connectionInfo.getHost());
        config.setHostPort(connectionInfo.getPort());
        config.setDatabaseName(connectionInfo.getDatabase());
        DataSourceDescriptor dataSource = new DataSourceDescriptor(dataSourceRegistry, DataSourceDescriptor.generateNewId((DBPDriver)connectionInfo.getDriver()), connectionInfo.getDriver(), config);
        dataSource.setName(name);
        dataSource.setSavePassword(!CommonUtils.isEmpty((String)config.getUserPassword()));
        dataSourceRegistry.addDataSource((DBPDataSourceContainer)dataSource);
    }

    protected void adaptConnectionUrl(ImportConnectionInfo connectionInfo) throws DBException {
        String url;
        block24: {
            String sampleURL = connectionInfo.getDriverInfo().getSampleURL();
            if (connectionInfo.getDriver() != null) {
                sampleURL = connectionInfo.getDriver().getSampleURL();
            }
            if ((url = connectionInfo.getUrl()) == null) break block24;
            JDBCURL.MetaURL metaURL = JDBCURL.parseSampleURL((String)sampleURL);
            int sourceOffset = 0;
            List urlComponents = metaURL.getUrlComponents();
            int i = 0;
            int urlComponentsSize = urlComponents.size();
            while (i < urlComponentsSize) {
                block27: {
                    String component;
                    block25: {
                        int partEnd;
                        component = (String)urlComponents.get(i);
                        if (component.length() <= 2 || component.charAt(0) != '{' || component.charAt(component.length() - 1) != '}' || !metaURL.getAvailableProperties().contains(component.substring(1, component.length() - 1))) break block25;
                        if (i < urlComponentsSize - 1) {
                            String nextComponent = (String)urlComponents.get(i + 1);
                            partEnd = url.indexOf(nextComponent, sourceOffset);
                            if (partEnd == -1) {
                                if (nextComponent.equals(":")) {
                                    partEnd = url.indexOf("/", sourceOffset);
                                }
                                if (partEnd == -1) {
                                    if (connectionInfo.getHost() == null) {
                                        throw new DBException("Can't parse URL '" + url + "' with pattern '" + sampleURL + "'. String '" + nextComponent + "' not found after '" + component);
                                    }
                                    url = null;
                                    break;
                                }
                            }
                        } else {
                            partEnd = url.length();
                        }
                        String propertyValue = url.substring(sourceOffset, partEnd);
                        switch (component) {
                            case "{host}": {
                                connectionInfo.setHost(propertyValue);
                                break;
                            }
                            case "{port}": {
                                connectionInfo.setPort(propertyValue);
                                break;
                            }
                            case "{database}": {
                                connectionInfo.setDatabase(propertyValue);
                                break;
                            }
                            default: {
                                if (connectionInfo.getHost() != null) break;
                                throw new DBException("Unsupported property " + component);
                            }
                        }
                        sourceOffset = partEnd;
                        break block27;
                    }
                    sourceOffset += component.length();
                }
                ++i;
            }
        }
        if (url == null) {
            if (connectionInfo.getDriver() == null) {
                throw new DBCException("Can't detect target driver for '" + connectionInfo.getAlias() + "'");
            }
            if (connectionInfo.getHost() == null) {
                throw new DBCException("No URL and no host name - can't import connection '" + connectionInfo.getAlias() + "'");
            }
            DBPConnectionConfiguration conConfig = new DBPConnectionConfiguration();
            conConfig.setHostName(connectionInfo.getHost());
            conConfig.setHostPort(connectionInfo.getPort());
            conConfig.setDatabaseName(connectionInfo.getDatabase());
            url = connectionInfo.getDriver().getDataSourceProvider().getConnectionURL((DBPDriver)connectionInfo.getDriver(), conConfig);
            connectionInfo.setUrl(url);
        }
    }
}

