/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.Name;

@BugPattern(name="ObjectsHashCodePrimitive", summary="Objects.hashCode(Object o) should not be passed a primitive value", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class ObjectsHashCodePrimitive
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> OBJECTS_HASHCODE_CALLS = Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.util.Objects").named("hashCode"), Matchers.argument((int)0, (Matcher)Matchers.isPrimitiveType())});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        return OBJECTS_HASHCODE_CALLS.matches((Tree)tree, state) ? this.describeMatch(tree, ObjectsHashCodePrimitive.adjustHashCodeCall(tree, state)) : Description.NO_MATCH;
    }

    private static Fix adjustHashCodeCall(MethodInvocationTree tree, VisitorState state) {
        String argumentClass = ((Name)state.getTypes().boxedTypeOrType((Type)ASTHelpers.getType((Tree)((Tree)tree.getArguments().get((int)0)))).tsym.getSimpleName()).toString();
        return SuggestedFix.builder().prefixWith((Tree)tree, argumentClass + ".hashCode(").replace((Tree)tree, state.getSourceForNode((Tree)tree.getArguments().get(0))).postfixWith((Tree)tree, ")").build();
    }
}

