(function() {
  var addSet, intersectSet, setEqual, subtractSet;

  setEqual = function(a, b) {
    var iterator, next;
    if (a.size !== b.size) {
      return false;
    }
    iterator = a.values();
    while (!(next = iterator.next()).done) {
      if (!b.has(next.value)) {
        return false;
      }
    }
    return true;
  };

  subtractSet = function(set, valuesToRemove) {
    if (set.size > valuesToRemove.size) {
      return valuesToRemove.forEach(function(value) {
        return set["delete"](value);
      });
    } else {
      return set.forEach(function(value) {
        if (valuesToRemove.has(value)) {
          return set["delete"](value);
        }
      });
    }
  };

  addSet = function(set, valuesToAdd) {
    return valuesToAdd.forEach(function(value) {
      return set.add(value);
    });
  };

  intersectSet = function(set, other) {
    return set.forEach(function(value) {
      if (!other.has(value)) {
        return set["delete"](value);
      }
    });
  };

  module.exports = {
    setEqual: setEqual,
    subtractSet: subtractSet,
    addSet: addSet,
    intersectSet: intersectSet
  };

}).call(this);
