"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.collectionRenderer = collectionRenderer;
exports["default"] = void 0;

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _propTypes2 = require("../prop-types");

var _helpers = require("../helpers");

var _octicon = _interopRequireDefault(require("../atom/octicon"));

var _commitsView = _interopRequireDefault(require("./timeline-items/commits-view.js"));

var _issueCommentView = _interopRequireDefault(require("./timeline-items/issue-comment-view.js"));

var _mergedEventView = _interopRequireDefault(require("./timeline-items/merged-event-view.js"));

var _headRefForcePushedEventView = _interopRequireDefault(require("./timeline-items/head-ref-force-pushed-event-view.js"));

var _crossReferencedEventsView = _interopRequireDefault(require("./timeline-items/cross-referenced-events-view.js"));

var _commitCommentThreadView = _interopRequireDefault(require("./timeline-items/commit-comment-thread-view"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function collectionRenderer(Component, styleAsTimelineItem = true) {
  var _class, _temp;

  return _temp = _class = class GroupedComponent extends _react["default"].Component {
    static getFragment(fragName, ...args) {
      const frag = fragName === 'nodes' ? 'item' : fragName;
      return Component.getFragment(frag, ...args);
    }

    constructor(props) {
      super(props);
      (0, _helpers.autobind)(this, 'renderNode');
    }

    render() {
      return _react["default"].createElement("div", {
        className: styleAsTimelineItem ? 'timeline-item' : ''
      }, this.props.nodes.map(this.renderNode));
    }

    renderNode(node, i) {
      return _react["default"].createElement(Component, {
        key: i,
        item: node,
        issueish: this.props.issueish,
        switchToIssueish: this.props.switchToIssueish
      });
    }

  }, _defineProperty(_class, "displayName", `Grouped(${Component.render ? Component.render.displayName : Component.displayName})`), _defineProperty(_class, "propTypes", {
    nodes: _propTypes["default"].array.isRequired,
    issueish: _propTypes["default"].object.isRequired,
    switchToIssueish: _propTypes["default"].func.isRequired
  }), _temp;
}

const timelineItems = {
  Commit: _commitsView["default"],
  CommitCommentThread: collectionRenderer(_commitCommentThreadView["default"], false),
  IssueComment: collectionRenderer(_issueCommentView["default"], false),
  MergedEvent: collectionRenderer(_mergedEventView["default"]),
  HeadRefForcePushedEvent: collectionRenderer(_headRefForcePushedEventView["default"]),
  CrossReferencedEvent: _crossReferencedEventsView["default"]
};
const TimelineConnectionPropType = (0, _propTypes2.RelayConnectionPropType)(_propTypes["default"].shape({
  __typename: _propTypes["default"].string.isRequired
})).isRequired;

class IssueishTimelineView extends _react["default"].Component {
  constructor(props) {
    super(props);
    (0, _helpers.autobind)(this, 'loadMore');
  }

  loadMore() {
    this.props.relay.loadMore(10, () => {
      this.forceUpdate();
    });
    this.forceUpdate();
  }

  render() {
    const issueish = this.props.issue || this.props.pullRequest;
    const groupedEdges = this.groupEdges(issueish.timeline.edges);
    return _react["default"].createElement("div", {
      className: "github-PrTimeline"
    }, groupedEdges.map(({
      type,
      edges
    }) => {
      const Component = timelineItems[type];
      const propsForCommits = {
        onBranch: this.props.onBranch,
        openCommit: this.props.openCommit
      };

      if (Component) {
        return _react["default"].createElement(Component, _extends({
          key: `${type}-${edges[0].cursor}`,
          nodes: edges.map(e => e.node),
          issueish: issueish,
          switchToIssueish: this.props.switchToIssueish
        }, Component === _commitsView["default"] && propsForCommits));
      } else {
        // eslint-disable-next-line no-console
        console.warn(`unrecognized timeline event type: ${type}`);
        return null;
      }
    }), this.renderLoadMore());
  }

  renderLoadMore() {
    if (!this.props.relay.hasMore()) {
      return null;
    }

    return _react["default"].createElement("div", {
      className: "github-PrTimeline-loadMore"
    }, _react["default"].createElement("button", {
      className: "github-PrTimeline-loadMoreButton btn",
      onClick: this.loadMore
    }, this.props.relay.isLoading() ? _react["default"].createElement(_octicon["default"], {
      icon: "ellipsis"
    }) : 'Load More'));
  }

  groupEdges(edges) {
    let currentGroup;
    const groupedEdges = [];
    let lastEdgeType;
    edges.forEach(({
      node,
      cursor
    }) => {
      const currentEdgeType = node.__typename;

      if (currentEdgeType === lastEdgeType) {
        currentGroup.edges.push({
          node,
          cursor
        });
      } else {
        currentGroup = {
          type: currentEdgeType,
          edges: [{
            node,
            cursor
          }]
        };
        groupedEdges.push(currentGroup);
      }

      lastEdgeType = currentEdgeType;
    });
    return groupedEdges;
  }

}

exports["default"] = IssueishTimelineView;

_defineProperty(IssueishTimelineView, "propTypes", {
  switchToIssueish: _propTypes["default"].func.isRequired,
  relay: _propTypes["default"].shape({
    hasMore: _propTypes["default"].func.isRequired,
    loadMore: _propTypes["default"].func.isRequired,
    isLoading: _propTypes["default"].func.isRequired
  }).isRequired,
  issue: _propTypes["default"].shape({
    timeline: TimelineConnectionPropType
  }),
  pullRequest: _propTypes["default"].shape({
    timeline: TimelineConnectionPropType
  }),
  onBranch: _propTypes["default"].bool,
  openCommit: _propTypes["default"].func
});

_defineProperty(IssueishTimelineView, "defaultProps", {
  onBranch: false,
  openCommit: () => {}
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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