/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.instrumentation;

import java.io.ByteArrayOutputStream;
import org.netbeans.lib.profiler.classfile.DynamicClassInfo;
import org.netbeans.lib.profiler.global.CommonConstants;
import org.netbeans.lib.profiler.instrumentation.CPExtensionsRepository;
import org.netbeans.lib.profiler.instrumentation.Injector;

class MethodEntryExitCallsInjector
extends Injector
implements CommonConstants {
    protected static byte[] injCode1;
    protected static int injCodeLen1;
    protected static int injCodeMethodIdxPos1;
    protected static int injCodeMethodIdPos1;
    protected static byte[] injCode2;
    protected static int injCodeLen2;
    protected static int injCodeMethodIdxPos2;
    protected static int injCodeMethodIdPos2;
    protected static byte[] injCode3;
    protected static int injCodeLen3;
    protected static int injCodeMethodIdxPos3;
    protected static int injCodeMethodIdPos3;
    protected int baseRootCPoolCount;
    protected int injType;
    protected int methodId;

    MethodEntryExitCallsInjector(DynamicClassInfo dynamicClassInfo, int n, int n2, int n3, int n4, int n5) {
        super(dynamicClassInfo, n3);
        this.injType = n4;
        this.methodId = n5;
        this.baseCPoolCount = n;
        this.baseRootCPoolCount = n2;
    }

    @Override
    public byte[] instrumentMethod() {
        int n = 0;
        for (int i = 0; i < this.bytecodesLength; i += this.opcodeLength(i)) {
            int n2 = this.bytecodes[i] & 0xFF;
            if (n2 < 172 || n2 > 177) continue;
            ++n;
        }
        this.injectMethodEntry();
        this.injectMethodExits(n);
        this.injectGlobalCatch();
        ++this.maxStack;
        return this.createPackedMethodInfo();
    }

    private static void initializeInjectedCode() {
        injCodeLen1 = 8;
        injCode1 = new byte[injCodeLen1];
        MethodEntryExitCallsInjector.injCode1[0] = 17;
        injCodeMethodIdPos1 = 1;
        MethodEntryExitCallsInjector.injCode1[3] = -72;
        injCodeMethodIdxPos1 = 4;
        MethodEntryExitCallsInjector.injCode1[7] = 0;
        MethodEntryExitCallsInjector.injCode1[6] = 0;
        injCodeLen2 = 9;
        injCode2 = new byte[injCodeLen2];
        MethodEntryExitCallsInjector.injCode2[0] = 76;
        MethodEntryExitCallsInjector.injCode2[1] = 17;
        injCodeMethodIdPos2 = 2;
        MethodEntryExitCallsInjector.injCode2[4] = -72;
        injCodeMethodIdxPos2 = 5;
        MethodEntryExitCallsInjector.injCode2[7] = 43;
        MethodEntryExitCallsInjector.injCode2[8] = -65;
        injCodeLen3 = 8;
        injCode3 = new byte[injCodeLen3];
        MethodEntryExitCallsInjector.injCode3[0] = 89;
        MethodEntryExitCallsInjector.injCode3[1] = 17;
        injCodeMethodIdPos3 = 2;
        MethodEntryExitCallsInjector.injCode3[4] = -72;
        injCodeMethodIdxPos3 = 5;
        MethodEntryExitCallsInjector.injCode3[7] = 0;
    }

    private void injectGlobalCatch() {
        int n = this.injType == 2 || this.injType == 5 ? CPExtensionsRepository.rootContents_MarkerExitMethodIdx + this.baseRootCPoolCount : CPExtensionsRepository.normalContents_MethodExitMethodIdx + this.baseCPoolCount;
        MethodEntryExitCallsInjector.putU2(injCode2, injCodeMethodIdPos2, this.methodId);
        MethodEntryExitCallsInjector.putU2(injCode2, injCodeMethodIdxPos2, n);
        int n2 = this.bytecodesLength;
        boolean bl = false;
        int n3 = this.bytecodesLength;
        this.appendCode(injCode2, injCodeLen2);
        this.addExceptionTableEntry(0, n3, n2, 0);
        this.addGlobalCatchStackMapTableEntry(n3);
        if (this.maxLocals < 2) {
            this.maxLocals = 2;
        }
    }

    private void injectMethodEntry() {
        int n = 0;
        n = this.injType == 1 || this.injType == 4 ? CPExtensionsRepository.rootContents_RootEntryMethodIdx + this.baseRootCPoolCount : (this.injType == 2 || this.injType == 5 ? CPExtensionsRepository.rootContents_MarkerEntryMethodIdx + this.baseRootCPoolCount : CPExtensionsRepository.normalContents_MethodEntryMethodIdx + this.baseCPoolCount);
        MethodEntryExitCallsInjector.putU2(injCode1, injCodeMethodIdxPos1, n);
        MethodEntryExitCallsInjector.putU2(injCode1, injCodeMethodIdPos1, this.methodId);
        this.injectCodeAndRewrite(injCode1, injCodeLen1, 0, true);
        if (this.injType == 2 || this.injType == 5) {
            int n2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            String string = this.getParTypes();
            if (this.clazz.isMethodStatic(this.methodIdx)) {
                n2 = 0;
            } else {
                n2 = 1;
                if (!"<init>".equals(this.clazz.getMethodName(this.methodIdx))) {
                    this.getParInvocationCode('L', 0, byteArrayOutputStream);
                }
            }
            char[] cArray = string.toCharArray();
            int n3 = cArray.length;
            block3: for (int i = 0; i < n3; ++i) {
                char c = cArray[i];
                this.getParInvocationCode(c, n2, byteArrayOutputStream);
                switch (c) {
                    case 'D': 
                    case 'J': {
                        n2 += 2;
                        continue block3;
                    }
                    default: {
                        ++n2;
                    }
                }
            }
            int n4 = (4 - byteArrayOutputStream.size() % 4) % 4;
            for (n3 = 0; n3 < n4; ++n3) {
                byteArrayOutputStream.write(0);
            }
            this.injectCodeAndRewrite(byteArrayOutputStream.toByteArray(), byteArrayOutputStream.size(), 0, true);
        }
    }

    private void injectMethodExits(int n) {
        int n2;
        int n3 = -1;
        if (this.injType == 2 || this.injType == 5) {
            n2 = CPExtensionsRepository.rootContents_MarkerExitMethodIdx + this.baseRootCPoolCount;
            n3 = CPExtensionsRepository.rootContents_MarkerExitParMethodIdx + this.baseRootCPoolCount;
        } else {
            n2 = CPExtensionsRepository.normalContents_MethodExitMethodIdx + this.baseCPoolCount;
        }
        MethodEntryExitCallsInjector.putU2(injCode1, injCodeMethodIdxPos1, n2);
        if (n3 != -1) {
            MethodEntryExitCallsInjector.putU2(injCode3, injCodeMethodIdPos3, this.methodId);
            MethodEntryExitCallsInjector.putU2(injCode3, injCodeMethodIdxPos3, n3);
        }
        block0: for (int i = 0; i < n; ++i) {
            int n4 = -1;
            for (int j = 0; j < this.bytecodesLength; j += this.opcodeLength(j)) {
                int n5 = this.bytecodes[j] & 0xFF;
                if (n5 < 172 || n5 > 177 || ++n4 != i) continue;
                if (n5 == 176 && n3 != -1) {
                    this.injectCodeAndRewrite(injCode3, injCodeLen3, j, true);
                    continue block0;
                }
                this.injectCodeAndRewrite(injCode1, injCodeLen1, j, true);
                continue block0;
            }
        }
    }

    private String getParTypes() {
        String string = this.clazz.getMethodSignature(this.methodIdx);
        int n = string.indexOf(40) + 1;
        int n2 = string.lastIndexOf(41);
        StringBuilder stringBuilder = new StringBuilder();
        if (n2 > 0) {
            String string2 = string.substring(n, n2);
            boolean bl = false;
            int n3 = 0;
            while (n3 < string2.length()) {
                char c;
                while (string2.charAt(n3) == '[') {
                    bl = true;
                    ++n3;
                }
                if ((c = string2.charAt(n3++)) == 'L') {
                    while (string2.charAt(n3) != ';') {
                        ++n3;
                    }
                    ++n3;
                }
                if (bl) {
                    stringBuilder.append('L');
                    continue;
                }
                stringBuilder.append(c);
            }
        }
        return stringBuilder.toString();
    }

    private void getParInvocationCode(char c, int n, ByteArrayOutputStream byteArrayOutputStream) {
        switch (c) {
            case 'Z': {
                this.getIloadCode(n, byteArrayOutputStream);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParBooleanMethodIdx + this.baseRootCPoolCount, byteArrayOutputStream);
                break;
            }
            case 'C': {
                this.getIloadCode(n, byteArrayOutputStream);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParCharMethodIdx + this.baseRootCPoolCount, byteArrayOutputStream);
                break;
            }
            case 'B': {
                this.getIloadCode(n, byteArrayOutputStream);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParByteMethodIdx + this.baseRootCPoolCount, byteArrayOutputStream);
                break;
            }
            case 'S': {
                this.getIloadCode(n, byteArrayOutputStream);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParShortMethodIdx + this.baseRootCPoolCount, byteArrayOutputStream);
                break;
            }
            case 'I': {
                this.getIloadCode(n, byteArrayOutputStream);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParIntMethodIdx + this.baseRootCPoolCount, byteArrayOutputStream);
                break;
            }
            case 'J': {
                this.getLloadCode(n, byteArrayOutputStream);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParLongMethodIdx + this.baseRootCPoolCount, byteArrayOutputStream);
                break;
            }
            case 'F': {
                this.getFloadCode(n, byteArrayOutputStream);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParFloatMethodIdx + this.baseRootCPoolCount, byteArrayOutputStream);
                break;
            }
            case 'D': {
                this.getDloadCode(n, byteArrayOutputStream);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParDoubleMethodIdx + this.baseRootCPoolCount, byteArrayOutputStream);
                break;
            }
            case 'L': {
                this.getAloadCode(n, byteArrayOutputStream);
                this.getInvokeStatic(CPExtensionsRepository.miContents_AddParObjectMethodIdx + this.baseRootCPoolCount, byteArrayOutputStream);
            }
        }
    }

    private void getIloadCode(int n, ByteArrayOutputStream byteArrayOutputStream) {
        switch (n) {
            case 0: {
                byteArrayOutputStream.write(26);
                break;
            }
            case 1: {
                byteArrayOutputStream.write(27);
                break;
            }
            case 2: {
                byteArrayOutputStream.write(28);
                break;
            }
            case 3: {
                byteArrayOutputStream.write(29);
                break;
            }
            default: {
                byteArrayOutputStream.write(21);
                byteArrayOutputStream.write(n);
            }
        }
    }

    private void getLloadCode(int n, ByteArrayOutputStream byteArrayOutputStream) {
        switch (n) {
            case 0: {
                byteArrayOutputStream.write(30);
                break;
            }
            case 1: {
                byteArrayOutputStream.write(31);
                break;
            }
            case 2: {
                byteArrayOutputStream.write(32);
                break;
            }
            case 3: {
                byteArrayOutputStream.write(33);
                break;
            }
            default: {
                byteArrayOutputStream.write(22);
                byteArrayOutputStream.write(n);
            }
        }
    }

    private void getFloadCode(int n, ByteArrayOutputStream byteArrayOutputStream) {
        switch (n) {
            case 0: {
                byteArrayOutputStream.write(34);
                break;
            }
            case 1: {
                byteArrayOutputStream.write(35);
                break;
            }
            case 2: {
                byteArrayOutputStream.write(36);
                break;
            }
            case 3: {
                byteArrayOutputStream.write(37);
                break;
            }
            default: {
                byteArrayOutputStream.write(23);
                byteArrayOutputStream.write(n);
            }
        }
    }

    private void getDloadCode(int n, ByteArrayOutputStream byteArrayOutputStream) {
        switch (n) {
            case 0: {
                byteArrayOutputStream.write(38);
                break;
            }
            case 1: {
                byteArrayOutputStream.write(39);
                break;
            }
            case 2: {
                byteArrayOutputStream.write(40);
                break;
            }
            case 3: {
                byteArrayOutputStream.write(41);
                break;
            }
            default: {
                byteArrayOutputStream.write(24);
                byteArrayOutputStream.write(n);
            }
        }
    }

    private void getAloadCode(int n, ByteArrayOutputStream byteArrayOutputStream) {
        switch (n) {
            case 0: {
                byteArrayOutputStream.write(42);
                break;
            }
            case 1: {
                byteArrayOutputStream.write(43);
                break;
            }
            case 2: {
                byteArrayOutputStream.write(44);
                break;
            }
            case 3: {
                byteArrayOutputStream.write(45);
                break;
            }
            default: {
                byteArrayOutputStream.write(25);
                byteArrayOutputStream.write(n);
            }
        }
    }

    private void getInvokeStatic(int n, ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.write(184);
        byteArrayOutputStream.write(n >> 8 & 0xFF);
        byteArrayOutputStream.write(n & 0xFF);
    }

    static {
        MethodEntryExitCallsInjector.initializeInjectedCode();
    }
}

