# -*- coding: utf-8 -*-

"""
***************************************************************************
    i_albedo.py
    -----------
    Date                 : February 2016
    Copyright            : (C) 2016 by Médéric Ribreux
    Email                : medspx at medspx dot fr
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Médéric Ribreux'
__date__ = 'March 2016'
__copyright__ = '(C) 2016, Médéric Ribreux'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '0c5774c0685d4b6f3e92a086234455708d1cd427'

from .i import verifyRasterNum


def checkParameterValuesBeforeExecuting(alg, parameters, context):
    if alg.parameterAsBool(parameters, '-m', context):
        return verifyRasterNum(alg, parameters, context, 'input', 7)
    elif alg.parameterAsBool(parameters, '-n', context):
        return verifyRasterNum(alg, parameters, context, 'input', 2)
    elif (alg.parameterAsBool(parameters, '-l', context)
          or alg.parameterAsBool(parameters, '-a', context)):
        return verifyRasterNum(alg, parameters, context, 'input', 6)
    return True, None
