/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import java.util.function.Consumer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentValidator {
    private static final String PROPERTY_NAME = "JComponent.componentValidator";
    private static final JBValue MAX_WIDTH = new JBValue.UIInteger("ValidationTooltip.maxWidth", 384);
    private final Disposable parentDisposable;
    private Consumer<ComponentValidator> validator;
    private ValidationInfo validationInfo;
    private ComponentPopupBuilder popupBuilder;
    private JBPopup popup;
    private RelativePoint popupLocation;
    private Dimension popupSize;
    private boolean disableValidation;

    public ComponentValidator(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            ComponentValidator.$$$reportNull$$$0(0);
        }
        this.parentDisposable = parentDisposable;
    }

    public ComponentValidator withValidator(@NotNull Consumer<ComponentValidator> validator) {
        if (validator == null) {
            ComponentValidator.$$$reportNull$$$0(1);
        }
        this.validator = validator;
        return this;
    }

    public ComponentValidator andStartOnFocusLost() {
        this.disableValidation = true;
        return this;
    }

    public ComponentValidator installOn(@NotNull JComponent component) {
        Component fc;
        if (component == null) {
            ComponentValidator.$$$reportNull$$$0(2);
        }
        if ((fc = (Component)ComponentValidator.getFocusable(component).orElse(null)) == null) {
            return null;
        }
        component.putClientProperty(PROPERTY_NAME, this);
        ValidationFocusListener focusListener = new ValidationFocusListener();
        ValidationMouseListener mouseListener = new ValidationMouseListener();
        ComponentAdapter componentListener = new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (ComponentValidator.this.popup != null && ComponentValidator.this.popup.isVisible() && ComponentValidator.this.popupLocation != null) {
                    ComponentValidator.this.popup.setLocation(ComponentValidator.this.popupLocation.getScreenPoint());
                }
            }
        };
        PropertyChangeListener ancestorListener = e -> {
            Window w = (Window)UIUtil.findParentByCondition((Component)((Component)e.getSource()), v -> v instanceof Window);
            if (w != null) {
                if (e.getNewValue() != null) {
                    w.addComponentListener(componentListener);
                } else {
                    w.removeComponentListener(componentListener);
                }
            }
        };
        Window w = (Window)UIUtil.findParentByCondition((Component)component, v -> v instanceof Window);
        if (w != null) {
            w.addComponentListener(componentListener);
        } else {
            component.addPropertyChangeListener("ancestor", ancestorListener);
        }
        fc.addFocusListener(focusListener);
        fc.addMouseListener(mouseListener);
        Disposer.register((Disposable)this.parentDisposable, () -> {
            fc.removeFocusListener(focusListener);
            fc.removeMouseListener(mouseListener);
            if (w != null) {
                w.removeComponentListener(componentListener);
            }
        });
        return this;
    }

    public void revalidate() {
        if (this.validator != null) {
            this.validator.accept(this);
        }
    }

    public static Optional<ComponentValidator> getInstance(@NotNull JComponent component) {
        if (component == null) {
            ComponentValidator.$$$reportNull$$$0(3);
        }
        return Optional.ofNullable((ComponentValidator)component.getClientProperty(PROPERTY_NAME));
    }

    private void reset() {
        if (this.validationInfo != null && this.validationInfo.component != null) {
            this.validationInfo.component.putClientProperty("JComponent.outline", null);
            this.validationInfo.component.revalidate();
            this.validationInfo.component.repaint();
        }
        this.hidePopup();
        this.popupBuilder = null;
        this.popupLocation = null;
        this.popupSize = null;
        this.validationInfo = null;
    }

    public void updateInfo(@Nullable ValidationInfo info) {
        boolean newInfo;
        if (this.disableValidation) {
            return;
        }
        boolean resetInfo = info == null && this.validationInfo != null;
        boolean bl = newInfo = info != null && !info.equals(this.validationInfo);
        if (resetInfo || newInfo) {
            this.reset();
            this.validationInfo = info;
            if (newInfo) {
                if (this.validationInfo.component != null) {
                    this.validationInfo.component.putClientProperty("JComponent.outline", this.validationInfo.warning ? "warning" : "error");
                    this.validationInfo.component.revalidate();
                    this.validationInfo.component.repaint();
                }
                if (StringUtil.isNotEmpty((String)this.validationInfo.message)) {
                    JLabel tipComponent = new JLabel();
                    View v = BasicHTML.createHTMLView(tipComponent, String.format("<html>%s</html>", this.validationInfo.message));
                    String labelText = v.getPreferredSpan(0) > (float)MAX_WIDTH.get() ? String.format("<html><div width=%d>%s</div></html>", MAX_WIDTH.get(), this.validationInfo.message) : String.format("<html><div>%s</div></html>", this.validationInfo.message);
                    tipComponent.setText(labelText);
                    tipComponent.setBackground(this.validationInfo.warning ? JBUI.CurrentTheme.Validator.warningBackgroundColor() : JBUI.CurrentTheme.Validator.errorBackgroundColor());
                    tipComponent.setOpaque(true);
                    tipComponent.setBorder(ComponentValidator.getBorder());
                    this.popupSize = tipComponent.getPreferredSize();
                    this.popupBuilder = JBPopupFactory.getInstance().createComponentPopupBuilder(tipComponent, null).setBorderColor(this.validationInfo.warning ? JBUI.CurrentTheme.Validator.warningBorderColor() : JBUI.CurrentTheme.Validator.errorBorderColor()).setCancelOnClickOutside(false).setCancelOnMouseOutCallback(e -> e.getID() == 501 && !this.withinComponent(e)).setShowShadow(false);
                    ComponentValidator.getFocusable(this.validationInfo.component).ifPresent(fc -> {
                        if (fc.hasFocus()) {
                            this.showPopup();
                        }
                    });
                }
            }
        }
    }

    private boolean withinComponent(@NotNull MouseEvent e) {
        if (e == null) {
            ComponentValidator.$$$reportNull$$$0(4);
        }
        if (this.validationInfo != null && this.validationInfo.component != null && this.validationInfo.component.isShowing()) {
            Rectangle screenBounds = new Rectangle(this.validationInfo.component.getLocationOnScreen(), this.validationInfo.component.getSize());
            return screenBounds.contains(e.getLocationOnScreen());
        }
        return false;
    }

    private void showPopup() {
        if ((this.popup == null || !this.popup.isVisible()) && this.popupBuilder != null && this.validationInfo != null && this.validationInfo.component != null && this.validationInfo.component.isEnabled()) {
            this.popup = this.popupBuilder.createPopup();
            Insets i = this.validationInfo.component.getInsets();
            Point point = new Point(JBUI.scale((int)40), i.top - JBUI.scale((int)6) - this.popupSize.height);
            this.popupLocation = new RelativePoint((Component)this.validationInfo.component, point);
            this.popup.show(this.popupLocation);
        }
    }

    private void hidePopup() {
        if (this.popup != null && this.popup.isVisible()) {
            this.popup.cancel();
            this.popup = null;
        }
    }

    private static Border getBorder() {
        Insets i = UIManager.getInsets("ValidationTooltip.borderInsets");
        return i != null ? new JBEmptyBorder(i) : JBUI.Borders.empty((int)4, (int)8);
    }

    private static Optional<Component> getFocusable(Component source) {
        return source instanceof JComboBox && !((JComboBox)source).isEditable() ? Optional.of(source) : ((JBTreeTraverser)UIUtil.uiTraverser((Component)source).filter(c -> c instanceof JTextComponent && c.isFocusable())).toList().stream().findFirst();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/ui/ComponentValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withValidator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installOn";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "withinComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ValidationMouseListener
    extends MouseAdapter {
        private ValidationMouseListener() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            ComponentValidator.this.showPopup();
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (ComponentValidator.this.validationInfo != null) {
                ComponentValidator.getFocusable(((ComponentValidator)ComponentValidator.this).validationInfo.component).ifPresent(fc -> {
                    if (!fc.hasFocus()) {
                        ComponentValidator.this.hidePopup();
                    }
                });
            }
        }
    }

    private class ValidationFocusListener
    implements FocusListener {
        private ValidationFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            ComponentValidator.this.showPopup();
        }

        @Override
        public void focusLost(FocusEvent e) {
            ComponentValidator.this.hidePopup();
            if (ComponentValidator.this.disableValidation) {
                ComponentValidator.this.disableValidation = false;
                ComponentValidator.this.revalidate();
            }
        }
    }
}

