/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.progress.receiving;

import org.netbeans.lib.cvsclient.command.CommandUtils;
import org.netbeans.lib.cvsclient.command.ICvsFiles;
import org.netbeans.lib.cvsclient.command.IFileInfo;
import org.netbeans.lib.cvsclient.event.ICvsListener;
import org.netbeans.lib.cvsclient.event.ICvsListenerRegistry;
import org.netbeans.lib.cvsclient.event.IFileInfoListener;
import org.netbeans.lib.cvsclient.event.IMessageListener;
import org.netbeans.lib.cvsclient.file.FileUtils;
import org.netbeans.lib.cvsclient.progress.IProgressViewer;
import org.netbeans.lib.cvsclient.progress.receiving.AbstractResponseProgressHandler;
import org.netbeans.lib.cvsclient.util.BugLog;

public final class FileInfoAndMessageResponseProgressHandler
extends AbstractResponseProgressHandler
implements ICvsListener,
IMessageListener,
IFileInfoListener {
    private final String examinePattern;

    public FileInfoAndMessageResponseProgressHandler(IProgressViewer progressViewer, ICvsFiles cvsFiles, String examinePattern) {
        super(progressViewer, cvsFiles);
        BugLog.getInstance().assertNotNull(examinePattern);
        this.examinePattern = examinePattern;
    }

    @Override
    public void registerListeners(ICvsListenerRegistry listenerRegistry) {
        listenerRegistry.addMessageListener(this);
        listenerRegistry.addFileInfoListener(this);
    }

    @Override
    public void unregisterListeners(ICvsListenerRegistry listenerRegistry) {
        listenerRegistry.removeMessageListener(this);
        listenerRegistry.removeFileInfoListener(this);
    }

    @Override
    public void messageSent(String message, byte[] byteMessage, boolean error, boolean tagged) {
        if (!error || tagged) {
            return;
        }
        String directoryPath = CommandUtils.getExaminedDirectory(message, this.examinePattern);
        if (directoryPath == null) {
            return;
        }
        if (directoryPath.equals(".")) {
            this.directoryProcessed("/");
        } else {
            this.directoryProcessed(FileUtils.ensureLeadingSlash(directoryPath));
        }
    }

    @Override
    public void fileInfoGenerated(Object info) {
        if (info instanceof IFileInfo) {
            IFileInfo fileInfo = (IFileInfo)info;
            this.fileProcessed(fileInfo.getFileObject());
        }
    }

    @Override
    public void binaryMessageSent(byte[] bytes) {
    }
}

