/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import git4idea.DialogManager;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.AbstractGithubUrlGroupingAction;
import org.jetbrains.plugins.github.GithubCreatePullRequestWorker;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.ui.GithubCreatePullRequestDialog;

public class GithubCreatePullRequestAction
extends AbstractGithubUrlGroupingAction {
    public GithubCreatePullRequestAction() {
        super("Create Pull Request", "Create pull request from current branch", AllIcons.Vcs.Vendors.Github);
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e, @NotNull Project project, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String remoteUrl, @NotNull GithubAccount account) {
        if (e == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(0);
        }
        if (project == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(1);
        }
        if (repository == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(2);
        }
        if (remote == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(3);
        }
        if (remoteUrl == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(4);
        }
        if (account == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(5);
        }
        GithubCreatePullRequestAction.createPullRequest(project, repository, remote, remoteUrl, account);
    }

    static void createPullRequest(@NotNull Project project, @NotNull GitRepository gitRepository, @NotNull GitRemote remote, @NotNull String remoteUrl, @NotNull GithubAccount account) {
        GithubApiRequestExecutor.WithTokenAuth executor;
        if (project == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(6);
        }
        if (gitRepository == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(7);
        }
        if (remote == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(8);
        }
        if (remoteUrl == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(9);
        }
        if (account == null) {
            GithubCreatePullRequestAction.$$$reportNull$$$0(10);
        }
        if ((executor = GithubApiRequestExecutorManager.getInstance().getExecutor(account, project)) == null) {
            return;
        }
        GithubCreatePullRequestWorker worker = GithubCreatePullRequestWorker.create(project, gitRepository, remote, remoteUrl, executor, account.getServer());
        if (worker == null) {
            return;
        }
        GithubCreatePullRequestDialog dialog2 = new GithubCreatePullRequestDialog(project, worker);
        DialogManager.show((DialogWrapper)dialog2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteUrl";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "account";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gitRepository";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/github/GithubCreatePullRequestAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "createPullRequest";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

