/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.data.index;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Throwable2Computable;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.io.PersistentMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogDetailsFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.VcsLogTextFilter;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.data.index.VcsLogPathsIndex;
import com.intellij.vcs.log.data.index.VcsLogPersistentIndex;
import com.intellij.vcs.log.history.FileNamesData;
import com.intellij.vcs.log.impl.FatalErrorHandler;
import com.intellij.vcs.log.ui.filter.VcsLogMultiplePatternsTextFilter;
import com.intellij.vcs.log.util.TroveUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcsUtil.VcsUtil;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexDataGetter {
    private static final Logger LOG = Logger.getInstance(IndexDataGetter.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<? extends VirtualFile> myRoots;
    @NotNull
    private final VcsLogPersistentIndex.IndexStorage myIndexStorage;
    @NotNull
    private final VcsLogStorage myLogStorage;
    @NotNull
    private final FatalErrorHandler myFatalErrorsConsumer;

    public IndexDataGetter(@NotNull Project project, @NotNull Set<? extends VirtualFile> roots, @NotNull VcsLogPersistentIndex.IndexStorage indexStorage, @NotNull VcsLogStorage logStorage, @NotNull FatalErrorHandler fatalErrorsConsumer) {
        if (project == null) {
            IndexDataGetter.$$$reportNull$$$0(0);
        }
        if (roots == null) {
            IndexDataGetter.$$$reportNull$$$0(1);
        }
        if (indexStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(2);
        }
        if (logStorage == null) {
            IndexDataGetter.$$$reportNull$$$0(3);
        }
        if (fatalErrorsConsumer == null) {
            IndexDataGetter.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.myRoots = roots;
        this.myIndexStorage = indexStorage;
        this.myLogStorage = logStorage;
        this.myFatalErrorsConsumer = fatalErrorsConsumer;
    }

    @Nullable
    public VcsUser getAuthor(int commit) {
        return (VcsUser)this.executeAndCatch(() -> this.myIndexStorage.users.getAuthorForCommit(commit));
    }

    @Nullable
    public VcsUser getCommitter(int commit) {
        return (VcsUser)this.executeAndCatch(() -> {
            Integer committer = (Integer)this.myIndexStorage.committers.get((Object)commit);
            if (committer != null) {
                return this.myIndexStorage.users.getUserById(committer);
            }
            if (this.myIndexStorage.commits.contains(commit)) {
                return this.myIndexStorage.users.getAuthorForCommit(commit);
            }
            return null;
        });
    }

    @Nullable
    public Long getAuthorTime(int commit) {
        return (Long)this.executeAndCatch(() -> {
            Pair time = (Pair)this.myIndexStorage.timestamps.get((Object)commit);
            if (time == null) {
                return null;
            }
            return (Long)time.first;
        });
    }

    @Nullable
    public Long getCommitTime(int commit) {
        return (Long)this.executeAndCatch(() -> {
            Pair time = (Pair)this.myIndexStorage.timestamps.get((Object)commit);
            if (time == null) {
                return null;
            }
            return (Long)time.second;
        });
    }

    @Nullable
    public String getFullMessage(int index) {
        return (String)this.executeAndCatch(() -> (String)this.myIndexStorage.messages.get((Object)index));
    }

    @Nullable
    public List<Hash> getParents(int index) {
        return (List)this.executeAndCatch(() -> {
            List parentsIndexes = (List)this.myIndexStorage.parents.get((Object)index);
            if (parentsIndexes == null) {
                return null;
            }
            ArrayList result2 = ContainerUtil.newArrayList();
            Iterator iterator = parentsIndexes.iterator();
            while (iterator.hasNext()) {
                int parentIndex = (Integer)iterator.next();
                CommitId id = this.myLogStorage.getCommitId(parentIndex);
                if (id == null) {
                    return null;
                }
                result2.add(id.getHash());
            }
            return result2;
        });
    }

    @NotNull
    public Set<FilePath> getChangedPaths(int commit) {
        List<Hash> parents = this.getParents(commit);
        if (parents == null || parents.size() > 1) {
            Set<FilePath> set = Collections.emptySet();
            if (set == null) {
                IndexDataGetter.$$$reportNull$$$0(5);
            }
            return set;
        }
        Set<FilePath> set = this.getChangedPaths(commit, 0);
        if (set == null) {
            IndexDataGetter.$$$reportNull$$$0(6);
        }
        return set;
    }

    @NotNull
    public Set<FilePath> getChangedPaths(int commit, int parentIndex) {
        Set<FilePath> set = this.executeAndCatch(() -> this.myIndexStorage.paths.getPathsChangedInCommit(commit, parentIndex), Collections.emptySet());
        if (set == null) {
            IndexDataGetter.$$$reportNull$$$0(7);
        }
        return set;
    }

    public boolean canFilter(@NotNull List<VcsLogDetailsFilter> filters) {
        if (filters == null) {
            IndexDataGetter.$$$reportNull$$$0(8);
        }
        if (filters.isEmpty()) {
            return false;
        }
        return ContainerUtil.all(filters, filter -> {
            if (filter instanceof VcsLogTextFilter || filter instanceof VcsLogUserFilter) {
                return true;
            }
            if (filter instanceof VcsLogStructureFilter) {
                Collection files2 = ((VcsLogStructureFilter)filter).getFiles();
                return ContainerUtil.find((Iterable)files2, file2 -> file2.isDirectory() && this.myRoots.contains(file2.getVirtualFile())) == null;
            }
            return false;
        });
    }

    @NotNull
    public Set<Integer> filter(@NotNull List<VcsLogDetailsFilter> detailsFilters) {
        if (detailsFilters == null) {
            IndexDataGetter.$$$reportNull$$$0(9);
        }
        VcsLogTextFilter textFilter = (VcsLogTextFilter)ContainerUtil.findInstance(detailsFilters, VcsLogTextFilter.class);
        VcsLogUserFilter userFilter = (VcsLogUserFilter)ContainerUtil.findInstance(detailsFilters, VcsLogUserFilter.class);
        VcsLogStructureFilter pathFilter = (VcsLogStructureFilter)ContainerUtil.findInstance(detailsFilters, VcsLogStructureFilter.class);
        TIntHashSet filteredByMessage = null;
        if (textFilter != null) {
            filteredByMessage = this.filterMessages(textFilter);
        }
        TIntHashSet filteredByUser = null;
        if (userFilter != null) {
            HashSet users = ContainerUtil.newHashSet();
            for (VirtualFile virtualFile : this.myRoots) {
                users.addAll(userFilter.getUsers(virtualFile));
            }
            filteredByUser = this.filterUsers(users);
        }
        TIntHashSet filteredByPath = null;
        if (pathFilter != null) {
            filteredByPath = this.filterPaths(pathFilter.getFiles());
        }
        Set<Integer> set = TroveUtil.intersect(filteredByMessage, filteredByPath, filteredByUser);
        if (set == null) {
            IndexDataGetter.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    private TIntHashSet filterUsers(@NotNull Set<VcsUser> users) {
        if (users == null) {
            IndexDataGetter.$$$reportNull$$$0(11);
        }
        TIntHashSet tIntHashSet = this.executeAndCatch(() -> this.myIndexStorage.users.getCommitsForUsers(users), new TIntHashSet());
        if (tIntHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(12);
        }
        return tIntHashSet;
    }

    @NotNull
    private TIntHashSet filterPaths(@NotNull Collection<FilePath> paths) {
        if (paths == null) {
            IndexDataGetter.$$$reportNull$$$0(13);
        }
        TIntHashSet tIntHashSet = this.executeAndCatch(() -> {
            TIntHashSet result2 = new TIntHashSet();
            for (FilePath path : paths) {
                Set<Integer> commits = this.createFileNamesData(path).getCommits();
                if (commits.isEmpty() && !path.isDirectory()) {
                    commits = this.createFileNamesData(VcsUtil.getFilePath((String)path.getPath(), (boolean)true)).getCommits();
                }
                TroveUtil.addAll(result2, commits);
            }
            return result2;
        }, new TIntHashSet());
        if (tIntHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(14);
        }
        return tIntHashSet;
    }

    @NotNull
    private TIntHashSet filterMessages(@NotNull VcsLogTextFilter filter) {
        TIntHashSet resultByTrigrams;
        if (filter == null) {
            IndexDataGetter.$$$reportNull$$$0(15);
        }
        if ((!filter.isRegex() || filter instanceof VcsLogMultiplePatternsTextFilter) && (resultByTrigrams = (TIntHashSet)this.executeAndCatch(() -> {
            List<String> trigramSources = filter instanceof VcsLogMultiplePatternsTextFilter ? ((VcsLogMultiplePatternsTextFilter)filter).getPatterns() : Collections.singletonList(filter.getText());
            TIntHashSet commitsForSearch = new TIntHashSet();
            for (String string : trigramSources) {
                TIntHashSet commits = this.myIndexStorage.trigrams.getCommitsForSubstring(string);
                if (commits == null) {
                    return null;
                }
                TroveUtil.addAll(commitsForSearch, commits);
            }
            TIntHashSet result2 = new TIntHashSet();
            commitsForSearch.forEach(commit -> {
                try {
                    String value = (String)this.myIndexStorage.messages.get((Object)commit);
                    if (value != null && filter.matches(value)) {
                        result2.add(commit);
                    }
                }
                catch (IOException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                    return false;
                }
                return true;
            });
            return result2;
        })) != null) {
            TIntHashSet tIntHashSet = resultByTrigrams;
            if (tIntHashSet == null) {
                IndexDataGetter.$$$reportNull$$$0(16);
            }
            return tIntHashSet;
        }
        TIntHashSet tIntHashSet = this.filter(this.myIndexStorage.messages, arg_0 -> ((VcsLogTextFilter)filter).matches(arg_0));
        if (tIntHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(17);
        }
        return tIntHashSet;
    }

    @NotNull
    private <T> TIntHashSet filter(@NotNull PersistentMap<Integer, T> map, @NotNull Condition<T> condition) {
        if (map == null) {
            IndexDataGetter.$$$reportNull$$$0(18);
        }
        if (condition == null) {
            IndexDataGetter.$$$reportNull$$$0(19);
        }
        TIntHashSet result2 = new TIntHashSet();
        TIntHashSet tIntHashSet = this.executeAndCatch(() -> {
            this.myIndexStorage.commits.process((Processor<Integer>)((Processor)commit -> {
                try {
                    Object value = map.get(commit);
                    if (value != null && condition.value(value)) {
                        result2.add(commit.intValue());
                    }
                }
                catch (IOException e) {
                    this.myFatalErrorsConsumer.consume(this, e);
                    return false;
                }
                return true;
            }));
            return result2;
        }, result2);
        if (tIntHashSet == null) {
            IndexDataGetter.$$$reportNull$$$0(20);
        }
        return tIntHashSet;
    }

    @NotNull
    public Set<FilePath> getKnownNames(@NotNull FilePath path) {
        if (path == null) {
            IndexDataGetter.$$$reportNull$$$0(21);
        }
        Set<FilePath> set = this.executeAndCatch(() -> this.createFileNamesData(path).getFiles(), Collections.emptySet());
        if (set == null) {
            IndexDataGetter.$$$reportNull$$$0(22);
        }
        return set;
    }

    @NotNull
    public TIntObjectHashMap<TIntObjectHashMap<VcsLogPathsIndex.ChangeKind>> getAffectedCommits(@NotNull FilePath path) {
        if (path == null) {
            IndexDataGetter.$$$reportNull$$$0(23);
        }
        TIntObjectHashMap affectedCommits = new TIntObjectHashMap();
        VirtualFile root = VcsLogUtil.getActualRoot(this.myProject, path);
        if (this.myRoots.contains(root)) {
            this.executeAndCatch(() -> {
                this.myIndexStorage.paths.iterateCommits(path, (changes2, commit) -> this.executeAndCatch(() -> {
                    List parents = (List)this.myIndexStorage.parents.get((Object)commit);
                    if (parents == null) {
                        throw new CorruptedDataException("No parents for commit " + commit);
                    }
                    TIntObjectHashMap changesMap = new TIntObjectHashMap();
                    if (parents.size() == 0 && !changes2.isEmpty()) {
                        changesMap.put(commit, ContainerUtil.getFirstItem((List)changes2));
                    } else {
                        LOG.assertTrue(parents.size() == changes2.size(), (Object)("Commit " + commit + " has " + parents.size() + " parents, but " + changes2.size() + " changes."));
                        for (Pair parentAndChanges : ContainerUtil.zip((Iterable)parents, (Iterable)changes2)) {
                            changesMap.put(((Integer)parentAndChanges.first).intValue(), parentAndChanges.second);
                        }
                    }
                    affectedCommits.put(commit, (Object)changesMap);
                    return null;
                }));
                return null;
            });
        }
        TIntObjectHashMap tIntObjectHashMap = affectedCommits;
        if (tIntObjectHashMap == null) {
            IndexDataGetter.$$$reportNull$$$0(24);
        }
        return tIntObjectHashMap;
    }

    @Nullable
    public Couple<FilePath> findRename(int parent, int child2, @NotNull BooleanFunction<Couple<FilePath>> accept) {
        if (accept == null) {
            IndexDataGetter.$$$reportNull$$$0(25);
        }
        return (Couple)this.executeAndCatch(() -> this.myIndexStorage.paths.iterateRenames(parent, child2, accept));
    }

    @NotNull
    public FileNamesData createFileNamesData(@NotNull FilePath path) {
        if (path == null) {
            IndexDataGetter.$$$reportNull$$$0(26);
        }
        FileNamesData fileNamesData = new FileNamesData(path){

            @Override
            @NotNull
            public TIntObjectHashMap<TIntObjectHashMap<VcsLogPathsIndex.ChangeKind>> getAffectedCommits(@NotNull FilePath path) {
                if (path == null) {
                    1.$$$reportNull$$$0(0);
                }
                TIntObjectHashMap<TIntObjectHashMap<VcsLogPathsIndex.ChangeKind>> tIntObjectHashMap = IndexDataGetter.this.getAffectedCommits(path);
                if (tIntObjectHashMap == null) {
                    1.$$$reportNull$$$0(1);
                }
                return tIntObjectHashMap;
            }

            @Override
            @Nullable
            public Couple<FilePath> findRename(int parent, int child2, @NotNull Function1<? super Couple<FilePath>, Boolean> accept) {
                if (accept == null) {
                    1.$$$reportNull$$$0(2);
                }
                return IndexDataGetter.this.findRename(parent, child2, (BooleanFunction<Couple<FilePath>>)((BooleanFunction)couple -> (Boolean)accept.invoke(couple)));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "path";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter$1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "accept";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAffectedCommits";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getAffectedCommits";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "findRename";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (fileNamesData == null) {
            IndexDataGetter.$$$reportNull$$$0(27);
        }
        return fileNamesData;
    }

    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<T, IOException, StorageException> computable) {
        if (computable == null) {
            IndexDataGetter.$$$reportNull$$$0(28);
        }
        return this.executeAndCatch(computable, null);
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    private <T> T executeAndCatch(@NotNull Throwable2Computable<T, IOException, StorageException> computable, @Nullable T defaultValue) {
        if (computable == null) {
            IndexDataGetter.$$$reportNull$$$0(29);
        }
        try {
            return (T)computable.compute();
        }
        catch (StorageException | CorruptedDataException | IOException e) {
            this.myIndexStorage.markCorrupted();
            this.myFatalErrorsConsumer.consume(this, e);
        }
        catch (RuntimeException e) {
            this.processRuntimeException(e);
        }
        return defaultValue;
    }

    private void processRuntimeException(@NotNull RuntimeException e) {
        if (e == null) {
            IndexDataGetter.$$$reportNull$$$0(30);
        }
        if (e instanceof ProcessCanceledException) {
            throw e;
        }
        this.myIndexStorage.markCorrupted();
        if (!(e.getCause() instanceof IOException) && !(e.getCause() instanceof StorageException)) {
            throw new RuntimeException(e);
        }
        this.myFatalErrorsConsumer.consume(this, e);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexStorage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logStorage";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fatalErrorsConsumer";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detailsFilters";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "users";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accept";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/data/index/IndexDataGetter";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedPaths";
                break;
            }
            case 10: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUsers";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "filterPaths";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMessages";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getKnownNames";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedCommits";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileNamesData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 27: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "canFilter";
                break;
            }
            case 9: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "filterUsers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterPaths";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "filterMessages";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getKnownNames";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedCommits";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findRename";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createFileNamesData";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "executeAndCatch";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processRuntimeException";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 20: 
            case 22: 
            case 24: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CorruptedDataException
    extends RuntimeException {
        CorruptedDataException(@NotNull String message) {
            if (message == null) {
                CorruptedDataException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/vcs/log/data/index/IndexDataGetter$CorruptedDataException", "<init>"));
        }
    }
}

