/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.statusbar;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.CodeStyleConfigurableWrapper;
import com.intellij.application.options.CodeStyleSchemesConfigurable;
import com.intellij.application.options.codeStyle.OtherFileTypesCodeStyleConfigurable;
import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedStatusBarPopup;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsChangeEvent;
import com.intellij.psi.codeStyle.CodeStyleSettingsListener;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.FileIndentOptionsProvider;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtilRt;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleStatusBarWidget
extends EditorBasedStatusBarPopup
implements CodeStyleSettingsListener {
    public CodeStyleStatusBarWidget(@NotNull Project project) {
        if (project == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(0);
        }
        super(project);
    }

    @Override
    @NotNull
    protected EditorBasedStatusBarPopup.WidgetState getWidgetState(@Nullable VirtualFile file2) {
        if (file2 == null) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                CodeStyleStatusBarWidget.$$$reportNull$$$0(1);
            }
            return widgetState;
        }
        PsiFile psiFile = this.getPsiFile();
        if (psiFile == null || !psiFile.isWritable()) {
            EditorBasedStatusBarPopup.WidgetState widgetState = EditorBasedStatusBarPopup.WidgetState.HIDDEN;
            if (widgetState == null) {
                CodeStyleStatusBarWidget.$$$reportNull$$$0(2);
            }
            return widgetState;
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((PsiFile)psiFile);
        FileIndentOptionsProvider provider = CodeStyleStatusBarWidget.findProvider(file2, indentOptions);
        EditorBasedStatusBarPopup.WidgetState widgetState = CodeStyleStatusBarWidget.createWidgetState(psiFile, indentOptions, provider);
        if (widgetState == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(3);
        }
        return widgetState;
    }

    @Nullable
    private static FileIndentOptionsProvider findProvider(@NotNull VirtualFile file2, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions) {
        FileIndentOptionsProvider optionsProvider;
        if (file2 == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(4);
        }
        if (indentOptions == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(5);
        }
        if ((optionsProvider = indentOptions.getFileIndentOptionsProvider()) != null) {
            return optionsProvider;
        }
        for (FileIndentOptionsProvider provider : (FileIndentOptionsProvider[])FileIndentOptionsProvider.EP_NAME.getExtensions()) {
            if (!provider.areActionsAvailable(file2, indentOptions)) continue;
            return provider;
        }
        return null;
    }

    private static EditorBasedStatusBarPopup.WidgetState createWidgetState(@NotNull PsiFile psiFile, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable FileIndentOptionsProvider provider) {
        if (psiFile == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(6);
        }
        if (indentOptions == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(7);
        }
        String indentInfo = FileIndentOptionsProvider.getTooltip((CommonCodeStyleSettings.IndentOptions)indentOptions, null);
        String hint = provider != null ? provider.getHint(indentOptions) : null;
        String tooltip = CodeStyleStatusBarWidget.createTooltip(indentInfo, hint);
        StringBuilder widgetText = new StringBuilder();
        widgetText.append(indentInfo);
        CommonCodeStyleSettings.IndentOptions projectIndentOptions = CodeStyle.getSettings((Project)psiFile.getProject()).getLanguageIndentOptions(psiFile.getLanguage());
        if (!projectIndentOptions.equals((Object)indentOptions)) {
            widgetText.append("*");
        }
        return new MyWidgetState(tooltip, widgetText.toString(), psiFile, indentOptions, provider);
    }

    @NotNull
    private static String createTooltip(String indentInfo, String hint) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html>").append("Indent: ").append(indentInfo);
        if (hint != null) {
            sb.append("&nbsp;&nbsp;").append("<span style=\"color:#").append(ColorUtil.toHex((Color)JBColor.GRAY)).append("\">");
            sb.append(StringUtil.capitalize((String)hint));
            sb.append("</span>");
        }
        String string = sb.toString();
        if (string == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    private PsiFile getPsiFile() {
        Editor editor = this.getEditor();
        Project project = this.getProject();
        if (editor != null && project != null) {
            Document document = editor.getDocument();
            return PsiDocumentManager.getInstance((Project)project).getPsiFile(document);
        }
        return null;
    }

    @Override
    @Nullable
    protected ListPopup createPopup(DataContext context) {
        MyWidgetState state = (MyWidgetState)this.getWidgetState((VirtualFile)context.getData(CommonDataKeys.VIRTUAL_FILE));
        Editor editor = this.getEditor();
        PsiFile psiFile = this.getPsiFile();
        if (state != EditorBasedStatusBarPopup.WidgetState.HIDDEN && editor != null && psiFile != null) {
            final AnAction[] actions = CodeStyleStatusBarWidget.getActions(state.getProvider(), psiFile, state);
            ActionGroup actionGroup = new ActionGroup(){

                @NotNull
                public AnAction[] getChildren(@Nullable AnActionEvent e) {
                    if (actions == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return actions;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/codeStyle/statusbar/CodeStyleStatusBarWidget$1", "getChildren"));
                }
            };
            return JBPopupFactory.getInstance().createActionGroupPopup(null, actionGroup, context, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        }
        return null;
    }

    @NotNull
    private static AnAction[] getActions(@Nullable FileIndentOptionsProvider provider, @NotNull PsiFile psiFile, @NotNull MyWidgetState state) {
        AnAction[] actions;
        if (psiFile == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(9);
        }
        if (state == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(10);
        }
        ArrayList allActions = ContainerUtilRt.newArrayList();
        if (provider != null && (actions = provider.getActions(psiFile, state.getIndentOptions())) != null) {
            allActions.addAll(Arrays.asList(actions));
        }
        if (provider == null || provider.isShowFileIndentOptionsEnabled()) {
            allActions.add(DumbAwareAction.create((String)ApplicationBundle.message((String)"code.style.widget.configure.indents", (Object[])new Object[]{psiFile.getLanguage().getDisplayName()}), event -> {
                String id = CodeStyleStatusBarWidget.findCodeStyleConfigurableId(psiFile);
                ShowSettingsUtilImpl.showSettingsDialog(psiFile.getProject(), id, "Tab,Indent");
            }));
        }
        if (provider != null) {
            AnAction disabledAction = provider.createDisableAction(psiFile.getProject());
            if (disabledAction != null) {
                allActions.add(disabledAction);
            }
        } else {
            for (FileIndentOptionsProvider each : FileIndentOptionsProvider.EP_NAME.getExtensionList()) {
                AnAction defaultAction = each.createDefaultAction(psiFile.getProject());
                if (defaultAction == null) continue;
                allActions.add(defaultAction);
            }
        }
        AnAction[] anActionArray = allActions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(11);
        }
        return anActionArray;
    }

    @Override
    protected void registerCustomListeners() {
        CodeStyleSettingsManager.getInstance((Project)this.getProject()).addListener((CodeStyleSettingsListener)this);
    }

    public void codeStyleSettingsChanged(@NotNull CodeStyleSettingsChangeEvent event) {
        if (event == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(12);
        }
        this.update();
    }

    @Override
    @NotNull
    protected StatusBarWidget createInstance(Project project) {
        CodeStyleStatusBarWidget codeStyleStatusBarWidget = new CodeStyleStatusBarWidget(project);
        if (codeStyleStatusBarWidget == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(13);
        }
        return codeStyleStatusBarWidget;
    }

    @NotNull
    public String ID() {
        String string = CodeStyleStatusBarWidget.class.getName();
        if (string == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    public void dispose() {
        CodeStyleSettingsManager.removeListener((Project)this.myProject, (CodeStyleSettingsListener)this);
        super.dispose();
    }

    @Override
    protected void afterVisibleUpdate(@NotNull EditorBasedStatusBarPopup.WidgetState state) {
        String message;
        MyWidgetState codeStyleWidgetState;
        FileIndentOptionsProvider provider;
        if (state == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(15);
        }
        if (state instanceof MyWidgetState && (provider = (codeStyleWidgetState = (MyWidgetState)state).getProvider()) != null && (message = provider.getAdvertisementText(codeStyleWidgetState.getPsiFile(), codeStyleWidgetState.getIndentOptions())) != null) {
            this.advertise(message);
        }
    }

    private void advertise(@NotNull String message) {
        if (message == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(16);
        }
        Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)this);
        alarm.addRequest(() -> {
            BalloonBuilder builder2 = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(message));
            JComponent statusBarComponent = this.getComponent();
            Balloon balloon = builder2.setCalloutShift(statusBarComponent.getHeight() / 2).setDisposable((Disposable)this).setHideOnClickOutside(true).createBalloon();
            balloon.showInCenterOf(statusBarComponent);
        }, 500, ModalityState.NON_MODAL);
    }

    @NotNull
    private static String findCodeStyleConfigurableId(@NotNull PsiFile file2) {
        CodeStyleSchemesConfigurable topConfigurable;
        SearchableConfigurable result2;
        String name;
        if (file2 == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(17);
        }
        Project project = file2.getProject();
        Language language = file2.getLanguage();
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.findUsingBaseLanguage((Language)language);
        if (provider != null && provider.getIndentOptionsEditor() != null && (name = provider.getConfigurableDisplayName()) != null && (result2 = (topConfigurable = new CodeStyleSchemesConfigurable(project)).findSubConfigurable(name)) != null) {
            String string = result2.getId();
            if (string == null) {
                CodeStyleStatusBarWidget.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = CodeStyleConfigurableWrapper.getConfigurableId(OtherFileTypesCodeStyleConfigurable.DISPLAY_NAME);
        if (string == null) {
            CodeStyleStatusBarWidget.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/statusbar/CodeStyleStatusBarWidget";
                break;
            }
            case 4: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentOptions";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/statusbar/CodeStyleStatusBarWidget";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTooltip";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActions";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createInstance";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "ID";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "findCodeStyleConfigurableId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createWidgetState";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "codeStyleSettingsChanged";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "afterVisibleUpdate";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "advertise";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findCodeStyleConfigurableId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyWidgetState
    extends EditorBasedStatusBarPopup.WidgetState {
        @NotNull
        private final CommonCodeStyleSettings.IndentOptions myIndentOptions;
        @Nullable
        private final FileIndentOptionsProvider myProvider;
        @NotNull
        private final PsiFile myPsiFile;

        protected MyWidgetState(String toolTip, String text, @NotNull PsiFile psiFile, @NotNull CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable FileIndentOptionsProvider provider) {
            if (psiFile == null) {
                MyWidgetState.$$$reportNull$$$0(0);
            }
            if (indentOptions == null) {
                MyWidgetState.$$$reportNull$$$0(1);
            }
            super(toolTip, text, true);
            this.myIndentOptions = indentOptions;
            this.myProvider = provider;
            this.myPsiFile = psiFile;
        }

        @Nullable
        public FileIndentOptionsProvider getProvider() {
            return this.myProvider;
        }

        @NotNull
        public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
            CommonCodeStyleSettings.IndentOptions indentOptions = this.myIndentOptions;
            if (indentOptions == null) {
                MyWidgetState.$$$reportNull$$$0(2);
            }
            return indentOptions;
        }

        @NotNull
        public PsiFile getPsiFile() {
            PsiFile psiFile = this.myPsiFile;
            if (psiFile == null) {
                MyWidgetState.$$$reportNull$$$0(3);
            }
            return psiFile;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indentOptions";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/statusbar/CodeStyleStatusBarWidget$MyWidgetState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/statusbar/CodeStyleStatusBarWidget$MyWidgetState";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIndentOptions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPsiFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

