/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapitools.builders;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapitools.builders.BaseBuilder;

public class BuilderSWRLRule
extends BaseBuilder<SWRLRule, BuilderSWRLRule> {
    @Nonnull
    private final Set<SWRLAtom> body = new HashSet<SWRLAtom>();
    @Nonnull
    private final Set<SWRLAtom> head = new HashSet<SWRLAtom>();

    public BuilderSWRLRule(@Nonnull SWRLRule expected, OWLDataFactory df) {
        this(df);
        this.withBody(expected.getBody()).withHead(expected.getHead()).withAnnotations(expected.getAnnotations());
    }

    @Inject
    public BuilderSWRLRule(OWLDataFactory df) {
        super(df);
    }

    @Nonnull
    public BuilderSWRLRule withBody(SWRLAtom arg) {
        this.body.add(arg);
        return this;
    }

    @Nonnull
    public BuilderSWRLRule withHead(SWRLAtom arg) {
        this.head.add(arg);
        return this;
    }

    @Nonnull
    public BuilderSWRLRule withBody(@Nonnull Collection<SWRLAtom> arg) {
        this.body.addAll(arg);
        return this;
    }

    @Nonnull
    public BuilderSWRLRule withHead(@Nonnull Collection<SWRLAtom> arg) {
        this.head.addAll(arg);
        return this;
    }

    @Override
    public SWRLRule buildObject() {
        return this.df.getSWRLRule(this.body, this.head, this.annotations);
    }
}

