/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam;

import java.awt.Desktop;
import java.awt.EventQueue;
import java.io.IOException;
import org.pdfsam.ui.commons.OpenFileRequest;
import org.sejda.eventstudio.StaticStudio;
import org.sejda.eventstudio.annotation.EventListener;
import org.sejda.injector.Auto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Auto
class OpenFileController {
    private static final Logger LOG = LoggerFactory.getLogger(OpenFileController.class);

    OpenFileController() {
        StaticStudio.eventStudio().addAnnotatedListeners((Object)this);
    }

    @EventListener
    public void openPath(OpenFileRequest event) {
        EventQueue.invokeLater(() -> this.doOpen(event));
    }

    private void doOpen(OpenFileRequest event) {
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(event.getFile());
            }
            catch (IOException e) {
                LOG.error(String.format("Unable to open '%s'", event.getFile().getAbsoluteFile()), (Throwable)e);
            }
        }
    }
}

