/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.editor;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.spring.beans.editor.DocumentContext;
import org.netbeans.modules.xml.text.api.dom.SyntaxElement;
import org.netbeans.modules.xml.text.api.dom.TagElement;

public final class ContextUtilities {
    public static final String P_NAMESPACE = "http://www.springframework.org/schema/p";

    private ContextUtilities() {
    }

    public static boolean isPNamespaceName(DocumentContext context, String nodeName) {
        String namespaceUri;
        String prefix = ContextUtilities.getPrefixFromNodeName(nodeName);
        return prefix != null && P_NAMESPACE.equals(namespaceUri = context.lookupNamespacePrefix(prefix));
    }

    public static boolean isValueToken(Token<XMLTokenId> currentToken) {
        return currentToken != null && currentToken.id() == XMLTokenId.VALUE;
    }

    public static boolean isTagToken(Token<XMLTokenId> currentToken) {
        return currentToken != null && currentToken.id() == XMLTokenId.TAG;
    }

    public static boolean isAttributeToken(Token<XMLTokenId> currentToken) {
        return currentToken != null && currentToken.id() == XMLTokenId.ARGUMENT;
    }

    public static Token<XMLTokenId> getAttributeToken(DocumentContext context) {
        return context.getSyntaxSupport().getAttributeToken(context.getCurrentTokenOffset());
    }

    public static String getAttributeTokenImage(DocumentContext context) {
        Token<XMLTokenId> tok = ContextUtilities.getAttributeToken(context);
        if (tok != null) {
            return tok.text().toString();
        }
        return null;
    }

    public static String getPrefixFromTag(String tagName) {
        if (tagName == null) {
            return null;
        }
        return tagName.indexOf(":") == -1 ? null : tagName.substring(0, tagName.indexOf(":"));
    }

    public static String getLocalNameFromTag(String tagName) {
        if (tagName == null) {
            return null;
        }
        return tagName.indexOf(":") == -1 ? tagName : tagName.substring(tagName.indexOf(":") + 1, tagName.length());
    }

    public static String getPrefixFromNamespaceDeclaration(String namespace) {
        if (!namespace.startsWith("xmlns")) {
            return null;
        }
        int xmlnsLength = "xmlns".length();
        if (namespace.length() == xmlnsLength) {
            return "";
        }
        if (namespace.charAt(xmlnsLength) == ':') {
            return namespace.substring(xmlnsLength + 1);
        }
        return null;
    }

    public static String getPrefixFromNodeName(String nodeName) {
        int colonIndex = nodeName.indexOf(58);
        if (colonIndex <= 0) {
            return null;
        }
        return nodeName.substring(0, colonIndex);
    }

    public static SyntaxElement getRoot(SyntaxElement se) {
        SyntaxElement root = null;
        while (se != null) {
            if (se.getType() == 1 && ((TagElement)se).isStart()) {
                root = se;
            }
            se = se.getPrevious();
        }
        return root;
    }

    public static boolean isPNamespaceAdded(DocumentContext dc) {
        return dc.getDeclaredNamespaces().contains(P_NAMESPACE);
    }
}

