/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.debugging;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.netbeans.modules.debugger.jpda.ui.debugging.DebuggingViewSupportImpl;
import org.netbeans.modules.debugger.jpda.util.WeakCacheMap;
import org.netbeans.spi.debugger.ui.DebuggingView;

public class JPDADVThread
implements DebuggingView.DVThread,
WeakCacheMap.KeyedValue<JPDAThreadImpl> {
    private final DebuggingViewSupportImpl dvSupport;
    private final JPDAThreadImpl t;
    private PropertyChangeProxyListener proxyListener;

    public JPDADVThread(DebuggingViewSupportImpl dvSupport, JPDAThreadImpl t) {
        this.dvSupport = dvSupport;
        this.t = t;
    }

    public String getName() {
        return this.t.getName();
    }

    public boolean isSuspended() {
        return this.t.isSuspended();
    }

    public void resume() {
        this.t.resume();
    }

    public void suspend() {
        this.t.suspend();
    }

    public void makeCurrent() {
        this.t.makeCurrent();
    }

    public DebuggingView.DVSupport getDVSupport() {
        return this.dvSupport;
    }

    public List<DebuggingView.DVThread> getLockerThreads() {
        List lockerThreads = this.t.getLockerThreads();
        if (lockerThreads == null) {
            return null;
        }
        return new ThreadListDelegate(lockerThreads);
    }

    public void resumeBlockingThreads() {
        this.t.resumeBlockingThreads();
    }

    public Breakpoint getCurrentBreakpoint() {
        return this.t.getCurrentBreakpoint();
    }

    public boolean isInStep() {
        return this.t.isInStep();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener pcl) {
        if (this.proxyListener == null) {
            this.proxyListener = new PropertyChangeProxyListener();
            this.t.addPropertyChangeListener((PropertyChangeListener)this.proxyListener);
        }
        this.proxyListener.add(pcl);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener pcl) {
        if (this.proxyListener != null) {
            this.proxyListener.remove(pcl);
            if (this.proxyListener.isEmpty()) {
                this.t.removePropertyChangeListener((PropertyChangeListener)this.proxyListener);
                this.proxyListener = null;
            }
        }
    }

    public JPDAThreadImpl getKey() {
        return this.t;
    }

    private class PropertyChangeProxyListener
    implements PropertyChangeListener {
        private final List<PropertyChangeListener> listeners = new CopyOnWriteArrayList<PropertyChangeListener>();

        private PropertyChangeProxyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyChangeEvent proxyEvent = new PropertyChangeEvent(JPDADVThread.this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            proxyEvent.setPropagationId(evt.getPropagationId());
            for (PropertyChangeListener pchl : this.listeners) {
                pchl.propertyChange(proxyEvent);
            }
        }

        void add(PropertyChangeListener pcl) {
            this.listeners.add(pcl);
        }

        void remove(PropertyChangeListener pcl) {
            this.listeners.remove(pcl);
        }

        boolean isEmpty() {
            return this.listeners.isEmpty();
        }
    }

    private class ThreadListDelegate
    extends AbstractList<DebuggingView.DVThread> {
        private final List<JPDAThread> threads;

        public ThreadListDelegate(List<JPDAThread> threads) {
            this.threads = threads;
        }

        @Override
        public DebuggingView.DVThread get(int index) {
            return JPDADVThread.this.dvSupport.get((JPDAThread)((JPDAThreadImpl)this.threads.get(index)));
        }

        @Override
        public int size() {
            return this.threads.size();
        }
    }
}

