/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.openide.util.RequestProcessor;

public class JavaUtils {
    private static final int ASYNC_WAIT_TIME = 500;
    private static final RequestProcessor scanningProcessor = new RequestProcessor("Debugger Context Scanning", 1);

    public static Future<Void> runWhenScanFinishedReallyLazy(final JavaSource js, final Task<CompilationController> task, final boolean shared) throws IOException {
        return JavaUtils.scanReallyLazy(new ScanRunnable<IOException>(IOException.class){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run(Future<Void>[] resultPtr, IOException[] excPtr) {
                try {
                    js.runUserActionTask(task, shared);
                    return;
                }
                catch (IOException ex) {
                    Future<Void>[] futureArray = resultPtr;
                    synchronized (resultPtr) {
                        excPtr[0] = ex;
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return;
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <E extends Throwable> Future<Void> scanReallyLazy(ScanRunnable<E> run) throws E {
        final Future[] resultPtr = new Future[]{null};
        final Throwable[] excPtr = (Throwable[])Array.newInstance(((ScanRunnable)run).exceptionType, 1);
        ((ScanRunnable)run).setParam(resultPtr, excPtr);
        final RequestProcessor.Task scanning = scanningProcessor.post(run);
        try {
            scanning.waitFinished(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Future[] futureArray = resultPtr;
        synchronized (resultPtr) {
            if (excPtr[0] != null) {
                throw excPtr[0];
            }
            if (resultPtr[0] != null) {
                // ** MonitorExit[var4_5] (shouldn't be in output)
                return resultPtr[0];
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            return new Future<Void>(){
                boolean cancelled = false;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private Future<Void> getDelegate() {
                    Future[] futureArray = resultPtr;
                    synchronized (resultPtr) {
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return resultPtr[0];
                    }
                }

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    this.cancelled = scanning.cancel();
                    return this.cancelled;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return scanning.isFinished();
                }

                @Override
                public Void get() throws InterruptedException, ExecutionException {
                    scanning.waitFinished();
                    if (excPtr[0] != null) {
                        throw new ExecutionException(excPtr[0]);
                    }
                    return null;
                }

                @Override
                public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                    long mstimeout = unit.toMillis(timeout);
                    if (mstimeout == 0L) {
                        if (!scanning.isFinished()) {
                            throw new TimeoutException("Task timeout");
                        }
                    } else {
                        long s1 = System.nanoTime();
                        boolean finished = scanning.waitFinished(mstimeout);
                        if (!finished) {
                            throw new TimeoutException("Task timeout");
                        }
                        long s2 = System.nanoTime();
                        if ((timeout -= unit.convert(s2 - s1, TimeUnit.NANOSECONDS)) < 0L) {
                            timeout = 1L;
                        }
                    }
                    if (excPtr[0] != null) {
                        throw new ExecutionException(excPtr[0]);
                    }
                    return null;
                }
            };
        }
    }

    private static abstract class ScanRunnable<E extends Throwable>
    implements Runnable {
        private Future<Void>[] resultPtr;
        private E[] excPtr;
        private Class<E> exceptionType;

        public ScanRunnable(Class<E> exceptionType) {
            this.exceptionType = exceptionType;
        }

        private void setParam(Future<Void>[] resultPtr, E[] excPtr) {
            this.resultPtr = resultPtr;
            this.excPtr = excPtr;
        }

        @Override
        public final void run() {
            this.run(this.resultPtr, (Throwable[])this.excPtr);
        }

        public abstract void run(Future<Void>[] var1, E[] var2);
    }
}

