/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.support.Logger;
import org.netbeans.modules.nativeexecution.support.MiscUtils;
import org.openide.util.RequestProcessor;

public final class ShellSession {
    private static final java.util.logging.Logger log = Logger.getInstance();
    private static final RequestProcessor RP = new RequestProcessor("ShellSession I/O", 10);
    private static final HashMap<ExecutionEnvironment, ShellProcess> processes = new HashMap();
    private static final String csName = "UTF-8";
    private static final String eop = "ShellSession.CMDDONE";

    private ShellSession() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdown(ExecutionEnvironment env) {
        ShellProcess process;
        HashMap<ExecutionEnvironment, ShellProcess> hashMap = processes;
        synchronized (hashMap) {
            process = processes.put(env, null);
        }
        if (process != null) {
            log.log(Level.FINE, "{0} - shutdown", process);
            ProcessUtils.destroy(process.process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ShellProcess startProcessIfNeeded(ExecutionEnvironment env) throws IOException, CancellationException {
        ShellProcess process;
        HashMap<ExecutionEnvironment, ShellProcess> hashMap = processes;
        synchronized (hashMap) {
            process = processes.get(env);
            if (process != null && ProcessUtils.isAlive(process.process)) {
                return process;
            }
            process = null;
            processes.put(env, null);
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo(env);
                String shell = HostInfo.OSFamily.WINDOWS.equals((Object)hostInfo.getOSFamily()) ? hostInfo.getShell() : "/bin/sh";
                NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder(env);
                npb.setExecutable(shell).setArguments("-s");
                npb.getEnvironment().put("LC_ALL", "C");
                NativeProcess sh = npb.call();
                if (sh.getState() == NativeProcess.State.RUNNING) {
                    process = new ShellProcess(sh);
                    processes.put(env, process);
                } else {
                    process = null;
                    ProcessUtils.readProcessError(sh);
                    ProcessUtils.readProcessOutput(sh);
                }
            }
            catch (ConnectionManager.CancellationException ex) {
                throw new CancellationException(ex.getMessage());
            }
        }
        if (process == null) {
            throw new IOException("Failed to start shell session on " + env.getDisplayName());
        }
        log.log(Level.FINE, "{0} - started", process);
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessUtils.ExitStatus execute(ExecutionEnvironment env, String command) throws IOException, CancellationException {
        while (true) {
            ShellProcess process;
            if ((process = ShellSession.startProcessIfNeeded(env)) == null) {
                continue;
            }
            ShellProcess shellProcess = process;
            synchronized (shellProcess) {
                if (ProcessUtils.isAlive(process.process)) {
                    try {
                        ProcessUtils.ExitStatus result = ShellSession.executeSync(process, env, command);
                        if (result != null) {
                            return result;
                        }
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        return new ProcessUtils.ExitStatus(-1, null, MiscUtils.getMessageAsList(ex));
                    }
                }
            }
        }
    }

    private static ProcessUtils.ExitStatus executeSync(final ShellProcess process, ExecutionEnvironment env, String command) throws IOException, CancellationException, InterruptedException {
        List error;
        List output;
        StringBuilder sb = new StringBuilder();
        sb.append('(').append(command).append(')');
        sb.append("; echo ").append(eop).append("$?; echo ").append(eop).append(" 1>&2\n");
        log.log(Level.FINE, "{0} - \"{1}\"", new Object[]{process, sb.toString()});
        OutputStream os = process.process.getOutputStream();
        if (!ProcessUtils.isAlive(process.process)) {
            return null;
        }
        try {
            os.write(sb.toString().getBytes(csName));
            os.flush();
        }
        catch (IOException ex) {
            log.log(Level.FINE, "{0} - FAILED TO WRITE TO OUTPUT - {1}", new Object[]{process, ex.getMessage()});
            return null;
        }
        final AtomicInteger rc = new AtomicInteger(-1);
        Future out = RP.submit((Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                String line;
                ArrayList<String> result = new ArrayList<String>();
                while ((line = process.out.readLine()) != null) {
                    if (line.startsWith(ShellSession.eop)) {
                        rc.set(Integer.parseInt(line.substring(ShellSession.eop.length())));
                        break;
                    }
                    result.add(line);
                }
                return result;
            }
        });
        Future err = RP.submit((Callable)new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                String line;
                ArrayList<String> result = new ArrayList<String>();
                while ((line = process.err.readLine()) != null && !line.startsWith(ShellSession.eop)) {
                    result.add(line);
                }
                return result;
            }
        });
        try {
            output = (List)out.get();
        }
        catch (ExecutionException ex) {
            return null;
        }
        try {
            error = (List)err.get();
        }
        catch (ExecutionException ex) {
            return null;
        }
        ProcessUtils.ExitStatus result = new ProcessUtils.ExitStatus(rc.get(), output, error);
        log.log(Level.FINE, "{0} - \"{1}\" result is {2}", new Object[]{process, sb.toString(), result});
        return result;
    }

    private static class ShellProcess {
        private final NativeProcess process;
        private final BufferedReader out;
        private final BufferedReader err;
        private final String displayName;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ShellProcess(NativeProcess process) {
            String _displayName;
            try {
                _displayName = "ShellProcess@" + process.getExecutionEnvironment().getDisplayName() + " [" + process.getPID() + "]";
            }
            catch (IOException ex) {
                _displayName = "ShellProcess@" + process.getExecutionEnvironment().getDisplayName() + " [broken]";
            }
            this.displayName = _displayName;
            this.process = process;
            BufferedReader bout = null;
            try {
                bout = new BufferedReader(new InputStreamReader(process.getInputStream(), ShellSession.csName));
            }
            catch (UnsupportedEncodingException ex) {
                bout = new BufferedReader(new InputStreamReader(process.getInputStream()));
            }
            finally {
                this.out = bout;
            }
            BufferedReader berr = null;
            try {
                berr = new BufferedReader(new InputStreamReader(process.getErrorStream(), ShellSession.csName));
            }
            catch (UnsupportedEncodingException ex) {
                berr = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            }
            finally {
                this.err = berr;
            }
        }

        public String toString() {
            return this.displayName;
        }
    }
}

