/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.lexer;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.db.sql.lexer.SQLLexer;
import org.netbeans.spi.lexer.LanguageEmbedding;
import org.netbeans.spi.lexer.LanguageHierarchy;
import org.netbeans.spi.lexer.Lexer;
import org.netbeans.spi.lexer.LexerRestartInfo;

public enum SQLTokenId implements TokenId
{
    WHITESPACE("sql-whitespace"),
    LINE_COMMENT("sql-line-comment"),
    BLOCK_COMMENT("sql-block-comment"),
    STRING("sql-string-literal"),
    INCOMPLETE_STRING("sql-errors"),
    INCOMPLETE_IDENTIFIER("sql-errors"),
    IDENTIFIER("sql-identifier"),
    OPERATOR("sql-operator"),
    LPAREN("sql-operator"),
    RPAREN("sql-operator"),
    DOT("sql-dot"),
    COMMA("sql-operator"),
    INT_LITERAL("sql-int-literal"),
    DOUBLE_LITERAL("sql-double-literal"),
    KEYWORD("sql-keyword");

    private final String primaryCategory;
    private static final Language<SQLTokenId> language;

    private SQLTokenId(String primaryCategory) {
        this.primaryCategory = primaryCategory;
    }

    public String primaryCategory() {
        return this.primaryCategory;
    }

    public static Language<SQLTokenId> language() {
        return language;
    }

    static {
        language = new LanguageHierarchy<SQLTokenId>(){

            protected String mimeType() {
                return "text/x-sql";
            }

            protected Collection<SQLTokenId> createTokenIds() {
                return EnumSet.allOf(SQLTokenId.class);
            }

            protected Map<String, Collection<SQLTokenId>> createTokenCategories() {
                return Collections.emptyMap();
            }

            protected Lexer<SQLTokenId> createLexer(LexerRestartInfo<SQLTokenId> info) {
                return new SQLLexer(info);
            }

            protected LanguageEmbedding<?> embedding(Token<SQLTokenId> token, LanguagePath languagePath, InputAttributes inputAttributes) {
                return null;
            }
        }.language();
    }
}

