/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.commons;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import org.openide.awt.Mnemonics;

public final class TransparentSectionButton
extends JCheckBox {
    final boolean isGTK = "GTK".equals(UIManager.getLookAndFeel().getID());
    final boolean isNimbus = "Nimbus".equals(UIManager.getLookAndFeel().getID());
    final boolean isAqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private ActionListener al;

    public TransparentSectionButton() {
        this((ActionListener)null);
    }

    public TransparentSectionButton(ActionListener al) {
        UIManager.get("nb.propertysheet");
        this.setMargin(new Insets(0, 3, 0, 3));
        this.setFocusPainted(false);
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(4);
        this.setVerticalTextPosition(0);
        this.updateProperties();
        if (this.getBorder() instanceof CompoundBorder) {
            Dimension pref = this.getPreferredSize();
            pref.height -= 3;
            this.setPreferredSize(pref);
        }
        if (al != null) {
            this.addActionListener(al);
        }
        this.initActions();
    }

    @Override
    public void addActionListener(ActionListener al) {
        this.al = al;
        super.addActionListener(al);
    }

    @Override
    public String getUIClassID() {
        return super.getUIClassID();
    }

    private void initActions() {
        InputMap inputMap = this.getInputMap(0);
        inputMap.put(KeyStroke.getKeyStroke(37, 0, false), "collapse");
        inputMap.put(KeyStroke.getKeyStroke(39, 0, false), "expand");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("collapse", new ExpandAction(false));
        actionMap.put("expand", new ExpandAction(true));
    }

    private void updateProperties() {
        this.setIcon(UIManager.getIcon(this.isGTK ? "Tree.gtk_collapsedIcon" : "Tree.collapsedIcon"));
        this.setSelectedIcon(UIManager.getIcon(this.isGTK ? "Tree.gtk_expandedIcon" : "Tree.expandedIcon"));
        Mnemonics.setLocalizedText((AbstractButton)this, (String)this.getText());
        this.getAccessibleContext().setAccessibleName(this.getText());
        this.getAccessibleContext().setAccessibleDescription(this.getText());
        this.setOpaque(false);
        if (this.isAqua) {
            this.setContentAreaFilled(true);
            this.setBackground(new Color(0, 0, 0));
            this.setForeground(new Color(255, 255, 255));
        }
        if (this.isNimbus) {
            this.setContentAreaFilled(true);
        }
    }

    private boolean isExpanded() {
        return this.isSelected();
    }

    private void setExpanded(boolean expand) {
        this.setSelected(expand);
        this.requestFocus();
    }

    @Override
    public Color getForeground() {
        if (this.isFocusOwner()) {
            if (this.isAqua) {
                return UIManager.getColor("Table.foreground");
            }
            if (this.isGTK || this.isNimbus) {
                return UIManager.getColor("Tree.selectionForeground");
            }
            return UIManager.getColor("PropSheet.selectedSetForeground");
        }
        if (this.isAqua) {
            Color res = UIManager.getColor("PropSheet.setForeground");
            if (res == null && (res = UIManager.getColor("Table.foreground")) == null && (res = UIManager.getColor("textText")) == null) {
                res = Color.BLACK;
            }
            return res;
        }
        if (this.isGTK || this.isNimbus) {
            return new Color(UIManager.getColor("Menu.foreground").getRGB());
        }
        return super.getForeground();
    }

    private class ExpandAction
    extends AbstractAction {
        private final boolean expand;

        public ExpandAction(boolean expand) {
            this.expand = expand;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.expand == TransparentSectionButton.this.isExpanded()) {
                return;
            }
            TransparentSectionButton.this.setExpanded(this.expand);
            TransparentSectionButton.this.al.actionPerformed(e);
        }
    }
}

