/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.shelve;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.diff.ExportDiffChangesAction;
import org.netbeans.modules.mercurial.ui.diff.Setup;
import org.netbeans.modules.mercurial.ui.update.RevertModificationsAction;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.shelve.ShelveChangesActionsRegistry;
import org.netbeans.modules.versioning.shelve.ShelveChangesSupport;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;

public class ShelveChangesAction
extends ContextAction {
    private static ShelveChangesActionsRegistry.ShelveChangesActionProvider ACTION_PROVIDER;

    @Override
    public boolean enable(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        if (!HgUtils.isFromHgRepository(ctx) || !Mercurial.getInstance().getFileStatusCache().containsFileOfStatus(ctx, 6612, true)) {
            return false;
        }
        return super.enable(nodes);
    }

    @Override
    protected String getBaseName(Node[] activatedNodes) {
        return "CTL_ShelveChanges_Title";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext ctx = HgUtils.getCurrentContext(nodes);
        File root = HgUtils.getRootFile(ctx);
        if (root == null) {
            Mercurial.LOG.log(Level.FINE, "No versioned folder in the selected context for {0}", nodes);
            return;
        }
        HgShelveChangesSupport supp = new HgShelveChangesSupport();
        if (supp.open()) {
            RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(root);
            supp.startAsync(rp, root, ctx);
        }
    }

    public static ShelveChangesActionsRegistry.ShelveChangesActionProvider getProvider() {
        if (ACTION_PROVIDER == null) {
            ACTION_PROVIDER = new ShelveChangesActionsRegistry.ShelveChangesActionProvider(){

                public Action getAction() {
                    SystemAction a = SystemAction.get(ShelveChangesAction.class);
                    Utils.setAcceleratorBindings((String)"Actions/Mercurial", (Action[])new Action[]{a});
                    return a;
                }
            };
        }
        return ACTION_PROVIDER;
    }

    private static class HgShelveChangesSupport
    extends ShelveChangesSupport {
        private HgProgressSupport support;
        private OutputLogger logger;
        private Set<File> filteredRoots;
        private final JPanel optionsPanel;
        private final JCheckBox doBackupChxBox = new JCheckBox();
        private final JCheckBox doPurgeChxBox;
        private boolean doBackup;
        private boolean doPurge;

        public HgShelveChangesSupport() {
            Mnemonics.setLocalizedText((AbstractButton)this.doBackupChxBox, (String)NbBundle.getMessage(ShelveChangesAction.class, (String)"ShelvePanel.doBackupChxBox.text"));
            this.doBackupChxBox.setToolTipText(NbBundle.getMessage(ShelveChangesAction.class, (String)"ShelvePanel.doBackupChxBox.desc"));
            this.doBackupChxBox.getAccessibleContext().setAccessibleDescription(this.doBackupChxBox.getToolTipText());
            this.doBackupChxBox.setSelected(HgModuleConfig.getDefault().getBackupOnRevertModifications());
            this.doPurgeChxBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.doPurgeChxBox, (String)NbBundle.getMessage(ShelveChangesAction.class, (String)"ShelvePanel.doPurgeChxBox.text"));
            this.doPurgeChxBox.setToolTipText(NbBundle.getMessage(ShelveChangesAction.class, (String)"ShelvePanel.doPurgeChxBox.desc"));
            this.doPurgeChxBox.getAccessibleContext().setAccessibleDescription(this.doPurgeChxBox.getToolTipText());
            this.doPurgeChxBox.setSelected(HgModuleConfig.getDefault().isRemoveNewFilesOnRevertModifications());
            this.optionsPanel = new JPanel();
            this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
            this.optionsPanel.add(this.doBackupChxBox);
            this.optionsPanel.add(this.doPurgeChxBox);
        }

        protected void exportPatch(File toFile, File commonParent) throws IOException {
            this.support.setDisplayName(NbBundle.getMessage(ShelveChangesAction.class, (String)"MSG_ShelveChanges.progress.exporting"));
            ArrayList<Setup> setups = new ArrayList<Setup>(this.filteredRoots.size());
            for (File file : this.filteredRoots) {
                Setup setup = new Setup(file, null, 0);
                setups.add(setup);
            }
            ((ExportDiffChangesAction)SystemAction.get(ExportDiffChangesAction.class)).exportDiff(setups, toFile, commonParent, this.support);
        }

        protected void postExportCleanup() {
            Map<File, Set<File>> sorted = HgUtils.sortUnderRepository(this.filteredRoots);
            for (Map.Entry<File, Set<File>> e : sorted.entrySet()) {
                File root = e.getKey();
                Set<File> roots = e.getValue();
                if (roots.isEmpty()) continue;
                this.support.setDisplayName(NbBundle.getMessage(ShelveChangesAction.class, (String)"MSG_ShelveChanges.progress.reverting", (Object)root.getName()));
                RevertModificationsAction.performRevert(root, null, roots.toArray(new File[roots.size()]), this.doBackup, this.doPurge, this.logger);
            }
        }

        protected boolean isCanceled() {
            return this.support == null ? false : this.support.isCanceled();
        }

        private void startAsync(RequestProcessor rp, File root, final VCSContext context) {
            this.support = new HgProgressSupport(){

                @Override
                protected void perform() {
                    HgShelveChangesSupport.this.logger = this.getLogger();
                    HgShelveChangesSupport.this.filteredRoots = new HashSet<File>(Arrays.asList(HgUtils.getModifiedFiles(context, 6612, true)));
                    HgShelveChangesSupport.this.shelveChanges(HgShelveChangesSupport.this.filteredRoots.toArray(new File[HgShelveChangesSupport.this.filteredRoots.size()]));
                }
            };
            this.support.start(rp, root, NbBundle.getMessage(ShelveChangesAction.class, (String)"LBL_ShelveChanges_Progress"));
        }

        private boolean open() {
            boolean retval = this.prepare(this.optionsPanel, "org.netbeans.modules.mercurial.ui.shelve.ShelveChangesPanel");
            if (retval) {
                this.doBackup = this.doBackupChxBox.isSelected();
                this.doPurge = this.doPurgeChxBox.isSelected();
                HgModuleConfig.getDefault().setBackupOnRevertModifications(this.doBackup);
                HgModuleConfig.getDefault().setRemoveNewFilesOnRevertModifications(this.doPurge);
            }
            return retval;
        }
    }
}

