/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.awt.EventQueue;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationStrategy;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.SwingValidationGroup;

class JTextComponentValidationListenerImpl
extends ValidationListener<JTextComponent>
implements DocumentListener,
FocusListener,
Runnable {
    private Validator<Document> validator;
    private boolean hasFatalProblem = false;

    public JTextComponentValidationListenerImpl(JTextComponent component, ValidationStrategy strategy, ValidationUI validationUI, Validator<Document> validator) {
        super(JTextComponent.class, validationUI, component);
        this.validator = validator;
        if (strategy == null) {
            throw new NullPointerException("strategy null");
        }
        component.addPropertyChangeListener("enabled", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JTextComponentValidationListenerImpl.this.performValidation();
            }
        });
        switch (strategy) {
            case DEFAULT: 
            case ON_CHANGE_OR_ACTION: {
                component.getDocument().addDocumentListener(this);
                break;
            }
            case INPUT_VERIFIER: {
                component.setInputVerifier(new InputVerifier(){

                    @Override
                    public boolean verify(JComponent input) {
                        JTextComponentValidationListenerImpl.this.performValidation();
                        return !JTextComponentValidationListenerImpl.this.hasFatalProblem;
                    }
                });
                break;
            }
            case ON_FOCUS_LOSS: {
                component.addFocusListener(this);
            }
        }
        this.performValidation();
    }

    @Override
    protected final void performValidation(Problems ps) {
        JTextComponent component = (JTextComponent)this.getTarget();
        if (!component.isEnabled()) {
            return;
        }
        this.validator.validate(ps, SwingValidationGroup.nameForComponent(component), component.getDocument());
        this.hasFatalProblem = ps.hasFatal();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.performValidation();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.removeUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(this);
        } else {
            this.performValidation();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.removeUpdate(e);
    }

    @Override
    public void run() {
        this.performValidation();
    }
}

